/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.SpatialDataType;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.mvstore.type.DataType;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.result.SortOrder;
import org.h2.store.DataHandler;
import org.h2.util.JdbcUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueRow;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class ValueDataType
implements DataType {
    private static final byte NULL = 0;
    private static final byte BYTE = 2;
    private static final byte SHORT = 3;
    private static final byte INT = 4;
    private static final byte LONG = 5;
    private static final byte DECIMAL = 6;
    private static final byte DOUBLE = 7;
    private static final byte FLOAT = 8;
    private static final byte TIME = 9;
    private static final byte DATE = 10;
    private static final byte TIMESTAMP = 11;
    private static final byte BYTES = 12;
    private static final byte STRING = 13;
    private static final byte STRING_IGNORECASE = 14;
    private static final byte BLOB = 15;
    private static final byte CLOB = 16;
    private static final byte ARRAY = 17;
    private static final byte RESULT_SET = 18;
    private static final byte JAVA_OBJECT = 19;
    private static final byte UUID = 20;
    private static final byte STRING_FIXED = 21;
    private static final byte GEOMETRY = 22;
    private static final byte TIMESTAMP_TZ = 24;
    private static final byte ENUM = 25;
    private static final byte INTERVAL = 26;
    private static final byte ROW = 27;
    private static final byte INT_0_15 = 32;
    private static final byte LONG_0_7 = 48;
    private static final byte DECIMAL_0_1 = 56;
    private static final byte DECIMAL_SMALL_0 = 58;
    private static final byte DECIMAL_SMALL = 59;
    private static final byte DOUBLE_0_1 = 60;
    private static final byte FLOAT_0_1 = 62;
    private static final byte BOOLEAN_FALSE = 64;
    private static final byte BOOLEAN_TRUE = 65;
    private static final byte INT_NEG = 66;
    private static final byte LONG_NEG = 67;
    private static final byte STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int SPATIAL_KEY_2D = 132;
    private static final int CUSTOM_DATA_TYPE = 133;
    private static final int JSON = 134;
    private static final int TIMESTAMP_TZ_2 = 135;
    private static final int TIME_TZ = 136;
    final DataHandler handler;
    final CastDataProvider provider;
    final CompareMode compareMode;
    protected final Mode mode;
    final int[] sortTypes;
    SpatialDataType spatialType;

    public ValueDataType() {
        this(null, CompareMode.getInstance(null, 0), null, null, null);
    }

    public ValueDataType(Database database, int[] nArray) {
        this(database, database.getCompareMode(), database.getMode(), database, nArray);
    }

    private ValueDataType(CastDataProvider castDataProvider, CompareMode compareMode, Mode mode, DataHandler dataHandler, int[] nArray) {
        this.provider = castDataProvider;
        this.compareMode = compareMode;
        this.mode = mode;
        this.handler = dataHandler;
        this.sortTypes = nArray;
    }

    private SpatialDataType getSpatialDataType() {
        if (this.spatialType == null) {
            this.spatialType = new SpatialDataType(2);
        }
        return this.spatialType;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object instanceof ValueCollectionBase && object2 instanceof ValueCollectionBase) {
            Value[] valueArray = ((ValueCollectionBase)object).getList();
            Value[] valueArray2 = ((ValueCollectionBase)object2).getList();
            int n = valueArray.length;
            int n2 = valueArray2.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.sortTypes == null ? 0 : this.sortTypes[i];
                Value value = valueArray[i];
                Value value2 = valueArray2[i];
                if (value == null || value2 == null) {
                    return this.compareValues(valueArray[n3 - 1], valueArray2[n3 - 1], 0);
                }
                int n5 = this.compareValues(value, value2, n4);
                if (n5 == 0) continue;
                return n5;
            }
            if (n3 < n) {
                return -1;
            }
            if (n3 < n2) {
                return 1;
            }
            return 0;
        }
        return this.compareValues((Value)object, (Value)object2, 0);
    }

    private int compareValues(Value value, Value value2, int n) {
        boolean bl;
        if (value == value2) {
            return 0;
        }
        boolean bl2 = bl = value == ValueNull.INSTANCE;
        if (bl || value2 == ValueNull.INSTANCE) {
            return SortOrder.compareNull(bl, n);
        }
        int n2 = value.compareTo(value2, this.provider, this.compareMode);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    @Override
    public int getMemory(Object object) {
        if (object instanceof SpatialKey) {
            return this.getSpatialDataType().getMemory(object);
        }
        return ValueDataType.getMemory((Value)object);
    }

    private static int getMemory(Value value) {
        return value == null ? 0 : value.getMemory();
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            this.write(writeBuffer, objectArray[i]);
        }
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        return this.readValue(byteBuffer);
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        if (object instanceof SpatialKey) {
            writeBuffer.put((byte)-124);
            this.getSpatialDataType().write(writeBuffer, object);
            return;
        }
        Value value = (Value)object;
        this.writeValue(writeBuffer, value);
    }

    private void writeValue(WriteBuffer writeBuffer, Value value) {
        if (value == ValueNull.INSTANCE) {
            writeBuffer.put((byte)0);
            return;
        }
        int n = value.getValueType();
        switch (n) {
            case 1: {
                writeBuffer.put(value.getBoolean() ? (byte)65 : 64);
                break;
            }
            case 2: {
                writeBuffer.put((byte)2).put(value.getByte());
                break;
            }
            case 3: {
                writeBuffer.put((byte)3).putShort(value.getShort());
                break;
            }
            case 4: 
            case 25: {
                int n2 = value.getInt();
                if (n2 < 0) {
                    writeBuffer.put((byte)66).putVarInt(-n2);
                    break;
                }
                if (n2 < 16) {
                    writeBuffer.put((byte)(32 + n2));
                    break;
                }
                writeBuffer.put(n == 4 ? (byte)4 : 25).putVarInt(n2);
                break;
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    writeBuffer.put((byte)67).putVarLong(-l);
                    break;
                }
                if (l < 8L) {
                    writeBuffer.put((byte)(48L + l));
                    break;
                }
                writeBuffer.put((byte)5).putVarLong(l);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    writeBuffer.put((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    writeBuffer.put((byte)57);
                    break;
                }
                int n3 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n4 = bigInteger.bitLength();
                if (n4 <= 63) {
                    if (n3 == 0) {
                        writeBuffer.put((byte)58).putVarLong(bigInteger.longValue());
                        break;
                    }
                    writeBuffer.put((byte)59).putVarInt(n3).putVarLong(bigInteger.longValue());
                    break;
                }
                byte[] byArray = bigInteger.toByteArray();
                writeBuffer.put((byte)6).putVarInt(n3).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 9: {
                ValueTime valueTime = (ValueTime)value;
                long l = valueTime.getNanos();
                long l2 = l / 1000000L;
                writeBuffer.put((byte)9).putVarLong(l2).putVarInt((int)(l -= l2 * 1000000L));
                break;
            }
            case 41: {
                ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value;
                long l = valueTimeTimeZone.getNanos();
                writeBuffer.put((byte)-120).putVarInt((int)(l / 1000000000L)).putVarInt((int)(l % 1000000000L));
                ValueDataType.writeTimeZone(writeBuffer, valueTimeTimeZone.getTimeZoneOffsetSeconds());
                break;
            }
            case 10: {
                long l = ((ValueDate)value).getDateValue();
                writeBuffer.put((byte)10).putVarLong(l);
                break;
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                long l = valueTimestamp.getDateValue();
                long l3 = valueTimestamp.getTimeNanos();
                long l4 = l3 / 1000000L;
                writeBuffer.put((byte)11).putVarLong(l).putVarLong(l4).putVarInt((int)(l3 -= l4 * 1000000L));
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                long l = valueTimestampTimeZone.getDateValue();
                long l5 = valueTimestampTimeZone.getTimeNanos();
                long l6 = l5 / 1000000L;
                l5 -= l6 * 1000000L;
                int n5 = valueTimestampTimeZone.getTimeZoneOffsetSeconds();
                if (n5 % 60 == 0) {
                    writeBuffer.put((byte)24).putVarLong(l).putVarLong(l6).putVarInt((int)l5).putVarInt(n5 / 60);
                    break;
                }
                writeBuffer.put((byte)-121).putVarLong(l).putVarLong(l6).putVarInt((int)l5);
                ValueDataType.writeTimeZone(writeBuffer, n5);
                break;
            }
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                writeBuffer.put((byte)19).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                if (n6 < 32) {
                    writeBuffer.put((byte)(100 + n6)).put(byArray);
                    break;
                }
                writeBuffer.put((byte)12).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                writeBuffer.put((byte)20).putLong(valueUuid.getHigh()).putLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n7 = string.length();
                if (n7 < 32) {
                    writeBuffer.put((byte)(68 + n7)).putStringData(string, n7);
                    break;
                }
                writeBuffer.put((byte)13);
                ValueDataType.writeString(writeBuffer, string);
                break;
            }
            case 14: {
                writeBuffer.put((byte)14);
                ValueDataType.writeString(writeBuffer, value.getString());
                break;
            }
            case 21: {
                writeBuffer.put((byte)21);
                ValueDataType.writeString(writeBuffer, value.getString());
                break;
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    writeBuffer.put((byte)61);
                    break;
                }
                long l = Double.doubleToLongBits(d);
                if (l == 0L) {
                    writeBuffer.put((byte)60);
                    break;
                }
                writeBuffer.put((byte)7).putVarLong(Long.reverse(l));
                break;
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    writeBuffer.put((byte)63);
                    break;
                }
                int n8 = Float.floatToIntBits(f);
                if (n8 == 0) {
                    writeBuffer.put((byte)62);
                    break;
                }
                writeBuffer.put((byte)8).putVarInt(Integer.reverse(n8));
                break;
            }
            case 15: 
            case 16: {
                writeBuffer.put(n == 15 ? (byte)15 : 16);
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    writeBuffer.putVarInt(-3).putVarInt(valueLobDb.getTableId()).putVarLong(valueLobDb.getLobId()).putVarLong(valueLobDb.getType().getPrecision());
                    break;
                }
                writeBuffer.putVarInt(byArray.length).put(byArray);
                break;
            }
            case 17: 
            case 39: {
                Value[] valueArray = ((ValueCollectionBase)value).getList();
                writeBuffer.put(n == 17 ? (byte)17 : 27).putVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(writeBuffer, value2);
                }
                break;
            }
            case 18: {
                writeBuffer.put((byte)18);
                ResultInterface resultInterface = ((ValueResultSet)value).getResult();
                int n9 = resultInterface.getVisibleColumnCount();
                writeBuffer.putVarInt(n9);
                for (int i = 0; i < n9; ++i) {
                    ValueDataType.writeString(writeBuffer, resultInterface.getAlias(i));
                    ValueDataType.writeString(writeBuffer, resultInterface.getColumnName(i));
                    TypeInfo typeInfo = resultInterface.getColumnType(i);
                    writeBuffer.putVarInt(typeInfo.getValueType()).putVarLong(typeInfo.getPrecision()).putVarInt(typeInfo.getScale());
                }
                while (resultInterface.next()) {
                    writeBuffer.put((byte)1);
                    Value[] valueArray = resultInterface.currentRow();
                    for (int i = 0; i < n9; ++i) {
                        this.writeValue(writeBuffer, valueArray[i]);
                    }
                }
                writeBuffer.put((byte)0);
                break;
            }
            case 22: {
                byte[] byArray = value.getBytes();
                int n10 = byArray.length;
                writeBuffer.put((byte)22).putVarInt(n10).put(byArray);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                ValueInterval valueInterval = (ValueInterval)value;
                int n11 = n - 26;
                if (valueInterval.isNegative()) {
                    n11 ^= 0xFFFFFFFF;
                }
                writeBuffer.put((byte)26).put((byte)n11).putVarLong(valueInterval.getLeading());
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                ValueInterval valueInterval = (ValueInterval)value;
                int n12 = n - 26;
                if (valueInterval.isNegative()) {
                    n12 ^= 0xFFFFFFFF;
                }
                writeBuffer.put((byte)26).put((byte)n12).putVarLong(valueInterval.getLeading()).putVarLong(valueInterval.getRemaining());
                break;
            }
            case 40: {
                byte[] byArray = value.getBytesNoCopy();
                writeBuffer.put((byte)-122).putVarInt(byArray.length).put(byArray);
                break;
            }
            default: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    byte[] byArray = value.getBytesNoCopy();
                    writeBuffer.put((byte)-123).putVarInt(n).putVarInt(byArray.length).put(byArray);
                    break;
                }
                DbException.throwInternalError("type=" + value.getValueType());
            }
        }
    }

    private static void writeString(WriteBuffer writeBuffer, String string) {
        int n = string.length();
        writeBuffer.putVarInt(n).putStringData(string, n);
    }

    private static void writeTimeZone(WriteBuffer writeBuffer, int n) {
        if (n % 900 == 0) {
            writeBuffer.put((byte)(n / 900));
        } else if (n > 0) {
            writeBuffer.put((byte)127).putVarInt(n);
        } else {
            writeBuffer.put((byte)-128).putVarInt(-n);
        }
    }

    private Object readValue(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.TRUE;
            }
            case 64: {
                return ValueBoolean.FALSE;
            }
            case 66: {
                return ValueInt.get(-DataUtils.readVarInt(byteBuffer));
            }
            case 4: 
            case 25: {
                return ValueInt.get(DataUtils.readVarInt(byteBuffer));
            }
            case 67: {
                return ValueLong.get(-DataUtils.readVarLong(byteBuffer));
            }
            case 5: {
                return ValueLong.get(DataUtils.readVarLong(byteBuffer));
            }
            case 2: {
                return ValueByte.get(byteBuffer.get());
            }
            case 3: {
                return ValueShort.get(byteBuffer.getShort());
            }
            case 56: {
                return ValueDecimal.ZERO;
            }
            case 57: {
                return ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer)));
            }
            case 59: {
                int n2 = DataUtils.readVarInt(byteBuffer);
                return ValueDecimal.get(BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer), n2));
            }
            case 6: {
                int n3 = DataUtils.readVarInt(byteBuffer);
                int n4 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n4);
                byteBuffer.get(byArray, 0, n4);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n3));
            }
            case 10: {
                return ValueDate.fromDateValue(DataUtils.readVarLong(byteBuffer));
            }
            case 9: {
                long l = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                return ValueTime.fromNanos(l);
            }
            case 136: {
                return ValueTimeTimeZone.fromNanos((long)DataUtils.readVarInt(byteBuffer) * 1000000000L + (long)DataUtils.readVarInt(byteBuffer), ValueDataType.readTimeZone(byteBuffer));
            }
            case 11: {
                long l = DataUtils.readVarLong(byteBuffer);
                long l2 = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                return ValueTimestamp.fromDateValueAndNanos(l, l2);
            }
            case 24: {
                long l = DataUtils.readVarLong(byteBuffer);
                long l3 = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                int n5 = DataUtils.readVarInt(byteBuffer) * 60;
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l3, n5);
            }
            case 135: {
                long l = DataUtils.readVarLong(byteBuffer);
                long l4 = DataUtils.readVarLong(byteBuffer) * 1000000L + (long)DataUtils.readVarInt(byteBuffer);
                int n6 = ValueDataType.readTimeZone(byteBuffer);
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l4, n6);
            }
            case 12: {
                int n7 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n7);
                byteBuffer.get(byArray, 0, n7);
                return ValueBytes.getNoCopy(byArray);
            }
            case 19: {
                int n8 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n8);
                byteBuffer.get(byArray, 0, n8);
                return ValueJavaObject.getNoCopy(null, byArray, this.handler);
            }
            case 20: {
                return ValueUuid.get(byteBuffer.getLong(), byteBuffer.getLong());
            }
            case 13: {
                return ValueString.get(DataUtils.readString(byteBuffer));
            }
            case 14: {
                return ValueStringIgnoreCase.get(DataUtils.readString(byteBuffer));
            }
            case 21: {
                return ValueStringFixed.get(DataUtils.readString(byteBuffer));
            }
            case 26: {
                boolean bl;
                int n9 = byteBuffer.get();
                boolean bl2 = bl = n9 < 0;
                if (bl) {
                    n9 ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(n9), bl, DataUtils.readVarLong(byteBuffer), n9 < 5 ? 0L : DataUtils.readVarLong(byteBuffer));
            }
            case 62: {
                return ValueFloat.ZERO;
            }
            case 63: {
                return ValueFloat.ONE;
            }
            case 60: {
                return ValueDouble.ZERO;
            }
            case 61: {
                return ValueDouble.ONE;
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(DataUtils.readVarLong(byteBuffer))));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(DataUtils.readVarInt(byteBuffer))));
            }
            case 15: 
            case 16: {
                int n10 = DataUtils.readVarInt(byteBuffer);
                if (n10 >= 0) {
                    byte[] byArray = Utils.newBytes(n10);
                    byteBuffer.get(byArray, 0, n10);
                    return ValueLobDb.createSmallLob(n == 15 ? 15 : 16, byArray);
                }
                if (n10 == -3) {
                    int n11 = DataUtils.readVarInt(byteBuffer);
                    long l = DataUtils.readVarLong(byteBuffer);
                    long l5 = DataUtils.readVarLong(byteBuffer);
                    return ValueLobDb.create(n == 15 ? 15 : 16, this.handler, n11, l, null, l5);
                }
                throw DbException.get(90030, "lob type: " + n10);
            }
            case 17: 
            case 27: {
                int n12 = DataUtils.readVarInt(byteBuffer);
                Value[] valueArray = new Value[n12];
                for (int i = 0; i < n12; ++i) {
                    valueArray[i] = (Value)this.readValue(byteBuffer);
                }
                return n == 17 ? ValueArray.get(valueArray) : ValueRow.get(valueArray);
            }
            case 18: {
                SimpleResult simpleResult = new SimpleResult();
                int n13 = DataUtils.readVarInt(byteBuffer);
                for (int i = 0; i < n13; ++i) {
                    simpleResult.addColumn(DataUtils.readString(byteBuffer), DataUtils.readString(byteBuffer), DataUtils.readVarInt(byteBuffer), DataUtils.readVarLong(byteBuffer), DataUtils.readVarInt(byteBuffer));
                }
                while (byteBuffer.get() != 0) {
                    Value[] valueArray = new Value[n13];
                    for (int i = 0; i < n13; ++i) {
                        valueArray[i] = (Value)this.readValue(byteBuffer);
                    }
                    simpleResult.addRow(valueArray);
                }
                return ValueResultSet.get(simpleResult);
            }
            case 22: {
                int n14 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n14);
                byteBuffer.get(byArray, 0, n14);
                return ValueGeometry.get(byArray);
            }
            case 132: {
                return this.getSpatialDataType().read(byteBuffer);
            }
            case 133: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    int n15 = DataUtils.readVarInt(byteBuffer);
                    int n16 = DataUtils.readVarInt(byteBuffer);
                    byte[] byArray = Utils.newBytes(n16);
                    byteBuffer.get(byArray, 0, n16);
                    return JdbcUtils.customDataTypesHandler.convert(ValueBytes.getNoCopy(byArray), n15);
                }
                throw DbException.get(50004, "No CustomDataTypesHandler has been set up");
            }
            case 134: {
                int n17 = DataUtils.readVarInt(byteBuffer);
                byte[] byArray = Utils.newBytes(n17);
                byteBuffer.get(byArray, 0, n17);
                return ValueJson.getInternal(byArray);
            }
        }
        if (n >= 32 && n < 48) {
            return ValueInt.get(n - 32);
        }
        if (n >= 48 && n < 56) {
            return ValueLong.get(n - 48);
        }
        if (n >= 100 && n < 132) {
            int n18 = n - 100;
            byte[] byArray = Utils.newBytes(n18);
            byteBuffer.get(byArray, 0, n18);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n >= 68 && n < 100) {
            return ValueString.get(DataUtils.readString(byteBuffer, n - 68));
        }
        throw DbException.get(90030, "type: " + n);
    }

    private static int readTimeZone(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 127) {
            return DataUtils.readVarInt(byteBuffer);
        }
        if (by == -128) {
            return -DataUtils.readVarInt(byteBuffer);
        }
        return by * 900;
    }

    public int hashCode() {
        return this.compareMode.hashCode() ^ Arrays.hashCode(this.sortTypes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValueDataType)) {
            return false;
        }
        ValueDataType valueDataType = (ValueDataType)object;
        if (!this.compareMode.equals(valueDataType.compareMode)) {
            return false;
        }
        return Arrays.equals(this.sortTypes, valueDataType.sortTypes);
    }
}

