/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;
import org.xml.sax.InputSource;

public class ApplyXPathDOM {
    protected String filename = null;
    protected String xpath = null;

    public void doMain(String[] args) throws Exception {
        this.filename = args[0];
        this.xpath = args[1];
        if (this.filename != null && this.filename.length() > 0 && this.xpath != null && this.xpath.length() > 0) {
            Node n;
            System.out.println("Loading classes, parsing " + this.filename + ", and setting up serializer");
            InputSource in = new InputSource(new FileInputStream(this.filename));
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            Document doc = dfactory.newDocumentBuilder().parse(in);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            System.out.println("Querying DOM using " + this.xpath);
            XPathEvaluatorImpl evaluator = new XPathEvaluatorImpl(doc);
            XPathNSResolver resolver = evaluator.createNSResolver(doc);
            XPathResult result = (XPathResult)evaluator.evaluate(this.xpath, doc, resolver, (short)4, null);
            System.out.println("<output>");
            while ((n = result.iterateNext()) != null) {
                if (ApplyXPathDOM.isTextNode(n)) {
                    StringBuffer sb = new StringBuffer(n.getNodeValue());
                    Node nn = n.getNextSibling();
                    while (ApplyXPathDOM.isTextNode(nn)) {
                        sb.append(nn.getNodeValue());
                        nn = nn.getNextSibling();
                    }
                    System.out.print(sb);
                } else {
                    serializer.transform(new DOMSource(n), new StreamResult(new OutputStreamWriter(System.out)));
                }
                System.out.println();
            }
            System.out.println("</output>");
        } else {
            System.out.println("Bad input args: " + this.filename + ", " + this.xpath);
        }
    }

    static boolean isTextNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("java ApplyXPathDOM filename.xml xpath\nReads filename.xml and applies the xpath; prints the nodelist found.");
            return;
        }
        ApplyXPathDOM app = new ApplyXPathDOM();
        app.doMain(args);
    }
}

