// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectControl_HeaderFile
#define _IFSelect_SelectControl_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_SelectControl.hxx>

#include <Handle_IFSelect_Selection.hxx>
#include <IFSelect_Selection.hxx>
#include <Standard_Boolean.hxx>
class IFSelect_Selection;
class IFSelect_SelectionIterator;


//! A SelectControl kind Selection works with two input Selections
//! in a dissymmetric way : the Main Input which gives an input
//! list of Entities, to be processed, and the Second Input which
//! gives another list, to be used to filter the main input.
//!
//! e.g. : SelectDiff retains the items of the Main Input which
//! are not in the Control Input (which acts as Diff Input)
//! or a specific selection which retains Entities from the Main
//! Input if and only if they are concerned by an entity from
//! the Control Input (such as Views in IGES, etc...)
//!
//! The way RootResult and Label are produced are at charge of
//! each sub-class
class IFSelect_SelectControl : public IFSelect_Selection
{

public:

  
  //! Returns the Main Input Selection
  Standard_EXPORT   Handle(IFSelect_Selection) MainInput()  const;
  
  //! Returns True if a Control Input is defined
  //! Thus, Result can be computed differently if there is a
  //! Control Input or if there is none
  Standard_EXPORT   Standard_Boolean HasSecondInput()  const;
  
  //! Returns the Control Input Selection, or a Null Handle
  Standard_EXPORT   Handle(IFSelect_Selection) SecondInput()  const;
  
  //! Sets a Selection to be the Main Input
  Standard_EXPORT   void SetMainInput (const Handle(IFSelect_Selection)& sel) ;
  
  //! Sets a Selection to be the Control Input
  Standard_EXPORT   void SetSecondInput (const Handle(IFSelect_Selection)& sel) ;
  
  //! Puts in an Iterator the Selections from which "me" depends
  //! That is to say, the list of Input Selections
  Standard_EXPORT   void FillIterator (IFSelect_SelectionIterator& iter)  const;




  DEFINE_STANDARD_RTTI(IFSelect_SelectControl)

protected:




private: 


  Handle(IFSelect_Selection) themain;
  Handle(IFSelect_Selection) thesecond;


};







#endif // _IFSelect_SelectControl_HeaderFile
