"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_redux_1 = require("react-redux");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var geometries_1 = require("../../state/selectors/geometries");
var picked_shapes_1 = require("../../state/selectors/picked_shapes");
var highlighter_1 = require("./highlighter");
var hoverMapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return highlighter_1.DEFAULT_PROPS;
    }
    var chartId = state.chartId;
    var _a = geometries_1.partitionGeometries(state), outerRadius = _a.outerRadius, diskCenter = _a.diskCenter, partitionLayout = _a.config.partitionLayout;
    var geometries = picked_shapes_1.getPickedShapes(state);
    var canvasDimension = get_chart_container_dimensions_1.getChartContainerDimensionsSelector(state);
    return {
        chartId: chartId,
        initialized: true,
        renderAsOverlay: true,
        canvasDimension: canvasDimension,
        diskCenter: diskCenter,
        outerRadius: outerRadius,
        geometries: geometries,
        partitionLayout: partitionLayout,
    };
};
exports.HighlighterFromHover = react_redux_1.connect(hoverMapStateToProps)(highlighter_1.HighlighterComponent);
//# sourceMappingURL=highlighter_hover.js.map