"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../renderers/canvas");
var rendering_1 = require("../../rendering/rendering");
var points_1 = require("./points");
var path_1 = require("./primitives/path");
var line_1 = require("./styles/line");
function renderLines(ctx, props) {
    canvas_1.withContext(ctx, function (ctx) {
        var lines = props.lines, sharedStyle = props.sharedStyle, highlightedLegendItem = props.highlightedLegendItem, clippings = props.clippings;
        lines.forEach(function (line) {
            var _a;
            var seriesLineStyle = line.seriesLineStyle, seriesPointStyle = line.seriesPointStyle;
            if (seriesLineStyle.visible) {
                canvas_1.withContext(ctx, function (ctx) {
                    renderLine(ctx, line, highlightedLegendItem, sharedStyle, clippings);
                });
            }
            if (seriesPointStyle.visible) {
                canvas_1.withClip(ctx, clippings, function (ctx) {
                    var geometryStyle = rendering_1.getGeometryStateStyle(line.seriesIdentifier, highlightedLegendItem, sharedStyle);
                    points_1.renderPoints(ctx, line.points, line.seriesPointStyle, geometryStyle);
                }, ((_a = line.points[0]) === null || _a === void 0 ? void 0 : _a.value.mark) !== null);
            }
        });
    });
}
exports.renderLines = renderLines;
function renderLine(ctx, line, highlightedLegendItem, sharedStyle, clippings) {
    var color = line.color, transform = line.transform, seriesIdentifier = line.seriesIdentifier, seriesLineStyle = line.seriesLineStyle, clippedRanges = line.clippedRanges, hideClippedRanges = line.hideClippedRanges;
    var geometryStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, highlightedLegendItem, sharedStyle);
    var stroke = line_1.buildLineStyles(color, seriesLineStyle, geometryStyle);
    path_1.renderLinePaths(ctx, transform.x, [line.line], stroke, clippedRanges, clippings, hideClippedRanges);
}
//# sourceMappingURL=lines.js.map