# -*- coding: utf-8 -*-

"""Data literal storing emoji Italian names and Unicode codes."""

__all__ = ['EMOJI_UNICODE_ITALIAN', 'UNICODE_EMOJI_ITALIAN',]


EMOJI_UNICODE_ITALIAN = {
	u':faccina_con_un_gran_sorriso:': u'\U0001F600',
	u':faccina_con_un_gran_sorriso_e_occhi_spalancati:': u'\U0001F603',
	u':faccina_con_sorriso_e_occhi_sorridenti:': u'\U0001F604',
	u':faccina_raggiante_con_occhi_felici:': u'\U0001F601',
	u':sorriso_a_bocca_aperta_con_occhi_chiusi:': u'\U0001F606',
	u':faccina_con_un_gran_sorriso_e_goccia_di_sudore:': u'\U0001F605',
	u':ridere_a_crepapelle:': u'\U0001F923',
	u':faccina_con_lacrime_di_gioia:': u'\U0001F602',
	u':faccina_con_sorriso_accennato:': u'\U0001F642',
	u':faccina_sottosopra:': u'\U0001F643',
	u':faccina_che_fa_l’occhiolino:': u'\U0001F609',
	u':faccina_con_occhi_sorridenti:': u'\U0001F60A',
	u':faccina_con_sorriso_e_aureola:': u'\U0001F607',
	u':faccina_con_cuoricini:': u'\U0001F970',
	u':faccina_con_sorriso_e_occhi_a_cuore:': u'\U0001F60D',
	u':colpo_di_fulmine:': u'\U0001F929',
	u':faccina_che_manda_un_bacio:': u'\U0001F618',
	u':faccina_che_bacia:': u'\U0001F617',
	u':faccina_sorridente:': u'\U0000263A\U0000FE0F',
	u':faccina_che_bacia_con_occhi_chiusi:': u'\U0001F61A',
	u':faccina_che_bacia_con_occhi_sorridenti:': u'\U0001F619',
	u':faccina_sorridente_con_lacrima:': u'\U0001F972',
	u':faccina_che_si_lecca_i_baffi:': u'\U0001F60B',
	u':faccina_che_mostra_la_lingua:': u'\U0001F61B',
	u':faccina_che_fa_l’occhiolino_e_mostra_la_lingua:': u'\U0001F61C',
	u':faccina_impazzita:': u'\U0001F92A',
	u':faccina_con_un_gran_sorriso_che_mostra_la_lingua:': u'\U0001F61D',
	u':faccina_avida_di_denaro:': u'\U0001F911',
	u':faccina_che_abbraccia:': u'\U0001F917',
	u':faccina_con_mano_sulla_bocca:': u'\U0001F92D',
	u':faccina_che_zittisce:': u'\U0001F92B',
	u':faccina_concentrata:': u'\U0001F914',
	u':faccina_con_bocca_con_cerniera:': u'\U0001F910',
	u':faccia_con_sopracciglia_alzate:': u'\U0001F928',
	u':faccina_neutra:': u'\U0001F610',
	u':faccina_inespressiva:': u'\U0001F611',
	u':faccina_senza_bocca:': u'\U0001F636',
	u':faccina_con_sorrisetto:': u'\U0001F60F',
	u':faccina_contrariata:': u'\U0001F612',
	u':faccina_con_occhi_al_cielo:': u'\U0001F644',
	u':faccina_con_smorfia:': u'\U0001F62C',
	u':faccina_bugiarda:': u'\U0001F925',
	u':faccina_sollevata:': u'\U0001F60C',
	u':faccina_pensierosa:': u'\U0001F614',
	u':faccina_assonnata:': u'\U0001F62A',
	u':faccina_che_sbava:': u'\U0001F924',
	u':faccina_che_dorme:': u'\U0001F634',
	u':faccina_con_mascherina:': u'\U0001F637',
	u':faccina_con_termometro:': u'\U0001F912',
	u':faccina_con_la_testa_bendata:': u'\U0001F915',
	u':faccina_nauseata:': u'\U0001F922',
	u':faccina_che_vomita:': u'\U0001F92E',
	u':faccina_che_starnutisce:': u'\U0001F927',
	u':faccina_accaldata:': u'\U0001F975',
	u':faccina_congelata:': u'\U0001F976',
	u':faccina_stordita:': u'\U0001F974',
	u':faccina_frastornata:': u'\U0001F635',
	u':testa_che_esplode:': u'\U0001F92F',
	u':faccina_con_cappello_da_cowboy:': u'\U0001F920',
	u':faccina_che_festeggia:': u'\U0001F973',
	u':faccina_travestita:': u'\U0001F978',
	u':faccina_con_sorriso_e_occhiali_da_sole:': u'\U0001F60E',
	u':faccina_nerd:': u'\U0001F913',
	u':faccina_con_monocolo:': u'\U0001F9D0',
	u':faccina_confusa:': u'\U0001F615',
	u':faccina_preoccupata:': u'\U0001F61F',
	u':faccina_leggermente_imbronciata:': u'\U0001F641',
	u':faccina_imbronciata:': u'\U00002639\U0000FE0F',
	u':faccina_con_bocca_aperta:': u'\U0001F62E',
	u':faccina_sorpresa:': u'\U0001F62F',
	u':faccina_stupita:': u'\U0001F632',
	u':faccina_imbarazzata:': u'\U0001F633',
	u':faccina_supplichevole:': u'\U0001F97A',
	u':faccina_imbronciata_con_bocca_aperta:': u'\U0001F626',
	u':faccina_angosciata:': u'\U0001F627',
	u':faccina_impaurita:': u'\U0001F628',
	u':faccina_sudata_in_ansia:': u'\U0001F630',
	u':faccina_delusa_ma_sollevata:': u'\U0001F625',
	u':faccina_che_piange:': u'\U0001F622',
	u':faccina_disperata:': u'\U0001F62D',
	u':faccina_terrorizzata:': u'\U0001F631',
	u':faccina_frustrata:': u'\U0001F616',
	u':faccina_perseverante:': u'\U0001F623',
	u':faccina_delusa:': u'\U0001F61E',
	u':faccina_sudata:': u'\U0001F613',
	u':faccina_esausta:': u'\U0001F629',
	u':faccina_stanca:': u'\U0001F62B',
	u':faccina_che_sbadiglia:': u'\U0001F971',
	u':faccina_che_sbuffa:': u'\U0001F624',
	u':faccina_accigliata:': u'\U0001F621',
	u':faccina_arrabbiata:': u'\U0001F620',
	u':faccina_con_simboli_sulla_bocca:': u'\U0001F92C',
	u':faccina_con_sorriso_e_corna:': u'\U0001F608',
	u':faccina_arrabbiata_con_corna:': u'\U0001F47F',
	u':teschio:': u'\U0001F480',
	u':teschio_con_ossa_incrociate:': u'\U00002620\U0000FE0F',
	u':cacca:': u'\U0001F4A9',
	u':faccina_pagliaccio:': u'\U0001F921',
	u':orco:': u'\U0001F479',
	u':goblin:': u'\U0001F47A',
	u':fantasma:': u'\U0001F47B',
	u':alieno:': u'\U0001F47D',
	u':mostro_alieno:': u'\U0001F47E',
	u':faccina_di_robot:': u'\U0001F916',
	u':gatto_che_sorride:': u'\U0001F63A',
	u':gatto_che_sogghigna:': u'\U0001F638',
	u':gatto_con_lacrime_di_gioia:': u'\U0001F639',
	u':gatto_innamorato:': u'\U0001F63B',
	u':gatto_con_sorriso_sarcastico:': u'\U0001F63C',
	u':gatto_che_manda_baci:': u'\U0001F63D',
	u':gatto_esterrefatto:': u'\U0001F640',
	u':gatto_che_piange:': u'\U0001F63F',
	u':gatto_imbronciato:': u'\U0001F63E',
	u':non_vedo:': u'\U0001F648',
	u':non_sento:': u'\U0001F649',
	u':non_parlo:': u'\U0001F64A',
	u':impronta_della_bocca:': u'\U0001F48B',
	u':lettera_d’amore:': u'\U0001F48C',
	u':cuore_con_freccia:': u'\U0001F498',
	u':cuore_con_fiocco:': u'\U0001F49D',
	u':cuore_che_luccica:': u'\U0001F496',
	u':cuore_che_cresce:': u'\U0001F497',
	u':cuore_che_batte:': u'\U0001F493',
	u':cuori_che_girano:': u'\U0001F49E',
	u':due_cuori:': u'\U0001F495',
	u':decorazione_con_cuore:': u'\U0001F49F',
	u':punto_esclamativo_a_cuore:': u'\U00002763\U0000FE0F',
	u':cuore_infranto:': u'\U0001F494',
	u':cuore_rosso:': u'\U00002764\U0000FE0F',
	u':cuore_arancione:': u'\U0001F9E1',
	u':cuore_giallo:': u'\U0001F49B',
	u':cuore_verde:': u'\U0001F49A',
	u':cuore_azzurro:': u'\U0001F499',
	u':cuore_viola:': u'\U0001F49C',
	u':cuore_marrone:': u'\U0001F90E',
	u':cuore_nero:': u'\U0001F5A4',
	u':cuore_bianco:': u'\U0001F90D',
	u':100_punti:': u'\U0001F4AF',
	u':rabbia:': u'\U0001F4A2',
	u':collisione:': u'\U0001F4A5',
	u':stella_con_scia:': u'\U0001F4AB',
	u':gocce_di_sudore:': u'\U0001F4A6',
	u':nuvola_di_polvere:': u'\U0001F4A8',
	u':buco:': u'\U0001F573\U0000FE0F',
	u':bomba:': u'\U0001F4A3',
	u':fumetto:': u'\U0001F4AC',
	u':occhio_nel_fumetto:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F',
	u':nuvoletta_nera:': u'\U0001F5E8\U0000FE0F',
	u':nuvoletta_rabbia:': u'\U0001F5EF\U0000FE0F',
	u':nuvoletta:': u'\U0001F4AD',
	u':sonno:': u'\U0001F4A4',
	u':mano_che_saluta:': u'\U0001F44B',
	u':mano_che_saluta_carnagione_chiara:': u'\U0001F44B\U0001F3FB',
	u':mano_che_saluta_carnagione_abbastanza_chiara:': u'\U0001F44B\U0001F3FC',
	u':mano_che_saluta_carnagione_olivastra:': u'\U0001F44B\U0001F3FD',
	u':mano_che_saluta_carnagione_abbastanza_scura:': u'\U0001F44B\U0001F3FE',
	u':mano_che_saluta_carnagione_scura:': u'\U0001F44B\U0001F3FF',
	u':dorso_mano_alzata:': u'\U0001F91A',
	u':dorso_mano_alzata_carnagione_chiara:': u'\U0001F91A\U0001F3FB',
	u':dorso_mano_alzata_carnagione_abbastanza_chiara:': u'\U0001F91A\U0001F3FC',
	u':dorso_mano_alzata_carnagione_olivastra:': u'\U0001F91A\U0001F3FD',
	u':dorso_mano_alzata_carnagione_abbastanza_scura:': u'\U0001F91A\U0001F3FE',
	u':dorso_mano_alzata_carnagione_scura:': u'\U0001F91A\U0001F3FF',
	u':mano_aperta:': u'\U0001F590\U0000FE0F',
	u':mano_aperta_carnagione_chiara:': u'\U0001F590\U0001F3FB',
	u':mano_aperta_carnagione_abbastanza_chiara:': u'\U0001F590\U0001F3FC',
	u':mano_aperta_carnagione_olivastra:': u'\U0001F590\U0001F3FD',
	u':mano_aperta_carnagione_abbastanza_scura:': u'\U0001F590\U0001F3FE',
	u':mano_aperta_carnagione_scura:': u'\U0001F590\U0001F3FF',
	u':mano_alzata:': u'\U0000270B',
	u':mano_alzata_carnagione_chiara:': u'\U0000270B\U0001F3FB',
	u':mano_alzata_carnagione_abbastanza_chiara:': u'\U0000270B\U0001F3FC',
	u':mano_alzata_carnagione_olivastra:': u'\U0000270B\U0001F3FD',
	u':mano_alzata_carnagione_abbastanza_scura:': u'\U0000270B\U0001F3FE',
	u':mano_alzata_carnagione_scura:': u'\U0000270B\U0001F3FF',
	u':saluto_vulcaniano:': u'\U0001F596',
	u':saluto_vulcaniano_carnagione_chiara:': u'\U0001F596\U0001F3FB',
	u':saluto_vulcaniano_carnagione_abbastanza_chiara:': u'\U0001F596\U0001F3FC',
	u':saluto_vulcaniano_carnagione_olivastra:': u'\U0001F596\U0001F3FD',
	u':saluto_vulcaniano_carnagione_abbastanza_scura:': u'\U0001F596\U0001F3FE',
	u':saluto_vulcaniano_carnagione_scura:': u'\U0001F596\U0001F3FF',
	u':mano_che_fa_ok:': u'\U0001F44C',
	u':mano_che_fa_ok_carnagione_chiara:': u'\U0001F44C\U0001F3FB',
	u':mano_che_fa_ok_carnagione_abbastanza_chiara:': u'\U0001F44C\U0001F3FC',
	u':mano_che_fa_ok_carnagione_olivastra:': u'\U0001F44C\U0001F3FD',
	u':mano_che_fa_ok_carnagione_abbastanza_scura:': u'\U0001F44C\U0001F3FE',
	u':mano_che_fa_ok_carnagione_scura:': u'\U0001F44C\U0001F3FF',
	u':mano_a_pigna:': u'\U0001F90C',
	u':mano_a_pigna_carnagione_chiara:': u'\U0001F90C\U0001F3FB',
	u':mano_a_pigna_carnagione_abbastanza_chiara:': u'\U0001F90C\U0001F3FC',
	u':mano_a_pigna_carnagione_olivastra:': u'\U0001F90C\U0001F3FD',
	u':mano_a_pigna_carnagione_abbastanza_scura:': u'\U0001F90C\U0001F3FE',
	u':mano_a_pigna_carnagione_scura:': u'\U0001F90C\U0001F3FF',
	u':mano_che_fa_il_gesto_del_pizzico:': u'\U0001F90F',
	u':mano_che_fa_il_gesto_del_pizzico_carnagione_chiara:': u'\U0001F90F\U0001F3FB',
	u':mano_che_fa_il_gesto_del_pizzico_carnagione_abbastanza_chiara:': u'\U0001F90F\U0001F3FC',
	u':mano_che_fa_il_gesto_del_pizzico_carnagione_olivastra:': u'\U0001F90F\U0001F3FD',
	u':mano_che_fa_il_gesto_del_pizzico_carnagione_abbastanza_scura:': u'\U0001F90F\U0001F3FE',
	u':mano_che_fa_il_gesto_del_pizzico_carnagione_scura:': u'\U0001F90F\U0001F3FF',
	u':vittoria:': u'\U0000270C\U0000FE0F',
	u':vittoria_carnagione_chiara:': u'\U0000270C\U0001F3FB',
	u':vittoria_carnagione_abbastanza_chiara:': u'\U0000270C\U0001F3FC',
	u':vittoria_carnagione_olivastra:': u'\U0000270C\U0001F3FD',
	u':vittoria_carnagione_abbastanza_scura:': u'\U0000270C\U0001F3FE',
	u':vittoria_carnagione_scura:': u'\U0000270C\U0001F3FF',
	u':dita_incrociate:': u'\U0001F91E',
	u':dita_incrociate_carnagione_chiara:': u'\U0001F91E\U0001F3FB',
	u':dita_incrociate_carnagione_abbastanza_chiara:': u'\U0001F91E\U0001F3FC',
	u':dita_incrociate_carnagione_olivastra:': u'\U0001F91E\U0001F3FD',
	u':dita_incrociate_carnagione_abbastanza_scura:': u'\U0001F91E\U0001F3FE',
	u':dita_incrociate_carnagione_scura:': u'\U0001F91E\U0001F3FF',
	u':gesto_ti_amo:': u'\U0001F91F',
	u':gesto_ti_amo_carnagione_chiara:': u'\U0001F91F\U0001F3FB',
	u':gesto_ti_amo_carnagione_abbastanza_chiara:': u'\U0001F91F\U0001F3FC',
	u':gesto_ti_amo_carnagione_olivastra:': u'\U0001F91F\U0001F3FD',
	u':gesto_ti_amo_carnagione_abbastanza_scura:': u'\U0001F91F\U0001F3FE',
	u':gesto_ti_amo_carnagione_scura:': u'\U0001F91F\U0001F3FF',
	u':segno_delle_corna:': u'\U0001F918',
	u':segno_delle_corna_carnagione_chiara:': u'\U0001F918\U0001F3FB',
	u':segno_delle_corna_carnagione_abbastanza_chiara:': u'\U0001F918\U0001F3FC',
	u':segno_delle_corna_carnagione_olivastra:': u'\U0001F918\U0001F3FD',
	u':segno_delle_corna_carnagione_abbastanza_scura:': u'\U0001F918\U0001F3FE',
	u':segno_delle_corna_carnagione_scura:': u'\U0001F918\U0001F3FF',
	u':mano_con_gesto_di_chiamata:': u'\U0001F919',
	u':mano_con_gesto_di_chiamata_carnagione_chiara:': u'\U0001F919\U0001F3FB',
	u':mano_con_gesto_di_chiamata_carnagione_abbastanza_chiara:': u'\U0001F919\U0001F3FC',
	u':mano_con_gesto_di_chiamata_carnagione_olivastra:': u'\U0001F919\U0001F3FD',
	u':mano_con_gesto_di_chiamata_carnagione_abbastanza_scura:': u'\U0001F919\U0001F3FE',
	u':mano_con_gesto_di_chiamata_carnagione_scura:': u'\U0001F919\U0001F3FF',
	u':indice_verso_sinistra:': u'\U0001F448',
	u':indice_verso_sinistra_carnagione_chiara:': u'\U0001F448\U0001F3FB',
	u':indice_verso_sinistra_carnagione_abbastanza_chiara:': u'\U0001F448\U0001F3FC',
	u':indice_verso_sinistra_carnagione_olivastra:': u'\U0001F448\U0001F3FD',
	u':indice_verso_sinistra_carnagione_abbastanza_scura:': u'\U0001F448\U0001F3FE',
	u':indice_verso_sinistra_carnagione_scura:': u'\U0001F448\U0001F3FF',
	u':indice_verso_destra:': u'\U0001F449',
	u':indice_verso_destra_carnagione_chiara:': u'\U0001F449\U0001F3FB',
	u':indice_verso_destra_carnagione_abbastanza_chiara:': u'\U0001F449\U0001F3FC',
	u':indice_verso_destra_carnagione_olivastra:': u'\U0001F449\U0001F3FD',
	u':indice_verso_destra_carnagione_abbastanza_scura:': u'\U0001F449\U0001F3FE',
	u':indice_verso_destra_carnagione_scura:': u'\U0001F449\U0001F3FF',
	u':indice_alzato:': u'\U0001F446',
	u':indice_alzato_carnagione_chiara:': u'\U0001F446\U0001F3FB',
	u':indice_alzato_carnagione_abbastanza_chiara:': u'\U0001F446\U0001F3FC',
	u':indice_alzato_carnagione_olivastra:': u'\U0001F446\U0001F3FD',
	u':indice_alzato_carnagione_abbastanza_scura:': u'\U0001F446\U0001F3FE',
	u':indice_alzato_carnagione_scura:': u'\U0001F446\U0001F3FF',
	u':dito_medio:': u'\U0001F595',
	u':dito_medio_carnagione_chiara:': u'\U0001F595\U0001F3FB',
	u':dito_medio_carnagione_abbastanza_chiara:': u'\U0001F595\U0001F3FC',
	u':dito_medio_carnagione_olivastra:': u'\U0001F595\U0001F3FD',
	u':dito_medio_carnagione_abbastanza_scura:': u'\U0001F595\U0001F3FE',
	u':dito_medio_carnagione_scura:': u'\U0001F595\U0001F3FF',
	u':indice_abbassato:': u'\U0001F447',
	u':indice_abbassato_carnagione_chiara:': u'\U0001F447\U0001F3FB',
	u':indice_abbassato_carnagione_abbastanza_chiara:': u'\U0001F447\U0001F3FC',
	u':indice_abbassato_carnagione_olivastra:': u'\U0001F447\U0001F3FD',
	u':indice_abbassato_carnagione_abbastanza_scura:': u'\U0001F447\U0001F3FE',
	u':indice_abbassato_carnagione_scura:': u'\U0001F447\U0001F3FF',
	u':indice_verso_l’alto:': u'\U0000261D\U0000FE0F',
	u':indice_verso_l’alto_carnagione_chiara:': u'\U0000261D\U0001F3FB',
	u':indice_verso_l’alto_carnagione_abbastanza_chiara:': u'\U0000261D\U0001F3FC',
	u':indice_verso_l’alto_carnagione_olivastra:': u'\U0000261D\U0001F3FD',
	u':indice_verso_l’alto_carnagione_abbastanza_scura:': u'\U0000261D\U0001F3FE',
	u':indice_verso_l’alto_carnagione_scura:': u'\U0000261D\U0001F3FF',
	u':pollice_in_su:': u'\U0001F44D',
	u':pollice_in_su_carnagione_chiara:': u'\U0001F44D\U0001F3FB',
	u':pollice_in_su_carnagione_abbastanza_chiara:': u'\U0001F44D\U0001F3FC',
	u':pollice_in_su_carnagione_olivastra:': u'\U0001F44D\U0001F3FD',
	u':pollice_in_su_carnagione_abbastanza_scura:': u'\U0001F44D\U0001F3FE',
	u':pollice_in_su_carnagione_scura:': u'\U0001F44D\U0001F3FF',
	u':pollice_verso:': u'\U0001F44E',
	u':pollice_verso_carnagione_chiara:': u'\U0001F44E\U0001F3FB',
	u':pollice_verso_carnagione_abbastanza_chiara:': u'\U0001F44E\U0001F3FC',
	u':pollice_verso_carnagione_olivastra:': u'\U0001F44E\U0001F3FD',
	u':pollice_verso_carnagione_abbastanza_scura:': u'\U0001F44E\U0001F3FE',
	u':pollice_verso_carnagione_scura:': u'\U0001F44E\U0001F3FF',
	u':pugno:': u'\U0000270A',
	u':pugno_carnagione_chiara:': u'\U0000270A\U0001F3FB',
	u':pugno_carnagione_abbastanza_chiara:': u'\U0000270A\U0001F3FC',
	u':pugno_carnagione_olivastra:': u'\U0000270A\U0001F3FD',
	u':pugno_carnagione_abbastanza_scura:': u'\U0000270A\U0001F3FE',
	u':pugno_carnagione_scura:': u'\U0000270A\U0001F3FF',
	u':pugno_chiuso:': u'\U0001F44A',
	u':pugno_chiuso_carnagione_chiara:': u'\U0001F44A\U0001F3FB',
	u':pugno_chiuso_carnagione_abbastanza_chiara:': u'\U0001F44A\U0001F3FC',
	u':pugno_chiuso_carnagione_olivastra:': u'\U0001F44A\U0001F3FD',
	u':pugno_chiuso_carnagione_abbastanza_scura:': u'\U0001F44A\U0001F3FE',
	u':pugno_chiuso_carnagione_scura:': u'\U0001F44A\U0001F3FF',
	u':pugno_a_sinistra:': u'\U0001F91B',
	u':pugno_a_sinistra_carnagione_chiara:': u'\U0001F91B\U0001F3FB',
	u':pugno_a_sinistra_carnagione_abbastanza_chiara:': u'\U0001F91B\U0001F3FC',
	u':pugno_a_sinistra_carnagione_olivastra:': u'\U0001F91B\U0001F3FD',
	u':pugno_a_sinistra_carnagione_abbastanza_scura:': u'\U0001F91B\U0001F3FE',
	u':pugno_a_sinistra_carnagione_scura:': u'\U0001F91B\U0001F3FF',
	u':pugno_a_destra:': u'\U0001F91C',
	u':pugno_a_destra_carnagione_chiara:': u'\U0001F91C\U0001F3FB',
	u':pugno_a_destra_carnagione_abbastanza_chiara:': u'\U0001F91C\U0001F3FC',
	u':pugno_a_destra_carnagione_olivastra:': u'\U0001F91C\U0001F3FD',
	u':pugno_a_destra_carnagione_abbastanza_scura:': u'\U0001F91C\U0001F3FE',
	u':pugno_a_destra_carnagione_scura:': u'\U0001F91C\U0001F3FF',
	u':mani_che_applaudono:': u'\U0001F44F',
	u':mani_che_applaudono_carnagione_chiara:': u'\U0001F44F\U0001F3FB',
	u':mani_che_applaudono_carnagione_abbastanza_chiara:': u'\U0001F44F\U0001F3FC',
	u':mani_che_applaudono_carnagione_olivastra:': u'\U0001F44F\U0001F3FD',
	u':mani_che_applaudono_carnagione_abbastanza_scura:': u'\U0001F44F\U0001F3FE',
	u':mani_che_applaudono_carnagione_scura:': u'\U0001F44F\U0001F3FF',
	u':mani_alzate:': u'\U0001F64C',
	u':mani_alzate_carnagione_chiara:': u'\U0001F64C\U0001F3FB',
	u':mani_alzate_carnagione_abbastanza_chiara:': u'\U0001F64C\U0001F3FC',
	u':mani_alzate_carnagione_olivastra:': u'\U0001F64C\U0001F3FD',
	u':mani_alzate_carnagione_abbastanza_scura:': u'\U0001F64C\U0001F3FE',
	u':mani_alzate_carnagione_scura:': u'\U0001F64C\U0001F3FF',
	u':mani_aperte:': u'\U0001F450',
	u':mani_aperte_carnagione_chiara:': u'\U0001F450\U0001F3FB',
	u':mani_aperte_carnagione_abbastanza_chiara:': u'\U0001F450\U0001F3FC',
	u':mani_aperte_carnagione_olivastra:': u'\U0001F450\U0001F3FD',
	u':mani_aperte_carnagione_abbastanza_scura:': u'\U0001F450\U0001F3FE',
	u':mani_aperte_carnagione_scura:': u'\U0001F450\U0001F3FF',
	u':mani_unite_in_alto:': u'\U0001F932',
	u':mani_unite_in_alto_carnagione_chiara:': u'\U0001F932\U0001F3FB',
	u':mani_unite_in_alto_carnagione_abbastanza_chiara:': u'\U0001F932\U0001F3FC',
	u':mani_unite_in_alto_carnagione_olivastra:': u'\U0001F932\U0001F3FD',
	u':mani_unite_in_alto_carnagione_abbastanza_scura:': u'\U0001F932\U0001F3FE',
	u':mani_unite_in_alto_carnagione_scura:': u'\U0001F932\U0001F3FF',
	u':stretta_di_mano:': u'\U0001F91D',
	u':mani_giunte:': u'\U0001F64F',
	u':mani_giunte_carnagione_chiara:': u'\U0001F64F\U0001F3FB',
	u':mani_giunte_carnagione_abbastanza_chiara:': u'\U0001F64F\U0001F3FC',
	u':mani_giunte_carnagione_olivastra:': u'\U0001F64F\U0001F3FD',
	u':mani_giunte_carnagione_abbastanza_scura:': u'\U0001F64F\U0001F3FE',
	u':mani_giunte_carnagione_scura:': u'\U0001F64F\U0001F3FF',
	u':mano_che_scrive:': u'\U0000270D\U0000FE0F',
	u':mano_che_scrive_carnagione_chiara:': u'\U0000270D\U0001F3FB',
	u':mano_che_scrive_carnagione_abbastanza_chiara:': u'\U0000270D\U0001F3FC',
	u':mano_che_scrive_carnagione_olivastra:': u'\U0000270D\U0001F3FD',
	u':mano_che_scrive_carnagione_abbastanza_scura:': u'\U0000270D\U0001F3FE',
	u':mano_che_scrive_carnagione_scura:': u'\U0000270D\U0001F3FF',
	u':smalto_per_unghie:': u'\U0001F485',
	u':smalto_per_unghie_carnagione_chiara:': u'\U0001F485\U0001F3FB',
	u':smalto_per_unghie_carnagione_abbastanza_chiara:': u'\U0001F485\U0001F3FC',
	u':smalto_per_unghie_carnagione_olivastra:': u'\U0001F485\U0001F3FD',
	u':smalto_per_unghie_carnagione_abbastanza_scura:': u'\U0001F485\U0001F3FE',
	u':smalto_per_unghie_carnagione_scura:': u'\U0001F485\U0001F3FF',
	u':selfie:': u'\U0001F933',
	u':selfie_carnagione_chiara:': u'\U0001F933\U0001F3FB',
	u':selfie_carnagione_abbastanza_chiara:': u'\U0001F933\U0001F3FC',
	u':selfie_carnagione_olivastra:': u'\U0001F933\U0001F3FD',
	u':selfie_carnagione_abbastanza_scura:': u'\U0001F933\U0001F3FE',
	u':selfie_carnagione_scura:': u'\U0001F933\U0001F3FF',
	u':bicipite:': u'\U0001F4AA',
	u':bicipite_carnagione_chiara:': u'\U0001F4AA\U0001F3FB',
	u':bicipite_carnagione_abbastanza_chiara:': u'\U0001F4AA\U0001F3FC',
	u':bicipite_carnagione_olivastra:': u'\U0001F4AA\U0001F3FD',
	u':bicipite_carnagione_abbastanza_scura:': u'\U0001F4AA\U0001F3FE',
	u':bicipite_carnagione_scura:': u'\U0001F4AA\U0001F3FF',
	u':protesi_robotica_per_il_braccio:': u'\U0001F9BE',
	u':protesi_robotica_per_la_gamba:': u'\U0001F9BF',
	u':gamba:': u'\U0001F9B5',
	u':gamba_carnagione_chiara:': u'\U0001F9B5\U0001F3FB',
	u':gamba_carnagione_abbastanza_chiara:': u'\U0001F9B5\U0001F3FC',
	u':gamba_carnagione_olivastra:': u'\U0001F9B5\U0001F3FD',
	u':gamba_carnagione_abbastanza_scura:': u'\U0001F9B5\U0001F3FE',
	u':gamba_carnagione_scura:': u'\U0001F9B5\U0001F3FF',
	u':piede:': u'\U0001F9B6',
	u':piede_carnagione_chiara:': u'\U0001F9B6\U0001F3FB',
	u':piede_carnagione_abbastanza_chiara:': u'\U0001F9B6\U0001F3FC',
	u':piede_carnagione_olivastra:': u'\U0001F9B6\U0001F3FD',
	u':piede_carnagione_abbastanza_scura:': u'\U0001F9B6\U0001F3FE',
	u':piede_carnagione_scura:': u'\U0001F9B6\U0001F3FF',
	u':orecchio:': u'\U0001F442',
	u':orecchio_carnagione_chiara:': u'\U0001F442\U0001F3FB',
	u':orecchio_carnagione_abbastanza_chiara:': u'\U0001F442\U0001F3FC',
	u':orecchio_carnagione_olivastra:': u'\U0001F442\U0001F3FD',
	u':orecchio_carnagione_abbastanza_scura:': u'\U0001F442\U0001F3FE',
	u':orecchio_carnagione_scura:': u'\U0001F442\U0001F3FF',
	u':orecchio_con_apparecchio_acustico:': u'\U0001F9BB',
	u':orecchio_con_apparecchio_acustico_carnagione_chiara:': u'\U0001F9BB\U0001F3FB',
	u':orecchio_con_apparecchio_acustico_carnagione_abbastanza_chiara:': u'\U0001F9BB\U0001F3FC',
	u':orecchio_con_apparecchio_acustico_carnagione_olivastra:': u'\U0001F9BB\U0001F3FD',
	u':orecchio_con_apparecchio_acustico_carnagione_abbastanza_scura:': u'\U0001F9BB\U0001F3FE',
	u':orecchio_con_apparecchio_acustico_carnagione_scura:': u'\U0001F9BB\U0001F3FF',
	u':naso:': u'\U0001F443',
	u':naso_carnagione_chiara:': u'\U0001F443\U0001F3FB',
	u':naso_carnagione_abbastanza_chiara:': u'\U0001F443\U0001F3FC',
	u':naso_carnagione_olivastra:': u'\U0001F443\U0001F3FD',
	u':naso_carnagione_abbastanza_scura:': u'\U0001F443\U0001F3FE',
	u':naso_carnagione_scura:': u'\U0001F443\U0001F3FF',
	u':cervello:': u'\U0001F9E0',
	u':organo_del_cuore:': u'\U0001FAC0',
	u':polmoni:': u'\U0001FAC1',
	u':dente:': u'\U0001F9B7',
	u':osso:': u'\U0001F9B4',
	u':occhi:': u'\U0001F440',
	u':occhio:': u'\U0001F441\U0000FE0F',
	u':lingua:': u'\U0001F445',
	u':bocca:': u'\U0001F444',
	u':neonato:': u'\U0001F476',
	u':neonato_carnagione_chiara:': u'\U0001F476\U0001F3FB',
	u':neonato_carnagione_abbastanza_chiara:': u'\U0001F476\U0001F3FC',
	u':neonato_carnagione_olivastra:': u'\U0001F476\U0001F3FD',
	u':neonato_carnagione_abbastanza_scura:': u'\U0001F476\U0001F3FE',
	u':neonato_carnagione_scura:': u'\U0001F476\U0001F3FF',
	u':bimbo:': u'\U0001F9D2',
	u':bimbo_carnagione_chiara:': u'\U0001F9D2\U0001F3FB',
	u':bimbo_carnagione_abbastanza_chiara:': u'\U0001F9D2\U0001F3FC',
	u':bimbo_carnagione_olivastra:': u'\U0001F9D2\U0001F3FD',
	u':bimbo_carnagione_abbastanza_scura:': u'\U0001F9D2\U0001F3FE',
	u':bimbo_carnagione_scura:': u'\U0001F9D2\U0001F3FF',
	u':bambino:': u'\U0001F466',
	u':bambino_carnagione_chiara:': u'\U0001F466\U0001F3FB',
	u':bambino_carnagione_abbastanza_chiara:': u'\U0001F466\U0001F3FC',
	u':bambino_carnagione_olivastra:': u'\U0001F466\U0001F3FD',
	u':bambino_carnagione_abbastanza_scura:': u'\U0001F466\U0001F3FE',
	u':bambino_carnagione_scura:': u'\U0001F466\U0001F3FF',
	u':bambina:': u'\U0001F467',
	u':bambina_carnagione_chiara:': u'\U0001F467\U0001F3FB',
	u':bambina_carnagione_abbastanza_chiara:': u'\U0001F467\U0001F3FC',
	u':bambina_carnagione_olivastra:': u'\U0001F467\U0001F3FD',
	u':bambina_carnagione_abbastanza_scura:': u'\U0001F467\U0001F3FE',
	u':bambina_carnagione_scura:': u'\U0001F467\U0001F3FF',
	u':persona:': u'\U0001F9D1',
	u':persona_carnagione_chiara:': u'\U0001F9D1\U0001F3FB',
	u':persona_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC',
	u':persona_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD',
	u':persona_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE',
	u':persona_carnagione_scura:': u'\U0001F9D1\U0001F3FF',
	u':persona_bionda:': u'\U0001F471',
	u':persona_bionda_carnagione_chiara:': u'\U0001F471\U0001F3FB',
	u':persona_bionda_carnagione_abbastanza_chiara:': u'\U0001F471\U0001F3FC',
	u':persona_bionda_carnagione_olivastra:': u'\U0001F471\U0001F3FD',
	u':persona_bionda_carnagione_abbastanza_scura:': u'\U0001F471\U0001F3FE',
	u':persona_bionda_carnagione_scura:': u'\U0001F471\U0001F3FF',
	u':uomo:': u'\U0001F468',
	u':uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB',
	u':uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC',
	u':uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD',
	u':uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE',
	u':uomo_carnagione_scura:': u'\U0001F468\U0001F3FF',
	u':uomo_con_la_barba:': u'\U0001F9D4',
	u':uomo_con_la_barba_carnagione_chiara:': u'\U0001F9D4\U0001F3FB',
	u':uomo_con_la_barba_carnagione_abbastanza_chiara:': u'\U0001F9D4\U0001F3FC',
	u':uomo_con_la_barba_carnagione_olivastra:': u'\U0001F9D4\U0001F3FD',
	u':uomo_con_la_barba_carnagione_abbastanza_scura:': u'\U0001F9D4\U0001F3FE',
	u':uomo_con_la_barba_carnagione_scura:': u'\U0001F9D4\U0001F3FF',
	u':uomo_capelli_rossi:': u'\U0001F468\U0000200D\U0001F9B0',
	u':uomo_carnagione_chiara_e_capelli_rossi:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B0',
	u':uomo_carnagione_abbastanza_chiara_e_capelli_rossi:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B0',
	u':uomo_carnagione_olivastra_e_capelli_rossi:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B0',
	u':uomo_carnagione_abbastanza_scura_e_capelli_rossi:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B0',
	u':uomo_carnagione_scura_e_capelli_rossi:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B0',
	u':uomo_capelli_ricci:': u'\U0001F468\U0000200D\U0001F9B1',
	u':uomo_carnagione_chiara_e_capelli_ricci:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B1',
	u':uomo_carnagione_abbastanza_chiara_e_capelli_ricci:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B1',
	u':uomo_carnagione_olivastra_e_capelli_ricci:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B1',
	u':uomo_carnagione_abbastanza_scura_e_capelli_ricci:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B1',
	u':uomo_carnagione_scura_e_capelli_ricci:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B1',
	u':uomo_capelli_bianchi:': u'\U0001F468\U0000200D\U0001F9B3',
	u':uomo_carnagione_chiara_e_capelli_bianchi:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B3',
	u':uomo_carnagione_abbastanza_chiara_e_capelli_bianchi:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B3',
	u':uomo_carnagione_olivastra_e_capelli_bianchi:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B3',
	u':uomo_carnagione_abbastanza_scura_e_capelli_bianchi:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B3',
	u':uomo_carnagione_scura_e_capelli_bianchi:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B3',
	u':uomo_calvo:': u'\U0001F468\U0000200D\U0001F9B2',
	u':uomo_carnagione_chiara_e_calvo:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B2',
	u':uomo_carnagione_abbastanza_chiara_e_calvo:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B2',
	u':uomo_carnagione_olivastra_e_calvo:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B2',
	u':uomo_carnagione_abbastanza_scura_e_calvo:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B2',
	u':uomo_carnagione_scura_e_calvo:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B2',
	u':donna:': u'\U0001F469',
	u':donna_carnagione_chiara:': u'\U0001F469\U0001F3FB',
	u':donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC',
	u':donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD',
	u':donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE',
	u':donna_carnagione_scura:': u'\U0001F469\U0001F3FF',
	u':donna_capelli_rossi:': u'\U0001F469\U0000200D\U0001F9B0',
	u':donna_carnagione_chiara_e_capelli_rossi:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B0',
	u':donna_carnagione_abbastanza_chiara_e_capelli_rossi:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B0',
	u':donna_carnagione_olivastra_e_capelli_rossi:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B0',
	u':donna_carnagione_abbastanza_scura_e_capelli_rossi:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B0',
	u':donna_carnagione_scura_e_capelli_rossi:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B0',
	u':persona_capelli_rossi:': u'\U0001F9D1\U0000200D\U0001F9B0',
	u':persona_carnagione_chiara_e_capelli_rossi:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B0',
	u':persona_carnagione_abbastanza_chiara_e_capelli_rossi:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B0',
	u':persona_carnagione_olivastra_e_capelli_rossi:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B0',
	u':persona_carnagione_abbastanza_scura_e_capelli_rossi:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B0',
	u':persona_carnagione_scura_e_capelli_rossi:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B0',
	u':donna_capelli_ricci:': u'\U0001F469\U0000200D\U0001F9B1',
	u':donna_carnagione_chiara_e_capelli_ricci:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B1',
	u':donna_carnagione_abbastanza_chiara_e_capelli_ricci:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B1',
	u':donna_carnagione_olivastra_e_capelli_ricci:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B1',
	u':donna_carnagione_abbastanza_scura_e_capelli_ricci:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B1',
	u':donna_carnagione_scura_e_capelli_ricci:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B1',
	u':persona_capelli_ricci:': u'\U0001F9D1\U0000200D\U0001F9B1',
	u':persona_carnagione_chiara_e_capelli_ricci:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B1',
	u':persona_carnagione_abbastanza_chiara_e_capelli_ricci:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B1',
	u':persona_carnagione_olivastra_e_capelli_ricci:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B1',
	u':persona_carnagione_abbastanza_scura_e_capelli_ricci:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B1',
	u':persona_carnagione_scura_e_capelli_ricci:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B1',
	u':donna_capelli_bianchi:': u'\U0001F469\U0000200D\U0001F9B3',
	u':donna_carnagione_chiara_e_capelli_bianchi:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B3',
	u':donna_carnagione_abbastanza_chiara_e_capelli_bianchi:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B3',
	u':donna_carnagione_olivastra_e_capelli_bianchi:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B3',
	u':donna_carnagione_abbastanza_scura_e_capelli_bianchi:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B3',
	u':donna_carnagione_scura_e_capelli_bianchi:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B3',
	u':persona_capelli_bianchi:': u'\U0001F9D1\U0000200D\U0001F9B3',
	u':persona_carnagione_chiara_e_capelli_bianchi:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B3',
	u':persona_carnagione_abbastanza_chiara_e_capelli_bianchi:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B3',
	u':persona_carnagione_olivastra_e_capelli_bianchi:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B3',
	u':persona_carnagione_abbastanza_scura_e_capelli_bianchi:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B3',
	u':persona_carnagione_scura_e_capelli_bianchi:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B3',
	u':donna_calvo:': u'\U0001F469\U0000200D\U0001F9B2',
	u':donna_carnagione_chiara_e_calvo:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B2',
	u':donna_carnagione_abbastanza_chiara_e_calvo:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B2',
	u':donna_carnagione_olivastra_e_calvo:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B2',
	u':donna_carnagione_abbastanza_scura_e_calvo:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B2',
	u':donna_carnagione_scura_e_calvo:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B2',
	u':persona_calvo:': u'\U0001F9D1\U0000200D\U0001F9B2',
	u':persona_carnagione_chiara_e_calvo:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B2',
	u':persona_carnagione_abbastanza_chiara_e_calvo:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B2',
	u':persona_carnagione_olivastra_e_calvo:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B2',
	u':persona_carnagione_abbastanza_scura_e_calvo:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B2',
	u':persona_carnagione_scura_e_calvo:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B2',
	u':donna_bionda:': u'\U0001F471\U0000200D\U00002640\U0000FE0F',
	u':donna_bionda_carnagione_chiara:': u'\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_bionda_carnagione_abbastanza_chiara:': u'\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_bionda_carnagione_olivastra:': u'\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_bionda_carnagione_abbastanza_scura:': u'\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_bionda_carnagione_scura:': u'\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':uomo_biondo:': u'\U0001F471\U0000200D\U00002642\U0000FE0F',
	u':uomo_biondo_carnagione_chiara:': u'\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_biondo_carnagione_abbastanza_chiara:': u'\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_biondo_carnagione_olivastra:': u'\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_biondo_carnagione_abbastanza_scura:': u'\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_biondo_carnagione_scura:': u'\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':persona_anziana:': u'\U0001F9D3',
	u':persona_anziana_carnagione_chiara:': u'\U0001F9D3\U0001F3FB',
	u':persona_anziana_carnagione_abbastanza_chiara:': u'\U0001F9D3\U0001F3FC',
	u':persona_anziana_carnagione_olivastra:': u'\U0001F9D3\U0001F3FD',
	u':persona_anziana_carnagione_abbastanza_scura:': u'\U0001F9D3\U0001F3FE',
	u':persona_anziana_carnagione_scura:': u'\U0001F9D3\U0001F3FF',
	u':uomo_anziano:': u'\U0001F474',
	u':uomo_anziano_carnagione_chiara:': u'\U0001F474\U0001F3FB',
	u':uomo_anziano_carnagione_abbastanza_chiara:': u'\U0001F474\U0001F3FC',
	u':uomo_anziano_carnagione_olivastra:': u'\U0001F474\U0001F3FD',
	u':uomo_anziano_carnagione_abbastanza_scura:': u'\U0001F474\U0001F3FE',
	u':uomo_anziano_carnagione_scura:': u'\U0001F474\U0001F3FF',
	u':donna_anziana:': u'\U0001F475',
	u':donna_anziana_carnagione_chiara:': u'\U0001F475\U0001F3FB',
	u':donna_anziana_carnagione_abbastanza_chiara:': u'\U0001F475\U0001F3FC',
	u':donna_anziana_carnagione_olivastra:': u'\U0001F475\U0001F3FD',
	u':donna_anziana_carnagione_abbastanza_scura:': u'\U0001F475\U0001F3FE',
	u':donna_anziana_carnagione_scura:': u'\U0001F475\U0001F3FF',
	u':persona_corrucciata:': u'\U0001F64D',
	u':persona_corrucciata_carnagione_chiara:': u'\U0001F64D\U0001F3FB',
	u':persona_corrucciata_carnagione_abbastanza_chiara:': u'\U0001F64D\U0001F3FC',
	u':persona_corrucciata_carnagione_olivastra:': u'\U0001F64D\U0001F3FD',
	u':persona_corrucciata_carnagione_abbastanza_scura:': u'\U0001F64D\U0001F3FE',
	u':persona_corrucciata_carnagione_scura:': u'\U0001F64D\U0001F3FF',
	u':uomo_corrucciato:': u'\U0001F64D\U0000200D\U00002642\U0000FE0F',
	u':uomo_corrucciato_carnagione_chiara:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_corrucciato_carnagione_abbastanza_chiara:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_corrucciato_carnagione_olivastra:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_corrucciato_carnagione_abbastanza_scura:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_corrucciato_carnagione_scura:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_corrucciata:': u'\U0001F64D\U0000200D\U00002640\U0000FE0F',
	u':donna_corrucciata_carnagione_chiara:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_corrucciata_carnagione_abbastanza_chiara:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_corrucciata_carnagione_olivastra:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_corrucciata_carnagione_abbastanza_scura:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_corrucciata_carnagione_scura:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_imbronciata:': u'\U0001F64E',
	u':persona_imbronciata_carnagione_chiara:': u'\U0001F64E\U0001F3FB',
	u':persona_imbronciata_carnagione_abbastanza_chiara:': u'\U0001F64E\U0001F3FC',
	u':persona_imbronciata_carnagione_olivastra:': u'\U0001F64E\U0001F3FD',
	u':persona_imbronciata_carnagione_abbastanza_scura:': u'\U0001F64E\U0001F3FE',
	u':persona_imbronciata_carnagione_scura:': u'\U0001F64E\U0001F3FF',
	u':uomo_imbronciato:': u'\U0001F64E\U0000200D\U00002642\U0000FE0F',
	u':uomo_imbronciato_carnagione_chiara:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_imbronciato_carnagione_abbastanza_chiara:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_imbronciato_carnagione_olivastra:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_imbronciato_carnagione_abbastanza_scura:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_imbronciato_carnagione_scura:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_imbronciata:': u'\U0001F64E\U0000200D\U00002640\U0000FE0F',
	u':donna_imbronciata_carnagione_chiara:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_imbronciata_carnagione_abbastanza_chiara:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_imbronciata_carnagione_olivastra:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_imbronciata_carnagione_abbastanza_scura:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_imbronciata_carnagione_scura:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_fa_segno_di_no:': u'\U0001F645',
	u':persona_che_fa_segno_di_no_carnagione_chiara:': u'\U0001F645\U0001F3FB',
	u':persona_che_fa_segno_di_no_carnagione_abbastanza_chiara:': u'\U0001F645\U0001F3FC',
	u':persona_che_fa_segno_di_no_carnagione_olivastra:': u'\U0001F645\U0001F3FD',
	u':persona_che_fa_segno_di_no_carnagione_abbastanza_scura:': u'\U0001F645\U0001F3FE',
	u':persona_che_fa_segno_di_no_carnagione_scura:': u'\U0001F645\U0001F3FF',
	u':uomo_con_gesto_di_rifiuto:': u'\U0001F645\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_di_rifiuto_carnagione_chiara:': u'\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_di_rifiuto_carnagione_abbastanza_chiara:': u'\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_di_rifiuto_carnagione_olivastra:': u'\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_di_rifiuto_carnagione_abbastanza_scura:': u'\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_di_rifiuto_carnagione_scura:': u'\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_con_gesto_di_rifiuto:': u'\U0001F645\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_di_rifiuto_carnagione_chiara:': u'\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_di_rifiuto_carnagione_abbastanza_chiara:': u'\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_di_rifiuto_carnagione_olivastra:': u'\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_di_rifiuto_carnagione_abbastanza_scura:': u'\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_di_rifiuto_carnagione_scura:': u'\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_con_gesto_ok:': u'\U0001F646',
	u':persona_con_gesto_ok_carnagione_chiara:': u'\U0001F646\U0001F3FB',
	u':persona_con_gesto_ok_carnagione_abbastanza_chiara:': u'\U0001F646\U0001F3FC',
	u':persona_con_gesto_ok_carnagione_olivastra:': u'\U0001F646\U0001F3FD',
	u':persona_con_gesto_ok_carnagione_abbastanza_scura:': u'\U0001F646\U0001F3FE',
	u':persona_con_gesto_ok_carnagione_scura:': u'\U0001F646\U0001F3FF',
	u':uomo_con_gesto_ok:': u'\U0001F646\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_ok_carnagione_chiara:': u'\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_ok_carnagione_abbastanza_chiara:': u'\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_ok_carnagione_olivastra:': u'\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_ok_carnagione_abbastanza_scura:': u'\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_gesto_ok_carnagione_scura:': u'\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_con_gesto_ok:': u'\U0001F646\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_ok_carnagione_chiara:': u'\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_ok_carnagione_abbastanza_chiara:': u'\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_ok_carnagione_olivastra:': u'\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_ok_carnagione_abbastanza_scura:': u'\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_con_gesto_ok_carnagione_scura:': u'\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_al_punto_informazioni:': u'\U0001F481',
	u':persona_al_punto_informazioni_carnagione_chiara:': u'\U0001F481\U0001F3FB',
	u':persona_al_punto_informazioni_carnagione_abbastanza_chiara:': u'\U0001F481\U0001F3FC',
	u':persona_al_punto_informazioni_carnagione_olivastra:': u'\U0001F481\U0001F3FD',
	u':persona_al_punto_informazioni_carnagione_abbastanza_scura:': u'\U0001F481\U0001F3FE',
	u':persona_al_punto_informazioni_carnagione_scura:': u'\U0001F481\U0001F3FF',
	u':uomo_con_suggerimento:': u'\U0001F481\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_suggerimento_carnagione_chiara:': u'\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_suggerimento_carnagione_abbastanza_chiara:': u'\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_suggerimento_carnagione_olivastra:': u'\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_suggerimento_carnagione_abbastanza_scura:': u'\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_suggerimento_carnagione_scura:': u'\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_con_suggerimento:': u'\U0001F481\U0000200D\U00002640\U0000FE0F',
	u':donna_con_suggerimento_carnagione_chiara:': u'\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_con_suggerimento_carnagione_abbastanza_chiara:': u'\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_con_suggerimento_carnagione_olivastra:': u'\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_con_suggerimento_carnagione_abbastanza_scura:': u'\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_con_suggerimento_carnagione_scura:': u'\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_con_mano_alzata:': u'\U0001F64B',
	u':persona_con_mano_alzata_carnagione_chiara:': u'\U0001F64B\U0001F3FB',
	u':persona_con_mano_alzata_carnagione_abbastanza_chiara:': u'\U0001F64B\U0001F3FC',
	u':persona_con_mano_alzata_carnagione_olivastra:': u'\U0001F64B\U0001F3FD',
	u':persona_con_mano_alzata_carnagione_abbastanza_scura:': u'\U0001F64B\U0001F3FE',
	u':persona_con_mano_alzata_carnagione_scura:': u'\U0001F64B\U0001F3FF',
	u':uomo_con_mano_alzata:': u'\U0001F64B\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_mano_alzata_carnagione_chiara:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_mano_alzata_carnagione_abbastanza_chiara:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_mano_alzata_carnagione_olivastra:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_mano_alzata_carnagione_abbastanza_scura:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_mano_alzata_carnagione_scura:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_con_mano_alzata:': u'\U0001F64B\U0000200D\U00002640\U0000FE0F',
	u':donna_con_mano_alzata_carnagione_chiara:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_con_mano_alzata_carnagione_abbastanza_chiara:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_con_mano_alzata_carnagione_olivastra:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_con_mano_alzata_carnagione_abbastanza_scura:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_con_mano_alzata_carnagione_scura:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_con_problemi_di_udito:': u'\U0001F9CF',
	u':persona_con_problemi_di_udito_carnagione_chiara:': u'\U0001F9CF\U0001F3FB',
	u':persona_con_problemi_di_udito_carnagione_abbastanza_chiara:': u'\U0001F9CF\U0001F3FC',
	u':persona_con_problemi_di_udito_carnagione_olivastra:': u'\U0001F9CF\U0001F3FD',
	u':persona_con_problemi_di_udito_carnagione_abbastanza_scura:': u'\U0001F9CF\U0001F3FE',
	u':persona_con_problemi_di_udito_carnagione_scura:': u'\U0001F9CF\U0001F3FF',
	u':uomo_con_problemi_di_udito:': u'\U0001F9CF\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_problemi_di_udito_carnagione_chiara:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_problemi_di_udito_carnagione_abbastanza_chiara:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_problemi_di_udito_carnagione_olivastra:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_problemi_di_udito_carnagione_abbastanza_scura:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_problemi_di_udito_carnagione_scura:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_con_problemi_di_udito:': u'\U0001F9CF\U0000200D\U00002640\U0000FE0F',
	u':donna_con_problemi_di_udito_carnagione_chiara:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_con_problemi_di_udito_carnagione_abbastanza_chiara:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_con_problemi_di_udito_carnagione_olivastra:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_con_problemi_di_udito_carnagione_abbastanza_scura:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_con_problemi_di_udito_carnagione_scura:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_fa_un_inchino_profondo:': u'\U0001F647',
	u':persona_che_fa_un_inchino_profondo_carnagione_chiara:': u'\U0001F647\U0001F3FB',
	u':persona_che_fa_un_inchino_profondo_carnagione_abbastanza_chiara:': u'\U0001F647\U0001F3FC',
	u':persona_che_fa_un_inchino_profondo_carnagione_olivastra:': u'\U0001F647\U0001F3FD',
	u':persona_che_fa_un_inchino_profondo_carnagione_abbastanza_scura:': u'\U0001F647\U0001F3FE',
	u':persona_che_fa_un_inchino_profondo_carnagione_scura:': u'\U0001F647\U0001F3FF',
	u':uomo_che_fa_inchino_profondo:': u'\U0001F647\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_inchino_profondo_carnagione_chiara:': u'\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_inchino_profondo_carnagione_abbastanza_chiara:': u'\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_inchino_profondo_carnagione_olivastra:': u'\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_inchino_profondo_carnagione_abbastanza_scura:': u'\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_inchino_profondo_carnagione_scura:': u'\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_fa_inchino_profondo:': u'\U0001F647\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_inchino_profondo_carnagione_chiara:': u'\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_inchino_profondo_carnagione_abbastanza_chiara:': u'\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_inchino_profondo_carnagione_olivastra:': u'\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_inchino_profondo_carnagione_abbastanza_scura:': u'\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_inchino_profondo_carnagione_scura:': u'\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_esasperata:': u'\U0001F926',
	u':persona_esasperata_carnagione_chiara:': u'\U0001F926\U0001F3FB',
	u':persona_esasperata_carnagione_abbastanza_chiara:': u'\U0001F926\U0001F3FC',
	u':persona_esasperata_carnagione_olivastra:': u'\U0001F926\U0001F3FD',
	u':persona_esasperata_carnagione_abbastanza_scura:': u'\U0001F926\U0001F3FE',
	u':persona_esasperata_carnagione_scura:': u'\U0001F926\U0001F3FF',
	u':uomo_esasperato:': u'\U0001F926\U0000200D\U00002642\U0000FE0F',
	u':uomo_esasperato_carnagione_chiara:': u'\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_esasperato_carnagione_abbastanza_chiara:': u'\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_esasperato_carnagione_olivastra:': u'\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_esasperato_carnagione_abbastanza_scura:': u'\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_esasperato_carnagione_scura:': u'\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_esasperata:': u'\U0001F926\U0000200D\U00002640\U0000FE0F',
	u':donna_esasperata_carnagione_chiara:': u'\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_esasperata_carnagione_abbastanza_chiara:': u'\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_esasperata_carnagione_olivastra:': u'\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_esasperata_carnagione_abbastanza_scura:': u'\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_esasperata_carnagione_scura:': u'\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_scrolla_le_spalle:': u'\U0001F937',
	u':persona_che_scrolla_le_spalle_carnagione_chiara:': u'\U0001F937\U0001F3FB',
	u':persona_che_scrolla_le_spalle_carnagione_abbastanza_chiara:': u'\U0001F937\U0001F3FC',
	u':persona_che_scrolla_le_spalle_carnagione_olivastra:': u'\U0001F937\U0001F3FD',
	u':persona_che_scrolla_le_spalle_carnagione_abbastanza_scura:': u'\U0001F937\U0001F3FE',
	u':persona_che_scrolla_le_spalle_carnagione_scura:': u'\U0001F937\U0001F3FF',
	u':uomo_che_scrolla_le_spalle:': u'\U0001F937\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_scrolla_le_spalle_carnagione_chiara:': u'\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_scrolla_le_spalle_carnagione_abbastanza_chiara:': u'\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_scrolla_le_spalle_carnagione_olivastra:': u'\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_scrolla_le_spalle_carnagione_abbastanza_scura:': u'\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_scrolla_le_spalle_carnagione_scura:': u'\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_scrolla_le_spalle:': u'\U0001F937\U0000200D\U00002640\U0000FE0F',
	u':donna_che_scrolla_le_spalle_carnagione_chiara:': u'\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_scrolla_le_spalle_carnagione_abbastanza_chiara:': u'\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_scrolla_le_spalle_carnagione_olivastra:': u'\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_scrolla_le_spalle_carnagione_abbastanza_scura:': u'\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_scrolla_le_spalle_carnagione_scura:': u'\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_lavora_nella_sanità:': u'\U0001F9D1\U0000200D\U00002695\U0000FE0F',
	u':persona_che_lavora_nella_sanità_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002695\U0000FE0F',
	u':persona_che_lavora_nella_sanità_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002695\U0000FE0F',
	u':persona_che_lavora_nella_sanità_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002695\U0000FE0F',
	u':persona_che_lavora_nella_sanità_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002695\U0000FE0F',
	u':persona_che_lavora_nella_sanità_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002695\U0000FE0F',
	u':operatore_sanitario:': u'\U0001F468\U0000200D\U00002695\U0000FE0F',
	u':operatore_sanitario_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F',
	u':operatore_sanitario_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F',
	u':operatore_sanitario_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F',
	u':operatore_sanitario_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F',
	u':operatore_sanitario_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F',
	u':operatrice_sanitaria:': u'\U0001F469\U0000200D\U00002695\U0000FE0F',
	u':operatrice_sanitaria_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F',
	u':operatrice_sanitaria_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F',
	u':operatrice_sanitaria_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F',
	u':operatrice_sanitaria_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F',
	u':operatrice_sanitaria_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F',
	u':studente:': u'\U0001F9D1\U0000200D\U0001F393',
	u':studente_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F393',
	u':studente_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F393',
	u':studente_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F393',
	u':studente_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F393',
	u':studente_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F393',
	u':studente_maschio:': u'\U0001F468\U0000200D\U0001F393',
	u':studente_maschio_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F393',
	u':studente_maschio_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F393',
	u':studente_maschio_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F393',
	u':studente_maschio_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F393',
	u':studente_maschio_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F393',
	u':studentessa:': u'\U0001F469\U0000200D\U0001F393',
	u':studentessa_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F393',
	u':studentessa_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F393',
	u':studentessa_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F393',
	u':studentessa_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F393',
	u':studentessa_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F393',
	u':insegnante:': u'\U0001F9D1\U0000200D\U0001F3EB',
	u':insegnante_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3EB',
	u':insegnante_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3EB',
	u':insegnante_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3EB',
	u':insegnante_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3EB',
	u':insegnante_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3EB',
	u':professore:': u'\U0001F468\U0000200D\U0001F3EB',
	u':professore_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3EB',
	u':professore_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3EB',
	u':professore_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3EB',
	u':professore_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3EB',
	u':professore_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3EB',
	u':professoressa:': u'\U0001F469\U0000200D\U0001F3EB',
	u':professoressa_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3EB',
	u':professoressa_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3EB',
	u':professoressa_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3EB',
	u':professoressa_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3EB',
	u':professoressa_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3EB',
	u':giudice:': u'\U0001F9D1\U0000200D\U00002696\U0000FE0F',
	u':giudice_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002696\U0000FE0F',
	u':giudice_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002696\U0000FE0F',
	u':giudice_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002696\U0000FE0F',
	u':giudice_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002696\U0000FE0F',
	u':giudice_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002696\U0000FE0F',
	u':giudice_uomo:': u'\U0001F468\U0000200D\U00002696\U0000FE0F',
	u':giudice_uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F',
	u':giudice_uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F',
	u':giudice_uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F',
	u':giudice_uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F',
	u':giudice_uomo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F',
	u':giudice_donna:': u'\U0001F469\U0000200D\U00002696\U0000FE0F',
	u':giudice_donna_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F',
	u':giudice_donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F',
	u':giudice_donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F',
	u':giudice_donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F',
	u':giudice_donna_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F',
	u':agricoltore:': u'\U0001F9D1\U0000200D\U0001F33E',
	u':agricoltore_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F33E',
	u':agricoltore_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F33E',
	u':agricoltore_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F33E',
	u':agricoltore_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F33E',
	u':agricoltore_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F33E',
	u':contadino:': u'\U0001F468\U0000200D\U0001F33E',
	u':contadino_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F33E',
	u':contadino_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F33E',
	u':contadino_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F33E',
	u':contadino_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F33E',
	u':contadino_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F33E',
	u':contadina:': u'\U0001F469\U0000200D\U0001F33E',
	u':contadina_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F33E',
	u':contadina_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F33E',
	u':contadina_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F33E',
	u':contadina_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F33E',
	u':contadina_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F33E',
	u':persona_che_cucina:': u'\U0001F9D1\U0000200D\U0001F373',
	u':persona_che_cucina_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F373',
	u':persona_che_cucina_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F373',
	u':persona_che_cucina_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F373',
	u':persona_che_cucina_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F373',
	u':persona_che_cucina_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F373',
	u':cuoco:': u'\U0001F468\U0000200D\U0001F373',
	u':cuoco_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F373',
	u':cuoco_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F373',
	u':cuoco_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F373',
	u':cuoco_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F373',
	u':cuoco_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F373',
	u':cuoca:': u'\U0001F469\U0000200D\U0001F373',
	u':cuoca_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F373',
	u':cuoca_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F373',
	u':cuoca_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F373',
	u':cuoca_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F373',
	u':cuoca_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F373',
	u':meccanico:': u'\U0001F9D1\U0000200D\U0001F527',
	u':meccanico_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F527',
	u':meccanico_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F527',
	u':meccanico_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F527',
	u':meccanico_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F527',
	u':meccanico_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F527',
	u':meccanico_uomo:': u'\U0001F468\U0000200D\U0001F527',
	u':meccanico_uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F527',
	u':meccanico_uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F527',
	u':meccanico_uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F527',
	u':meccanico_uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F527',
	u':meccanico_uomo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F527',
	u':meccanico_donna:': u'\U0001F469\U0000200D\U0001F527',
	u':meccanico_donna_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F527',
	u':meccanico_donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F527',
	u':meccanico_donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F527',
	u':meccanico_donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F527',
	u':meccanico_donna_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F527',
	u':persona_che_lavora_in_fabbrica:': u'\U0001F9D1\U0000200D\U0001F3ED',
	u':persona_che_lavora_in_fabbrica_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3ED',
	u':persona_che_lavora_in_fabbrica_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3ED',
	u':persona_che_lavora_in_fabbrica_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3ED',
	u':persona_che_lavora_in_fabbrica_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3ED',
	u':persona_che_lavora_in_fabbrica_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3ED',
	u':operaio:': u'\U0001F468\U0000200D\U0001F3ED',
	u':operaio_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3ED',
	u':operaio_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3ED',
	u':operaio_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3ED',
	u':operaio_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3ED',
	u':operaio_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3ED',
	u':operaia:': u'\U0001F469\U0000200D\U0001F3ED',
	u':operaia_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3ED',
	u':operaia_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3ED',
	u':operaia_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3ED',
	u':operaia_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3ED',
	u':operaia_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3ED',
	u':persona_che_fa_un_lavoro_d’ufficio:': u'\U0001F9D1\U0000200D\U0001F4BC',
	u':persona_che_fa_un_lavoro_d’ufficio_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BC',
	u':persona_che_fa_un_lavoro_d’ufficio_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BC',
	u':persona_che_fa_un_lavoro_d’ufficio_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BC',
	u':persona_che_fa_un_lavoro_d’ufficio_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BC',
	u':persona_che_fa_un_lavoro_d’ufficio_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BC',
	u':impiegato:': u'\U0001F468\U0000200D\U0001F4BC',
	u':impiegato_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BC',
	u':impiegato_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BC',
	u':impiegato_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BC',
	u':impiegato_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BC',
	u':impiegato_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BC',
	u':impiegata:': u'\U0001F469\U0000200D\U0001F4BC',
	u':impiegata_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BC',
	u':impiegata_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BC',
	u':impiegata_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BC',
	u':impiegata_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BC',
	u':impiegata_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BC',
	u':persona_che_lavora_in_campo_scientifico:': u'\U0001F9D1\U0000200D\U0001F52C',
	u':persona_che_lavora_in_campo_scientifico_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F52C',
	u':persona_che_lavora_in_campo_scientifico_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F52C',
	u':persona_che_lavora_in_campo_scientifico_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F52C',
	u':persona_che_lavora_in_campo_scientifico_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F52C',
	u':persona_che_lavora_in_campo_scientifico_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F52C',
	u':scienziato:': u'\U0001F468\U0000200D\U0001F52C',
	u':scienziato_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F52C',
	u':scienziato_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F52C',
	u':scienziato_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F52C',
	u':scienziato_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F52C',
	u':scienziato_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F52C',
	u':scienziata:': u'\U0001F469\U0000200D\U0001F52C',
	u':scienziata_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F52C',
	u':scienziata_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F52C',
	u':scienziata_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F52C',
	u':scienziata_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F52C',
	u':scienziata_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F52C',
	u':persona_esperta_di_tecnologia:': u'\U0001F9D1\U0000200D\U0001F4BB',
	u':persona_esperta_di_tecnologia_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BB',
	u':persona_esperta_di_tecnologia_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BB',
	u':persona_esperta_di_tecnologia_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BB',
	u':persona_esperta_di_tecnologia_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BB',
	u':persona_esperta_di_tecnologia_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BB',
	u':tecnologo:': u'\U0001F468\U0000200D\U0001F4BB',
	u':tecnologo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BB',
	u':tecnologo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BB',
	u':tecnologo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BB',
	u':tecnologo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BB',
	u':tecnologo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BB',
	u':tecnologa:': u'\U0001F469\U0000200D\U0001F4BB',
	u':tecnologa_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BB',
	u':tecnologa_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BB',
	u':tecnologa_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BB',
	u':tecnologa_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BB',
	u':tecnologa_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BB',
	u':cantante:': u'\U0001F9D1\U0000200D\U0001F3A4',
	u':cantante_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A4',
	u':cantante_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A4',
	u':cantante_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A4',
	u':cantante_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A4',
	u':cantante_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A4',
	u':cantante_uomo:': u'\U0001F468\U0000200D\U0001F3A4',
	u':cantante_uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A4',
	u':cantante_uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A4',
	u':cantante_uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A4',
	u':cantante_uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A4',
	u':cantante_uomo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A4',
	u':cantante_donna:': u'\U0001F469\U0000200D\U0001F3A4',
	u':cantante_donna_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A4',
	u':cantante_donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A4',
	u':cantante_donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A4',
	u':cantante_donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A4',
	u':cantante_donna_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A4',
	u':artista:': u'\U0001F9D1\U0000200D\U0001F3A8',
	u':artista_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A8',
	u':artista_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A8',
	u':artista_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A8',
	u':artista_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A8',
	u':artista_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A8',
	u':artista_uomo:': u'\U0001F468\U0000200D\U0001F3A8',
	u':artista_uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A8',
	u':artista_uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A8',
	u':artista_uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A8',
	u':artista_uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A8',
	u':artista_uomo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A8',
	u':artista_donna:': u'\U0001F469\U0000200D\U0001F3A8',
	u':artista_donna_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A8',
	u':artista_donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A8',
	u':artista_donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A8',
	u':artista_donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A8',
	u':artista_donna_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A8',
	u':pilota:': u'\U0001F9D1\U0000200D\U00002708\U0000FE0F',
	u':pilota_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002708\U0000FE0F',
	u':pilota_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002708\U0000FE0F',
	u':pilota_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002708\U0000FE0F',
	u':pilota_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002708\U0000FE0F',
	u':pilota_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002708\U0000FE0F',
	u':pilota_uomo:': u'\U0001F468\U0000200D\U00002708\U0000FE0F',
	u':pilota_uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F',
	u':pilota_uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F',
	u':pilota_uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F',
	u':pilota_uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F',
	u':pilota_uomo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F',
	u':pilota_donna:': u'\U0001F469\U0000200D\U00002708\U0000FE0F',
	u':pilota_donna_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F',
	u':pilota_donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F',
	u':pilota_donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F',
	u':pilota_donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F',
	u':pilota_donna_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F',
	u':astronauta:': u'\U0001F9D1\U0000200D\U0001F680',
	u':astronauta_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F680',
	u':astronauta_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F680',
	u':astronauta_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F680',
	u':astronauta_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F680',
	u':astronauta_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F680',
	u':astronauta_uomo:': u'\U0001F468\U0000200D\U0001F680',
	u':astronauta_uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F680',
	u':astronauta_uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F680',
	u':astronauta_uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F680',
	u':astronauta_uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F680',
	u':astronauta_uomo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F680',
	u':astronauta_donna:': u'\U0001F469\U0000200D\U0001F680',
	u':astronauta_donna_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F680',
	u':astronauta_donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F680',
	u':astronauta_donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F680',
	u':astronauta_donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F680',
	u':astronauta_donna_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F680',
	u':pompiere:': u'\U0001F9D1\U0000200D\U0001F692',
	u':pompiere_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F692',
	u':pompiere_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F692',
	u':pompiere_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F692',
	u':pompiere_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F692',
	u':pompiere_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F692',
	u':pompiere_uomo:': u'\U0001F468\U0000200D\U0001F692',
	u':pompiere_uomo_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F692',
	u':pompiere_uomo_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F692',
	u':pompiere_uomo_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F692',
	u':pompiere_uomo_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F692',
	u':pompiere_uomo_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F692',
	u':pompiere_donna:': u'\U0001F469\U0000200D\U0001F692',
	u':pompiere_donna_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F692',
	u':pompiere_donna_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F692',
	u':pompiere_donna_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F692',
	u':pompiere_donna_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F692',
	u':pompiere_donna_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F692',
	u':agente_di_polizia:': u'\U0001F46E',
	u':agente_di_polizia_carnagione_chiara:': u'\U0001F46E\U0001F3FB',
	u':agente_di_polizia_carnagione_abbastanza_chiara:': u'\U0001F46E\U0001F3FC',
	u':agente_di_polizia_carnagione_olivastra:': u'\U0001F46E\U0001F3FD',
	u':agente_di_polizia_carnagione_abbastanza_scura:': u'\U0001F46E\U0001F3FE',
	u':agente_di_polizia_carnagione_scura:': u'\U0001F46E\U0001F3FF',
	u':poliziotto_uomo:': u'\U0001F46E\U0000200D\U00002642\U0000FE0F',
	u':poliziotto_uomo_carnagione_chiara:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':poliziotto_uomo_carnagione_abbastanza_chiara:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':poliziotto_uomo_carnagione_olivastra:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':poliziotto_uomo_carnagione_abbastanza_scura:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':poliziotto_uomo_carnagione_scura:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':poliziotta:': u'\U0001F46E\U0000200D\U00002640\U0000FE0F',
	u':poliziotta_carnagione_chiara:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':poliziotta_carnagione_abbastanza_chiara:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':poliziotta_carnagione_olivastra:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':poliziotta_carnagione_abbastanza_scura:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':poliziotta_carnagione_scura:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':detective:': u'\U0001F575\U0000FE0F',
	u':detective_carnagione_chiara:': u'\U0001F575\U0001F3FB',
	u':detective_carnagione_abbastanza_chiara:': u'\U0001F575\U0001F3FC',
	u':detective_carnagione_olivastra:': u'\U0001F575\U0001F3FD',
	u':detective_carnagione_abbastanza_scura:': u'\U0001F575\U0001F3FE',
	u':detective_carnagione_scura:': u'\U0001F575\U0001F3FF',
	u':investigatore:': u'\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':investigatore_carnagione_chiara:': u'\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':investigatore_carnagione_abbastanza_chiara:': u'\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':investigatore_carnagione_olivastra:': u'\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':investigatore_carnagione_abbastanza_scura:': u'\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':investigatore_carnagione_scura:': u'\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':investigatrice:': u'\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':investigatrice_carnagione_chiara:': u'\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':investigatrice_carnagione_abbastanza_chiara:': u'\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':investigatrice_carnagione_olivastra:': u'\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':investigatrice_carnagione_abbastanza_scura:': u'\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':investigatrice_carnagione_scura:': u'\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':guardia:': u'\U0001F482',
	u':guardia_carnagione_chiara:': u'\U0001F482\U0001F3FB',
	u':guardia_carnagione_abbastanza_chiara:': u'\U0001F482\U0001F3FC',
	u':guardia_carnagione_olivastra:': u'\U0001F482\U0001F3FD',
	u':guardia_carnagione_abbastanza_scura:': u'\U0001F482\U0001F3FE',
	u':guardia_carnagione_scura:': u'\U0001F482\U0001F3FF',
	u':guardia_uomo:': u'\U0001F482\U0000200D\U00002642\U0000FE0F',
	u':guardia_uomo_carnagione_chiara:': u'\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':guardia_uomo_carnagione_abbastanza_chiara:': u'\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':guardia_uomo_carnagione_olivastra:': u'\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':guardia_uomo_carnagione_abbastanza_scura:': u'\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':guardia_uomo_carnagione_scura:': u'\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':guardia_donna:': u'\U0001F482\U0000200D\U00002640\U0000FE0F',
	u':guardia_donna_carnagione_chiara:': u'\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':guardia_donna_carnagione_abbastanza_chiara:': u'\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':guardia_donna_carnagione_olivastra:': u'\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':guardia_donna_carnagione_abbastanza_scura:': u'\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':guardia_donna_carnagione_scura:': u'\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':ninja:': u'\U0001F977',
	u':ninja_carnagione_chiara:': u'\U0001F977\U0001F3FB',
	u':ninja_carnagione_abbastanza_chiara:': u'\U0001F977\U0001F3FC',
	u':ninja_carnagione_olivastra:': u'\U0001F977\U0001F3FD',
	u':ninja_carnagione_abbastanza_scura:': u'\U0001F977\U0001F3FE',
	u':ninja_carnagione_scura:': u'\U0001F977\U0001F3FF',
	u':operaio_edile:': u'\U0001F477',
	u':operaio_edile_carnagione_chiara:': u'\U0001F477\U0001F3FB',
	u':operaio_edile_carnagione_abbastanza_chiara:': u'\U0001F477\U0001F3FC',
	u':operaio_edile_carnagione_olivastra:': u'\U0001F477\U0001F3FD',
	u':operaio_edile_carnagione_abbastanza_scura:': u'\U0001F477\U0001F3FE',
	u':operaio_edile_carnagione_scura:': u'\U0001F477\U0001F3FF',
	u':operaio_edile_uomo:': u'\U0001F477\U0000200D\U00002642\U0000FE0F',
	u':operaio_edile_uomo_carnagione_chiara:': u'\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':operaio_edile_uomo_carnagione_abbastanza_chiara:': u'\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':operaio_edile_uomo_carnagione_olivastra:': u'\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':operaio_edile_uomo_carnagione_abbastanza_scura:': u'\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':operaio_edile_uomo_carnagione_scura:': u'\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':operaia_edile:': u'\U0001F477\U0000200D\U00002640\U0000FE0F',
	u':operaia_edile_carnagione_chiara:': u'\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':operaia_edile_carnagione_abbastanza_chiara:': u'\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':operaia_edile_carnagione_olivastra:': u'\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':operaia_edile_carnagione_abbastanza_scura:': u'\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':operaia_edile_carnagione_scura:': u'\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':principe:': u'\U0001F934',
	u':principe_carnagione_chiara:': u'\U0001F934\U0001F3FB',
	u':principe_carnagione_abbastanza_chiara:': u'\U0001F934\U0001F3FC',
	u':principe_carnagione_olivastra:': u'\U0001F934\U0001F3FD',
	u':principe_carnagione_abbastanza_scura:': u'\U0001F934\U0001F3FE',
	u':principe_carnagione_scura:': u'\U0001F934\U0001F3FF',
	u':principessa:': u'\U0001F478',
	u':principessa_carnagione_chiara:': u'\U0001F478\U0001F3FB',
	u':principessa_carnagione_abbastanza_chiara:': u'\U0001F478\U0001F3FC',
	u':principessa_carnagione_olivastra:': u'\U0001F478\U0001F3FD',
	u':principessa_carnagione_abbastanza_scura:': u'\U0001F478\U0001F3FE',
	u':principessa_carnagione_scura:': u'\U0001F478\U0001F3FF',
	u':persona_con_turbante:': u'\U0001F473',
	u':persona_con_turbante_carnagione_chiara:': u'\U0001F473\U0001F3FB',
	u':persona_con_turbante_carnagione_abbastanza_chiara:': u'\U0001F473\U0001F3FC',
	u':persona_con_turbante_carnagione_olivastra:': u'\U0001F473\U0001F3FD',
	u':persona_con_turbante_carnagione_abbastanza_scura:': u'\U0001F473\U0001F3FE',
	u':persona_con_turbante_carnagione_scura:': u'\U0001F473\U0001F3FF',
	u':uomo_con_turbante:': u'\U0001F473\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_turbante_carnagione_chiara:': u'\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_turbante_carnagione_abbastanza_chiara:': u'\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_turbante_carnagione_olivastra:': u'\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_turbante_carnagione_abbastanza_scura:': u'\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_con_turbante_carnagione_scura:': u'\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_con_turbante:': u'\U0001F473\U0000200D\U00002640\U0000FE0F',
	u':donna_con_turbante_carnagione_chiara:': u'\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_con_turbante_carnagione_abbastanza_chiara:': u'\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_con_turbante_carnagione_olivastra:': u'\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_con_turbante_carnagione_abbastanza_scura:': u'\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_con_turbante_carnagione_scura:': u'\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':uomo_con_zucchetto_cinese:': u'\U0001F472',
	u':uomo_con_zucchetto_cinese_carnagione_chiara:': u'\U0001F472\U0001F3FB',
	u':uomo_con_zucchetto_cinese_carnagione_abbastanza_chiara:': u'\U0001F472\U0001F3FC',
	u':uomo_con_zucchetto_cinese_carnagione_olivastra:': u'\U0001F472\U0001F3FD',
	u':uomo_con_zucchetto_cinese_carnagione_abbastanza_scura:': u'\U0001F472\U0001F3FE',
	u':uomo_con_zucchetto_cinese_carnagione_scura:': u'\U0001F472\U0001F3FF',
	u':donna_con_velo:': u'\U0001F9D5',
	u':donna_con_velo_carnagione_chiara:': u'\U0001F9D5\U0001F3FB',
	u':donna_con_velo_carnagione_abbastanza_chiara:': u'\U0001F9D5\U0001F3FC',
	u':donna_con_velo_carnagione_olivastra:': u'\U0001F9D5\U0001F3FD',
	u':donna_con_velo_carnagione_abbastanza_scura:': u'\U0001F9D5\U0001F3FE',
	u':donna_con_velo_carnagione_scura:': u'\U0001F9D5\U0001F3FF',
	u':persona_in_smoking:': u'\U0001F935',
	u':persona_in_smoking_carnagione_chiara:': u'\U0001F935\U0001F3FB',
	u':persona_in_smoking_carnagione_abbastanza_chiara:': u'\U0001F935\U0001F3FC',
	u':persona_in_smoking_carnagione_olivastra:': u'\U0001F935\U0001F3FD',
	u':persona_in_smoking_carnagione_abbastanza_scura:': u'\U0001F935\U0001F3FE',
	u':persona_in_smoking_carnagione_scura:': u'\U0001F935\U0001F3FF',
	u':uomo_in_smoking:': u'\U0001F935\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_smoking_carnagione_chiara:': u'\U0001F935\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_smoking_carnagione_abbastanza_chiara:': u'\U0001F935\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_smoking_carnagione_olivastra:': u'\U0001F935\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_smoking_carnagione_abbastanza_scura:': u'\U0001F935\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_smoking_carnagione_scura:': u'\U0001F935\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_in_smoking:': u'\U0001F935\U0000200D\U00002640\U0000FE0F',
	u':donna_in_smoking_carnagione_chiara:': u'\U0001F935\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_in_smoking_carnagione_abbastanza_chiara:': u'\U0001F935\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_in_smoking_carnagione_olivastra:': u'\U0001F935\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_in_smoking_carnagione_abbastanza_scura:': u'\U0001F935\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_in_smoking_carnagione_scura:': u'\U0001F935\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_con_velo:': u'\U0001F470',
	u':persona_con_velo_carnagione_chiara:': u'\U0001F470\U0001F3FB',
	u':persona_con_velo_carnagione_abbastanza_chiara:': u'\U0001F470\U0001F3FC',
	u':persona_con_velo_carnagione_olivastra:': u'\U0001F470\U0001F3FD',
	u':persona_con_velo_carnagione_abbastanza_scura:': u'\U0001F470\U0001F3FE',
	u':persona_con_velo_carnagione_scura:': u'\U0001F470\U0001F3FF',
	u':sposo_con_velo:': u'\U0001F470\U0000200D\U00002642\U0000FE0F',
	u':sposo_con_velo_carnagione_chiara:': u'\U0001F470\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':sposo_con_velo_carnagione_abbastanza_chiara:': u'\U0001F470\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':sposo_con_velo_carnagione_olivastra:': u'\U0001F470\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':sposo_con_velo_carnagione_abbastanza_scura:': u'\U0001F470\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':sposo_con_velo_carnagione_scura:': u'\U0001F470\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':sposa_con_velo:': u'\U0001F470\U0000200D\U00002640\U0000FE0F',
	u':sposa_con_velo_carnagione_chiara:': u'\U0001F470\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':sposa_con_velo_carnagione_abbastanza_chiara:': u'\U0001F470\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':sposa_con_velo_carnagione_olivastra:': u'\U0001F470\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':sposa_con_velo_carnagione_abbastanza_scura:': u'\U0001F470\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':sposa_con_velo_carnagione_scura:': u'\U0001F470\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':donna_incinta:': u'\U0001F930',
	u':donna_incinta_carnagione_chiara:': u'\U0001F930\U0001F3FB',
	u':donna_incinta_carnagione_abbastanza_chiara:': u'\U0001F930\U0001F3FC',
	u':donna_incinta_carnagione_olivastra:': u'\U0001F930\U0001F3FD',
	u':donna_incinta_carnagione_abbastanza_scura:': u'\U0001F930\U0001F3FE',
	u':donna_incinta_carnagione_scura:': u'\U0001F930\U0001F3FF',
	u':allattare:': u'\U0001F931',
	u':allattare_carnagione_chiara:': u'\U0001F931\U0001F3FB',
	u':allattare_carnagione_abbastanza_chiara:': u'\U0001F931\U0001F3FC',
	u':allattare_carnagione_olivastra:': u'\U0001F931\U0001F3FD',
	u':allattare_carnagione_abbastanza_scura:': u'\U0001F931\U0001F3FE',
	u':allattare_carnagione_scura:': u'\U0001F931\U0001F3FF',
	u':donna_che_allatta:': u'\U0001F469\U0000200D\U0001F37C',
	u':donna_che_allatta_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F37C',
	u':donna_che_allatta_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F37C',
	u':donna_che_allatta_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F37C',
	u':donna_che_allatta_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F37C',
	u':donna_che_allatta_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F37C',
	u':uomo_che_allatta:': u'\U0001F468\U0000200D\U0001F37C',
	u':uomo_che_allatta_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F37C',
	u':uomo_che_allatta_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F37C',
	u':uomo_che_allatta_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F37C',
	u':uomo_che_allatta_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F37C',
	u':uomo_che_allatta_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F37C',
	u':persona_che_allatta:': u'\U0001F9D1\U0000200D\U0001F37C',
	u':persona_che_allatta_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F37C',
	u':persona_che_allatta_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F37C',
	u':persona_che_allatta_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F37C',
	u':persona_che_allatta_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F37C',
	u':persona_che_allatta_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F37C',
	u':angioletto:': u'\U0001F47C',
	u':angioletto_carnagione_chiara:': u'\U0001F47C\U0001F3FB',
	u':angioletto_carnagione_abbastanza_chiara:': u'\U0001F47C\U0001F3FC',
	u':angioletto_carnagione_olivastra:': u'\U0001F47C\U0001F3FD',
	u':angioletto_carnagione_abbastanza_scura:': u'\U0001F47C\U0001F3FE',
	u':angioletto_carnagione_scura:': u'\U0001F47C\U0001F3FF',
	u':babbo_natale:': u'\U0001F385',
	u':babbo_natale_carnagione_chiara:': u'\U0001F385\U0001F3FB',
	u':babbo_natale_carnagione_abbastanza_chiara:': u'\U0001F385\U0001F3FC',
	u':babbo_natale_carnagione_olivastra:': u'\U0001F385\U0001F3FD',
	u':babbo_natale_carnagione_abbastanza_scura:': u'\U0001F385\U0001F3FE',
	u':babbo_natale_carnagione_scura:': u'\U0001F385\U0001F3FF',
	u':mamma_natale:': u'\U0001F936',
	u':mamma_natale_carnagione_chiara:': u'\U0001F936\U0001F3FB',
	u':mamma_natale_carnagione_abbastanza_chiara:': u'\U0001F936\U0001F3FC',
	u':mamma_natale_carnagione_olivastra:': u'\U0001F936\U0001F3FD',
	u':mamma_natale_carnagione_abbastanza_scura:': u'\U0001F936\U0001F3FE',
	u':mamma_natale_carnagione_scura:': u'\U0001F936\U0001F3FF',
	u':santa_claus:': u'\U0001F9D1\U0000200D\U0001F384',
	u':santa_claus_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F384',
	u':santa_claus_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F384',
	u':santa_claus_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F384',
	u':santa_claus_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F384',
	u':santa_claus_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F384',
	u':supereroe:': u'\U0001F9B8',
	u':supereroe_carnagione_chiara:': u'\U0001F9B8\U0001F3FB',
	u':supereroe_carnagione_abbastanza_chiara:': u'\U0001F9B8\U0001F3FC',
	u':supereroe_carnagione_olivastra:': u'\U0001F9B8\U0001F3FD',
	u':supereroe_carnagione_abbastanza_scura:': u'\U0001F9B8\U0001F3FE',
	u':supereroe_carnagione_scura:': u'\U0001F9B8\U0001F3FF',
	u':supereroe_uomo:': u'\U0001F9B8\U0000200D\U00002642\U0000FE0F',
	u':supereroe_uomo_carnagione_chiara:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':supereroe_uomo_carnagione_abbastanza_chiara:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':supereroe_uomo_carnagione_olivastra:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':supereroe_uomo_carnagione_abbastanza_scura:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':supereroe_uomo_carnagione_scura:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':supereroina:': u'\U0001F9B8\U0000200D\U00002640\U0000FE0F',
	u':supereroina_carnagione_chiara:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':supereroina_carnagione_abbastanza_chiara:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':supereroina_carnagione_olivastra:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':supereroina_carnagione_abbastanza_scura:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':supereroina_carnagione_scura:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':supercattivo:': u'\U0001F9B9',
	u':supercattivo_carnagione_chiara:': u'\U0001F9B9\U0001F3FB',
	u':supercattivo_carnagione_abbastanza_chiara:': u'\U0001F9B9\U0001F3FC',
	u':supercattivo_carnagione_olivastra:': u'\U0001F9B9\U0001F3FD',
	u':supercattivo_carnagione_abbastanza_scura:': u'\U0001F9B9\U0001F3FE',
	u':supercattivo_carnagione_scura:': u'\U0001F9B9\U0001F3FF',
	u':supercattivo_uomo:': u'\U0001F9B9\U0000200D\U00002642\U0000FE0F',
	u':supercattivo_uomo_carnagione_chiara:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':supercattivo_uomo_carnagione_abbastanza_chiara:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':supercattivo_uomo_carnagione_olivastra:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':supercattivo_uomo_carnagione_abbastanza_scura:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':supercattivo_uomo_carnagione_scura:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':supercattiva:': u'\U0001F9B9\U0000200D\U00002640\U0000FE0F',
	u':supercattiva_carnagione_chiara:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':supercattiva_carnagione_abbastanza_chiara:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':supercattiva_carnagione_olivastra:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':supercattiva_carnagione_abbastanza_scura:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':supercattiva_carnagione_scura:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':mago:': u'\U0001F9D9',
	u':mago_carnagione_chiara:': u'\U0001F9D9\U0001F3FB',
	u':mago_carnagione_abbastanza_chiara:': u'\U0001F9D9\U0001F3FC',
	u':mago_carnagione_olivastra:': u'\U0001F9D9\U0001F3FD',
	u':mago_carnagione_abbastanza_scura:': u'\U0001F9D9\U0001F3FE',
	u':mago_carnagione_scura:': u'\U0001F9D9\U0001F3FF',
	u':mago_uomo:': u'\U0001F9D9\U0000200D\U00002642\U0000FE0F',
	u':mago_uomo_carnagione_chiara:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mago_uomo_carnagione_abbastanza_chiara:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mago_uomo_carnagione_olivastra:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mago_uomo_carnagione_abbastanza_scura:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mago_uomo_carnagione_scura:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':maga:': u'\U0001F9D9\U0000200D\U00002640\U0000FE0F',
	u':maga_carnagione_chiara:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':maga_carnagione_abbastanza_chiara:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':maga_carnagione_olivastra:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':maga_carnagione_abbastanza_scura:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':maga_carnagione_scura:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':fata:': u'\U0001F9DA',
	u':fata_carnagione_chiara:': u'\U0001F9DA\U0001F3FB',
	u':fata_carnagione_abbastanza_chiara:': u'\U0001F9DA\U0001F3FC',
	u':fata_carnagione_olivastra:': u'\U0001F9DA\U0001F3FD',
	u':fata_carnagione_abbastanza_scura:': u'\U0001F9DA\U0001F3FE',
	u':fata_carnagione_scura:': u'\U0001F9DA\U0001F3FF',
	u':folletto_alato:': u'\U0001F9DA\U0000200D\U00002642\U0000FE0F',
	u':folletto_alato_carnagione_chiara:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':folletto_alato_carnagione_abbastanza_chiara:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':folletto_alato_carnagione_olivastra:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':folletto_alato_carnagione_abbastanza_scura:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':folletto_alato_carnagione_scura:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':fata_donna:': u'\U0001F9DA\U0000200D\U00002640\U0000FE0F',
	u':fata_donna_carnagione_chiara:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':fata_donna_carnagione_abbastanza_chiara:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':fata_donna_carnagione_olivastra:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':fata_donna_carnagione_abbastanza_scura:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':fata_donna_carnagione_scura:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':vampiro:': u'\U0001F9DB',
	u':vampiro_carnagione_chiara:': u'\U0001F9DB\U0001F3FB',
	u':vampiro_carnagione_abbastanza_chiara:': u'\U0001F9DB\U0001F3FC',
	u':vampiro_carnagione_olivastra:': u'\U0001F9DB\U0001F3FD',
	u':vampiro_carnagione_abbastanza_scura:': u'\U0001F9DB\U0001F3FE',
	u':vampiro_carnagione_scura:': u'\U0001F9DB\U0001F3FF',
	u':vampiro_uomo:': u'\U0001F9DB\U0000200D\U00002642\U0000FE0F',
	u':vampiro_uomo_carnagione_chiara:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':vampiro_uomo_carnagione_abbastanza_chiara:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':vampiro_uomo_carnagione_olivastra:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':vampiro_uomo_carnagione_abbastanza_scura:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':vampiro_uomo_carnagione_scura:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':vampira:': u'\U0001F9DB\U0000200D\U00002640\U0000FE0F',
	u':vampira_carnagione_chiara:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':vampira_carnagione_abbastanza_chiara:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':vampira_carnagione_olivastra:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':vampira_carnagione_abbastanza_scura:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':vampira_carnagione_scura:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':sirena:': u'\U0001F9DC',
	u':sirena_carnagione_chiara:': u'\U0001F9DC\U0001F3FB',
	u':sirena_carnagione_abbastanza_chiara:': u'\U0001F9DC\U0001F3FC',
	u':sirena_carnagione_olivastra:': u'\U0001F9DC\U0001F3FD',
	u':sirena_carnagione_abbastanza_scura:': u'\U0001F9DC\U0001F3FE',
	u':sirena_carnagione_scura:': u'\U0001F9DC\U0001F3FF',
	u':tritone:': u'\U0001F9DC\U0000200D\U00002642\U0000FE0F',
	u':tritone_carnagione_chiara:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':tritone_carnagione_abbastanza_chiara:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':tritone_carnagione_olivastra:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':tritone_carnagione_abbastanza_scura:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':tritone_carnagione_scura:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':sirena_donna:': u'\U0001F9DC\U0000200D\U00002640\U0000FE0F',
	u':sirena_donna_carnagione_chiara:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':sirena_donna_carnagione_abbastanza_chiara:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':sirena_donna_carnagione_olivastra:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':sirena_donna_carnagione_abbastanza_scura:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':sirena_donna_carnagione_scura:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':elfo:': u'\U0001F9DD',
	u':elfo_carnagione_chiara:': u'\U0001F9DD\U0001F3FB',
	u':elfo_carnagione_abbastanza_chiara:': u'\U0001F9DD\U0001F3FC',
	u':elfo_carnagione_olivastra:': u'\U0001F9DD\U0001F3FD',
	u':elfo_carnagione_abbastanza_scura:': u'\U0001F9DD\U0001F3FE',
	u':elfo_carnagione_scura:': u'\U0001F9DD\U0001F3FF',
	u':elfo_uomo:': u'\U0001F9DD\U0000200D\U00002642\U0000FE0F',
	u':elfo_uomo_carnagione_chiara:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':elfo_uomo_carnagione_abbastanza_chiara:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':elfo_uomo_carnagione_olivastra:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':elfo_uomo_carnagione_abbastanza_scura:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':elfo_uomo_carnagione_scura:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':elfo_donna:': u'\U0001F9DD\U0000200D\U00002640\U0000FE0F',
	u':elfo_donna_carnagione_chiara:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':elfo_donna_carnagione_abbastanza_chiara:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':elfo_donna_carnagione_olivastra:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':elfo_donna_carnagione_abbastanza_scura:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':elfo_donna_carnagione_scura:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':genio:': u'\U0001F9DE',
	u':genio_uomo:': u'\U0001F9DE\U0000200D\U00002642\U0000FE0F',
	u':genio_donna:': u'\U0001F9DE\U0000200D\U00002640\U0000FE0F',
	u':zombie:': u'\U0001F9DF',
	u':zombie_uomo:': u'\U0001F9DF\U0000200D\U00002642\U0000FE0F',
	u':zombie_donna:': u'\U0001F9DF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_riceve_un_massaggio:': u'\U0001F486',
	u':persona_che_riceve_un_massaggio_carnagione_chiara:': u'\U0001F486\U0001F3FB',
	u':persona_che_riceve_un_massaggio_carnagione_abbastanza_chiara:': u'\U0001F486\U0001F3FC',
	u':persona_che_riceve_un_massaggio_carnagione_olivastra:': u'\U0001F486\U0001F3FD',
	u':persona_che_riceve_un_massaggio_carnagione_abbastanza_scura:': u'\U0001F486\U0001F3FE',
	u':persona_che_riceve_un_massaggio_carnagione_scura:': u'\U0001F486\U0001F3FF',
	u':uomo_che_riceve_un_massaggio:': u'\U0001F486\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_riceve_un_massaggio_carnagione_chiara:': u'\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_riceve_un_massaggio_carnagione_abbastanza_chiara:': u'\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_riceve_un_massaggio_carnagione_olivastra:': u'\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_riceve_un_massaggio_carnagione_abbastanza_scura:': u'\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_riceve_un_massaggio_carnagione_scura:': u'\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_riceve_un_massaggio:': u'\U0001F486\U0000200D\U00002640\U0000FE0F',
	u':donna_che_riceve_un_massaggio_carnagione_chiara:': u'\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_riceve_un_massaggio_carnagione_abbastanza_chiara:': u'\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_riceve_un_massaggio_carnagione_olivastra:': u'\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_riceve_un_massaggio_carnagione_abbastanza_scura:': u'\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_riceve_un_massaggio_carnagione_scura:': u'\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':taglio_di_capelli:': u'\U0001F487',
	u':taglio_di_capelli_carnagione_chiara:': u'\U0001F487\U0001F3FB',
	u':taglio_di_capelli_carnagione_abbastanza_chiara:': u'\U0001F487\U0001F3FC',
	u':taglio_di_capelli_carnagione_olivastra:': u'\U0001F487\U0001F3FD',
	u':taglio_di_capelli_carnagione_abbastanza_scura:': u'\U0001F487\U0001F3FE',
	u':taglio_di_capelli_carnagione_scura:': u'\U0001F487\U0001F3FF',
	u':taglio_di_capelli_per_uomo:': u'\U0001F487\U0000200D\U00002642\U0000FE0F',
	u':taglio_di_capelli_per_uomo_carnagione_chiara:': u'\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':taglio_di_capelli_per_uomo_carnagione_abbastanza_chiara:': u'\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':taglio_di_capelli_per_uomo_carnagione_olivastra:': u'\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':taglio_di_capelli_per_uomo_carnagione_abbastanza_scura:': u'\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':taglio_di_capelli_per_uomo_carnagione_scura:': u'\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':taglio_di_capelli_per_donna:': u'\U0001F487\U0000200D\U00002640\U0000FE0F',
	u':taglio_di_capelli_per_donna_carnagione_chiara:': u'\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':taglio_di_capelli_per_donna_carnagione_abbastanza_chiara:': u'\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':taglio_di_capelli_per_donna_carnagione_olivastra:': u'\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':taglio_di_capelli_per_donna_carnagione_abbastanza_scura:': u'\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':taglio_di_capelli_per_donna_carnagione_scura:': u'\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':pedone:': u'\U0001F6B6',
	u':pedone_carnagione_chiara:': u'\U0001F6B6\U0001F3FB',
	u':pedone_carnagione_abbastanza_chiara:': u'\U0001F6B6\U0001F3FC',
	u':pedone_carnagione_olivastra:': u'\U0001F6B6\U0001F3FD',
	u':pedone_carnagione_abbastanza_scura:': u'\U0001F6B6\U0001F3FE',
	u':pedone_carnagione_scura:': u'\U0001F6B6\U0001F3FF',
	u':uomo_che_cammina:': u'\U0001F6B6\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_cammina_carnagione_chiara:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_cammina_carnagione_abbastanza_chiara:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_cammina_carnagione_olivastra:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_cammina_carnagione_abbastanza_scura:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_cammina_carnagione_scura:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_cammina:': u'\U0001F6B6\U0000200D\U00002640\U0000FE0F',
	u':donna_che_cammina_carnagione_chiara:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_cammina_carnagione_abbastanza_chiara:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_cammina_carnagione_olivastra:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_cammina_carnagione_abbastanza_scura:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_cammina_carnagione_scura:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_in_piedi:': u'\U0001F9CD',
	u':persona_in_piedi_carnagione_chiara:': u'\U0001F9CD\U0001F3FB',
	u':persona_in_piedi_carnagione_abbastanza_chiara:': u'\U0001F9CD\U0001F3FC',
	u':persona_in_piedi_carnagione_olivastra:': u'\U0001F9CD\U0001F3FD',
	u':persona_in_piedi_carnagione_abbastanza_scura:': u'\U0001F9CD\U0001F3FE',
	u':persona_in_piedi_carnagione_scura:': u'\U0001F9CD\U0001F3FF',
	u':uomo_in_piedi:': u'\U0001F9CD\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_piedi_carnagione_chiara:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_piedi_carnagione_abbastanza_chiara:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_piedi_carnagione_olivastra:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_piedi_carnagione_abbastanza_scura:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_piedi_carnagione_scura:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_in_piedi:': u'\U0001F9CD\U0000200D\U00002640\U0000FE0F',
	u':donna_in_piedi_carnagione_chiara:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_in_piedi_carnagione_abbastanza_chiara:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_in_piedi_carnagione_olivastra:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_in_piedi_carnagione_abbastanza_scura:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_in_piedi_carnagione_scura:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_inginocchiata:': u'\U0001F9CE',
	u':persona_inginocchiata_carnagione_chiara:': u'\U0001F9CE\U0001F3FB',
	u':persona_inginocchiata_carnagione_abbastanza_chiara:': u'\U0001F9CE\U0001F3FC',
	u':persona_inginocchiata_carnagione_olivastra:': u'\U0001F9CE\U0001F3FD',
	u':persona_inginocchiata_carnagione_abbastanza_scura:': u'\U0001F9CE\U0001F3FE',
	u':persona_inginocchiata_carnagione_scura:': u'\U0001F9CE\U0001F3FF',
	u':uomo_inginocchiato:': u'\U0001F9CE\U0000200D\U00002642\U0000FE0F',
	u':uomo_inginocchiato_carnagione_chiara:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_inginocchiato_carnagione_abbastanza_chiara:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_inginocchiato_carnagione_olivastra:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_inginocchiato_carnagione_abbastanza_scura:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_inginocchiato_carnagione_scura:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_inginocchiata:': u'\U0001F9CE\U0000200D\U00002640\U0000FE0F',
	u':donna_inginocchiata_carnagione_chiara:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_inginocchiata_carnagione_abbastanza_chiara:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_inginocchiata_carnagione_olivastra:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_inginocchiata_carnagione_abbastanza_scura:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_inginocchiata_carnagione_scura:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_con_bastone_di_orientamento:': u'\U0001F9D1\U0000200D\U0001F9AF',
	u':persona_con_bastone_di_orientamento_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9AF',
	u':persona_con_bastone_di_orientamento_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9AF',
	u':persona_con_bastone_di_orientamento_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9AF',
	u':persona_con_bastone_di_orientamento_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9AF',
	u':persona_con_bastone_di_orientamento_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9AF',
	u':uomo_con_bastone_bianco_di_orientamento:': u'\U0001F468\U0000200D\U0001F9AF',
	u':uomo_con_bastone_bianco_di_orientamento_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9AF',
	u':uomo_con_bastone_bianco_di_orientamento_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9AF',
	u':uomo_con_bastone_bianco_di_orientamento_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9AF',
	u':uomo_con_bastone_bianco_di_orientamento_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9AF',
	u':uomo_con_bastone_bianco_di_orientamento_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9AF',
	u':donna_con_bastone_bianco_di_orientamento:': u'\U0001F469\U0000200D\U0001F9AF',
	u':donna_con_bastone_bianco_di_orientamento_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9AF',
	u':donna_con_bastone_bianco_di_orientamento_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9AF',
	u':donna_con_bastone_bianco_di_orientamento_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9AF',
	u':donna_con_bastone_bianco_di_orientamento_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9AF',
	u':donna_con_bastone_bianco_di_orientamento_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9AF',
	u':persona_su_sedia_a_rotelle_motorizzata:': u'\U0001F9D1\U0000200D\U0001F9BC',
	u':persona_su_sedia_a_rotelle_motorizzata_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BC',
	u':persona_su_sedia_a_rotelle_motorizzata_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BC',
	u':persona_su_sedia_a_rotelle_motorizzata_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BC',
	u':persona_su_sedia_a_rotelle_motorizzata_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BC',
	u':persona_su_sedia_a_rotelle_motorizzata_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BC',
	u':uomo_su_sedia_a_rotelle_motorizzata:': u'\U0001F468\U0000200D\U0001F9BC',
	u':uomo_su_sedia_a_rotelle_motorizzata_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BC',
	u':uomo_su_sedia_a_rotelle_motorizzata_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BC',
	u':uomo_su_sedia_a_rotelle_motorizzata_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BC',
	u':uomo_su_sedia_a_rotelle_motorizzata_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BC',
	u':uomo_su_sedia_a_rotelle_motorizzata_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BC',
	u':donna_su_sedia_a_rotelle_motorizzata:': u'\U0001F469\U0000200D\U0001F9BC',
	u':donna_su_sedia_a_rotelle_motorizzata_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BC',
	u':donna_su_sedia_a_rotelle_motorizzata_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BC',
	u':donna_su_sedia_a_rotelle_motorizzata_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BC',
	u':donna_su_sedia_a_rotelle_motorizzata_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BC',
	u':donna_su_sedia_a_rotelle_motorizzata_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BC',
	u':persona_su_sedia_a_rotelle_manuale:': u'\U0001F9D1\U0000200D\U0001F9BD',
	u':persona_su_sedia_a_rotelle_manuale_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BD',
	u':persona_su_sedia_a_rotelle_manuale_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BD',
	u':persona_su_sedia_a_rotelle_manuale_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BD',
	u':persona_su_sedia_a_rotelle_manuale_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BD',
	u':persona_su_sedia_a_rotelle_manuale_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BD',
	u':uomo_su_sedia_a_rotelle_manuale:': u'\U0001F468\U0000200D\U0001F9BD',
	u':uomo_su_sedia_a_rotelle_manuale_carnagione_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BD',
	u':uomo_su_sedia_a_rotelle_manuale_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BD',
	u':uomo_su_sedia_a_rotelle_manuale_carnagione_olivastra:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BD',
	u':uomo_su_sedia_a_rotelle_manuale_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BD',
	u':uomo_su_sedia_a_rotelle_manuale_carnagione_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BD',
	u':donna_su_sedia_a_rotelle_manuale:': u'\U0001F469\U0000200D\U0001F9BD',
	u':donna_su_sedia_a_rotelle_manuale_carnagione_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BD',
	u':donna_su_sedia_a_rotelle_manuale_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BD',
	u':donna_su_sedia_a_rotelle_manuale_carnagione_olivastra:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BD',
	u':donna_su_sedia_a_rotelle_manuale_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BD',
	u':donna_su_sedia_a_rotelle_manuale_carnagione_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BD',
	u':persona_che_corre:': u'\U0001F3C3',
	u':persona_che_corre_carnagione_chiara:': u'\U0001F3C3\U0001F3FB',
	u':persona_che_corre_carnagione_abbastanza_chiara:': u'\U0001F3C3\U0001F3FC',
	u':persona_che_corre_carnagione_olivastra:': u'\U0001F3C3\U0001F3FD',
	u':persona_che_corre_carnagione_abbastanza_scura:': u'\U0001F3C3\U0001F3FE',
	u':persona_che_corre_carnagione_scura:': u'\U0001F3C3\U0001F3FF',
	u':uomo_che_corre:': u'\U0001F3C3\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_corre_carnagione_chiara:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_corre_carnagione_abbastanza_chiara:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_corre_carnagione_olivastra:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_corre_carnagione_abbastanza_scura:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_corre_carnagione_scura:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_corre:': u'\U0001F3C3\U0000200D\U00002640\U0000FE0F',
	u':donna_che_corre_carnagione_chiara:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_corre_carnagione_abbastanza_chiara:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_corre_carnagione_olivastra:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_corre_carnagione_abbastanza_scura:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_corre_carnagione_scura:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':donna_che_balla:': u'\U0001F483',
	u':donna_che_balla_carnagione_chiara:': u'\U0001F483\U0001F3FB',
	u':donna_che_balla_carnagione_abbastanza_chiara:': u'\U0001F483\U0001F3FC',
	u':donna_che_balla_carnagione_olivastra:': u'\U0001F483\U0001F3FD',
	u':donna_che_balla_carnagione_abbastanza_scura:': u'\U0001F483\U0001F3FE',
	u':donna_che_balla_carnagione_scura:': u'\U0001F483\U0001F3FF',
	u':uomo_che_balla:': u'\U0001F57A',
	u':uomo_che_balla_carnagione_chiara:': u'\U0001F57A\U0001F3FB',
	u':uomo_che_balla_carnagione_abbastanza_chiara:': u'\U0001F57A\U0001F3FC',
	u':uomo_che_balla_carnagione_olivastra:': u'\U0001F57A\U0001F3FD',
	u':uomo_che_balla_carnagione_abbastanza_scura:': u'\U0001F57A\U0001F3FE',
	u':uomo_che_balla_carnagione_scura:': u'\U0001F57A\U0001F3FF',
	u':uomo_con_completo_che_levita:': u'\U0001F574\U0000FE0F',
	u':uomo_con_completo_che_levita_carnagione_chiara:': u'\U0001F574\U0001F3FB',
	u':uomo_con_completo_che_levita_carnagione_abbastanza_chiara:': u'\U0001F574\U0001F3FC',
	u':uomo_con_completo_che_levita_carnagione_olivastra:': u'\U0001F574\U0001F3FD',
	u':uomo_con_completo_che_levita_carnagione_abbastanza_scura:': u'\U0001F574\U0001F3FE',
	u':uomo_con_completo_che_levita_carnagione_scura:': u'\U0001F574\U0001F3FF',
	u':persone_con_orecchie_da_coniglio:': u'\U0001F46F',
	u':uomini_con_orecchie_da_coniglio:': u'\U0001F46F\U0000200D\U00002642\U0000FE0F',
	u':donne_con_orecchie_da_coniglio:': u'\U0001F46F\U0000200D\U00002640\U0000FE0F',
	u':persona_in_sauna:': u'\U0001F9D6',
	u':persona_in_sauna_carnagione_chiara:': u'\U0001F9D6\U0001F3FB',
	u':persona_in_sauna_carnagione_abbastanza_chiara:': u'\U0001F9D6\U0001F3FC',
	u':persona_in_sauna_carnagione_olivastra:': u'\U0001F9D6\U0001F3FD',
	u':persona_in_sauna_carnagione_abbastanza_scura:': u'\U0001F9D6\U0001F3FE',
	u':persona_in_sauna_carnagione_scura:': u'\U0001F9D6\U0001F3FF',
	u':uomo_in_sauna:': u'\U0001F9D6\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_sauna_carnagione_chiara:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_sauna_carnagione_abbastanza_chiara:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_sauna_carnagione_olivastra:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_sauna_carnagione_abbastanza_scura:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_sauna_carnagione_scura:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_in_sauna:': u'\U0001F9D6\U0000200D\U00002640\U0000FE0F',
	u':donna_in_sauna_carnagione_chiara:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_in_sauna_carnagione_abbastanza_chiara:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_in_sauna_carnagione_olivastra:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_in_sauna_carnagione_abbastanza_scura:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_in_sauna_carnagione_scura:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_scala:': u'\U0001F9D7',
	u':persona_che_scala_carnagione_chiara:': u'\U0001F9D7\U0001F3FB',
	u':persona_che_scala_carnagione_abbastanza_chiara:': u'\U0001F9D7\U0001F3FC',
	u':persona_che_scala_carnagione_olivastra:': u'\U0001F9D7\U0001F3FD',
	u':persona_che_scala_carnagione_abbastanza_scura:': u'\U0001F9D7\U0001F3FE',
	u':persona_che_scala_carnagione_scura:': u'\U0001F9D7\U0001F3FF',
	u':scalatore:': u'\U0001F9D7\U0000200D\U00002642\U0000FE0F',
	u':scalatore_carnagione_chiara:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':scalatore_carnagione_abbastanza_chiara:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':scalatore_carnagione_olivastra:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':scalatore_carnagione_abbastanza_scura:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':scalatore_carnagione_scura:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':scalatrice:': u'\U0001F9D7\U0000200D\U00002640\U0000FE0F',
	u':scalatrice_carnagione_chiara:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':scalatrice_carnagione_abbastanza_chiara:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':scalatrice_carnagione_olivastra:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':scalatrice_carnagione_abbastanza_scura:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':scalatrice_carnagione_scura:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':schermidore:': u'\U0001F93A',
	u':ippica:': u'\U0001F3C7',
	u':ippica_carnagione_chiara:': u'\U0001F3C7\U0001F3FB',
	u':ippica_carnagione_abbastanza_chiara:': u'\U0001F3C7\U0001F3FC',
	u':ippica_carnagione_olivastra:': u'\U0001F3C7\U0001F3FD',
	u':ippica_carnagione_abbastanza_scura:': u'\U0001F3C7\U0001F3FE',
	u':ippica_carnagione_scura:': u'\U0001F3C7\U0001F3FF',
	u':sciatore:': u'\U000026F7\U0000FE0F',
	u':persona_sullo_snowboard:': u'\U0001F3C2',
	u':persona_sullo_snowboard_carnagione_chiara:': u'\U0001F3C2\U0001F3FB',
	u':persona_sullo_snowboard_carnagione_abbastanza_chiara:': u'\U0001F3C2\U0001F3FC',
	u':persona_sullo_snowboard_carnagione_olivastra:': u'\U0001F3C2\U0001F3FD',
	u':persona_sullo_snowboard_carnagione_abbastanza_scura:': u'\U0001F3C2\U0001F3FE',
	u':persona_sullo_snowboard_carnagione_scura:': u'\U0001F3C2\U0001F3FF',
	u':persona_che_gioca_a_golf:': u'\U0001F3CC\U0000FE0F',
	u':persona_che_gioca_a_golf_carnagione_chiara:': u'\U0001F3CC\U0001F3FB',
	u':persona_che_gioca_a_golf_carnagione_abbastanza_chiara:': u'\U0001F3CC\U0001F3FC',
	u':persona_che_gioca_a_golf_carnagione_olivastra:': u'\U0001F3CC\U0001F3FD',
	u':persona_che_gioca_a_golf_carnagione_abbastanza_scura:': u'\U0001F3CC\U0001F3FE',
	u':persona_che_gioca_a_golf_carnagione_scura:': u'\U0001F3CC\U0001F3FF',
	u':golfista_uomo:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':golfista_uomo_carnagione_chiara:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':golfista_uomo_carnagione_abbastanza_chiara:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':golfista_uomo_carnagione_olivastra:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':golfista_uomo_carnagione_abbastanza_scura:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':golfista_uomo_carnagione_scura:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':golfista_donna:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':golfista_donna_carnagione_chiara:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':golfista_donna_carnagione_abbastanza_chiara:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':golfista_donna_carnagione_olivastra:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':golfista_donna_carnagione_abbastanza_scura:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':golfista_donna_carnagione_scura:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_fa_surf:': u'\U0001F3C4',
	u':persona_che_fa_surf_carnagione_chiara:': u'\U0001F3C4\U0001F3FB',
	u':persona_che_fa_surf_carnagione_abbastanza_chiara:': u'\U0001F3C4\U0001F3FC',
	u':persona_che_fa_surf_carnagione_olivastra:': u'\U0001F3C4\U0001F3FD',
	u':persona_che_fa_surf_carnagione_abbastanza_scura:': u'\U0001F3C4\U0001F3FE',
	u':persona_che_fa_surf_carnagione_scura:': u'\U0001F3C4\U0001F3FF',
	u':surfista_uomo:': u'\U0001F3C4\U0000200D\U00002642\U0000FE0F',
	u':surfista_uomo_carnagione_chiara:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':surfista_uomo_carnagione_abbastanza_chiara:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':surfista_uomo_carnagione_olivastra:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':surfista_uomo_carnagione_abbastanza_scura:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':surfista_uomo_carnagione_scura:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':surfista_donna:': u'\U0001F3C4\U0000200D\U00002640\U0000FE0F',
	u':surfista_donna_carnagione_chiara:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':surfista_donna_carnagione_abbastanza_chiara:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':surfista_donna_carnagione_olivastra:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':surfista_donna_carnagione_abbastanza_scura:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':surfista_donna_carnagione_scura:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_in_barca_a_remi:': u'\U0001F6A3',
	u':persona_in_barca_a_remi_carnagione_chiara:': u'\U0001F6A3\U0001F3FB',
	u':persona_in_barca_a_remi_carnagione_abbastanza_chiara:': u'\U0001F6A3\U0001F3FC',
	u':persona_in_barca_a_remi_carnagione_olivastra:': u'\U0001F6A3\U0001F3FD',
	u':persona_in_barca_a_remi_carnagione_abbastanza_scura:': u'\U0001F6A3\U0001F3FE',
	u':persona_in_barca_a_remi_carnagione_scura:': u'\U0001F6A3\U0001F3FF',
	u':uomo_in_barca_a_remi:': u'\U0001F6A3\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_barca_a_remi_carnagione_chiara:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_barca_a_remi_carnagione_abbastanza_chiara:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_barca_a_remi_carnagione_olivastra:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_barca_a_remi_carnagione_abbastanza_scura:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_barca_a_remi_carnagione_scura:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_in_barca_a_remi:': u'\U0001F6A3\U0000200D\U00002640\U0000FE0F',
	u':donna_in_barca_a_remi_carnagione_chiara:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_in_barca_a_remi_carnagione_abbastanza_chiara:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_in_barca_a_remi_carnagione_olivastra:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_in_barca_a_remi_carnagione_abbastanza_scura:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_in_barca_a_remi_carnagione_scura:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_nuota:': u'\U0001F3CA',
	u':persona_che_nuota_carnagione_chiara:': u'\U0001F3CA\U0001F3FB',
	u':persona_che_nuota_carnagione_abbastanza_chiara:': u'\U0001F3CA\U0001F3FC',
	u':persona_che_nuota_carnagione_olivastra:': u'\U0001F3CA\U0001F3FD',
	u':persona_che_nuota_carnagione_abbastanza_scura:': u'\U0001F3CA\U0001F3FE',
	u':persona_che_nuota_carnagione_scura:': u'\U0001F3CA\U0001F3FF',
	u':nuotatore:': u'\U0001F3CA\U0000200D\U00002642\U0000FE0F',
	u':nuotatore_carnagione_chiara:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':nuotatore_carnagione_abbastanza_chiara:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':nuotatore_carnagione_olivastra:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':nuotatore_carnagione_abbastanza_scura:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':nuotatore_carnagione_scura:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':nuotatrice:': u'\U0001F3CA\U0000200D\U00002640\U0000FE0F',
	u':nuotatrice_carnagione_chiara:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':nuotatrice_carnagione_abbastanza_chiara:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':nuotatrice_carnagione_olivastra:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':nuotatrice_carnagione_abbastanza_scura:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':nuotatrice_carnagione_scura:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_fa_rimbalzare_una_palla:': u'\U000026F9\U0000FE0F',
	u':persona_che_fa_rimbalzare_una_palla_carnagione_chiara:': u'\U000026F9\U0001F3FB',
	u':persona_che_fa_rimbalzare_una_palla_carnagione_abbastanza_chiara:': u'\U000026F9\U0001F3FC',
	u':persona_che_fa_rimbalzare_una_palla_carnagione_olivastra:': u'\U000026F9\U0001F3FD',
	u':persona_che_fa_rimbalzare_una_palla_carnagione_abbastanza_scura:': u'\U000026F9\U0001F3FE',
	u':persona_che_fa_rimbalzare_una_palla_carnagione_scura:': u'\U000026F9\U0001F3FF',
	u':uomo_che_fa_rimbalzare_una_palla:': u'\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_rimbalzare_una_palla_carnagione_chiara:': u'\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_rimbalzare_una_palla_carnagione_abbastanza_chiara:': u'\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_rimbalzare_una_palla_carnagione_olivastra:': u'\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_rimbalzare_una_palla_carnagione_abbastanza_scura:': u'\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_rimbalzare_una_palla_carnagione_scura:': u'\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_fa_rimbalzare_una_palla:': u'\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_rimbalzare_una_palla_carnagione_chiara:': u'\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_rimbalzare_una_palla_carnagione_abbastanza_chiara:': u'\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_rimbalzare_una_palla_carnagione_olivastra:': u'\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_rimbalzare_una_palla_carnagione_abbastanza_scura:': u'\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_rimbalzare_una_palla_carnagione_scura:': u'\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_solleva_pesi:': u'\U0001F3CB\U0000FE0F',
	u':persona_che_solleva_pesi_carnagione_chiara:': u'\U0001F3CB\U0001F3FB',
	u':persona_che_solleva_pesi_carnagione_abbastanza_chiara:': u'\U0001F3CB\U0001F3FC',
	u':persona_che_solleva_pesi_carnagione_olivastra:': u'\U0001F3CB\U0001F3FD',
	u':persona_che_solleva_pesi_carnagione_abbastanza_scura:': u'\U0001F3CB\U0001F3FE',
	u':persona_che_solleva_pesi_carnagione_scura:': u'\U0001F3CB\U0001F3FF',
	u':uomo_che_solleva_pesi:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_solleva_pesi_carnagione_chiara:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_solleva_pesi_carnagione_abbastanza_chiara:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_solleva_pesi_carnagione_olivastra:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_solleva_pesi_carnagione_abbastanza_scura:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_solleva_pesi_carnagione_scura:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_solleva_pesi:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':donna_che_solleva_pesi_carnagione_chiara:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_solleva_pesi_carnagione_abbastanza_chiara:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_solleva_pesi_carnagione_olivastra:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_solleva_pesi_carnagione_abbastanza_scura:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_solleva_pesi_carnagione_scura:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':ciclista:': u'\U0001F6B4',
	u':ciclista_carnagione_chiara:': u'\U0001F6B4\U0001F3FB',
	u':ciclista_carnagione_abbastanza_chiara:': u'\U0001F6B4\U0001F3FC',
	u':ciclista_carnagione_olivastra:': u'\U0001F6B4\U0001F3FD',
	u':ciclista_carnagione_abbastanza_scura:': u'\U0001F6B4\U0001F3FE',
	u':ciclista_carnagione_scura:': u'\U0001F6B4\U0001F3FF',
	u':ciclista_uomo:': u'\U0001F6B4\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_carnagione_chiara:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_carnagione_abbastanza_chiara:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_carnagione_olivastra:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_carnagione_abbastanza_scura:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_carnagione_scura:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':ciclista_donna:': u'\U0001F6B4\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_carnagione_chiara:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_carnagione_abbastanza_chiara:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_carnagione_olivastra:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_carnagione_abbastanza_scura:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_carnagione_scura:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':ciclista_di_mountain_bike:': u'\U0001F6B5',
	u':ciclista_di_mountain_bike_carnagione_chiara:': u'\U0001F6B5\U0001F3FB',
	u':ciclista_di_mountain_bike_carnagione_abbastanza_chiara:': u'\U0001F6B5\U0001F3FC',
	u':ciclista_di_mountain_bike_carnagione_olivastra:': u'\U0001F6B5\U0001F3FD',
	u':ciclista_di_mountain_bike_carnagione_abbastanza_scura:': u'\U0001F6B5\U0001F3FE',
	u':ciclista_di_mountain_bike_carnagione_scura:': u'\U0001F6B5\U0001F3FF',
	u':ciclista_uomo_di_mountain_bike:': u'\U0001F6B5\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_di_mountain_bike_carnagione_chiara:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_di_mountain_bike_carnagione_abbastanza_chiara:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_di_mountain_bike_carnagione_olivastra:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_di_mountain_bike_carnagione_abbastanza_scura:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':ciclista_uomo_di_mountain_bike_carnagione_scura:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':ciclista_donna_di_mountain_bike:': u'\U0001F6B5\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_di_mountain_bike_carnagione_chiara:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_di_mountain_bike_carnagione_abbastanza_chiara:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_di_mountain_bike_carnagione_olivastra:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_di_mountain_bike_carnagione_abbastanza_scura:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':ciclista_donna_di_mountain_bike_carnagione_scura:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_fa_la_ruota:': u'\U0001F938',
	u':persona_che_fa_la_ruota_carnagione_chiara:': u'\U0001F938\U0001F3FB',
	u':persona_che_fa_la_ruota_carnagione_abbastanza_chiara:': u'\U0001F938\U0001F3FC',
	u':persona_che_fa_la_ruota_carnagione_olivastra:': u'\U0001F938\U0001F3FD',
	u':persona_che_fa_la_ruota_carnagione_abbastanza_scura:': u'\U0001F938\U0001F3FE',
	u':persona_che_fa_la_ruota_carnagione_scura:': u'\U0001F938\U0001F3FF',
	u':uomo_che_fa_la_ruota:': u'\U0001F938\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_la_ruota_carnagione_chiara:': u'\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_la_ruota_carnagione_abbastanza_chiara:': u'\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_la_ruota_carnagione_olivastra:': u'\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_la_ruota_carnagione_abbastanza_scura:': u'\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_che_fa_la_ruota_carnagione_scura:': u'\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_che_fa_la_ruota:': u'\U0001F938\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_la_ruota_carnagione_chiara:': u'\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_la_ruota_carnagione_abbastanza_chiara:': u'\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_la_ruota_carnagione_olivastra:': u'\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_la_ruota_carnagione_abbastanza_scura:': u'\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_che_fa_la_ruota_carnagione_scura:': u'\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persone_che_fanno_la_lotta:': u'\U0001F93C',
	u':lottatori:': u'\U0001F93C\U0000200D\U00002642\U0000FE0F',
	u':lottatrici:': u'\U0001F93C\U0000200D\U00002640\U0000FE0F',
	u':persona_che_gioca_a_pallanuoto:': u'\U0001F93D',
	u':persona_che_gioca_a_pallanuoto_carnagione_chiara:': u'\U0001F93D\U0001F3FB',
	u':persona_che_gioca_a_pallanuoto_carnagione_abbastanza_chiara:': u'\U0001F93D\U0001F3FC',
	u':persona_che_gioca_a_pallanuoto_carnagione_olivastra:': u'\U0001F93D\U0001F3FD',
	u':persona_che_gioca_a_pallanuoto_carnagione_abbastanza_scura:': u'\U0001F93D\U0001F3FE',
	u':persona_che_gioca_a_pallanuoto_carnagione_scura:': u'\U0001F93D\U0001F3FF',
	u':pallanuotista_uomo:': u'\U0001F93D\U0000200D\U00002642\U0000FE0F',
	u':pallanuotista_uomo_carnagione_chiara:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':pallanuotista_uomo_carnagione_abbastanza_chiara:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':pallanuotista_uomo_carnagione_olivastra:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':pallanuotista_uomo_carnagione_abbastanza_scura:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':pallanuotista_uomo_carnagione_scura:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':pallanuotista_donna:': u'\U0001F93D\U0000200D\U00002640\U0000FE0F',
	u':pallanuotista_donna_carnagione_chiara:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':pallanuotista_donna_carnagione_abbastanza_chiara:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':pallanuotista_donna_carnagione_olivastra:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':pallanuotista_donna_carnagione_abbastanza_scura:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':pallanuotista_donna_carnagione_scura:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_gioca_a_pallamano:': u'\U0001F93E',
	u':persona_che_gioca_a_pallamano_carnagione_chiara:': u'\U0001F93E\U0001F3FB',
	u':persona_che_gioca_a_pallamano_carnagione_abbastanza_chiara:': u'\U0001F93E\U0001F3FC',
	u':persona_che_gioca_a_pallamano_carnagione_olivastra:': u'\U0001F93E\U0001F3FD',
	u':persona_che_gioca_a_pallamano_carnagione_abbastanza_scura:': u'\U0001F93E\U0001F3FE',
	u':persona_che_gioca_a_pallamano_carnagione_scura:': u'\U0001F93E\U0001F3FF',
	u':pallamanista_uomo:': u'\U0001F93E\U0000200D\U00002642\U0000FE0F',
	u':pallamanista_uomo_carnagione_chiara:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':pallamanista_uomo_carnagione_abbastanza_chiara:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':pallamanista_uomo_carnagione_olivastra:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':pallamanista_uomo_carnagione_abbastanza_scura:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':pallamanista_uomo_carnagione_scura:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':pallamanista_donna:': u'\U0001F93E\U0000200D\U00002640\U0000FE0F',
	u':pallamanista_donna_carnagione_chiara:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':pallamanista_donna_carnagione_abbastanza_chiara:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':pallamanista_donna_carnagione_olivastra:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':pallamanista_donna_carnagione_abbastanza_scura:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':pallamanista_donna_carnagione_scura:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_fa_giocoleria:': u'\U0001F939',
	u':persona_che_fa_giocoleria_carnagione_chiara:': u'\U0001F939\U0001F3FB',
	u':persona_che_fa_giocoleria_carnagione_abbastanza_chiara:': u'\U0001F939\U0001F3FC',
	u':persona_che_fa_giocoleria_carnagione_olivastra:': u'\U0001F939\U0001F3FD',
	u':persona_che_fa_giocoleria_carnagione_abbastanza_scura:': u'\U0001F939\U0001F3FE',
	u':persona_che_fa_giocoleria_carnagione_scura:': u'\U0001F939\U0001F3FF',
	u':giocoliere_uomo:': u'\U0001F939\U0000200D\U00002642\U0000FE0F',
	u':giocoliere_uomo_carnagione_chiara:': u'\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':giocoliere_uomo_carnagione_abbastanza_chiara:': u'\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':giocoliere_uomo_carnagione_olivastra:': u'\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':giocoliere_uomo_carnagione_abbastanza_scura:': u'\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':giocoliere_uomo_carnagione_scura:': u'\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':giocoliere_donna:': u'\U0001F939\U0000200D\U00002640\U0000FE0F',
	u':giocoliere_donna_carnagione_chiara:': u'\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':giocoliere_donna_carnagione_abbastanza_chiara:': u'\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':giocoliere_donna_carnagione_olivastra:': u'\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':giocoliere_donna_carnagione_abbastanza_scura:': u'\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':giocoliere_donna_carnagione_scura:': u'\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_in_posizione_del_loto:': u'\U0001F9D8',
	u':persona_in_posizione_del_loto_carnagione_chiara:': u'\U0001F9D8\U0001F3FB',
	u':persona_in_posizione_del_loto_carnagione_abbastanza_chiara:': u'\U0001F9D8\U0001F3FC',
	u':persona_in_posizione_del_loto_carnagione_olivastra:': u'\U0001F9D8\U0001F3FD',
	u':persona_in_posizione_del_loto_carnagione_abbastanza_scura:': u'\U0001F9D8\U0001F3FE',
	u':persona_in_posizione_del_loto_carnagione_scura:': u'\U0001F9D8\U0001F3FF',
	u':uomo_in_posizione_del_loto:': u'\U0001F9D8\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_posizione_del_loto_carnagione_chiara:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_posizione_del_loto_carnagione_abbastanza_chiara:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_posizione_del_loto_carnagione_olivastra:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_posizione_del_loto_carnagione_abbastanza_scura:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':uomo_in_posizione_del_loto_carnagione_scura:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':donna_in_posizione_del_loto:': u'\U0001F9D8\U0000200D\U00002640\U0000FE0F',
	u':donna_in_posizione_del_loto_carnagione_chiara:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':donna_in_posizione_del_loto_carnagione_abbastanza_chiara:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':donna_in_posizione_del_loto_carnagione_olivastra:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':donna_in_posizione_del_loto_carnagione_abbastanza_scura:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':donna_in_posizione_del_loto_carnagione_scura:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':persona_che_fa_il_bagno:': u'\U0001F6C0',
	u':persona_che_fa_il_bagno_carnagione_chiara:': u'\U0001F6C0\U0001F3FB',
	u':persona_che_fa_il_bagno_carnagione_abbastanza_chiara:': u'\U0001F6C0\U0001F3FC',
	u':persona_che_fa_il_bagno_carnagione_olivastra:': u'\U0001F6C0\U0001F3FD',
	u':persona_che_fa_il_bagno_carnagione_abbastanza_scura:': u'\U0001F6C0\U0001F3FE',
	u':persona_che_fa_il_bagno_carnagione_scura:': u'\U0001F6C0\U0001F3FF',
	u':persona_a_letto:': u'\U0001F6CC',
	u':persona_a_letto_carnagione_chiara:': u'\U0001F6CC\U0001F3FB',
	u':persona_a_letto_carnagione_abbastanza_chiara:': u'\U0001F6CC\U0001F3FC',
	u':persona_a_letto_carnagione_olivastra:': u'\U0001F6CC\U0001F3FD',
	u':persona_a_letto_carnagione_abbastanza_scura:': u'\U0001F6CC\U0001F3FE',
	u':persona_a_letto_carnagione_scura:': u'\U0001F6CC\U0001F3FF',
	u':persone_che_si_tengono_per_mano:': u'\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1',
	u':persone_che_si_tengono_per_mano_carnagione_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':persone_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':persone_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_olivastra:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':persone_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':persone_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_scura:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_olivastra:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_scura:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':persone_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_chiara:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':persone_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':persone_che_si_tengono_per_mano_carnagione_olivastra:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':persone_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':persone_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_scura:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_chiara:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_olivastra:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':persone_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_scura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':persone_che_si_tengono_per_mano_carnagione_scura_e_carnagione_chiara:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':persone_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_chiara:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':persone_che_si_tengono_per_mano_carnagione_scura_e_carnagione_olivastra:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':persone_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':persone_che_si_tengono_per_mano_carnagione_scura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':due_donne_che_si_tengono_per_mano:': u'\U0001F46D',
	u':due_donne_che_si_tengono_per_mano_carnagione_chiara:': u'\U0001F46D\U0001F3FB',
	u':due_donne_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':due_donne_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_olivastra:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':due_donne_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':due_donne_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_scura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_chiara:': u'\U0001F46D\U0001F3FC',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_olivastra:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_scura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':due_donne_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_chiara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':due_donne_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':due_donne_che_si_tengono_per_mano_carnagione_olivastra:': u'\U0001F46D\U0001F3FD',
	u':due_donne_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':due_donne_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_scura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_chiara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_olivastra:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_scura:': u'\U0001F46D\U0001F3FE',
	u':due_donne_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':due_donne_che_si_tengono_per_mano_carnagione_scura_e_carnagione_chiara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':due_donne_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':due_donne_che_si_tengono_per_mano_carnagione_scura_e_carnagione_olivastra:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':due_donne_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':due_donne_che_si_tengono_per_mano_carnagione_scura:': u'\U0001F46D\U0001F3FF',
	u':uomo_e_donna_che_si_tengono_per_mano:': u'\U0001F46B',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_chiara:': u'\U0001F46B\U0001F3FB',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_olivastra:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_scura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_chiara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_chiara:': u'\U0001F46B\U0001F3FC',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_olivastra:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_scura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_chiara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_olivastra:': u'\U0001F46B\U0001F3FD',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_scura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_chiara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_olivastra:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_scura:': u'\U0001F46B\U0001F3FE',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_scura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_scura_e_carnagione_chiara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_chiara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_scura_e_carnagione_olivastra:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_scura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':uomo_e_donna_che_si_tengono_per_mano_carnagione_scura:': u'\U0001F46B\U0001F3FF',
	u':due_uomini_che_si_tengono_per_mano:': u'\U0001F46C',
	u':due_uomini_che_si_tengono_per_mano_carnagione_chiara:': u'\U0001F46C\U0001F3FB',
	u':due_uomini_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':due_uomini_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_olivastra:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':due_uomini_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':due_uomini_che_si_tengono_per_mano_carnagione_chiara_e_carnagione_scura:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_chiara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_chiara:': u'\U0001F46C\U0001F3FC',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_olivastra:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_chiara_e_carnagione_scura:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':due_uomini_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_chiara:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':due_uomini_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':due_uomini_che_si_tengono_per_mano_carnagione_olivastra:': u'\U0001F46C\U0001F3FD',
	u':due_uomini_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':due_uomini_che_si_tengono_per_mano_carnagione_olivastra_e_carnagione_scura:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_chiara:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_olivastra:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_scura:': u'\U0001F46C\U0001F3FE',
	u':due_uomini_che_si_tengono_per_mano_carnagione_abbastanza_scura_e_carnagione_scura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':due_uomini_che_si_tengono_per_mano_carnagione_scura_e_carnagione_chiara:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':due_uomini_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_chiara:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':due_uomini_che_si_tengono_per_mano_carnagione_scura_e_carnagione_olivastra:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':due_uomini_che_si_tengono_per_mano_carnagione_scura_e_carnagione_abbastanza_scura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':due_uomini_che_si_tengono_per_mano_carnagione_scura:': u'\U0001F46C\U0001F3FF',
	u':bacio_tra_coppia:': u'\U0001F48F',
	u':bacio_tra_coppia_donna_e_uomo:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
	u':bacio_tra_coppia_uomo_e_uomo:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
	u':bacio_tra_coppia_donna_e_donna:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469',
	u':coppia_con_cuore:': u'\U0001F491',
	u':coppia_con_cuore_donna_e_uomo:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
	u':coppia_con_cuore_uomo_e_uomo:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
	u':coppia_con_cuore_donna_e_donna:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469',
	u':famiglia:': u'\U0001F46A',
	u':famiglia_uomo_donna_e_bambino:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466',
	u':famiglia_uomo_donna_e_bambina:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467',
	u':famiglia_uomo_donna_bambina_e_bambino:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
	u':famiglia_uomo_donna_bambino_e_bambino:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
	u':famiglia_uomo_donna_bambina_e_bambina:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
	u':famiglia_uomo_uomo_e_bambino:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466',
	u':famiglia_uomo_uomo_e_bambina:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467',
	u':famiglia_uomo_uomo_bambina_e_bambino:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
	u':famiglia_uomo_uomo_bambino_e_bambino:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
	u':famiglia_uomo_uomo_bambina_e_bambina:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
	u':famiglia_donna_donna_e_bambino:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466',
	u':famiglia_donna_donna_e_bambina:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467',
	u':famiglia_donna_donna_bambina_e_bambino:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
	u':famiglia_donna_donna_bambino_e_bambino:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
	u':famiglia_donna_donna_bambina_e_bambina:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
	u':famiglia_uomo_e_bambino:': u'\U0001F468\U0000200D\U0001F466',
	u':famiglia_uomo_bambino_e_bambino:': u'\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
	u':famiglia_uomo_e_bambina:': u'\U0001F468\U0000200D\U0001F467',
	u':famiglia_uomo_bambina_e_bambino:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
	u':famiglia_uomo_bambina_e_bambina:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
	u':famiglia_donna_e_bambino:': u'\U0001F469\U0000200D\U0001F466',
	u':famiglia_donna_bambino_e_bambino:': u'\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
	u':famiglia_donna_e_bambina:': u'\U0001F469\U0000200D\U0001F467',
	u':famiglia_donna_bambina_e_bambino:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
	u':famiglia_donna_bambina_e_bambina:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
	u':persona_che_parla:': u'\U0001F5E3\U0000FE0F',
	u':profilo_di_persona:': u'\U0001F464',
	u':profilo_di_due_persone:': u'\U0001F465',
	u':persone_che_si_abbracciano:': u'\U0001FAC2',
	u':impronta_di_piedi:': u'\U0001F463',
	u':carnagione_chiara:': u'\U0001F3FB',
	u':carnagione_abbastanza_chiara:': u'\U0001F3FC',
	u':carnagione_olivastra:': u'\U0001F3FD',
	u':carnagione_abbastanza_scura:': u'\U0001F3FE',
	u':carnagione_scura:': u'\U0001F3FF',
	u':capelli_rossi:': u'\U0001F9B0',
	u':capelli_ricci:': u'\U0001F9B1',
	u':capelli_bianchi:': u'\U0001F9B3',
	u':calvo:': u'\U0001F9B2',
	u':muso_di_scimmia:': u'\U0001F435',
	u':scimmia:': u'\U0001F412',
	u':gorilla:': u'\U0001F98D',
	u':orangotango:': u'\U0001F9A7',
	u':muso_di_cane:': u'\U0001F436',
	u':cane:': u'\U0001F415',
	u':cane_guida:': u'\U0001F9AE',
	u':cane_da_assistenza:': u'\U0001F415\U0000200D\U0001F9BA',
	u':barboncino:': u'\U0001F429',
	u':lupo:': u'\U0001F43A',
	u':volpe:': u'\U0001F98A',
	u':procione:': u'\U0001F99D',
	u':muso_di_gatto:': u'\U0001F431',
	u':gatto:': u'\U0001F408',
	u':gatto_nero:': u'\U0001F408\U0000200D\U00002B1B',
	u':leone:': u'\U0001F981',
	u':muso_di_tigre:': u'\U0001F42F',
	u':tigre:': u'\U0001F405',
	u':leopardo:': u'\U0001F406',
	u':muso_di_cavallo:': u'\U0001F434',
	u':cavallo:': u'\U0001F40E',
	u':unicorno:': u'\U0001F984',
	u':zebra:': u'\U0001F993',
	u':cervo:': u'\U0001F98C',
	u':bisonte:': u'\U0001F9AC',
	u':muso_di_mucca:': u'\U0001F42E',
	u':bue:': u'\U0001F402',
	u':bufalo_d’acqua:': u'\U0001F403',
	u':mucca:': u'\U0001F404',
	u':muso_di_maiale:': u'\U0001F437',
	u':maiale:': u'\U0001F416',
	u':cinghiale:': u'\U0001F417',
	u':naso_da_maiale:': u'\U0001F43D',
	u':montone:': u'\U0001F40F',
	u':pecora:': u'\U0001F411',
	u':capra:': u'\U0001F410',
	u':dromedario:': u'\U0001F42A',
	u':cammello:': u'\U0001F42B',
	u':lama:': u'\U0001F999',
	u':giraffa:': u'\U0001F992',
	u':elefante:': u'\U0001F418',
	u':mammut:': u'\U0001F9A3',
	u':rinoceronte:': u'\U0001F98F',
	u':ippopotamo:': u'\U0001F99B',
	u':muso_di_topo:': u'\U0001F42D',
	u':topo:': u'\U0001F401',
	u':ratto:': u'\U0001F400',
	u':criceto:': u'\U0001F439',
	u':muso_di_coniglio:': u'\U0001F430',
	u':coniglio:': u'\U0001F407',
	u':scoiattolo:': u'\U0001F43F\U0000FE0F',
	u':castoro:': u'\U0001F9AB',
	u':riccio:': u'\U0001F994',
	u':pipistrello:': u'\U0001F987',
	u':orso:': u'\U0001F43B',
	u':orso_polare:': u'\U0001F43B\U0000200D\U00002744\U0000FE0F',
	u':koala:': u'\U0001F428',
	u':panda:': u'\U0001F43C',
	u':bradipo:': u'\U0001F9A5',
	u':lontra:': u'\U0001F9A6',
	u':puzzola:': u'\U0001F9A8',
	u':canguro:': u'\U0001F998',
	u':tasso:': u'\U0001F9A1',
	u':impronte_di_zampe:': u'\U0001F43E',
	u':tacchino:': u'\U0001F983',
	u':gallina:': u'\U0001F414',
	u':gallo:': u'\U0001F413',
	u':pulcino_che_nasce:': u'\U0001F423',
	u':pulcino:': u'\U0001F424',
	u':pulcino_visto_di_fronte:': u'\U0001F425',
	u':uccello:': u'\U0001F426',
	u':pinguino:': u'\U0001F427',
	u':colomba:': u'\U0001F54A\U0000FE0F',
	u':aquila:': u'\U0001F985',
	u':anatra:': u'\U0001F986',
	u':cigno:': u'\U0001F9A2',
	u':gufo:': u'\U0001F989',
	u':dodo:': u'\U0001F9A4',
	u':piuma:': u'\U0001FAB6',
	u':fenicottero:': u'\U0001F9A9',
	u':pavone:': u'\U0001F99A',
	u':pappagallo:': u'\U0001F99C',
	u':rana:': u'\U0001F438',
	u':coccodrillo:': u'\U0001F40A',
	u':tartaruga:': u'\U0001F422',
	u':lucertola:': u'\U0001F98E',
	u':serpente:': u'\U0001F40D',
	u':testa_di_drago:': u'\U0001F432',
	u':drago:': u'\U0001F409',
	u':sauropode:': u'\U0001F995',
	u':t-rex:': u'\U0001F996',
	u':balena_che_spruzza_acqua:': u'\U0001F433',
	u':balena:': u'\U0001F40B',
	u':delfino:': u'\U0001F42C',
	u':foca:': u'\U0001F9AD',
	u':pesce:': u'\U0001F41F',
	u':pesce_tropicale:': u'\U0001F420',
	u':pesce_palla:': u'\U0001F421',
	u':squalo:': u'\U0001F988',
	u':polpo:': u'\U0001F419',
	u':conchiglia:': u'\U0001F41A',
	u':lumaca:': u'\U0001F40C',
	u':farfalla:': u'\U0001F98B',
	u':insetto:': u'\U0001F41B',
	u':formica:': u'\U0001F41C',
	u':ape:': u'\U0001F41D',
	u':coleottero:': u'\U0001FAB2',
	u':coccinella:': u'\U0001F41E',
	u':grillo:': u'\U0001F997',
	u':scarafaggio:': u'\U0001FAB3',
	u':ragno:': u'\U0001F577\U0000FE0F',
	u':ragnatela:': u'\U0001F578\U0000FE0F',
	u':scorpione:': u'\U0001F982',
	u':zanzara:': u'\U0001F99F',
	u':mosca:': u'\U0001FAB0',
	u':verme:': u'\U0001FAB1',
	u':microbo:': u'\U0001F9A0',
	u':mazzo_di_fiori:': u'\U0001F490',
	u':fiore_di_ciliegio:': u'\U0001F338',
	u':fiore_bianco:': u'\U0001F4AE',
	u':rosetta:': u'\U0001F3F5\U0000FE0F',
	u':rosa:': u'\U0001F339',
	u':fiore_appassito:': u'\U0001F940',
	u':ibisco:': u'\U0001F33A',
	u':girasole:': u'\U0001F33B',
	u':fiore:': u'\U0001F33C',
	u':tulipano:': u'\U0001F337',
	u':germoglio:': u'\U0001F331',
	u':pianta_in_vaso:': u'\U0001FAB4',
	u':albero_sempreverde:': u'\U0001F332',
	u':albero_deciduo:': u'\U0001F333',
	u':palma:': u'\U0001F334',
	u':cactus:': u'\U0001F335',
	u':pianta_di_riso:': u'\U0001F33E',
	u':pianta:': u'\U0001F33F',
	u':trifoglio:': u'\U00002618\U0000FE0F',
	u':quadrifoglio:': u'\U0001F340',
	u':foglia_d’acero:': u'\U0001F341',
	u':foglia_caduta:': u'\U0001F342',
	u':foglia_al_vento:': u'\U0001F343',
	u':uva:': u'\U0001F347',
	u':melone:': u'\U0001F348',
	u':anguria:': u'\U0001F349',
	u':mandarino:': u'\U0001F34A',
	u':limone:': u'\U0001F34B',
	u':banana:': u'\U0001F34C',
	u':ananas:': u'\U0001F34D',
	u':mango:': u'\U0001F96D',
	u':mela_rossa:': u'\U0001F34E',
	u':mela_verde:': u'\U0001F34F',
	u':pera:': u'\U0001F350',
	u':pesca:': u'\U0001F351',
	u':ciliegie:': u'\U0001F352',
	u':fragola:': u'\U0001F353',
	u':mirtilli:': u'\U0001FAD0',
	u':kiwi:': u'\U0001F95D',
	u':pomodoro:': u'\U0001F345',
	u':oliva:': u'\U0001FAD2',
	u':cocco:': u'\U0001F965',
	u':avocado:': u'\U0001F951',
	u':melanzana:': u'\U0001F346',
	u':patata:': u'\U0001F954',
	u':carota:': u'\U0001F955',
	u':pannocchia:': u'\U0001F33D',
	u':peperoncino:': u'\U0001F336\U0000FE0F',
	u':peperone:': u'\U0001FAD1',
	u':cetriolo:': u'\U0001F952',
	u':verdure_a_foglia:': u'\U0001F96C',
	u':broccoli:': u'\U0001F966',
	u':aglio:': u'\U0001F9C4',
	u':cipolla:': u'\U0001F9C5',
	u':fungo:': u'\U0001F344',
	u':arachidi:': u'\U0001F95C',
	u':castagna:': u'\U0001F330',
	u':pane_in_cassetta:': u'\U0001F35E',
	u':croissant:': u'\U0001F950',
	u':baguette:': u'\U0001F956',
	u':focaccia:': u'\U0001FAD3',
	u':pretzel:': u'\U0001F968',
	u':bagel:': u'\U0001F96F',
	u':pancake:': u'\U0001F95E',
	u':waffle:': u'\U0001F9C7',
	u':fetta_di_formaggio:': u'\U0001F9C0',
	u':carne:': u'\U0001F356',
	u':coscia_di_pollo:': u'\U0001F357',
	u':taglio_di_carne:': u'\U0001F969',
	u':pancetta:': u'\U0001F953',
	u':hamburger:': u'\U0001F354',
	u':patatine:': u'\U0001F35F',
	u':pizza:': u'\U0001F355',
	u':hot_dog:': u'\U0001F32D',
	u':sandwich:': u'\U0001F96A',
	u':taco:': u'\U0001F32E',
	u':burrito:': u'\U0001F32F',
	u':tamal:': u'\U0001FAD4',
	u':pita_farcita:': u'\U0001F959',
	u':falafel:': u'\U0001F9C6',
	u':uovo:': u'\U0001F95A',
	u':cucinare:': u'\U0001F373',
	u':padella_con_cibo:': u'\U0001F958',
	u':ciotola_di_cibo:': u'\U0001F372',
	u':fonduta:': u'\U0001FAD5',
	u':ciotola_con_cucchiaio:': u'\U0001F963',
	u':insalata_verde:': u'\U0001F957',
	u':popcorn:': u'\U0001F37F',
	u':burro:': u'\U0001F9C8',
	u':sale:': u'\U0001F9C2',
	u':cibo_in_scatola:': u'\U0001F96B',
	u':bento_box:': u'\U0001F371',
	u':galletta_di_riso:': u'\U0001F358',
	u':onigiri:': u'\U0001F359',
	u':riso_bollito:': u'\U0001F35A',
	u':riso_al_curry:': u'\U0001F35B',
	u':ciotola_fumante:': u'\U0001F35C',
	u':spaghetti:': u'\U0001F35D',
	u':patata_dolce_arrosto:': u'\U0001F360',
	u':oden_giapponese:': u'\U0001F362',
	u':sushi:': u'\U0001F363',
	u':gambero_fritto:': u'\U0001F364',
	u':tortino_di_pesce_a_spirale:': u'\U0001F365',
	u':torta_della_luna:': u'\U0001F96E',
	u':dolcetto:': u'\U0001F361',
	u':raviolo:': u'\U0001F95F',
	u':biscotto_della_fortuna:': u'\U0001F960',
	u':confezione_da_asporto:': u'\U0001F961',
	u':granchio:': u'\U0001F980',
	u':aragosta:': u'\U0001F99E',
	u':gamberetto:': u'\U0001F990',
	u':calamaro:': u'\U0001F991',
	u':ostrica:': u'\U0001F9AA',
	u':cono_gelato:': u'\U0001F366',
	u':granita:': u'\U0001F367',
	u':coppa_di_gelato:': u'\U0001F368',
	u':ciambella:': u'\U0001F369',
	u':biscotto:': u'\U0001F36A',
	u':torta_di_compleanno:': u'\U0001F382',
	u':fetta_di_torta:': u'\U0001F370',
	u':cupcake:': u'\U0001F9C1',
	u':torta:': u'\U0001F967',
	u':cioccolato:': u'\U0001F36B',
	u':caramella:': u'\U0001F36C',
	u':lecca_lecca:': u'\U0001F36D',
	u':budino:': u'\U0001F36E',
	u':barattolo_di_miele:': u'\U0001F36F',
	u':biberon:': u'\U0001F37C',
	u':bicchiere_di_latte:': u'\U0001F95B',
	u':bevanda_calda:': u'\U00002615',
	u':teiera:': u'\U0001FAD6',
	u':tazza_da_tè_senza_manico:': u'\U0001F375',
	u':sake:': u'\U0001F376',
	u':bottiglia_stappata:': u'\U0001F37E',
	u':bicchiere_di_vino:': u'\U0001F377',
	u':cocktail:': u'\U0001F378',
	u':cocktail_tropicale:': u'\U0001F379',
	u':boccale_di_birra:': u'\U0001F37A',
	u':boccali_di_birra:': u'\U0001F37B',
	u':brindisi:': u'\U0001F942',
	u':bicchiere_tumbler:': u'\U0001F943',
	u':bicchiere_con_cannuccia:': u'\U0001F964',
	u':bubble_tea:': u'\U0001F9CB',
	u':bevanda_monodose:': u'\U0001F9C3',
	u':mate:': u'\U0001F9C9',
	u':cubetto_di_ghiaccio:': u'\U0001F9CA',
	u':bacchette:': u'\U0001F962',
	u':piatto_e_posate:': u'\U0001F37D\U0000FE0F',
	u':forchetta_e_coltello:': u'\U0001F374',
	u':cucchiaio:': u'\U0001F944',
	u':coltello_da_cucina:': u'\U0001F52A',
	u':anfora:': u'\U0001F3FA',
	u':europa_e_africa:': u'\U0001F30D',
	u':america:': u'\U0001F30E',
	u':asia_e_australia:': u'\U0001F30F',
	u':globo_con_meridiani:': u'\U0001F310',
	u':mappa_mondiale:': u'\U0001F5FA\U0000FE0F',
	u':mappa_del_giappone:': u'\U0001F5FE',
	u':bussola:': u'\U0001F9ED',
	u':montagna_innevata:': u'\U0001F3D4\U0000FE0F',
	u':montagna:': u'\U000026F0\U0000FE0F',
	u':vulcano:': u'\U0001F30B',
	u':monte_fuji:': u'\U0001F5FB',
	u':campeggio:': u'\U0001F3D5\U0000FE0F',
	u':spiaggia_con_ombrellone:': u'\U0001F3D6\U0000FE0F',
	u':deserto:': u'\U0001F3DC\U0000FE0F',
	u':isola_deserta:': u'\U0001F3DD\U0000FE0F',
	u':parco_nazionale:': u'\U0001F3DE\U0000FE0F',
	u':stadio:': u'\U0001F3DF\U0000FE0F',
	u':edificio_classico:': u'\U0001F3DB\U0000FE0F',
	u':edificio_in_costruzione:': u'\U0001F3D7\U0000FE0F',
	u':mattoni:': u'\U0001F9F1',
	u':roccia:': u'\U0001FAA8',
	u':legna:': u'\U0001FAB5',
	u':capanna:': u'\U0001F6D6',
	u':case:': u'\U0001F3D8\U0000FE0F',
	u':casa_in_rovina:': u'\U0001F3DA\U0000FE0F',
	u':casa:': u'\U0001F3E0',
	u':casa_con_giardino:': u'\U0001F3E1',
	u':edificio:': u'\U0001F3E2',
	u':ufficio_postale_giapponese:': u'\U0001F3E3',
	u':ufficio_postale:': u'\U0001F3E4',
	u':ospedale:': u'\U0001F3E5',
	u':banca:': u'\U0001F3E6',
	u':hotel:': u'\U0001F3E8',
	u':love_hotel:': u'\U0001F3E9',
	u':minimarket:': u'\U0001F3EA',
	u':scuola:': u'\U0001F3EB',
	u':grande_magazzino:': u'\U0001F3EC',
	u':fabbrica:': u'\U0001F3ED',
	u':castello_giapponese:': u'\U0001F3EF',
	u':castello:': u'\U0001F3F0',
	u':chiesa_per_matrimonio:': u'\U0001F492',
	u':torre_di_tokyo:': u'\U0001F5FC',
	u':statua_della_libertà:': u'\U0001F5FD',
	u':chiesa:': u'\U000026EA',
	u':moschea:': u'\U0001F54C',
	u':tempio_indù:': u'\U0001F6D5',
	u':sinagoga:': u'\U0001F54D',
	u':santuario_shintoista:': u'\U000026E9\U0000FE0F',
	u':kaaba:': u'\U0001F54B',
	u':fontana:': u'\U000026F2',
	u':tenda:': u'\U000026FA',
	u':nebbioso:': u'\U0001F301',
	u':notte_stellata:': u'\U0001F303',
	u':paesaggio_urbano:': u'\U0001F3D9\U0000FE0F',
	u':alba_sulle_montagne:': u'\U0001F304',
	u':alba:': u'\U0001F305',
	u':città_al_tramonto:': u'\U0001F306',
	u':tramonto:': u'\U0001F307',
	u':ponte_di_notte:': u'\U0001F309',
	u':sorgenti_termali:': u'\U00002668\U0000FE0F',
	u':cavallo_da_giostra:': u'\U0001F3A0',
	u':ruota_panoramica:': u'\U0001F3A1',
	u':montagne_russe:': u'\U0001F3A2',
	u':barbiere:': u'\U0001F488',
	u':circo:': u'\U0001F3AA',
	u':locomotiva:': u'\U0001F682',
	u':vagone:': u'\U0001F683',
	u':treno_alta_velocità:': u'\U0001F684',
	u':treno_alta_velocità_punta_arrotondata:': u'\U0001F685',
	u':treno:': u'\U0001F686',
	u':metropolitana:': u'\U0001F687',
	u':metrotranvia:': u'\U0001F688',
	u':stazione:': u'\U0001F689',
	u':tram:': u'\U0001F68A',
	u':monorotaia:': u'\U0001F69D',
	u':ferrovia_di_montagna:': u'\U0001F69E',
	u':vagone_del_tram:': u'\U0001F68B',
	u':bus:': u'\U0001F68C',
	u':bus_in_arrivo:': u'\U0001F68D',
	u':filobus:': u'\U0001F68E',
	u':pulmino:': u'\U0001F690',
	u':ambulanza:': u'\U0001F691',
	u':camion_dei_pompieri:': u'\U0001F692',
	u':macchina_della_polizia:': u'\U0001F693',
	u':macchina_della_polizia_in_arrivo:': u'\U0001F694',
	u':taxi:': u'\U0001F695',
	u':taxi_in_arrivo:': u'\U0001F696',
	u':auto:': u'\U0001F697',
	u':auto_in_arrivo:': u'\U0001F698',
	u':suv:': u'\U0001F699',
	u':pickup:': u'\U0001F6FB',
	u':camion:': u'\U0001F69A',
	u':autoarticolato:': u'\U0001F69B',
	u':trattore:': u'\U0001F69C',
	u':auto_da_corsa:': u'\U0001F3CE\U0000FE0F',
	u':motocicletta:': u'\U0001F3CD\U0000FE0F',
	u':scooter:': u'\U0001F6F5',
	u':sedia_a_rotelle_manuale:': u'\U0001F9BD',
	u':sedia_a_rotelle_motorizzata:': u'\U0001F9BC',
	u':risciò_a_motore:': u'\U0001F6FA',
	u':bicicletta:': u'\U0001F6B2',
	u':monopattino:': u'\U0001F6F4',
	u':skateboard:': u'\U0001F6F9',
	u':pattini_a_rotelle:': u'\U0001F6FC',
	u':fermata_dell’autobus:': u'\U0001F68F',
	u':autostrada:': u'\U0001F6E3\U0000FE0F',
	u':binari:': u'\U0001F6E4\U0000FE0F',
	u':barile_di_petrolio:': u'\U0001F6E2\U0000FE0F',
	u':stazione_di_servizio:': u'\U000026FD',
	u':lampeggiante:': u'\U0001F6A8',
	u':semaforo_orizzontale:': u'\U0001F6A5',
	u':semaforo_verticale:': u'\U0001F6A6',
	u':segnale_di_stop:': u'\U0001F6D1',
	u':area_cantiere:': u'\U0001F6A7',
	u':ancora:': u'\U00002693',
	u':barca_a_vela:': u'\U000026F5',
	u':canoa:': u'\U0001F6F6',
	u':motoscafo:': u'\U0001F6A4',
	u':nave_da_crociera:': u'\U0001F6F3\U0000FE0F',
	u':traghetto:': u'\U000026F4\U0000FE0F',
	u':barca_a_motore:': u'\U0001F6E5\U0000FE0F',
	u':nave:': u'\U0001F6A2',
	u':aeroplano:': u'\U00002708\U0000FE0F',
	u':aereo_turistico:': u'\U0001F6E9\U0000FE0F',
	u':decollo:': u'\U0001F6EB',
	u':atterraggio:': u'\U0001F6EC',
	u':paracadute:': u'\U0001FA82',
	u':sedile:': u'\U0001F4BA',
	u':elicottero:': u'\U0001F681',
	u':funivia:': u'\U0001F69F',
	u':funicolare:': u'\U0001F6A0',
	u':funivia_aerea:': u'\U0001F6A1',
	u':satellite:': u'\U0001F6F0\U0000FE0F',
	u':razzo:': u'\U0001F680',
	u':disco_volante:': u'\U0001F6F8',
	u':campanello_da_hotel:': u'\U0001F6CE\U0000FE0F',
	u':valigia:': u'\U0001F9F3',
	u':clessidra:': u'\U0000231B',
	u':clessidra_che_scorre:': u'\U000023F3',
	u':orologio:': u'\U0000231A',
	u':sveglia:': u'\U000023F0',
	u':cronometro:': u'\U000023F1\U0000FE0F',
	u':timer:': u'\U000023F2\U0000FE0F',
	u':orologio_da_mensola:': u'\U0001F570\U0000FE0F',
	u':ore_dodici:': u'\U0001F55B',
	u':ore_dodici_e_mezza:': u'\U0001F567',
	u':ore_una:': u'\U0001F550',
	u':ore_una_e_mezza:': u'\U0001F55C',
	u':ore_due:': u'\U0001F551',
	u':ore_due_e_mezza:': u'\U0001F55D',
	u':ore_tre:': u'\U0001F552',
	u':ore_tre_e_mezza:': u'\U0001F55E',
	u':ore_quattro:': u'\U0001F553',
	u':ore_quattro_e_mezza:': u'\U0001F55F',
	u':ore_cinque:': u'\U0001F554',
	u':ore_cinque_e_mezza:': u'\U0001F560',
	u':ore_sei:': u'\U0001F555',
	u':ore_sei_e_mezza:': u'\U0001F561',
	u':ore_sette:': u'\U0001F556',
	u':ore_sette_e_mezza:': u'\U0001F562',
	u':ore_otto:': u'\U0001F557',
	u':ore_otto_e_mezza:': u'\U0001F563',
	u':ore_nove:': u'\U0001F558',
	u':ore_nove_e_mezza:': u'\U0001F564',
	u':ore_dieci:': u'\U0001F559',
	u':ore_dieci_e_mezza:': u'\U0001F565',
	u':ore_undici:': u'\U0001F55A',
	u':ore_undici_e_mezza:': u'\U0001F566',
	u':luna_nuova:': u'\U0001F311',
	u':luna_crescente:': u'\U0001F312',
	u':primo_quarto_di_luna:': u'\U0001F313',
	u':luna_gibbosa_crescente:': u'\U0001F314',
	u':luna_piena:': u'\U0001F315',
	u':luna_gibbosa_calante:': u'\U0001F316',
	u':ultimo_quarto_di_luna:': u'\U0001F317',
	u':luna_calante:': u'\U0001F318',
	u':spicchio_di_luna:': u'\U0001F319',
	u':faccina_luna_nuova:': u'\U0001F31A',
	u':faccina_primo_quarto_di_luna:': u'\U0001F31B',
	u':faccina_ultimo_quarto_di_luna:': u'\U0001F31C',
	u':termometro:': u'\U0001F321\U0000FE0F',
	u':sole:': u'\U00002600\U0000FE0F',
	u':faccina_luna_piena:': u'\U0001F31D',
	u':faccina_sole:': u'\U0001F31E',
	u':pianeta_con_satellite:': u'\U0001FA90',
	u':stella:': u'\U00002B50',
	u':stella_che_brilla:': u'\U0001F31F',
	u':stella_cadente:': u'\U0001F320',
	u':via_lattea:': u'\U0001F30C',
	u':nuvola:': u'\U00002601\U0000FE0F',
	u':sole_coperto:': u'\U000026C5',
	u':temporale:': u'\U000026C8\U0000FE0F',
	u':parzialmente_nuvoloso:': u'\U0001F324\U0000FE0F',
	u':molto_nuvoloso:': u'\U0001F325\U0000FE0F',
	u':sole_coperto_e_pioggia:': u'\U0001F326\U0000FE0F',
	u':pioggia:': u'\U0001F327\U0000FE0F',
	u':neve:': u'\U0001F328\U0000FE0F',
	u':fulmini:': u'\U0001F329\U0000FE0F',
	u':tornado:': u'\U0001F32A\U0000FE0F',
	u':nebbia:': u'\U0001F32B\U0000FE0F',
	u':vento:': u'\U0001F32C\U0000FE0F',
	u':ciclone:': u'\U0001F300',
	u':arcobaleno:': u'\U0001F308',
	u':ombrello_chiuso:': u'\U0001F302',
	u':ombrello:': u'\U00002602\U0000FE0F',
	u':ombrello_con_gocce_di_pioggia:': u'\U00002614',
	u':ombrellone:': u'\U000026F1\U0000FE0F',
	u':alta_tensione:': u'\U000026A1',
	u':fiocco_di_neve:': u'\U00002744\U0000FE0F',
	u':pupazzo_di_neve:': u'\U00002603\U0000FE0F',
	u':pupazzo_di_neve_senza_neve:': u'\U000026C4',
	u':cometa:': u'\U00002604\U0000FE0F',
	u':fuoco:': u'\U0001F525',
	u':goccia:': u'\U0001F4A7',
	u':onda:': u'\U0001F30A',
	u':zucca_di_halloween:': u'\U0001F383',
	u':albero_di_natale:': u'\U0001F384',
	u':fuochi_d’artificio:': u'\U0001F386',
	u':stellina_scintillante:': u'\U0001F387',
	u':petardo:': u'\U0001F9E8',
	u':stelline:': u'\U00002728',
	u':palloncino:': u'\U0001F388',
	u':spara_coriandoli:': u'\U0001F389',
	u':coriandoli:': u'\U0001F38A',
	u':albero_decorato:': u'\U0001F38B',
	u':bambù_decorato:': u'\U0001F38D',
	u':bambole_giapponesi:': u'\U0001F38E',
	u':aquilone_a_forma_di_carpa:': u'\U0001F38F',
	u':campana_al_vento:': u'\U0001F390',
	u':contemplazione_della_luna:': u'\U0001F391',
	u':busta_rossa:': u'\U0001F9E7',
	u':fiocco:': u'\U0001F380',
	u':regalo:': u'\U0001F381',
	u':nastro:': u'\U0001F397\U0000FE0F',
	u':biglietto_d’ingresso:': u'\U0001F39F\U0000FE0F',
	u':biglietto:': u'\U0001F3AB',
	u':medaglia_militare:': u'\U0001F396\U0000FE0F',
	u':coppa:': u'\U0001F3C6',
	u':medaglia_sportiva:': u'\U0001F3C5',
	u':medaglia_d’oro:': u'\U0001F947',
	u':medaglia_d’argento:': u'\U0001F948',
	u':medaglia_di_bronzo:': u'\U0001F949',
	u':pallone_da_calcio:': u'\U000026BD',
	u':palla_da_baseball:': u'\U000026BE',
	u':palla_da_softball:': u'\U0001F94E',
	u':palla_da_pallacanestro:': u'\U0001F3C0',
	u':palla_da_pallavolo:': u'\U0001F3D0',
	u':football_americano:': u'\U0001F3C8',
	u':pallone_da_rugby:': u'\U0001F3C9',
	u':tennis:': u'\U0001F3BE',
	u':frisbee:': u'\U0001F94F',
	u':bowling:': u'\U0001F3B3',
	u':cricket:': u'\U0001F3CF',
	u':hockey_su_prato:': u'\U0001F3D1',
	u':hockey_su_ghiaccio:': u'\U0001F3D2',
	u':lacrosse:': u'\U0001F94D',
	u':ping_pong:': u'\U0001F3D3',
	u':badminton:': u'\U0001F3F8',
	u':guantone_da_pugilato:': u'\U0001F94A',
	u':kimono_per_arti_marziali:': u'\U0001F94B',
	u':porta_da_calcio:': u'\U0001F945',
	u':bandiera_in_buca:': u'\U000026F3',
	u':pattinaggio_su_ghiaccio:': u'\U000026F8\U0000FE0F',
	u':canna_da_pesca:': u'\U0001F3A3',
	u':maschera_da_sub:': u'\U0001F93F',
	u':maglia_da_corsa:': u'\U0001F3BD',
	u':sci:': u'\U0001F3BF',
	u':slitta:': u'\U0001F6F7',
	u':stone_da_curling:': u'\U0001F94C',
	u':bersaglio:': u'\U0001F3AF',
	u':yo-yo:': u'\U0001FA80',
	u':aquilone:': u'\U0001FA81',
	u':palla_da_biliardo:': u'\U0001F3B1',
	u':sfera_di_cristallo:': u'\U0001F52E',
	u':bacchetta_magica:': u'\U0001FA84',
	u':occhio_di_allah:': u'\U0001F9FF',
	u':gamepad:': u'\U0001F3AE',
	u':joystick:': u'\U0001F579\U0000FE0F',
	u':slot_machine:': u'\U0001F3B0',
	u':dado:': u'\U0001F3B2',
	u':pezzo_di_puzzle:': u'\U0001F9E9',
	u':orsetto:': u'\U0001F9F8',
	u':pentolaccia:': u'\U0001FA85',
	u':matrioska:': u'\U0001FA86',
	u':picche:': u'\U00002660\U0000FE0F',
	u':cuori:': u'\U00002665\U0000FE0F',
	u':quadri:': u'\U00002666\U0000FE0F',
	u':fiori:': u'\U00002663\U0000FE0F',
	u':pedina_degli_scacchi:': u'\U0000265F\U0000FE0F',
	u':jolly:': u'\U0001F0CF',
	u':tessera_mahjong:': u'\U0001F004',
	u':carta_da_gioco:': u'\U0001F3B4',
	u':maschere:': u'\U0001F3AD',
	u':quadro_incorniciato:': u'\U0001F5BC\U0000FE0F',
	u':tavolozza:': u'\U0001F3A8',
	u':filo:': u'\U0001F9F5',
	u':ago_da_cucito:': u'\U0001FAA1',
	u':gomitolo:': u'\U0001F9F6',
	u':nodo:': u'\U0001FAA2',
	u':occhiali_da_vista:': u'\U0001F453',
	u':occhiali_da_sole:': u'\U0001F576\U0000FE0F',
	u':maschera:': u'\U0001F97D',
	u':camice:': u'\U0001F97C',
	u':gilet_di_sicurezza:': u'\U0001F9BA',
	u':cravatta:': u'\U0001F454',
	u':t-shirt:': u'\U0001F455',
	u':jeans:': u'\U0001F456',
	u':sciarpa:': u'\U0001F9E3',
	u':guanti:': u'\U0001F9E4',
	u':cappotto:': u'\U0001F9E5',
	u':calzini:': u'\U0001F9E6',
	u':vestito:': u'\U0001F457',
	u':kimono:': u'\U0001F458',
	u':sari:': u'\U0001F97B',
	u':costume_da_bagno_intero:': u'\U0001FA71',
	u':slip:': u'\U0001FA72',
	u':pantaloncini:': u'\U0001FA73',
	u':bikini:': u'\U0001F459',
	u':maglietta_da_donna:': u'\U0001F45A',
	u':borsellino:': u'\U0001F45B',
	u':borsa:': u'\U0001F45C',
	u':pochette:': u'\U0001F45D',
	u':borse_della_spesa:': u'\U0001F6CD\U0000FE0F',
	u':zaino:': u'\U0001F392',
	u':infradito:': u'\U0001FA74',
	u':scarpa_da_uomo:': u'\U0001F45E',
	u':scarpa_sportiva:': u'\U0001F45F',
	u':stivale_da_trekking:': u'\U0001F97E',
	u':ballerina:': u'\U0001F97F',
	u':scarpa_con_il_tacco:': u'\U0001F460',
	u':sandalo_da_donna:': u'\U0001F461',
	u':scarpette_da_ballerina:': u'\U0001FA70',
	u':stivale_da_donna:': u'\U0001F462',
	u':corona:': u'\U0001F451',
	u':cappello_da_donna:': u'\U0001F452',
	u':cilindro:': u'\U0001F3A9',
	u':cappello_da_laureato:': u'\U0001F393',
	u':cappello_con_visiera:': u'\U0001F9E2',
	u':elmetto_militare:': u'\U0001FA96',
	u':elmetto_con_croce_bianca:': u'\U000026D1\U0000FE0F',
	u':rosario:': u'\U0001F4FF',
	u':rossetto:': u'\U0001F484',
	u':anello:': u'\U0001F48D',
	u':gemma:': u'\U0001F48E',
	u':altoparlante_disattivato:': u'\U0001F507',
	u':altoparlante_a_volume_basso:': u'\U0001F508',
	u':altoparlante_a_volume_intermedio:': u'\U0001F509',
	u':altoparlante_a_volume_alto:': u'\U0001F50A',
	u':altoparlante:': u'\U0001F4E2',
	u':megafono:': u'\U0001F4E3',
	u':corno_postale:': u'\U0001F4EF',
	u':campana:': u'\U0001F514',
	u':campana_sbarrata:': u'\U0001F515',
	u':pentagramma:': u'\U0001F3BC',
	u':nota_musicale:': u'\U0001F3B5',
	u':note_musicali:': u'\U0001F3B6',
	u':microfono_radiofonico:': u'\U0001F399\U0000FE0F',
	u':cursore_del_volume:': u'\U0001F39A\U0000FE0F',
	u':manopole_di_controllo:': u'\U0001F39B\U0000FE0F',
	u':microfono:': u'\U0001F3A4',
	u':cuffie:': u'\U0001F3A7',
	u':radio:': u'\U0001F4FB',
	u':sassofono:': u'\U0001F3B7',
	u':fisarmonica:': u'\U0001FA97',
	u':chitarra:': u'\U0001F3B8',
	u':piano:': u'\U0001F3B9',
	u':tromba:': u'\U0001F3BA',
	u':violino:': u'\U0001F3BB',
	u':banjo:': u'\U0001FA95',
	u':tamburo:': u'\U0001F941',
	u':tamburo_lungo:': u'\U0001FA98',
	u':telefono_cellulare:': u'\U0001F4F1',
	u':telefono_cellulare_con_freccia:': u'\U0001F4F2',
	u':telefono_fisso:': u'\U0000260E\U0000FE0F',
	u':cornetta:': u'\U0001F4DE',
	u':cercapersone:': u'\U0001F4DF',
	u':fax:': u'\U0001F4E0',
	u':batteria:': u'\U0001F50B',
	u':spina_elettrica:': u'\U0001F50C',
	u':computer_portatile:': u'\U0001F4BB',
	u':computer_fisso:': u'\U0001F5A5\U0000FE0F',
	u':stampante:': u'\U0001F5A8\U0000FE0F',
	u':tastiera:': u'\U00002328\U0000FE0F',
	u':mouse:': u'\U0001F5B1\U0000FE0F',
	u':trackball:': u'\U0001F5B2\U0000FE0F',
	u':minidisc:': u'\U0001F4BD',
	u':floppy_disc:': u'\U0001F4BE',
	u':disco_ottico:': u'\U0001F4BF',
	u':dvd:': u'\U0001F4C0',
	u':abaco:': u'\U0001F9EE',
	u':cinepresa:': u'\U0001F3A5',
	u':pellicola_cinematografica:': u'\U0001F39E\U0000FE0F',
	u':proiettore_cinematografico:': u'\U0001F4FD\U0000FE0F',
	u':ciak:': u'\U0001F3AC',
	u':televisore:': u'\U0001F4FA',
	u':fotocamera:': u'\U0001F4F7',
	u':fotocamera_con_flash:': u'\U0001F4F8',
	u':videocamera:': u'\U0001F4F9',
	u':videocassetta:': u'\U0001F4FC',
	u':lente_di_ingrandimento_rivolta_a_sinistra:': u'\U0001F50D',
	u':lente_di_ingrandimento_rivolta_a_destra:': u'\U0001F50E',
	u':candela:': u'\U0001F56F\U0000FE0F',
	u':lampadina:': u'\U0001F4A1',
	u':torcia:': u'\U0001F526',
	u':lanterna_rossa:': u'\U0001F3EE',
	u':diya:': u'\U0001FA94',
	u':quaderno_con_copertina_decorata:': u'\U0001F4D4',
	u':libro_chiuso:': u'\U0001F4D5',
	u':libro_aperto:': u'\U0001F4D6',
	u':libro_verde:': u'\U0001F4D7',
	u':libro_blu:': u'\U0001F4D8',
	u':libro_arancione:': u'\U0001F4D9',
	u':libri:': u'\U0001F4DA',
	u':quaderno:': u'\U0001F4D3',
	u':quaderno_ad_anelli:': u'\U0001F4D2',
	u':pagina_con_piega:': u'\U0001F4C3',
	u':pergamena:': u'\U0001F4DC',
	u':pagina:': u'\U0001F4C4',
	u':quotidiano:': u'\U0001F4F0',
	u':quotidiano_arrotolato:': u'\U0001F5DE\U0000FE0F',
	u':etichette_segnalibro:': u'\U0001F4D1',
	u':segnalibro:': u'\U0001F516',
	u':etichetta:': u'\U0001F3F7\U0000FE0F',
	u':sacco_di_soldi:': u'\U0001F4B0',
	u':moneta:': u'\U0001FA99',
	u':banconota_yen:': u'\U0001F4B4',
	u':banconota_dollaro:': u'\U0001F4B5',
	u':banconota_euro:': u'\U0001F4B6',
	u':banconota_sterlina:': u'\U0001F4B7',
	u':soldi_con_le_ali:': u'\U0001F4B8',
	u':carta_di_credito:': u'\U0001F4B3',
	u':scontrino:': u'\U0001F9FE',
	u':grafico_ascendente:': u'\U0001F4B9',
	u':busta:': u'\U00002709\U0000FE0F',
	u':e-mail:': u'\U0001F4E7',
	u':posta_in_arrivo:': u'\U0001F4E8',
	u':posta_in_uscita:': u'\U0001F4E9',
	u':posta_inviata:': u'\U0001F4E4',
	u':posta_ricevuta:': u'\U0001F4E5',
	u':pacco:': u'\U0001F4E6',
	u':cassetta_postale_chiusa_bandierina_alzata:': u'\U0001F4EB',
	u':cassetta_postale_chiusa_bandierina_abbassata:': u'\U0001F4EA',
	u':cassetta_postale_aperta_bandierina_alzata:': u'\U0001F4EC',
	u':cassetta_postale_con_bandierina_abbassata:': u'\U0001F4ED',
	u':cassetta_delle_lettere:': u'\U0001F4EE',
	u':urna_elettorale_con_scheda:': u'\U0001F5F3\U0000FE0F',
	u':matita:': u'\U0000270F\U0000FE0F',
	u':pennino:': u'\U00002712\U0000FE0F',
	u':penna_stilografica:': u'\U0001F58B\U0000FE0F',
	u':penna_a_sfera:': u'\U0001F58A\U0000FE0F',
	u':pennello:': u'\U0001F58C\U0000FE0F',
	u':pastello_a_cera:': u'\U0001F58D\U0000FE0F',
	u':memo:': u'\U0001F4DD',
	u':valigetta_24_ore:': u'\U0001F4BC',
	u':cartella_file:': u'\U0001F4C1',
	u':cartella_aperta:': u'\U0001F4C2',
	u':divisori_per_schedario:': u'\U0001F5C2\U0000FE0F',
	u':calendario:': u'\U0001F4C5',
	u':calendario_a_strappo:': u'\U0001F4C6',
	u':blocco_per_appunti_con_spirale:': u'\U0001F5D2\U0000FE0F',
	u':calendario_a_spirale:': u'\U0001F5D3\U0000FE0F',
	u':schedario:': u'\U0001F4C7',
	u':grafico_con_andamento_positivo:': u'\U0001F4C8',
	u':grafico_con_andamento_negativo:': u'\U0001F4C9',
	u':grafico_a_barre:': u'\U0001F4CA',
	u':portablocco:': u'\U0001F4CB',
	u':puntina:': u'\U0001F4CC',
	u':puntina_arrotondata:': u'\U0001F4CD',
	u':graffetta:': u'\U0001F4CE',
	u':graffette_attaccate:': u'\U0001F587\U0000FE0F',
	u':righello:': u'\U0001F4CF',
	u':squadra:': u'\U0001F4D0',
	u':forbici:': u'\U00002702\U0000FE0F',
	u':schedario_da_tavolo:': u'\U0001F5C3\U0000FE0F',
	u':schedario_da_ufficio:': u'\U0001F5C4\U0000FE0F',
	u':cestino:': u'\U0001F5D1\U0000FE0F',
	u':lucchetto_chiuso:': u'\U0001F512',
	u':lucchetto_aperto:': u'\U0001F513',
	u':lucchetto_con_penna_stilo:': u'\U0001F50F',
	u':lucchetto_chiuso_con_chiave:': u'\U0001F510',
	u':chiave:': u'\U0001F511',
	u':chiave_antica:': u'\U0001F5DD\U0000FE0F',
	u':martello:': u'\U0001F528',
	u':ascia:': u'\U0001FA93',
	u':piccone:': u'\U000026CF\U0000FE0F',
	u':piccone_e_martello:': u'\U00002692\U0000FE0F',
	u':martello_e_chiave_inglese:': u'\U0001F6E0\U0000FE0F',
	u':pugnale:': u'\U0001F5E1\U0000FE0F',
	u':spade_incrociate:': u'\U00002694\U0000FE0F',
	u':pistola:': u'\U0001F52B',
	u':boomerang:': u'\U0001FA83',
	u':arco_e_freccia:': u'\U0001F3F9',
	u':scudo:': u'\U0001F6E1\U0000FE0F',
	u':sega_da_falegname:': u'\U0001FA9A',
	u':chiave_inglese:': u'\U0001F527',
	u':cacciavite:': u'\U0001FA9B',
	u':vite_e_bullone:': u'\U0001F529',
	u':ingranaggio:': u'\U00002699\U0000FE0F',
	u':morsetto:': u'\U0001F5DC\U0000FE0F',
	u':bilancia_a_doppio_piatto:': u'\U00002696\U0000FE0F',
	u':bastone_per_non_vedenti:': u'\U0001F9AF',
	u':collegamento:': u'\U0001F517',
	u':catene:': u'\U000026D3\U0000FE0F',
	u':gancio:': u'\U0001FA9D',
	u':cassetta_degli_attrezzi:': u'\U0001F9F0',
	u':calamita:': u'\U0001F9F2',
	u':scala:': u'\U0001FA9C',
	u':alambicco:': u'\U00002697\U0000FE0F',
	u':provetta:': u'\U0001F9EA',
	u':piastra_di_petri:': u'\U0001F9EB',
	u':dna:': u'\U0001F9EC',
	u':microscopio:': u'\U0001F52C',
	u':telescopio:': u'\U0001F52D',
	u':antenna_satellitare:': u'\U0001F4E1',
	u':siringa:': u'\U0001F489',
	u':goccia_di_sangue:': u'\U0001FA78',
	u':pillola:': u'\U0001F48A',
	u':cerotto:': u'\U0001FA79',
	u':stetoscopio:': u'\U0001FA7A',
	u':porta:': u'\U0001F6AA',
	u':ascensore:': u'\U0001F6D7',
	u':specchio:': u'\U0001FA9E',
	u':finestra:': u'\U0001FA9F',
	u':letto:': u'\U0001F6CF\U0000FE0F',
	u':divano_e_lampada:': u'\U0001F6CB\U0000FE0F',
	u':sedia:': u'\U0001FA91',
	u':toilette:': u'\U0001F6BD',
	u':sturalavandini:': u'\U0001FAA0',
	u':doccia:': u'\U0001F6BF',
	u':vasca:': u'\U0001F6C1',
	u':trappola_per_topi:': u'\U0001FAA4',
	u':rasoio:': u'\U0001FA92',
	u':flacone:': u'\U0001F9F4',
	u':spilla_da_balia:': u'\U0001F9F7',
	u':scopa:': u'\U0001F9F9',
	u':cesto:': u'\U0001F9FA',
	u':rotolo_di_carta_igienica:': u'\U0001F9FB',
	u':secchio:': u'\U0001FAA3',
	u':sapone:': u'\U0001F9FC',
	u':spazzolino_da_denti:': u'\U0001FAA5',
	u':spugna:': u'\U0001F9FD',
	u':estintore:': u'\U0001F9EF',
	u':carrello:': u'\U0001F6D2',
	u':sigaretta:': u'\U0001F6AC',
	u':bara:': u'\U000026B0\U0000FE0F',
	u':lapide:': u'\U0001FAA6',
	u':urna_funeraria:': u'\U000026B1\U0000FE0F',
	u':moai:': u'\U0001F5FF',
	u':cartello:': u'\U0001FAA7',
	u':simbolo_dello_sportello_bancomat:': u'\U0001F3E7',
	u':simbolo_per_la_raccolta_dei_rifiuti:': u'\U0001F6AE',
	u':acqua_potabile:': u'\U0001F6B0',
	u':simbolo_della_disabilità:': u'\U0000267F',
	u':simbolo_del_bagno_degli_uomini:': u'\U0001F6B9',
	u':simbolo_del_bagno_delle_donne:': u'\U0001F6BA',
	u':simbolo_dei_servizi_igienici:': u'\U0001F6BB',
	u':simbolo_con_immagine_di_bambino:': u'\U0001F6BC',
	u':simbolo_del_wc:': u'\U0001F6BE',
	u':simbolo_del_controllo_passaporti:': u'\U0001F6C2',
	u':simbolo_della_dogana:': u'\U0001F6C3',
	u':simbolo_del_ritiro_bagagli:': u'\U0001F6C4',
	u':simbolo_del_deposito_bagagli:': u'\U0001F6C5',
	u':simbolo_di_avviso:': u'\U000026A0\U0000FE0F',
	u':attraversamento_bambini:': u'\U0001F6B8',
	u':segnale_di_divieto_di_accesso:': u'\U000026D4',
	u':segnale_di_divieto:': u'\U0001F6AB',
	u':segnale_di_divieto_di_transito_delle_biciclette:': u'\U0001F6B3',
	u':segnale_di_vietato_fumare:': u'\U0001F6AD',
	u':simbolo_del_divieto_di_gettare_rifiuti:': u'\U0001F6AF',
	u':simbolo_di_acqua_non_potabile:': u'\U0001F6B1',
	u':simbolo_del_divieto_di_transito_pedoni:': u'\U0001F6B7',
	u':simbolo_che_vieta_l’utilizzo_dei_telefoni_cellulari:': u'\U0001F4F5',
	u':simbolo_di_divieto_ai_minorenni:': u'\U0001F51E',
	u':simbolo_della_radioattività:': u'\U00002622\U0000FE0F',
	u':simbolo_del_rischio_biologico:': u'\U00002623\U0000FE0F',
	u':freccia_rivolta_verso_l’alto:': u'\U00002B06\U0000FE0F',
	u':freccia_rivolta_verso_destra_che_punta_in_alto:': u'\U00002197\U0000FE0F',
	u':freccia_rivolta_verso_destra:': u'\U000027A1\U0000FE0F',
	u':freccia_in_basso_a_destra:': u'\U00002198\U0000FE0F',
	u':freccia_rivolta_verso_il_basso:': u'\U00002B07\U0000FE0F',
	u':freccia_in_basso_a_sinistra:': u'\U00002199\U0000FE0F',
	u':freccia_rivolta_a_sinistra:': u'\U00002B05\U0000FE0F',
	u':freccia_in_alto_a_sinistra:': u'\U00002196\U0000FE0F',
	u':freccia_su-giù:': u'\U00002195\U0000FE0F',
	u':freccia_sinistra-destra:': u'\U00002194\U0000FE0F',
	u':freccia_curva_a_sinistra:': u'\U000021A9\U0000FE0F',
	u':freccia_curva_a_destra:': u'\U000021AA\U0000FE0F',
	u':freccia_curva_in_alto:': u'\U00002934\U0000FE0F',
	u':freccia_curva_in_basso:': u'\U00002935\U0000FE0F',
	u':frecce_verticali_che_ruotano_in_senso_orario:': u'\U0001F503',
	u':pulsante_con_frecce_che_ruotano_in_senso_antiorario:': u'\U0001F504',
	u':freccia_back:': u'\U0001F519',
	u':freccia_end:': u'\U0001F51A',
	u':freccia_on:': u'\U0001F51B',
	u':freccia_soon:': u'\U0001F51C',
	u':freccia_top:': u'\U0001F51D',
	u':luogo_di_culto:': u'\U0001F6D0',
	u':simbolo_dell’atomo:': u'\U0000269B\U0000FE0F',
	u':om:': u'\U0001F549\U0000FE0F',
	u':stella_di_david:': u'\U00002721\U0000FE0F',
	u':ruota_del_dharma:': u'\U00002638\U0000FE0F',
	u':yin_e_yang:': u'\U0000262F\U0000FE0F',
	u':croce_latina:': u'\U0000271D\U0000FE0F',
	u':croce_ortodossa:': u'\U00002626\U0000FE0F',
	u':mezzaluna_e_stella:': u'\U0000262A\U0000FE0F',
	u':simbolo_della_pace:': u'\U0000262E\U0000FE0F',
	u':menorah:': u'\U0001F54E',
	u':stella_a_sei_punte:': u'\U0001F52F',
	u':segno_zodiacale_dell’ariete:': u'\U00002648',
	u':segno_zodiacale_del_toro:': u'\U00002649',
	u':segno_zodiacale_dei_gemelli:': u'\U0000264A',
	u':segno_zodiacale_del_cancro:': u'\U0000264B',
	u':segno_zodiacale_del_leone:': u'\U0000264C',
	u':segno_zodiacale_della_vergine:': u'\U0000264D',
	u':segno_zodiacale_della_bilancia:': u'\U0000264E',
	u':segno_zodiacale_dello_scorpione:': u'\U0000264F',
	u':segno_zodiacale_del_saggitario:': u'\U00002650',
	u':segno_zodiacale_del_capricorno:': u'\U00002651',
	u':segno_zodiacale_dell’acquario:': u'\U00002652',
	u':segno_zodiacale_dei_pesci:': u'\U00002653',
	u':segno_zodiacale_dell’ofiuco:': u'\U000026CE',
	u':pulsante_di_riproduzione_casuale:': u'\U0001F500',
	u':pulsante_di_ripetizione_della_riproduzione:': u'\U0001F501',
	u':pulsante_di_ripetizione_della_riproduzione_di_una_traccia:': u'\U0001F502',
	u':pulsante_di_riproduzione:': u'\U000025B6\U0000FE0F',
	u':pulsante_di_avanzamento_rapido:': u'\U000023E9',
	u':traccia_successiva:': u'\U000023ED\U0000FE0F',
	u':pulsante_riproduci_pausa:': u'\U000023EF\U0000FE0F',
	u':pulsante_di_riavvolgimento:': u'\U000025C0\U0000FE0F',
	u':pulsante_di_riavvolgimento_rapido:': u'\U000023EA',
	u':pulsante_traccia_precedente:': u'\U000023EE\U0000FE0F',
	u':pulsante_a_triangolo_rivolto_verso_l’alto:': u'\U0001F53C',
	u':pulsante_doppia_freccia_in_alto:': u'\U000023EB',
	u':pulsante_a_triangolo_rivolto_verso_il_basso:': u'\U0001F53D',
	u':doppia_freccia_in_basso:': u'\U000023EC',
	u':pulsante_pausa:': u'\U000023F8\U0000FE0F',
	u':pulsante_stop:': u'\U000023F9\U0000FE0F',
	u':pulsante_di_registrazione:': u'\U000023FA\U0000FE0F',
	u':pulsante_di_espulsione:': u'\U000023CF\U0000FE0F',
	u':simbolo_del_cinema:': u'\U0001F3A6',
	u':luminosità_bassa:': u'\U0001F505',
	u':luminosità_elevata:': u'\U0001F506',
	u':segnale_cellulare:': u'\U0001F4F6',
	u':modalità_vibrazione:': u'\U0001F4F3',
	u':cellulare_spento:': u'\U0001F4F4',
	u':simbolo_genere_femminile:': u'\U00002640\U0000FE0F',
	u':simbolo_genere_maschile:': u'\U00002642\U0000FE0F',
	u':simbolo_transgender:': u'\U000026A7\U0000FE0F',
	u':segno_moltiplicazione:': u'\U00002716\U0000FE0F',
	u':simbolo_dell’addizione:': u'\U00002795',
	u':simbolo_della_sottrazione:': u'\U00002796',
	u':simbolo_della_divisione:': u'\U00002797',
	u':simbolo_dell’infinito:': u'\U0000267E\U0000FE0F',
	u':doppio_punto_esclamativo:': u'\U0000203C\U0000FE0F',
	u':punto_esclamativo_e_interrogativo:': u'\U00002049\U0000FE0F',
	u':punto_interrogativo_rosso:': u'\U00002753',
	u':punto_interrogativo_bianco:': u'\U00002754',
	u':punto_esclamativo_bianco:': u'\U00002755',
	u':punto_esclamativo_rosso:': u'\U00002757',
	u':trattino_ondulato:': u'\U00003030\U0000FE0F',
	u':cambio_valuta:': u'\U0001F4B1',
	u':dollaro:': u'\U0001F4B2',
	u':simbolo_della_medicina:': u'\U00002695\U0000FE0F',
	u':simbolo_del_riciclaggio:': u'\U0000267B\U0000FE0F',
	u':giglio_araldico:': u'\U0000269C\U0000FE0F',
	u':tridente:': u'\U0001F531',
	u':tesserino_per_nome:': u'\U0001F4DB',
	u':ideogramma_giapponese_di_“principiante”:': u'\U0001F530',
	u':cerchio:': u'\U00002B55',
	u':segno_di_spunta:': u'\U00002705',
	u':riquadro_con_spunta:': u'\U00002611\U0000FE0F',
	u':segno_di_spunta_nero:': u'\U00002714\U0000FE0F',
	u':croce:': u'\U0000274C',
	u':croce_con_quadrato:': u'\U0000274E',
	u':occhiello:': u'\U000027B0',
	u':doppio_occhiello:': u'\U000027BF',
	u':simbolo_di_alternanza_delle_parti:': u'\U0000303D\U0000FE0F',
	u':asterisco:': u'\U00002733\U0000FE0F',
	u':stella_stilizzata:': u'\U00002734\U0000FE0F',
	u':scintilla_stilizzata:': u'\U00002747\U0000FE0F',
	u':copyright:': u'\U000000A9\U0000FE0F',
	u':marchio_registrato:': u'\U000000AE\U0000FE0F',
	u':marchio:': u'\U00002122\U0000FE0F',
	u':tasto_#:': u'\U00002122\U0000FE0F',
	u':tasto_*:': u'\U0000002A\U0000FE0F\U000020E3',
	u':tasto_0:': u'\U00000030\U0000FE0F\U000020E3',
	u':tasto_1:': u'\U00000031\U0000FE0F\U000020E3',
	u':tasto_2:': u'\U00000032\U0000FE0F\U000020E3',
	u':tasto_3:': u'\U00000033\U0000FE0F\U000020E3',
	u':tasto_4:': u'\U00000034\U0000FE0F\U000020E3',
	u':tasto_5:': u'\U00000035\U0000FE0F\U000020E3',
	u':tasto_6:': u'\U00000036\U0000FE0F\U000020E3',
	u':tasto_7:': u'\U00000037\U0000FE0F\U000020E3',
	u':tasto_8:': u'\U00000038\U0000FE0F\U000020E3',
	u':tasto_9:': u'\U00000039\U0000FE0F\U000020E3',
	u':tasto_10:': u'\U0001F51F',
	u':pulsante_con_lettere_latine_maiuscole:': u'\U0001F520',
	u':pulsante_con_lettere_latine_minuscole:': u'\U0001F521',
	u':pulsante_con_numeri:': u'\U0001F522',
	u':pulsante_con_simboli:': u'\U0001F523',
	u':pulsante_con_lettere_latine:': u'\U0001F524',
	u':gruppo_sanguigno_a:': u'\U0001F170\U0000FE0F',
	u':gruppo_sanguigno_ab:': u'\U0001F18E',
	u':gruppo_sanguigno_b:': u'\U0001F171\U0000FE0F',
	u':pulsante_cl:': u'\U0001F191',
	u':pulsante_cool:': u'\U0001F192',
	u':pulsante_free:': u'\U0001F193',
	u':punto_informazioni:': u'\U00002139\U0000FE0F',
	u':pulsante_id:': u'\U0001F194',
	u':pulsante_m_cerchiata:': u'\U000024C2\U0000FE0F',
	u':pulsante_new:': u'\U0001F195',
	u':pulsante_ng:': u'\U0001F196',
	u':gruppo_sanguigno_0:': u'\U0001F17E\U0000FE0F',
	u':pulsante_ok:': u'\U0001F197',
	u':pulsante_p:': u'\U0001F17F\U0000FE0F',
	u':pulsante_sos:': u'\U0001F198',
	u':pulsante_up!:': u'\U0001F199',
	u':pulsante_vs:': u'\U0001F19A',
	u':ideogramma_giapponese_per_“qui”:': u'\U0001F201',
	u':ideogramma_giapponese_di_“costo_del_servizio”:': u'\U0001F202\U0000FE0F',
	u':ideogramma_giapponese_di_“importo_mensile”:': u'\U0001F237\U0000FE0F',
	u':ideogramma_giapponese_di_“a_pagamento”:': u'\U0001F236',
	u':ideogramma_giapponese_di_“riservato”:': u'\U0001F22F',
	u':ideogramma_giapponese_di_“occasione”:': u'\U0001F250',
	u':ideogramma_giapponese_di_“sconto”:': u'\U0001F239',
	u':ideogramma_giapponese_di_“gratis”:': u'\U0001F21A',
	u':ideogramma_giapponese_di_“proibito”:': u'\U0001F232',
	u':ideogramma_giapponese_di_“accettabile”:': u'\U0001F251',
	u':ideogramma_giapponese_di_“candidatura”:': u'\U0001F238',
	u':ideogramma_giapponese_di_“voto_di_sufficienza”:': u'\U0001F234',
	u':ideogramma_giapponese_di_“posto_libero”:': u'\U0001F233',
	u':ideogramma_giapponese_di_“congratulazioni”:': u'\U00003297\U0000FE0F',
	u':ideogramma_giapponese_di_“segreto”:': u'\U00003299\U0000FE0F',
	u':ideogramma_giapponese_di_“aperto_al_pubblico”:': u'\U0001F23A',
	u':ideogramma_giapponese_di_“nessun_posto_libero”:': u'\U0001F235',
	u':cerchio_rosso:': u'\U0001F534',
	u':cerchio_arancione:': u'\U0001F7E0',
	u':cerchio_giallo:': u'\U0001F7E1',
	u':cerchio_verde:': u'\U0001F7E2',
	u':cerchio_blu:': u'\U0001F535',
	u':cerchio_viola:': u'\U0001F7E3',
	u':cerchio_marrone:': u'\U0001F7E4',
	u':cerchio_nero:': u'\U000026AB',
	u':cerchio_bianco:': u'\U000026AA',
	u':quadrato_rosso:': u'\U0001F7E5',
	u':quadrato_arancione:': u'\U0001F7E7',
	u':quadrato_giallo:': u'\U0001F7E8',
	u':quadrato_verde:': u'\U0001F7E9',
	u':quadrato_blu:': u'\U0001F7E6',
	u':quadrato_viola:': u'\U0001F7EA',
	u':quadrato_marrone:': u'\U0001F7EB',
	u':quadrato_nero_grande:': u'\U00002B1B',
	u':quadrato_bianco_grande:': u'\U00002B1C',
	u':quadrato_nero_medio:': u'\U000025FC\U0000FE0F',
	u':quadrato_bianco_medio:': u'\U000025FB\U0000FE0F',
	u':quadrato_nero_medio-piccolo:': u'\U000025FE',
	u':quadrato_bianco_medio-piccolo:': u'\U000025FD',
	u':quadrato_nero_piccolo:': u'\U000025AA\U0000FE0F',
	u':quadrato_bianco_piccolo:': u'\U000025AB\U0000FE0F',
	u':rombo_arancione_grande:': u'\U0001F536',
	u':rombo_blu_grande:': u'\U0001F537',
	u':rombo_arancione_piccolo:': u'\U0001F538',
	u':rombo_blu_piccolo:': u'\U0001F539',
	u':triangolo_rosso_con_punta_verso_l’alto:': u'\U0001F53A',
	u':triangolo_rosso_con_punta_verso_il_basso:': u'\U0001F53B',
	u':petalo_di_fiore:': u'\U0001F4A0',
	u':pulsante_rotondo:': u'\U0001F518',
	u':tasto_quadrato_nero_con_bordo_bianco:': u'\U0001F533',
	u':tasto_quadrato_bianco_con_bordo_nero:': u'\U0001F532',
	u':bandiera_a_scacchi:': u'\U0001F3C1',
	u':bandierina_rossa:': u'\U0001F6A9',
	u':bandiere_del_giappone_incrociate:': u'\U0001F38C',
	u':bandiera_nera:': u'\U0001F3F4',
	u':bandiera_bianca:': u'\U0001F3F3\U0000FE0F',
	u':bandiera_arcobaleno:': u'\U0001F3F3\U0000FE0F\U0000200D\U0001F308',
	u':bandiera_transgender:': u'\U0001F3F3\U0000FE0F\U0000200D\U000026A7\U0000FE0F',
	u':bandiera_dei_pirati:': u'\U0001F3F4\U0000200D\U00002620\U0000FE0F',
	u':bandiera_isola_ascensione:': u'\U0001F1E6\U0001F1E8',
	u':bandiera_andorra:': u'\U0001F1E6\U0001F1E9',
	u':bandiera_emirati_arabi_uniti:': u'\U0001F1E6\U0001F1EA',
	u':bandiera_afghanistan:': u'\U0001F1E6\U0001F1EB',
	u':bandiera_antigua_e_barbuda:': u'\U0001F1E6\U0001F1EC',
	u':bandiera_anguilla:': u'\U0001F1E6\U0001F1EE',
	u':bandiera_albania:': u'\U0001F1E6\U0001F1F1',
	u':bandiera_armenia:': u'\U0001F1E6\U0001F1F2',
	u':bandiera_angola:': u'\U0001F1E6\U0001F1F4',
	u':bandiera_antartide:': u'\U0001F1E6\U0001F1F6',
	u':bandiera_argentina:': u'\U0001F1E6\U0001F1F7',
	u':bandiera_samoa_americane:': u'\U0001F1E6\U0001F1F8',
	u':bandiera_austria:': u'\U0001F1E6\U0001F1F9',
	u':bandiera_australia:': u'\U0001F1E6\U0001F1FA',
	u':bandiera_aruba:': u'\U0001F1E6\U0001F1FC',
	u':bandiera_isole_åland:': u'\U0001F1E6\U0001F1FD',
	u':bandiera_azerbaigian:': u'\U0001F1E6\U0001F1FF',
	u':bandiera_bosnia_ed_erzegovina:': u'\U0001F1E7\U0001F1E6',
	u':bandiera_barbados:': u'\U0001F1E7\U0001F1E7',
	u':bandiera_bangladesh:': u'\U0001F1E7\U0001F1E9',
	u':bandiera_belgio:': u'\U0001F1E7\U0001F1EA',
	u':bandiera_burkina_faso:': u'\U0001F1E7\U0001F1EB',
	u':bandiera_bulgaria:': u'\U0001F1E7\U0001F1EC',
	u':bandiera_bahrein:': u'\U0001F1E7\U0001F1ED',
	u':bandiera_burundi:': u'\U0001F1E7\U0001F1EE',
	u':bandiera_benin:': u'\U0001F1E7\U0001F1EF',
	u':bandiera_saint-barthélemy:': u'\U0001F1E7\U0001F1F1',
	u':bandiera_bermuda:': u'\U0001F1E7\U0001F1F2',
	u':bandiera_brunei:': u'\U0001F1E7\U0001F1F3',
	u':bandiera_bolivia:': u'\U0001F1E7\U0001F1F4',
	u':bandiera_caraibi_olandesi:': u'\U0001F1E7\U0001F1F6',
	u':bandiera_brasile:': u'\U0001F1E7\U0001F1F7',
	u':bandiera_bahamas:': u'\U0001F1E7\U0001F1F8',
	u':bandiera_bhutan:': u'\U0001F1E7\U0001F1F9',
	u':bandiera_isola_bouvet:': u'\U0001F1E7\U0001F1FB',
	u':bandiera_botswana:': u'\U0001F1E7\U0001F1FC',
	u':bandiera_bielorussia:': u'\U0001F1E7\U0001F1FE',
	u':bandiera_belize:': u'\U0001F1E7\U0001F1FF',
	u':bandiera_canada:': u'\U0001F1E8\U0001F1E6',
	u':bandiera_isole_cocos_(keeling):': u'\U0001F1E8\U0001F1E8',
	u':bandiera_congo_–_kinshasa:': u'\U0001F1E8\U0001F1E9',
	u':bandiera_repubblica_centrafricana:': u'\U0001F1E8\U0001F1EB',
	u':bandiera_congo-brazzaville:': u'\U0001F1E8\U0001F1EC',
	u':bandiera_svizzera:': u'\U0001F1E8\U0001F1ED',
	u':bandiera_costa_d’avorio:': u'\U0001F1E8\U0001F1EE',
	u':bandiera_isole_cook:': u'\U0001F1E8\U0001F1F0',
	u':bandiera_cile:': u'\U0001F1E8\U0001F1F1',
	u':bandiera_camerun:': u'\U0001F1E8\U0001F1F2',
	u':bandiera_cina:': u'\U0001F1E8\U0001F1F3',
	u':bandiera_colombia:': u'\U0001F1E8\U0001F1F4',
	u':bandiera_isola_di_clipperton:': u'\U0001F1E8\U0001F1F5',
	u':bandiera_costa_rica:': u'\U0001F1E8\U0001F1F7',
	u':bandiera_cuba:': u'\U0001F1E8\U0001F1FA',
	u':bandiera_capo_verde:': u'\U0001F1E8\U0001F1FB',
	u':bandiera_curaçao:': u'\U0001F1E8\U0001F1FC',
	u':bandiera_isola_christmas:': u'\U0001F1E8\U0001F1FD',
	u':bandiera_cipro:': u'\U0001F1E8\U0001F1FE',
	u':bandiera_cechia:': u'\U0001F1E8\U0001F1FF',
	u':bandiera_germania:': u'\U0001F1E9\U0001F1EA',
	u':bandiera_diego_garcia:': u'\U0001F1E9\U0001F1EC',
	u':bandiera_gibuti:': u'\U0001F1E9\U0001F1EF',
	u':bandiera_danimarca:': u'\U0001F1E9\U0001F1F0',
	u':bandiera_dominica:': u'\U0001F1E9\U0001F1F2',
	u':bandiera_repubblica_dominicana:': u'\U0001F1E9\U0001F1F4',
	u':bandiera_algeria:': u'\U0001F1E9\U0001F1FF',
	u':bandiera_ceuta_e_melilla:': u'\U0001F1EA\U0001F1E6',
	u':bandiera_ecuador:': u'\U0001F1EA\U0001F1E8',
	u':bandiera_estonia:': u'\U0001F1EA\U0001F1EA',
	u':bandiera_egitto:': u'\U0001F1EA\U0001F1EC',
	u':bandiera_sahara_occidentale:': u'\U0001F1EA\U0001F1ED',
	u':bandiera_eritrea:': u'\U0001F1EA\U0001F1F7',
	u':bandiera_spagna:': u'\U0001F1EA\U0001F1F8',
	u':bandiera_etiopia:': u'\U0001F1EA\U0001F1F9',
	u':bandiera_unione_europea:': u'\U0001F1EA\U0001F1FA',
	u':bandiera_finlandia:': u'\U0001F1EB\U0001F1EE',
	u':bandiera_figi:': u'\U0001F1EB\U0001F1EF',
	u':bandiera_isole_falkland:': u'\U0001F1EB\U0001F1F0',
	u':bandiera_micronesia:': u'\U0001F1EB\U0001F1F2',
	u':bandiera_isole_fær_øer:': u'\U0001F1EB\U0001F1F4',
	u':bandiera_francia:': u'\U0001F1EB\U0001F1F7',
	u':bandiera_gabon:': u'\U0001F1EC\U0001F1E6',
	u':bandiera_regno_unito:': u'\U0001F1EC\U0001F1E7',
	u':bandiera_grenada:': u'\U0001F1EC\U0001F1E9',
	u':bandiera_georgia:': u'\U0001F1EC\U0001F1EA',
	u':bandiera_guyana_francese:': u'\U0001F1EC\U0001F1EB',
	u':bandiera_guernsey:': u'\U0001F1EC\U0001F1EC',
	u':bandiera_ghana:': u'\U0001F1EC\U0001F1ED',
	u':bandiera_gibilterra:': u'\U0001F1EC\U0001F1EE',
	u':bandiera_groenlandia:': u'\U0001F1EC\U0001F1F1',
	u':bandiera_gambia:': u'\U0001F1EC\U0001F1F2',
	u':bandiera_guinea:': u'\U0001F1EC\U0001F1F3',
	u':bandiera_guadalupa:': u'\U0001F1EC\U0001F1F5',
	u':bandiera_guinea_equatoriale:': u'\U0001F1EC\U0001F1F6',
	u':bandiera_grecia:': u'\U0001F1EC\U0001F1F7',
	u':bandiera_georgia_del_sud_e_sandwich_australi:': u'\U0001F1EC\U0001F1F8',
	u':bandiera_guatemala:': u'\U0001F1EC\U0001F1F9',
	u':bandiera_guam:': u'\U0001F1EC\U0001F1FA',
	u':bandiera_guinea-bissau:': u'\U0001F1EC\U0001F1FC',
	u':bandiera_guyana:': u'\U0001F1EC\U0001F1FE',
	u':bandiera_ras_di_hong_kong:': u'\U0001F1ED\U0001F1F0',
	u':bandiera_isole_heard_e_mcdonald:': u'\U0001F1ED\U0001F1F2',
	u':bandiera_honduras:': u'\U0001F1ED\U0001F1F3',
	u':bandiera_croazia:': u'\U0001F1ED\U0001F1F7',
	u':bandiera_haiti:': u'\U0001F1ED\U0001F1F9',
	u':bandiera_ungheria:': u'\U0001F1ED\U0001F1FA',
	u':bandiera_isole_canarie:': u'\U0001F1EE\U0001F1E8',
	u':bandiera_indonesia:': u'\U0001F1EE\U0001F1E9',
	u':bandiera_irlanda:': u'\U0001F1EE\U0001F1EA',
	u':bandiera_israele:': u'\U0001F1EE\U0001F1F1',
	u':bandiera_isola_di_man:': u'\U0001F1EE\U0001F1F2',
	u':bandiera_india:': u'\U0001F1EE\U0001F1F3',
	u':bandiera_territorio_britannico_dell’oceano_indiano:': u'\U0001F1EE\U0001F1F4',
	u':bandiera_iraq:': u'\U0001F1EE\U0001F1F6',
	u':bandiera_iran:': u'\U0001F1EE\U0001F1F7',
	u':bandiera_islanda:': u'\U0001F1EE\U0001F1F8',
	u':bandiera_italia:': u'\U0001F1EE\U0001F1F9',
	u':bandiera_jersey:': u'\U0001F1EF\U0001F1EA',
	u':bandiera_giamaica:': u'\U0001F1EF\U0001F1F2',
	u':bandiera_giordania:': u'\U0001F1EF\U0001F1F4',
	u':bandiera_giappone:': u'\U0001F1EF\U0001F1F5',
	u':bandiera_kenya:': u'\U0001F1F0\U0001F1EA',
	u':bandiera_kirghizistan:': u'\U0001F1F0\U0001F1EC',
	u':bandiera_cambogia:': u'\U0001F1F0\U0001F1ED',
	u':bandiera_kiribati:': u'\U0001F1F0\U0001F1EE',
	u':bandiera_comore:': u'\U0001F1F0\U0001F1F2',
	u':bandiera_saint_kitts_e_nevis:': u'\U0001F1F0\U0001F1F3',
	u':bandiera_corea_del_nord:': u'\U0001F1F0\U0001F1F5',
	u':bandiera_corea_del_sud:': u'\U0001F1F0\U0001F1F7',
	u':bandiera_kuwait:': u'\U0001F1F0\U0001F1FC',
	u':bandiera_isole_cayman:': u'\U0001F1F0\U0001F1FE',
	u':bandiera_kazakistan:': u'\U0001F1F0\U0001F1FF',
	u':bandiera_laos:': u'\U0001F1F1\U0001F1E6',
	u':bandiera_libano:': u'\U0001F1F1\U0001F1E7',
	u':bandiera_saint_lucia:': u'\U0001F1F1\U0001F1E8',
	u':bandiera_liechtenstein:': u'\U0001F1F1\U0001F1EE',
	u':bandiera_sri_lanka:': u'\U0001F1F1\U0001F1F0',
	u':bandiera_liberia:': u'\U0001F1F1\U0001F1F7',
	u':bandiera_lesotho:': u'\U0001F1F1\U0001F1F8',
	u':bandiera_lituania:': u'\U0001F1F1\U0001F1F9',
	u':bandiera_lussemburgo:': u'\U0001F1F1\U0001F1FA',
	u':bandiera_lettonia:': u'\U0001F1F1\U0001F1FB',
	u':bandiera_libia:': u'\U0001F1F1\U0001F1FE',
	u':bandiera_marocco:': u'\U0001F1F2\U0001F1E6',
	u':bandiera_monaco:': u'\U0001F1F2\U0001F1E8',
	u':bandiera_moldavia:': u'\U0001F1F2\U0001F1E9',
	u':bandiera_montenegro:': u'\U0001F1F2\U0001F1EA',
	u':bandiera_saint_martin:': u'\U0001F1F2\U0001F1EB',
	u':bandiera_madagascar:': u'\U0001F1F2\U0001F1EC',
	u':bandiera_isole_marshall:': u'\U0001F1F2\U0001F1ED',
	u':bandiera_macedonia_del_nord:': u'\U0001F1F2\U0001F1F0',
	u':bandiera_mali:': u'\U0001F1F2\U0001F1F1',
	u':bandiera_myanmar_(birmania):': u'\U0001F1F2\U0001F1F2',
	u':bandiera_mongolia:': u'\U0001F1F2\U0001F1F3',
	u':bandiera_ras_di_macao:': u'\U0001F1F2\U0001F1F4',
	u':bandiera_isole_marianne_settentrionali:': u'\U0001F1F2\U0001F1F5',
	u':bandiera_martinica:': u'\U0001F1F2\U0001F1F6',
	u':bandiera_mauritania:': u'\U0001F1F2\U0001F1F7',
	u':bandiera_montserrat:': u'\U0001F1F2\U0001F1F8',
	u':bandiera_malta:': u'\U0001F1F2\U0001F1F9',
	u':bandiera_mauritius:': u'\U0001F1F2\U0001F1FA',
	u':bandiera_maldive:': u'\U0001F1F2\U0001F1FB',
	u':bandiera_malawi:': u'\U0001F1F2\U0001F1FC',
	u':bandiera_messico:': u'\U0001F1F2\U0001F1FD',
	u':bandiera_malaysia:': u'\U0001F1F2\U0001F1FE',
	u':bandiera_mozambico:': u'\U0001F1F2\U0001F1FF',
	u':bandiera_namibia:': u'\U0001F1F3\U0001F1E6',
	u':bandiera_nuova_caledonia:': u'\U0001F1F3\U0001F1E8',
	u':bandiera_niger:': u'\U0001F1F3\U0001F1EA',
	u':bandiera_isola_norfolk:': u'\U0001F1F3\U0001F1EB',
	u':bandiera_nigeria:': u'\U0001F1F3\U0001F1EC',
	u':bandiera_nicaragua:': u'\U0001F1F3\U0001F1EE',
	u':bandiera_paesi_bassi:': u'\U0001F1F3\U0001F1F1',
	u':bandiera_norvegia:': u'\U0001F1F3\U0001F1F4',
	u':bandiera_nepal:': u'\U0001F1F3\U0001F1F5',
	u':bandiera_nauru:': u'\U0001F1F3\U0001F1F7',
	u':bandiera_niue:': u'\U0001F1F3\U0001F1FA',
	u':bandiera_nuova_zelanda:': u'\U0001F1F3\U0001F1FF',
	u':bandiera_oman:': u'\U0001F1F4\U0001F1F2',
	u':bandiera_panamá:': u'\U0001F1F5\U0001F1E6',
	u':bandiera_perù:': u'\U0001F1F5\U0001F1EA',
	u':bandiera_polinesia_francese:': u'\U0001F1F5\U0001F1EB',
	u':bandiera_papua_nuova_guinea:': u'\U0001F1F5\U0001F1EC',
	u':bandiera_filippine:': u'\U0001F1F5\U0001F1ED',
	u':bandiera_pakistan:': u'\U0001F1F5\U0001F1F0',
	u':bandiera_polonia:': u'\U0001F1F5\U0001F1F1',
	u':bandiera_saint-pierre_e_miquelon:': u'\U0001F1F5\U0001F1F2',
	u':bandiera_isole_pitcairn:': u'\U0001F1F5\U0001F1F3',
	u':bandiera_portorico:': u'\U0001F1F5\U0001F1F7',
	u':bandiera_territori_palestinesi:': u'\U0001F1F5\U0001F1F8',
	u':bandiera_portogallo:': u'\U0001F1F5\U0001F1F9',
	u':bandiera_palau:': u'\U0001F1F5\U0001F1FC',
	u':bandiera_paraguay:': u'\U0001F1F5\U0001F1FE',
	u':bandiera_qatar:': u'\U0001F1F6\U0001F1E6',
	u':bandiera_riunione:': u'\U0001F1F7\U0001F1EA',
	u':bandiera_romania:': u'\U0001F1F7\U0001F1F4',
	u':bandiera_serbia:': u'\U0001F1F7\U0001F1F8',
	u':bandiera_russia:': u'\U0001F1F7\U0001F1FA',
	u':bandiera_ruanda:': u'\U0001F1F7\U0001F1FC',
	u':bandiera_arabia_saudita:': u'\U0001F1F8\U0001F1E6',
	u':bandiera_isole_salomone:': u'\U0001F1F8\U0001F1E7',
	u':bandiera_seychelles:': u'\U0001F1F8\U0001F1E8',
	u':bandiera_sudan:': u'\U0001F1F8\U0001F1E9',
	u':bandiera_svezia:': u'\U0001F1F8\U0001F1EA',
	u':bandiera_singapore:': u'\U0001F1F8\U0001F1EC',
	u':bandiera_sant’elena:': u'\U0001F1F8\U0001F1ED',
	u':bandiera_slovenia:': u'\U0001F1F8\U0001F1EE',
	u':bandiera_svalbard_e_jan_mayen:': u'\U0001F1F8\U0001F1EF',
	u':bandiera_slovacchia:': u'\U0001F1F8\U0001F1F0',
	u':bandiera_sierra_leone:': u'\U0001F1F8\U0001F1F1',
	u':bandiera_san_marino:': u'\U0001F1F8\U0001F1F2',
	u':bandiera_senegal:': u'\U0001F1F8\U0001F1F3',
	u':bandiera_somalia:': u'\U0001F1F8\U0001F1F4',
	u':bandiera_suriname:': u'\U0001F1F8\U0001F1F7',
	u':bandiera_sud_sudan:': u'\U0001F1F8\U0001F1F8',
	u':bandiera_são_tomé_e_príncipe:': u'\U0001F1F8\U0001F1F9',
	u':bandiera_el_salvador:': u'\U0001F1F8\U0001F1FB',
	u':bandiera_sint_maarten:': u'\U0001F1F8\U0001F1FD',
	u':bandiera_siria:': u'\U0001F1F8\U0001F1FE',
	u':bandiera_swaziland:': u'\U0001F1F8\U0001F1FF',
	u':bandiera_tristan_da_cunha:': u'\U0001F1F9\U0001F1E6',
	u':bandiera_isole_turks_e_caicos:': u'\U0001F1F9\U0001F1E8',
	u':bandiera_ciad:': u'\U0001F1F9\U0001F1E9',
	u':bandiera_terre_australi_francesi:': u'\U0001F1F9\U0001F1EB',
	u':bandiera_togo:': u'\U0001F1F9\U0001F1EC',
	u':bandiera_thailandia:': u'\U0001F1F9\U0001F1ED',
	u':bandiera_tagikistan:': u'\U0001F1F9\U0001F1EF',
	u':bandiera_tokelau:': u'\U0001F1F9\U0001F1F0',
	u':bandiera_timor_est:': u'\U0001F1F9\U0001F1F1',
	u':bandiera_turkmenistan:': u'\U0001F1F9\U0001F1F2',
	u':bandiera_tunisia:': u'\U0001F1F9\U0001F1F3',
	u':bandiera_tonga:': u'\U0001F1F9\U0001F1F4',
	u':bandiera_turchia:': u'\U0001F1F9\U0001F1F7',
	u':bandiera_trinidad_e_tobago:': u'\U0001F1F9\U0001F1F9',
	u':bandiera_tuvalu:': u'\U0001F1F9\U0001F1FB',
	u':bandiera_taiwan:': u'\U0001F1F9\U0001F1FC',
	u':bandiera_tanzania:': u'\U0001F1F9\U0001F1FF',
	u':bandiera_ucraina:': u'\U0001F1FA\U0001F1E6',
	u':bandiera_uganda:': u'\U0001F1FA\U0001F1EC',
	u':bandiera_altre_isole_americane_del_pacifico:': u'\U0001F1FA\U0001F1F2',
	u':bandiera_nazioni_unite:': u'\U0001F1FA\U0001F1F3',
	u':bandiera_stati_uniti:': u'\U0001F1FA\U0001F1F8',
	u':bandiera_uruguay:': u'\U0001F1FA\U0001F1FE',
	u':bandiera_uzbekistan:': u'\U0001F1FA\U0001F1FF',
	u':bandiera_città_del_vaticano:': u'\U0001F1FB\U0001F1E6',
	u':bandiera_saint_vincent_e_grenadine:': u'\U0001F1FB\U0001F1E8',
	u':bandiera_venezuela:': u'\U0001F1FB\U0001F1EA',
	u':bandiera_isole_vergini_britanniche:': u'\U0001F1FB\U0001F1EC',
	u':bandiera_isole_vergini_americane:': u'\U0001F1FB\U0001F1EE',
	u':bandiera_vietnam:': u'\U0001F1FB\U0001F1F3',
	u':bandiera_vanuatu:': u'\U0001F1FB\U0001F1FA',
	u':bandiera_wallis_e_futuna:': u'\U0001F1FC\U0001F1EB',
	u':bandiera_samoa:': u'\U0001F1FC\U0001F1F8',
	u':bandiera_kosovo:': u'\U0001F1FD\U0001F1F0',
	u':bandiera_yemen:': u'\U0001F1FE\U0001F1EA',
	u':bandiera_mayotte:': u'\U0001F1FE\U0001F1F9',
	u':bandiera_sudafrica:': u'\U0001F1FF\U0001F1E6',
	u':bandiera_zambia:': u'\U0001F1FF\U0001F1F2',
	u':bandiera_zimbabwe:': u'\U0001F1FF\U0001F1FC',
	u':bandiera_inghilterra:': u'\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F',
	u':bandiera_scozia:': u'\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F',
	u':bandiera_galles:': u'\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F'
}

UNICODE_EMOJI_ITALIAN = {v: k for k, v in EMOJI_UNICODE_ITALIAN.items()}
