/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.solr.handler.designer.SchemaDesignerConstants;
import org.apache.solr.schema.ManagedIndexSchema;

class SchemaDesignerSettings
implements SchemaDesignerConstants {
    private String copyFrom;
    private boolean isDisabled;
    private List<String> languages;
    private boolean dynamicFieldsEnabled;
    private boolean nestedDocsEnabled;
    private boolean fieldGuessingEnabled;
    private Integer publishedVersion;
    private ManagedIndexSchema schema;

    SchemaDesignerSettings(Map<String, Object> stored) {
        this.isDisabled = (Boolean)stored.getOrDefault("_designer.disabled", false);
        this.publishedVersion = null;
        this.copyFrom = (String)stored.get("_designer.copyFrom");
        this.languages = stored.getOrDefault("_designer.languages", Collections.emptyList());
        this.dynamicFieldsEnabled = (Boolean)stored.getOrDefault("_designer.enableDynamicFields", true);
        this.nestedDocsEnabled = (Boolean)stored.getOrDefault("_designer.enableNestedDocs", false);
        this.fieldGuessingEnabled = (Boolean)stored.getOrDefault("update.autoCreateFields", true);
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_designer.disabled", this.isDisabled);
        map.put("_designer.languages", this.languages);
        map.put("_designer.enableDynamicFields", this.dynamicFieldsEnabled);
        map.put("_designer.enableNestedDocs", this.nestedDocsEnabled);
        map.put("update.autoCreateFields", this.fieldGuessingEnabled);
        if (this.copyFrom != null) {
            map.put("_designer.copyFrom", this.copyFrom);
        }
        if (this.publishedVersion != null) {
            map.put("_designer.publishedVersion", this.publishedVersion);
        }
        return map;
    }

    public ManagedIndexSchema getSchema() {
        return this.schema;
    }

    public void setSchema(ManagedIndexSchema schema) {
        this.schema = schema;
    }

    public Optional<Integer> getPublishedVersion() {
        return Optional.ofNullable(this.publishedVersion);
    }

    public void setPublishedVersion(int publishedVersion) {
        this.publishedVersion = publishedVersion;
    }

    public String getCopyFrom() {
        return this.copyFrom;
    }

    public void setCopyFrom(String copyFrom) {
        this.copyFrom = copyFrom;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> langs) {
        this.languages = langs != null ? langs : Collections.emptyList();
    }

    public boolean dynamicFieldsEnabled() {
        return this.dynamicFieldsEnabled;
    }

    public void setDynamicFieldsEnabled(boolean enabled) {
        this.dynamicFieldsEnabled = enabled;
    }

    public boolean nestedDocsEnabled() {
        return this.nestedDocsEnabled;
    }

    public void setNestedDocsEnabled(boolean enabled) {
        this.nestedDocsEnabled = enabled;
    }

    public boolean fieldGuessingEnabled() {
        return this.fieldGuessingEnabled;
    }

    public void setFieldGuessingEnabled(boolean enabled) {
        this.fieldGuessingEnabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDesignerSettings that = (SchemaDesignerSettings)o;
        return this.isDisabled == that.isDisabled && this.dynamicFieldsEnabled == that.dynamicFieldsEnabled && this.nestedDocsEnabled == that.nestedDocsEnabled && this.fieldGuessingEnabled == that.fieldGuessingEnabled && Objects.equals(this.copyFrom, that.copyFrom) && this.languages.equals(that.languages) && Objects.equals(this.publishedVersion, that.publishedVersion);
    }

    public int hashCode() {
        return Objects.hash(this.copyFrom, this.isDisabled, this.languages, this.dynamicFieldsEnabled, this.nestedDocsEnabled, this.fieldGuessingEnabled, this.publishedVersion);
    }
}

