/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scl;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.eclipse.EclipseConnection;
import ghidra.app.plugin.core.navigation.locationreferences.AddressLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.services.EclipseIntegrationService;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Miscellaneous", shortDescription="Source Code Lookup Plugin", description="Plugin to send requests to the development IDE to lookup symbols in source files.", servicesRequired={EclipseIntegrationService.class}, eventsConsumed={ProgramLocationPluginEvent.class})
public class SourceCodeLookupPlugin
extends ProgramPlugin {
    private static final String ACTION_NAME = "Go To Symbol Source";
    private static final String CDT_START = "org.eclipse.cdt.core_";
    private DockingAction lookupSourceCodeAction;

    public SourceCodeLookupPlugin(PluginTool tool) {
        super(tool, false, false);
    }

    protected void dispose() {
        super.dispose();
    }

    public void init() {
        super.init();
        this.lookupSourceCodeAction = new DockingAction("Source Code Lookup", this.getName()){

            public void actionPerformed(ActionContext context) {
                SourceCodeLookupPlugin.this.lookupSymbol();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context instanceof ProgramLocationActionContext;
            }
        };
        this.lookupSourceCodeAction.setMenuBarData(new MenuData(new String[]{"&Navigation", ACTION_NAME}, null, "GoTo", -1, "z"));
        this.lookupSourceCodeAction.setKeyBindingData(new KeyBindingData(114, 0));
        this.lookupSourceCodeAction.setHelpLocation(new HelpLocation("SourceCodeLookupPlugin", "Source_Code_Lookup_Plugin"));
        this.tool.addAction((DockingActionIf)this.lookupSourceCodeAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupSymbol() {
        EclipseIntegrationService service;
        ToolOptions options;
        int port;
        String symbolText = this.getSymbolText();
        if (symbolText == null) {
            return;
        }
        String demangled = this.attemptToDemangle(symbolText);
        if (demangled != null) {
            symbolText = demangled;
        }
        if ((port = (options = (service = (EclipseIntegrationService)this.tool.getService(EclipseIntegrationService.class)).getEclipseIntegrationOptions()).getInt("Symbol Lookup Port", -1)) < 0 || port > Short.MAX_VALUE) {
            service.handleEclipseError("Option \"Symbol Lookup Port\" is not valid.  Cannot connect to Eclipse.", true, null);
            return;
        }
        while (true) {
            EclipseConnection connection;
            Socket clientSocket;
            if ((clientSocket = (connection = service.connectToEclipse(port)).getSocket()) == null) {
                this.handleUnableToConnect(connection);
                return;
            }
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                try {
                    PrintStream output = new PrintStream(clientSocket.getOutputStream());
                    try {
                        output.print(symbolText + "\n");
                        output.flush();
                        String reply = input.readLine();
                        Msg.debug((Object)((Object)this), (Object)reply);
                        this.tool.setStatusInfo(reply);
                        if (!symbolText.startsWith("_")) break;
                        symbolText = symbolText.substring(1);
                        continue;
                    }
                    finally {
                        output.close();
                        continue;
                    }
                }
                finally {
                    input.close();
                    continue;
                }
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Unexpected Exception", (Object)"Unexpected exception connecting to source lookup editor", (Throwable)e);
                return;
            }
            finally {
                try {
                    clientSocket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    private String getSymbolText() {
        String symbolText = null;
        if (this.currentLocation instanceof DecompilerLocation) {
            DecompilerLocation decompilerLocation = (DecompilerLocation)this.currentLocation;
            ClangToken token = decompilerLocation.getToken();
            if (token == null) {
                return null;
            }
            if (token instanceof ClangFieldToken || token instanceof ClangFuncNameToken || token instanceof ClangLabelToken || token instanceof ClangTypeToken) {
                symbolText = token.getText();
            }
        } else {
            LocationDescriptor locationDescriptor = ReferenceUtils.getLocationDescriptor((ProgramLocation)this.currentLocation);
            if (locationDescriptor == null) {
                return null;
            }
            symbolText = this.getSymbolTextFromLocation(locationDescriptor);
        }
        return symbolText;
    }

    private String getSymbolTextFromLocation(LocationDescriptor locationDescriptor) {
        if (locationDescriptor.getClass() == AddressLocationDescriptor.class) {
            return null;
        }
        return locationDescriptor.getLabel();
    }

    private String attemptToDemangle(String nameToDemangle) {
        if (nameToDemangle == null) {
            return null;
        }
        DemangledObject demangledObject = DemanglerUtil.demangle((String)nameToDemangle);
        if (demangledObject != null) {
            return demangledObject.getName();
        }
        return null;
    }

    private void handleUnableToConnect(EclipseConnection connection) {
        EclipseIntegrationService service = (EclipseIntegrationService)this.tool.getService(EclipseIntegrationService.class);
        try {
            if (!service.isEclipseFeatureInstalled((dir, filename) -> filename.startsWith(CDT_START))) {
                Msg.showWarn((Object)((Object)this), null, (String)"No CDT Installed", (Object)"No CDT installed in Eclipse. You must install the CDT before\nusing the source code lookup plugin.");
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (connection.getProcess() != null) {
            Msg.showWarn((Object)((Object)this), null, (String)"Ports May Not Match", (Object)"The port used by Ghidra may not match the port used by Eclipse.\nMake sure the port in the Ghidra options (Edit -> Tool Options... -> Source Code Lookup) \nmatches the port in the Eclipse preference page (Preferences -> Ghidra -> Ghidra Symbol Lookup).");
        }
    }
}

