/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceInterfaceImplementationPair;
import ghidra.framework.plugintool.mgr.ServiceManager;
import ghidra.framework.plugintool.util.PluginClassManager;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.framework.plugintool.util.TransientToolState;
import ghidra.framework.plugintool.util.UndoRedoToolState;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.MultipleCauses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

class PluginManager {
    static final Logger log = LogManager.getLogger(PluginManager.class);
    private List<Plugin> pluginList = new ArrayList<Plugin>();
    private PluginTool tool;
    private ServiceManager serviceMgr;

    PluginManager(PluginTool tool, ServiceManager serviceMgr) {
        this.tool = tool;
        this.serviceMgr = serviceMgr;
    }

    boolean acceptData(DomainFile[] data) {
        for (Plugin p : this.pluginList) {
            if (!p.acceptData(data)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        Iterator<Plugin> it = this.pluginList.iterator();
        while (it.hasNext()) {
            Plugin plugin = it.next();
            plugin.cleanup();
            it.remove();
        }
    }

    DomainFile[] getData() {
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (Plugin plugin : this.pluginList) {
            for (DomainFile file : plugin.getData()) {
                list.add(file);
            }
        }
        DomainFile[] data = new DomainFile[list.size()];
        return list.toArray(data);
    }

    Class<?>[] getSupportedDataTypes() {
        HashSet set = new HashSet();
        for (Plugin plugin : this.pluginList) {
            for (Class<?> element : plugin.getSupportedDataTypes()) {
                set.add(element);
            }
        }
        Class[] cl = new Class[set.size()];
        return set.toArray(cl);
    }

    void addPlugin(Plugin plugin) throws PluginException {
        this.addPlugins(new Plugin[]{plugin});
    }

    void addPlugins(String[] classNames) throws PluginException {
        PluginException pe = null;
        ArrayList<Plugin> list = new ArrayList<Plugin>(classNames.length);
        ArrayList<String> badList = new ArrayList<String>();
        for (String className : classNames) {
            try {
                Class<? extends Plugin> pluginClass = PluginUtils.forName(className);
                if (this.getLoadedPlugin(pluginClass) != null) continue;
                PluginUtils.assertUniquePluginName(pluginClass);
                Plugin p = PluginUtils.instantiatePlugin(pluginClass, this.tool);
                list.add(p);
            }
            catch (PluginException e) {
                pe = e.getPluginException(pe);
                badList.add(className);
            }
        }
        Plugin[] pluginArray = list.toArray(new Plugin[list.size()]);
        try {
            this.addPlugins(pluginArray);
        }
        catch (PluginException e) {
            pe = e.getPluginException(pe);
        }
        if (badList.size() > 0) {
            for (int i = 0; i < badList.size(); ++i) {
                String className = (String)badList.get(i);
                this.tool.removeEventListener(className);
            }
        }
        if (pe != null) {
            throw pe;
        }
    }

    private <T extends Plugin> T getLoadedPlugin(Class<T> pluginClass) {
        for (Plugin p : this.pluginList) {
            if (p.getClass() != pluginClass) continue;
            return (T)((Plugin)pluginClass.cast(p));
        }
        return null;
    }

    private void addPlugins(Plugin[] plugs) throws PluginException {
        this.serviceMgr.setServiceAddedNotificationsOn(false);
        List<ServiceInterfaceImplementationPair> previousServices = this.serviceMgr.getAllServices();
        StringBuilder errMsg = new StringBuilder();
        MultipleCauses report = new MultipleCauses();
        int numOldPlugins = this.pluginList.size();
        for (Plugin newPluginToAdd : plugs) {
            this.pluginList.add(newPluginToAdd);
            newPluginToAdd.initServices();
        }
        HashMap dependencyProblemResults = new HashMap();
        Set<Class<?>> unresolvedDependencySet = this.resolveDependencies(dependencyProblemResults);
        if (!unresolvedDependencySet.isEmpty()) {
            for (Class<?> dependency : unresolvedDependencySet) {
                PluginException cause = (PluginException)((Object)dependencyProblemResults.get(dependency));
                errMsg.append("Unresolved dependency: " + dependency.getName() + "\n");
                if (cause != null) {
                    errMsg.append("Reason: " + cause.getMessage() + "\n");
                }
                errMsg.append("\n");
                report.addCause((Throwable)((Object)new PluginException("Unresolved dependency: " + dependency, (Throwable)((Object)cause))));
            }
            this.cleanupPluginsWithUnresolvedDependencies();
        }
        PluginEvent[] lastEvents = this.tool.getLastEvents();
        List<Plugin> sortedPlugins = this.getPluginsByServiceOrder(numOldPlugins);
        ArrayList<Plugin> badList = new ArrayList<Plugin>();
        Iterator<Plugin> it = sortedPlugins.iterator();
        while (it.hasNext()) {
            Plugin p = it.next();
            try {
                p.init();
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
                errMsg.append("Initializing " + p.getName() + " failed: " + t + "\n");
                report.addCause(t);
                badList.add(p);
                it.remove();
            }
        }
        if (badList.size() > 0) {
            Plugin[] badPlugins = new Plugin[badList.size()];
            try {
                this.removePlugins(badList.toArray(badPlugins));
            }
            catch (Throwable t) {
                log.debug("Exception unloading plugin", t);
            }
        }
        this.serviceMgr.setServiceAddedNotificationsOn(true);
        for (Plugin p : sortedPlugins) {
            this.notifyServices(p, previousServices);
        }
        for (Plugin p : sortedPlugins) {
            p.processLastEvents(lastEvents);
        }
        if (errMsg.length() > 0) {
            throw new PluginException(errMsg.toString(), (Throwable)report);
        }
    }

    private void notifyServices(Plugin p, List<ServiceInterfaceImplementationPair> previousServices) {
        for (ServiceInterfaceImplementationPair service : previousServices) {
            p.serviceAdded(service.interfaceClass, service.provider);
        }
    }

    List<Plugin> getPlugins() {
        return new ArrayList<Plugin>(this.pluginList);
    }

    void removePlugins(Plugin[] plugins) {
        for (Plugin plugin : plugins) {
            this.unregisterPlugin(plugin);
        }
        this.cleanupPluginsWithUnresolvedDependencies();
    }

    void saveToXml(Element root, boolean includeConfigState) {
        PluginClassManager pluginClassManager = this.tool.getPluginClassManager();
        pluginClassManager.addXmlElementsForPlugins(root, this.pluginList);
        if (!includeConfigState) {
            return;
        }
        SaveState saveState = new SaveState("PLUGIN_STATE");
        for (Plugin p : this.pluginList) {
            p.writeConfigState(saveState);
            if (saveState.isEmpty()) continue;
            Element pluginElem = saveState.saveToXml();
            pluginElem.setAttribute("CLASS", p.getClass().getName());
            root.addContent((Content)pluginElem);
            saveState = new SaveState("PLUGIN_STATE");
        }
    }

    void restorePluginsFromXml(Element root) throws PluginException {
        boolean isOld = this.isOldToolConfig(root);
        List<String> classNames = isOld ? this.getPLuginClassNamesFromOldXml(root) : this.getPluginClassNamesToLoad(root);
        Map<String, SaveState> map = isOld ? this.getPluginSavedStates(root, "PLUGIN") : this.getPluginSavedStates(root, "PLUGIN_STATE");
        PluginException pe = null;
        try {
            this.addPlugins(classNames.toArray(new String[classNames.size()]));
        }
        catch (PluginException e) {
            pe = e;
        }
        try {
            this.initConfigStates(map);
        }
        catch (PluginException e) {
            pe = e.getPluginException(pe);
        }
        if (pe != null) {
            throw pe;
        }
    }

    private Map<String, SaveState> getPluginSavedStates(Element root, String elementName) {
        HashMap<String, SaveState> map = new HashMap<String, SaveState>();
        List children = root.getChildren(elementName);
        for (Object object : children) {
            Element child = (Element)object;
            String className = child.getAttributeValue("CLASS");
            map.put(className, new SaveState(child));
        }
        return map;
    }

    private List<String> getPLuginClassNamesFromOldXml(Element root) {
        ArrayList<String> classNames = new ArrayList<String>();
        List pluginElementList = root.getChildren("PLUGIN");
        for (Element elem : pluginElementList) {
            String className = elem.getAttributeValue("CLASS");
            classNames.add(className);
        }
        PluginClassManager pluginClassManager = this.tool.getPluginClassManager();
        return pluginClassManager.fillInPackageClasses(classNames);
    }

    private boolean isOldToolConfig(Element root) {
        return root.getChild("PLUGIN") != null;
    }

    private List<String> getPluginClassNamesToLoad(Element root) {
        PluginClassManager pluginClassManager = this.tool.getPluginClassManager();
        return pluginClassManager.getPluginClasses(root);
    }

    void restoreDataStateFromXml(Element root) {
        HashMap<String, SaveState> map = new HashMap<String, SaveState>();
        for (Element elem : root.getChildren("PLUGIN")) {
            String pluginName = elem.getAttributeValue("NAME");
            SaveState saveState = new SaveState(elem);
            map.put(pluginName, saveState);
        }
        LinkedHashMap<String, Exception> badMap = new LinkedHashMap<String, Exception>();
        List<Plugin> list = this.getPluginsByServiceOrder(0);
        for (Plugin plugin : list) {
            SaveState saveState = (SaveState)map.get(plugin.getName());
            if (saveState == null) continue;
            try {
                plugin.readDataState(saveState);
            }
            catch (Exception e) {
                badMap.put(plugin.getName(), e);
            }
        }
        if (badMap.size() > 0) {
            log.error("*** Errors in Plugin Data States  ***");
            log.error("The data states for following plugins could not be restored:");
            Set entrySet = badMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String pluginName = (String)entry.getKey();
                Exception exception = (Exception)entry.getValue();
                log.error("     " + pluginName, (Throwable)exception);
            }
            log.error("*** (finished) Errors in Plugin Data States  ***");
            Msg.showError((Object)this, null, (String)"Data State Error", (Object)"Errors in plugin data states - check console for details");
        }
        for (Plugin plugin : list) {
            plugin.dataStateRestoreCompleted();
        }
    }

    Element saveDataStateToXml(boolean savingProject) {
        Element root = new Element("DATA_STATE");
        for (int i = 0; i < this.pluginList.size(); ++i) {
            Plugin p = this.pluginList.get(i);
            SaveState ss = new SaveState("PLUGIN");
            p.writeDataState(ss);
            if (ss.isEmpty()) continue;
            Element e = ss.saveToXml();
            e.setAttribute("NAME", p.getName());
            root.addContent((Content)e);
        }
        return root;
    }

    private void unregisterPlugin(Plugin plugin) {
        if (this.pluginList.remove(plugin)) {
            plugin.cleanup();
            this.tool.getOptionsManager().deregisterOwner(plugin);
        }
    }

    private void cleanupPluginsWithUnresolvedDependencies() {
        Plugin p;
        while ((p = this.findPluginWithUnresolvedDependencies()) != null) {
            this.unregisterPlugin(p);
        }
    }

    private Plugin findPluginWithUnresolvedDependencies() {
        for (Plugin plugin : this.pluginList) {
            if (!plugin.hasMissingRequiredService()) continue;
            return plugin;
        }
        return null;
    }

    private Set<Class<?>> resolveDependencies(Map<Class<?>, PluginException> dependencyProblemResults) {
        HashSet dependencySet = new HashSet();
        do {
            this.getUnresolvedDependencies(dependencySet, dependencyProblemResults);
        } while (this.addDependencies(dependencySet, dependencyProblemResults));
        return dependencySet;
    }

    private void getUnresolvedDependencies(Set<Class<?>> dependencySet, Map<Class<?>, PluginException> dependencyProblemResults) {
        dependencySet.clear();
        for (Plugin p : this.pluginList) {
            dependencySet.addAll(p.getMissingRequiredServices());
        }
    }

    private boolean addDependencies(Set<Class<?>> dependencySet, Map<Class<?>, PluginException> dependencyProblemResults) {
        boolean fixedDependency = false;
        for (Class<?> depClass : dependencySet) {
            fixedDependency |= this.fixDependency(depClass, dependencyProblemResults);
        }
        return fixedDependency;
    }

    private boolean fixDependency(Class<?> dependency, Map<Class<?>, PluginException> dependencyProblemResults) {
        Class pluginClass = PluginUtils.getDefaultProviderForServiceClass(dependency);
        if (pluginClass == null) {
            for (Class pc : ClassSearcher.getClasses(Plugin.class)) {
                if (!dependency.isAssignableFrom(pc)) continue;
                pluginClass = pc;
                break;
            }
        }
        if (pluginClass == null) {
            return false;
        }
        if (this.getLoadedPlugin(pluginClass) != null) {
            Msg.warn((Object)this, (Object)("Plugin " + pluginClass.getSimpleName() + " provides service " + dependency.getSimpleName() + " but that dependency failed to be resolved correctly in a previous step."));
            return true;
        }
        try {
            PluginUtils.assertUniquePluginName(pluginClass);
            Plugin p = PluginUtils.instantiatePlugin(pluginClass, this.tool);
            p.initServices();
            this.pluginList.add(p);
            return true;
        }
        catch (PluginException e) {
            dependencyProblemResults.put(dependency, e);
            return false;
        }
    }

    private void initConfigStates(Map<String, SaveState> map) throws PluginException {
        StringBuffer errMsg = new StringBuffer();
        for (Plugin p : this.pluginList) {
            this.configure(p, map, errMsg);
        }
        if (errMsg.length() > 0) {
            throw new PluginException(errMsg.toString());
        }
    }

    private void configure(Plugin p, Map<String, SaveState> map, StringBuffer errMsg) {
        SaveState ss = map.get(p.getClass().getName());
        if (ss != null) {
            try {
                p.readConfigState(ss);
            }
            catch (Exception e) {
                errMsg.append("Problem restoring plugin state for: " + p.getName()).append("\n\n");
                errMsg.append(e.getClass().getName()).append(": ").append(e.getMessage()).append('\n');
                StackTraceElement[] st = e.getStackTrace();
                int depth = Math.min(5, st.length);
                for (int j = 0; j < depth; ++j) {
                    errMsg.append("    ").append(st[j].toString()).append('\n');
                }
                errMsg.append('\n');
            }
        }
    }

    private List<Plugin> getPluginsByServiceOrder(int startIndex) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(this.pluginList.subList(startIndex, this.pluginList.size()));
        ArrayList<Plugin> orderedList = new ArrayList<Plugin>(plugins.size());
        while (plugins.size() > 0) {
            int n = plugins.size();
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                Plugin p = (Plugin)it.next();
                if (!this.checkServices(p, plugins)) continue;
                orderedList.add(p);
                it.remove();
            }
            if (n != plugins.size()) continue;
            this.showWarning(plugins);
            orderedList.addAll(plugins);
            plugins.clear();
        }
        return orderedList;
    }

    private boolean checkServices(Plugin usingPlugin, List<Plugin> serviceProvidingPlugins) {
        for (Class<?> usedService : usingPlugin.getServicesRequired()) {
            for (Plugin providingPlugin : serviceProvidingPlugins) {
                if (!providingPlugin.providesService(usedService)) continue;
                return false;
            }
        }
        return true;
    }

    private void showWarning(List<Plugin> plugins) {
        Msg.warn((Object)this, (Object)"The correct order for initializing the following plugins can't be\ndetermined because of circular use of services (check log)");
        for (Plugin plugin : plugins) {
            Msg.info((Object)this, (Object)("Plugin: " + plugin.getClass().getName()));
            for (Class<?> service : plugin.getServiceClasses()) {
                Msg.info((Object)this, (Object)("    provides: " + service));
            }
            for (Class clazz : plugin.getServicesRequired()) {
                Msg.info((Object)this, (Object)("    uses: " + clazz));
            }
        }
    }

    boolean canClose() {
        for (Plugin p : this.pluginList) {
            if (p.canClose()) continue;
            return false;
        }
        return true;
    }

    boolean canCloseDomainObject(DomainObject dObj) {
        for (Plugin p : this.pluginList) {
            if (p.canCloseDomainObject(dObj)) continue;
            return false;
        }
        return true;
    }

    boolean saveData() {
        for (Plugin p : this.pluginList) {
            if (p.saveData()) continue;
            return false;
        }
        return true;
    }

    boolean hasUnsavedData() {
        for (Plugin p : this.pluginList) {
            if (!p.hasUnsaveData()) continue;
            return true;
        }
        return false;
    }

    void close() {
        for (Plugin p : this.pluginList) {
            p.close();
        }
    }

    public TransientToolState getTransientState() {
        return new TransientToolState(new ArrayList<Plugin>(this.pluginList));
    }

    public UndoRedoToolState getUndoRedoToolState(DomainObject domainObject) {
        return new UndoRedoToolState(new ArrayList<Plugin>(this.pluginList), domainObject);
    }

    void prepareToSave(DomainObject dObj) {
        for (Plugin p : this.pluginList) {
            p.prepareToSave(dObj);
        }
    }
}

