/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.csjc;

import java.lang.reflect.Field;
import org.catacombae.hfsexplorer.Util;

public abstract class MutableStruct {
    private final boolean mutable;

    public MutableStruct() {
        this.mutable = false;
    }

    public MutableStruct(boolean mutable) {
        this.mutable = true;
    }

    public void setByteField(String fieldName, byte value) {
        if (this.mutable) {
            byte[] fieldData = this.getFieldData(fieldName);
            if (fieldData.length != 1) {
                throw new IllegalArgumentException("Invalid input! length is not equal to the length of the field data");
            }
            System.arraycopy(Util.toByteArrayBE((byte)value), 0, fieldData, 0, 1);
        } else {
            this.accessViolation();
        }
    }

    public void setShortField(String fieldName, short value) {
        if (this.mutable) {
            byte[] fieldData = this.getFieldData(fieldName);
            if (fieldData.length != 2) {
                throw new IllegalArgumentException("Invalid input! length is not equal to the length of the field data");
            }
            System.arraycopy(Util.toByteArrayBE((short)value), 0, fieldData, 0, fieldData.length);
        } else {
            this.accessViolation();
        }
    }

    public void setCharField(String fieldName, char value) {
        if (this.mutable) {
            byte[] fieldData = this.getFieldData(fieldName);
            if (fieldData.length != 2) {
                throw new IllegalArgumentException("Invalid input! length is not equal to the length of the field data");
            }
            System.arraycopy(Util.toByteArrayBE((char)value), 0, fieldData, 0, fieldData.length);
        } else {
            this.accessViolation();
        }
    }

    public void setIntField(String fieldName, int value) {
        if (this.mutable) {
            byte[] fieldData = this.getFieldData(fieldName);
            if (fieldData.length != 4) {
                throw new IllegalArgumentException("Invalid input! length is not equal to the length of the field data");
            }
            System.arraycopy(Util.toByteArrayBE((int)value), 0, fieldData, 0, fieldData.length);
        } else {
            this.accessViolation();
        }
    }

    public void setLongField(String fieldName, long value) {
        if (this.mutable) {
            byte[] fieldData = this.getFieldData(fieldName);
            if (fieldData.length != 8) {
                throw new IllegalArgumentException("Invalid input! length is not equal to the length of the field data");
            }
            System.arraycopy(Util.toByteArrayBE((long)value), 0, fieldData, 0, fieldData.length);
        } else {
            this.accessViolation();
        }
    }

    public void setByteArrayField(String fieldName, byte[] value) {
        this.setByteArrayField(fieldName, value, 0, value.length);
    }

    public void setByteArrayField(String fieldName, byte[] value, int offset, int length) {
        if (this.mutable) {
            byte[] fieldData = this.getFieldData(fieldName);
            if (length != fieldData.length) {
                throw new IllegalArgumentException("Invalid input! length is not equal to the length of the field data");
            }
            System.arraycopy(value, offset, fieldData, 0, length);
        } else {
            this.accessViolation();
        }
    }

    public void setStructField(String fieldName, MutableStruct yada) {
        if (this.mutable) {
            Object fieldObject = this.getFieldObject(fieldName);
            if (!(fieldObject instanceof MutableStruct)) {
                throw new IllegalArgumentException("No such Struct field.");
            }
        } else {
            this.accessViolation();
        }
    }

    protected void accessViolation() {
        throw new RuntimeException("Access violation: Tried to set fields in an immutable object.");
    }

    private byte[] getFieldData(String fieldName) {
        Object o = this.getFieldObject(fieldName);
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        throw new IllegalArgumentException("No such byte array field.");
    }

    private Object getFieldObject(String fieldName) {
        try {
            Class<?> thisClass = this.getClass();
            Field f = thisClass.getField(fieldName);
            return f.get(this);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException(nsfe);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae);
        }
    }
}

