/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.DebugInfoStateMachineReader;
import ghidra.file.formats.android.dex.util.Leb128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DebugInfoItem
implements StructConverter {
    private int lineStart;
    private int lineStartLength;
    private int parametersSize;
    private int parametersSizeLength;
    private int[] parameterNames;
    private int[] parameterNamesLengths;
    private byte[] stateMachineOpcodes;

    public DebugInfoItem(BinaryReader reader) throws IOException {
        this.lineStart = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.lineStartLength = Leb128.unsignedLeb128Size(this.lineStart);
        reader.readNextByteArray(this.lineStartLength);
        this.parametersSize = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.parametersSizeLength = Leb128.unsignedLeb128Size(this.parametersSize);
        reader.readNextByteArray(this.parametersSizeLength);
        this.parameterNames = new int[this.parametersSize];
        this.parameterNamesLengths = new int[this.parametersSize];
        for (int i = 0; i < this.parametersSize; ++i) {
            int value = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
            int valueLength = Leb128.unsignedLeb128Size(value);
            reader.readNextByteArray(valueLength);
            this.parameterNames[i] = value - 1;
            this.parameterNamesLengths[i] = valueLength;
        }
        long startIndex = reader.getPointerIndex();
        int count = DebugInfoStateMachineReader.computeLength(reader);
        reader.setPointerIndex(startIndex);
        this.stateMachineOpcodes = reader.readNextByteArray(count);
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getParametersSize() {
        return this.parametersSize;
    }

    public int[] getParameterNames() {
        return this.parameterNames;
    }

    public byte[] getStateMachineOpcodes() {
        return this.stateMachineOpcodes;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("debug_info_item_");
        builder.append("" + this.lineStartLength);
        builder.append("" + this.parametersSizeLength);
        builder.append("" + this.parametersSize);
        builder.append("" + this.stateMachineOpcodes.length);
        StructureDataType structure = new StructureDataType(builder.toString(), 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.lineStartLength, BYTE.getLength()), "line_start", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.parametersSizeLength, BYTE.getLength()), "parameters_size", null);
        for (int i = 0; i < this.parametersSize; ++i) {
            ArrayDataType dataType = new ArrayDataType(BYTE, this.parameterNamesLengths[i], BYTE.getLength());
            structure.add((DataType)dataType, "parameter_" + i, null);
            builder.append("" + dataType.getLength());
        }
        ArrayDataType stateMachineArray = new ArrayDataType(BYTE, this.stateMachineOpcodes.length, BYTE.getLength());
        structure.add((DataType)stateMachineArray, "state_machine", null);
        structure.setCategoryPath(new CategoryPath("/dex/debug_info_item"));
        try {
            structure.setName(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return structure;
    }
}

