/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store;

import ghidra.framework.store.CheckoutType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

public class ItemCheckoutStatus
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final int VERSION = 3;
    private long checkoutId;
    private String user;
    private int version;
    private long time;
    private String projectPath;
    private CheckoutType checkoutType;

    public ItemCheckoutStatus(long checkoutId, CheckoutType checkoutType, String user, int version, long time, String projectPath) {
        this.checkoutId = checkoutId;
        this.checkoutType = checkoutType;
        this.user = user;
        this.version = version;
        this.time = time;
        if (projectPath != null) {
            projectPath = projectPath.replace('\\', '/');
        }
        this.projectPath = projectPath;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeLong(this.checkoutId);
        out.writeUTF(this.user);
        out.writeInt(this.version);
        out.writeLong(this.time);
        out.writeInt(this.checkoutType.getID());
        out.writeUTF(this.projectPath != null ? this.projectPath : "");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long ver = in.readInt();
        if (ver > 3L) {
            throw new ClassNotFoundException("Unsupported version of ItemCheckoutStatus");
        }
        this.checkoutId = in.readLong();
        this.user = in.readUTF();
        this.version = in.readInt();
        this.time = in.readLong();
        if (ver < 3L) {
            this.checkoutType = in.readBoolean() ? CheckoutType.EXCLUSIVE : CheckoutType.NORMAL;
        } else {
            int checkoutTypeId = in.readInt();
            this.checkoutType = CheckoutType.getCheckoutType(checkoutTypeId);
            if (this.checkoutType == null) {
                throw new IOException("Invalid ItemCheckoutStatus Type: " + checkoutTypeId);
            }
        }
        if (ver > 1L) {
            this.projectPath = in.readUTF();
            if (this.projectPath.length() == 0) {
                this.projectPath = null;
            }
        }
    }

    public long getCheckoutId() {
        return this.checkoutId;
    }

    public CheckoutType getCheckoutType() {
        return this.checkoutType;
    }

    public String getUser() {
        return this.user;
    }

    public int getCheckoutVersion() {
        return this.version;
    }

    public long getCheckoutTime() {
        return this.time;
    }

    public Date getCheckoutDate() {
        return new Date(this.time);
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getProjectName() {
        if (this.projectPath == null) {
            return null;
        }
        String path = this.projectPath;
        int ix = path.indexOf("::");
        if (ix > 0) {
            path = path.substring(ix + 2);
        }
        if ((ix = path.lastIndexOf(47)) < 0) {
            return null;
        }
        return path.substring(ix + 1);
    }

    public String getProjectLocation() {
        if (this.projectPath == null) {
            return null;
        }
        String path = this.projectPath;
        int ix = path.indexOf("::");
        if (ix > 0) {
            path = path.substring(ix + 2);
        }
        if ((ix = path.lastIndexOf(47)) < 0) {
            return null;
        }
        return path.substring(0, ix);
    }

    public String getUserHostName() {
        if (this.projectPath == null) {
            return null;
        }
        int ix = this.projectPath.indexOf("::");
        if (ix > 0) {
            return this.projectPath.substring(0, ix);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.checkoutId ^ this.checkoutId >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemCheckoutStatus)) {
            return false;
        }
        ItemCheckoutStatus other = (ItemCheckoutStatus)obj;
        return this.checkoutId == other.checkoutId && this.user.equals(other.user) && this.version == other.version && this.time != other.time;
    }

    public static String getProjectPath(String projectPath, boolean isTransient) {
        Object hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName() + "::";
        }
        catch (UnknownHostException e1) {
            hostname = "<standalone>::";
        }
        if (isTransient) {
            return (String)hostname + "<Transient>";
        }
        return (String)hostname + projectPath;
    }
}

