/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.NamespaceUtils;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.function.Consumer;

public class NamespacePath
implements Comparable<NamespacePath> {
    public static final NamespacePath ROOT = new NamespacePath(null, null, SymbolType.NAMESPACE);
    private static final String FWDSLASH_MANGLE = "-fwdslash-";
    private static final String COLON_MANGLE = "-";
    private final NamespacePath parent;
    private final String name;
    private final SymbolType type;

    public static NamespacePath create(NamespacePath parent, String name, SymbolType type) {
        return new NamespacePath(parent == null ? ROOT : parent, NamespacePath.preMangleName(name), type);
    }

    private static String preMangleName(String name) {
        return name == null ? null : name.replaceAll(":", COLON_MANGLE).replaceAll(" ", "").replaceAll("/", FWDSLASH_MANGLE);
    }

    private NamespacePath(NamespacePath parent, String name, SymbolType type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getName() {
        return this.name;
    }

    public NamespacePath getParent() {
        return this.parent;
    }

    public SymbolType getType() {
        return this.type;
    }

    private static SymbolType flattenSymbolTypeForDNI(SymbolType type) {
        if (type == SymbolType.CLASS) {
            return SymbolType.CLASS;
        }
        return SymbolType.NAMESPACE;
    }

    public Namespace getNamespace(Program program) {
        if (this.isRoot()) {
            return program.getGlobalNamespace();
        }
        try {
            SymbolType existingSymbolType;
            Namespace result = this.parent.getNamespace(program);
            Namespace existingNamespace = NamespaceUtils.getFirstNonFunctionNamespace((Namespace)result, (String)this.name, (Program)program);
            SymbolType targetSymbolType = NamespacePath.flattenSymbolTypeForDNI(this.type);
            SymbolType symbolType = existingSymbolType = existingNamespace != null ? existingNamespace.getSymbol().getSymbolType() : null;
            if (existingNamespace == null) {
                result = targetSymbolType == SymbolType.NAMESPACE ? program.getSymbolTable().createNameSpace(result, this.name, SourceType.IMPORTED) : program.getSymbolTable().createClass(result, this.name, SourceType.IMPORTED);
            } else if (existingSymbolType == targetSymbolType) {
                result = existingNamespace;
            } else if (existingSymbolType == SymbolType.NAMESPACE && targetSymbolType == SymbolType.CLASS) {
                result = NamespaceUtils.convertNamespaceToClass((Namespace)existingNamespace);
            } else if (existingSymbolType == SymbolType.CLASS && targetSymbolType == SymbolType.NAMESPACE) {
                result = existingNamespace;
            } else {
                Msg.error((Object)this, (Object)("Error getting Ghidra namespace for " + this.asNamespaceString()));
                result = program.getGlobalNamespace();
            }
            return result;
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Msg.error((Object)this, (Object)("Failed to create Ghidra namespace for " + this.asNamespaceString()));
            return program.getGlobalNamespace();
        }
    }

    public String asCategoryPathString() {
        StringBuilder sb = new StringBuilder();
        this.doInOrderTraversal(nsp -> sb.append(sb.length() != 1 ? "/" : "").append(nsp.isRoot() ? "" : nsp.name));
        return sb.toString();
    }

    public String asNamespaceString() {
        StringBuilder sb = new StringBuilder();
        this.doInOrderTraversal(nsp -> sb.append(sb.length() != 0 ? "::" : "").append(nsp.isRoot() ? "ROOT" : nsp.name));
        return sb.toString();
    }

    public String asFormattedString() {
        StringBuilder sb = new StringBuilder();
        this.doInOrderTraversal(nsp -> {
            if (!nsp.isRoot()) {
                sb.append(sb.length() != 0 ? "::" : "").append(nsp.name);
            }
        });
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.doInOrderTraversal(nsp -> sb.append(sb.length() != 0 ? "::" : "").append(nsp.isRoot() ? "ROOT" : nsp.name).append("(" + (nsp.getType() != null ? nsp.getType() : "unknown type") + ")"));
        return sb.toString();
    }

    private void doInOrderTraversal(Consumer<NamespacePath> consumer) {
        if (this.parent != null) {
            this.parent.doInOrderTraversal(consumer);
        }
        consumer.accept(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespacePath)) {
            return false;
        }
        NamespacePath other = (NamespacePath)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    @Override
    public int compareTo(NamespacePath otherPath) {
        if (this.parent == null) {
            return otherPath.parent == null ? 0 : 1;
        }
        return this.parent == otherPath.parent ? this.name.compareTo(otherPath.name) : this.parent.compareTo(otherPath.parent);
    }
}

