/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexHasDeclSecurity;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableDeclSecurity
extends CliAbstractTable {
    public CliTableDeclSecurity(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliDeclSecurityRow row = new CliDeclSecurityRow(reader.readNextShort(), CliIndexHasDeclSecurity.readCodedIndex(reader, stream), this.readBlobIndex(reader));
            this.blobs.add(row.permissionSetIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "DeclSecurity Row", 0);
        rowDt.add(WORD, "Action", "Points to a System.Security.SecurityAction as described in ISO23271 IV");
        rowDt.add(CliIndexHasDeclSecurity.toDataType(this.metadataStream), "Parent", null);
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "PermissionSet", null);
        return rowDt;
    }

    public class CliDeclSecurityRow
    extends CliAbstractTableRow {
        public short action;
        public int parentIndex;
        public int permissionSetIndex;

        public CliDeclSecurityRow(short action, int parentIndex, int permissionSetIndex) {
            this.action = action;
            this.parentIndex = parentIndex;
            this.permissionSetIndex = permissionSetIndex;
        }

        @Override
        public String getRepresentation() {
            String parentRep;
            try {
                parentRep = CliTableDeclSecurity.this.getRowRepresentationSafe(CliIndexHasDeclSecurity.getTableName(this.parentIndex), CliIndexHasDeclSecurity.getRowIndex(this.parentIndex));
            }
            catch (InvalidInputException e) {
                parentRep = Integer.toHexString(this.parentIndex);
            }
            return String.format("Action %d Parent %s PermissionSet %x", this.action, parentRep, this.permissionSetIndex);
        }
    }
}

