/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class ConstantValue
extends PatternValue {
    long val;

    public ConstantValue(Location location) {
        super(location);
    }

    public ConstantValue(Location location, long v) {
        super(location);
        this.val = v;
    }

    @Override
    public long getValue(ParserWalker pos) {
        return this.val;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location);
    }

    @Override
    public TokenPattern genPattern(long v) {
        return new TokenPattern(this.location, this.val == v);
    }

    @Override
    public long minValue() {
        return this.val;
    }

    @Override
    public long maxValue() {
        return this.val;
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<intb val=\"");
        s.print(this.val);
        s.append("\"/>\n");
    }

    @Override
    public void restoreXml(Element el, Translate trans) {
        this.val = XmlUtils.decodeUnknownLong(el.getAttributeValue("val"));
    }
}

