/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.translate.BadDataError;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class VarnodeListSymbol
extends ValueSymbol {
    private VectorSTL<VarnodeSymbol> varnode_table = new VectorSTL();
    private boolean tableisfilled;

    public VarnodeListSymbol(Location location) {
        super(location);
    }

    @Override
    public symbol_type getType() {
        return symbol_type.varnodelist_symbol;
    }

    public VarnodeListSymbol(Location location, String nm, PatternValue pv, VectorSTL<SleighSymbol> vt) {
        super(location, nm, pv);
        for (int i = 0; i < vt.size(); ++i) {
            this.varnode_table.push_back((Object)((VarnodeSymbol)vt.get(i)));
        }
        this.checkTableFill();
    }

    private void checkTableFill() {
        long min = this.patval.minValue();
        long max = this.patval.maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.varnode_table.size();
        for (int i = 0; i < this.varnode_table.size(); ++i) {
            if (this.varnode_table.get(i) != null) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker walker) {
        int ind;
        if (!(this.tableisfilled || (ind = (int)this.patval.getValue(walker)) >= 0 && ind < this.varnode_table.size() && this.varnode_table.get(ind) != null)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream s = new PrintStream(baos);
            walker.getAddr().printRaw(s);
            throw new BadDataError(walker.getAddr().getShortcut() + baos.toString() + ": No corresponding entry in varnode list");
        }
        return null;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker pos) {
        int ind = (int)this.patval.getValue(pos);
        VarnodeData fix = ((VarnodeSymbol)this.varnode_table.get(ind)).getFixedVarnode();
        hand.space = fix.space;
        hand.offset_space = null;
        hand.offset_offset = fix.offset;
        hand.size = fix.size;
    }

    @Override
    public int getSize() {
        for (int i = 0; i < this.varnode_table.size(); ++i) {
            VarnodeSymbol vnsym = (VarnodeSymbol)this.varnode_table.get(i);
            if (vnsym == null) continue;
            return vnsym.getSize();
        }
        throw new SleighError("No register attached to: " + this.getName(), this.getLocation());
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        int ind = (int)this.patval.getValue(pos);
        if (ind >= this.varnode_table.size()) {
            throw new SleighError("Value out of range for varnode table", this.getLocation());
        }
        s.append(((VarnodeSymbol)this.varnode_table.get(ind)).getName());
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<varlist_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.append(">\n");
        this.patval.saveXml(s);
        for (int i = 0; i < this.varnode_table.size(); ++i) {
            if (this.varnode_table.get(i) == null) {
                s.append("<null/>\n");
                continue;
            }
            s.append("<var id=\"0x");
            s.append(Long.toHexString(((VarnodeSymbol)this.varnode_table.get(i)).getId()));
            s.append("\"/>\n");
        }
        s.append("</varlist_sym>\n");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<varlist_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.append("/>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        List children = el.getChildren();
        Iterator iter = children.iterator();
        Element child = (Element)iter.next();
        this.patval = (PatternValue)PatternExpression.restoreExpression(child, trans);
        this.patval.layClaim();
        while (iter.hasNext()) {
            Element subel = (Element)iter.next();
            if (subel.getName().equals("var")) {
                int id1 = XmlUtils.decodeUnknownInt(subel.getAttributeValue("id"));
                this.varnode_table.push_back((Object)((VarnodeSymbol)trans.findSymbol(id1)));
                continue;
            }
            this.varnode_table.push_back(null);
        }
        this.checkTableFill();
    }
}

