/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.symbol.OldVariableStorageDBAdapterV0;
import ghidra.program.database.symbol.OldVariableStorageDBAdapterV1;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class OldVariableStorageDBAdapter {
    static final String VARIABLE_STORAGE_TABLE_NAME = "VariableStorage";
    static final Schema VARIABLE_STORAGE_SCHEMA = new Schema(1, "Key", new Class[]{LongField.class, LongField.class, IntField.class}, new String[]{"Address", "NamespaceID", "SymCount"});
    static final int STORAGE_ADDR_COL = 0;
    static final int NAMESPACE_ID_COL = 1;
    static final int SYMBOL_COUNT_COL = 2;
    boolean upgradeOldVariableAddressesRequired = false;

    OldVariableStorageDBAdapter() {
    }

    static OldVariableStorageDBAdapter getAdapter(DBHandle dbHandle, int openMode, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == 0) {
            return new OldVariableStorageDBAdapterV1(dbHandle, true);
        }
        try {
            OldVariableStorageDBAdapterV1 adapter = new OldVariableStorageDBAdapterV1(dbHandle, false);
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            OldVariableStorageDBAdapter adapter = OldVariableStorageDBAdapter.findReadOnlyAdapter(dbHandle);
            if (openMode == 3) {
                if (adapter == null) {
                    adapter = new OldVariableStorageDBAdapterV1(dbHandle, true);
                    adapter.upgradeOldVariableAddressesRequired = true;
                } else {
                    adapter = OldVariableStorageDBAdapterV1.upgrade(dbHandle, adapter, monitor);
                }
            } else if (adapter == null) {
                throw e;
            }
            return adapter;
        }
    }

    static void deleteTable(DBHandle dbHandle) throws IOException {
        dbHandle.deleteTable(VARIABLE_STORAGE_TABLE_NAME);
    }

    private static OldVariableStorageDBAdapter findReadOnlyAdapter(DBHandle dbHandle) throws VersionException {
        if (dbHandle.getTable(VARIABLE_STORAGE_TABLE_NAME) == null) {
            return null;
        }
        return new OldVariableStorageDBAdapterV0(dbHandle);
    }

    abstract void updateRecord(Record var1) throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract Record[] getRecordsForNamespace(long var1) throws IOException;

    abstract long getNextStorageID();

    abstract void deleteRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract int getRecordCount();
}

