/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RegisterBuilder {
    ArrayList<Register> registerList = new ArrayList();
    HashMap<String, Register> registerMap = new HashMap();
    Address contextAddress;

    public void addRegister(String name, String description, Address address, int numBytes, boolean bigEndian, int typeFlags) {
        this.addRegister(name, description, address, numBytes, 0, numBytes * 8, bigEndian, typeFlags);
    }

    public void addRegister(String name, String description, Address address, int numBytes, int leastSignificantBit, int bitLength, boolean bigEndian, int typeFlags) {
        Register register = new Register(name, description, address, numBytes, leastSignificantBit, bitLength, bigEndian, typeFlags);
        this.addRegister(register);
    }

    public void addRegister(Register register) {
        Object aliasedReg = null;
        for (Register reg : this.registerList) {
            if (!reg.getAddress().equals(register.getAddress()) || reg.getLeastSignificantBit() != register.getLeastSignificantBit() || reg.getBitLength() != register.getBitLength()) continue;
            reg.addAlias(register.getName());
            this.registerMap.put(register.getName(), reg);
            return;
        }
        if (this.contextAddress == null && register.isProcessorContext()) {
            this.contextAddress = register.getAddress();
        }
        this.registerList.add(register);
        this.registerMap.put(register.getName(), register);
    }

    public Address getProcessContextAddress() {
        return this.contextAddress;
    }

    public void removeRegister(String name) {
        Register register = this.registerMap.remove(name);
        if (register != null) {
            if (name.equals(register.getName())) {
                Iterator<String> iter = register.getAliases().iterator();
                if (!iter.hasNext()) {
                    this.registerList.remove(register);
                } else {
                    register.rename(iter.next());
                }
            } else {
                register.removeAlias(name);
            }
        }
    }

    public RegisterManager getRegisterManager() {
        return new RegisterManager(this.computeRegisters());
    }

    private Register[] computeRegisters() {
        LinkedList<Register> regList = new LinkedList<Register>();
        LinkedList<Register> unprocessed = new LinkedList<Register>(this.registerList);
        int bitSize = 1;
        while (unprocessed.size() > 0) {
            int nextLargerSize = Integer.MAX_VALUE;
            Iterator it = unprocessed.iterator();
            while (it.hasNext()) {
                Register register = (Register)it.next();
                if (register.getBitLength() == bitSize) {
                    Register[] children = this.getChildren(register, regList);
                    register.setChildRegisters(children);
                    regList.add(register);
                    it.remove();
                    continue;
                }
                nextLargerSize = Math.min(nextLargerSize, register.getBitLength());
            }
            bitSize = nextLargerSize;
        }
        return this.registerList.toArray(new Register[this.registerList.size()]);
    }

    private Register[] getChildren(Register parent, List<Register> regList) {
        ArrayList<Register> children = new ArrayList<Register>();
        Iterator<Register> it = regList.iterator();
        while (it.hasNext()) {
            Register register = it.next();
            if (!this.contains(parent, register)) continue;
            children.add(register);
            it.remove();
        }
        return children.toArray(new Register[children.size()]);
    }

    private boolean contains(Register parent, Register child) {
        if (!parent.getAddressSpace().equals(child.getAddressSpace())) {
            return false;
        }
        long parentOffset = parent.getOffset();
        long childOffset = child.getOffset();
        if (childOffset < parentOffset || childOffset + (long)child.getMinimumByteSize() > parentOffset + (long)parent.getMinimumByteSize()) {
            return false;
        }
        if (parent.getLeastSignificantBit() != 0) {
            return false;
        }
        return parent.getBitLength() == parent.getMinimumByteSize() * 8;
    }

    public Register getRegister(String name) {
        return this.registerMap.get(name);
    }

    public boolean renameRegister(String oldName, String newName) {
        if (this.registerMap.containsKey(newName)) {
            return false;
        }
        Register register = this.registerMap.get(oldName);
        if (register == null) {
            return false;
        }
        register.rename(newName);
        this.registerMap.remove(oldName);
        this.registerMap.put(newName, register);
        return true;
    }

    public boolean setGroup(String registerName, String groupName) {
        Register register = this.registerMap.get(registerName);
        if (register == null) {
            return false;
        }
        register.setGroup(groupName);
        return true;
    }

    public boolean setFlag(String registerName, int registerFlag) {
        Register register = this.registerMap.get(registerName);
        if (register == null) {
            return false;
        }
        register.setFlag(registerFlag);
        return true;
    }

    public boolean addLaneSize(String registerName, int laneSizeInBytes) {
        Register register = this.registerMap.get(registerName);
        if (register == null) {
            return false;
        }
        register.addLaneSize(laneSizeInBytes);
        return true;
    }
}

