/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.Closure;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class SystemOutputInterceptor
extends FilterOutputStream {
    private Closure callback;

    public SystemOutputInterceptor(Closure callback) {
        super(System.out);
        this.callback = callback;
    }

    public void start() {
        System.setOut(new PrintStream(this));
    }

    public void stop() {
        System.setOut((PrintStream)this.out);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        Boolean result = (Boolean)this.callback.call(new String(b, off, len));
        if (result.booleanValue()) {
            this.out.write(b, off, len);
        }
    }

    public void write(int b) throws IOException {
        Boolean result = (Boolean)this.callback.call(String.valueOf((char)b));
        if (result.booleanValue()) {
            this.out.write(b);
        }
    }
}

