/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.config.BaseDrownCommandConfig;
import de.rub.nds.tlsattacker.attacks.constants.DrownVulnerabilityType;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class BaseDrownAttacker
extends Attacker<BaseDrownCommandConfig> {
    protected List<byte[]> premasterSecrets;

    public BaseDrownAttacker(BaseDrownCommandConfig config, Config baseConfig) {
        super(config, baseConfig);
        if (config.isExecuteAttack()) {
            FileReader secretsReaderUnbuffered;
            String secretsPath = config.getPremasterSecretsFilePath();
            if (secretsPath == null) {
                throw new ConfigurationException("Premaster secrets file is required for the attack");
            }
            try {
                secretsReaderUnbuffered = new FileReader(secretsPath);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Premaster secrets file not found");
            }
            BufferedReader secretsReaderBuffered = new BufferedReader(secretsReaderUnbuffered);
            this.premasterSecrets = new ArrayList<byte[]>();
            try {
                String line;
                while ((line = secretsReaderBuffered.readLine()) != null) {
                    byte[] secret = ArrayConverter.hexStringToByteArray((String)line);
                    this.premasterSecrets.add(secret);
                }
                secretsReaderBuffered.close();
                secretsReaderUnbuffered.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Boolean isVulnerable() {
        DrownVulnerabilityType type = this.getDrownVulnerabilityType();
        switch (type) {
            case GENERAL: {
                ConsoleLogger.CONSOLE.error("Server is vulnerable to the full General DROWN attack");
                return true;
            }
            case SPECIAL: {
                ConsoleLogger.CONSOLE.error("Server is vulnerable to the full Special DROWN attack");
                return true;
            }
            case SSL2: {
                ConsoleLogger.CONSOLE.warn("Server supports SSL2, but not any weak ciphersuites, so is not vulnerable to DROWN");
                return false;
            }
            case NONE: {
                return false;
            }
            case UNKNOWN: {
                ConsoleLogger.CONSOLE.info("Could not execute Workflow, check previous messages or increase log level");
                return null;
            }
        }
        return null;
    }

    public abstract DrownVulnerabilityType getDrownVulnerabilityType();
}

