/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.PainlessScript;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.antlr.Walker;
import org.elasticsearch.painless.ir.ClassNode;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.node.SClass;
import org.elasticsearch.painless.phase.DefaultConstantFoldingOptimizationPhase;
import org.elasticsearch.painless.phase.DefaultStringConcatenationOptimizationPhase;
import org.elasticsearch.painless.phase.DocFieldsPhase;
import org.elasticsearch.painless.phase.PainlessSemanticAnalysisPhase;
import org.elasticsearch.painless.phase.PainlessSemanticHeaderPhase;
import org.elasticsearch.painless.phase.PainlessUserTreeToIRTreePhase;
import org.elasticsearch.painless.symbol.Decorations;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.objectweb.asm.util.Printer;

final class Compiler {
    private static final CodeSource CODESOURCE;
    private final Class<?> scriptClass;
    private final PainlessLookup painlessLookup;
    private final Map<String, Class<?>> additionalClasses;

    public Loader createLoader(ClassLoader parent) {
        return new Loader(parent);
    }

    Compiler(Class<?> scriptClass, Class<?> factoryClass, Class<?> statefulFactoryClass, PainlessLookup painlessLookup) {
        this.scriptClass = scriptClass;
        this.painlessLookup = painlessLookup;
        HashMap additionalClasses = new HashMap();
        additionalClasses.put(scriptClass.getName(), scriptClass);
        Compiler.addFactoryMethod(additionalClasses, factoryClass, "newInstance");
        Compiler.addFactoryMethod(additionalClasses, statefulFactoryClass, "newFactory");
        Compiler.addFactoryMethod(additionalClasses, statefulFactoryClass, "newInstance");
        this.additionalClasses = Collections.unmodifiableMap(additionalClasses);
    }

    private static void addFactoryMethod(Map<String, Class<?>> additionalClasses, Class<?> factoryClass, String methodName) {
        if (factoryClass == null) {
            return;
        }
        Method factoryMethod = null;
        for (Method method : factoryClass.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            factoryMethod = method;
            break;
        }
        if (factoryMethod == null) {
            return;
        }
        additionalClasses.put(factoryClass.getName(), factoryClass);
        for (int i = 0; i < factoryMethod.getParameterTypes().length; ++i) {
            Class<?> parameterClazz = factoryMethod.getParameterTypes()[i];
            additionalClasses.put(parameterClazz.getName(), parameterClazz);
        }
    }

    ScriptScope compile(Loader loader, String name, String source, CompilerSettings settings) {
        String scriptName = Location.computeSourceName(name);
        ScriptClassInfo scriptClassInfo = new ScriptClassInfo(this.painlessLookup, this.scriptClass);
        SClass root = Walker.buildPainlessTree(scriptName, source, settings);
        ScriptScope scriptScope = new ScriptScope(this.painlessLookup, settings, scriptClassInfo, scriptName, source, root.getIdentifier() + 1);
        new PainlessSemanticHeaderPhase().visitClass(root, scriptScope);
        new PainlessSemanticAnalysisPhase().visitClass(root, scriptScope);
        new DocFieldsPhase().visitClass(root, scriptScope);
        new PainlessUserTreeToIRTreePhase().visitClass(root, scriptScope);
        ClassNode classNode = (ClassNode)scriptScope.getDecoration(root, Decorations.IRNodeDecoration.class).getIRNode();
        new DefaultStringConcatenationOptimizationPhase().visitClass(classNode, null);
        new DefaultConstantFoldingOptimizationPhase().visitClass(classNode, null);
        byte[] bytes = classNode.write();
        try {
            Class<? extends PainlessScript> clazz = loader.defineScript(WriterConstants.CLASS_NAME, bytes);
            for (Map.Entry<String, Object> staticConstant : scriptScope.getStaticConstants().entrySet()) {
                clazz.getField(staticConstant.getKey()).set(null, staticConstant.getValue());
            }
            return scriptScope;
        }
        catch (Exception exception) {
            throw new IllegalStateException("An internal error occurred attempting to define the script [" + name + "].", exception);
        }
    }

    byte[] compile(String name, String source, CompilerSettings settings, Printer debugStream) {
        String scriptName = Location.computeSourceName(name);
        ScriptClassInfo scriptClassInfo = new ScriptClassInfo(this.painlessLookup, this.scriptClass);
        SClass root = Walker.buildPainlessTree(scriptName, source, settings);
        ScriptScope scriptScope = new ScriptScope(this.painlessLookup, settings, scriptClassInfo, scriptName, source, root.getIdentifier() + 1);
        new PainlessSemanticHeaderPhase().visitClass(root, scriptScope);
        new PainlessSemanticAnalysisPhase().visitClass(root, scriptScope);
        new DocFieldsPhase().visitClass(root, scriptScope);
        new PainlessUserTreeToIRTreePhase().visitClass(root, scriptScope);
        ClassNode classNode = (ClassNode)scriptScope.getDecoration(root, Decorations.IRNodeDecoration.class).getIRNode();
        new DefaultStringConcatenationOptimizationPhase().visitClass(classNode, null);
        new DefaultConstantFoldingOptimizationPhase().visitClass(classNode, null);
        classNode.setDebugStream(debugStream);
        return classNode.write();
    }

    static {
        try {
            CODESOURCE = new CodeSource(new URL("file:/untrusted"), (Certificate[])null);
        }
        catch (MalformedURLException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    final class Loader
    extends SecureClassLoader {
        private final AtomicInteger lambdaCounter;

        Loader(ClassLoader parent) {
            super(parent);
            this.lambdaCounter = new AtomicInteger(0);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> found = (Class<?>)Compiler.this.additionalClasses.get(name);
            if (found != null) {
                return found;
            }
            found = Compiler.this.painlessLookup.javaClassNameToClass(name);
            return found != null ? found : super.findClass(name);
        }

        Class<?> defineFactory(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE);
        }

        Class<? extends PainlessScript> defineScript(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE).asSubclass(PainlessScript.class);
        }

        Class<?> defineLambda(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE);
        }

        int newLambdaIdentifier() {
            return this.lambdaCounter.getAndIncrement();
        }
    }
}

