/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.cursor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.aesh.readline.Buffer;
import org.aesh.readline.cursor.CursorLocation;
import org.aesh.readline.cursor.CursorLocator;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalCharacter;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Connection;
import org.aesh.utils.ANSI;

public class Line {
    private static final Logger LOG = Logger.getLogger(Line.class.getName());
    private final Buffer buffer;
    private final Connection connection;
    private final int width;

    public Line(Buffer buffer, Connection connection, int width) {
        this.buffer = buffer;
        this.connection = connection;
        this.width = width;
    }

    public String getLineFromCursor() {
        return this.buffer.asString().substring(this.buffer.multiCursor());
    }

    public String toString() {
        return this.buffer.asString();
    }

    public CursorTransactionBuilder newCursorTransactionBuilder() {
        return new CursorTransactionBuilder();
    }

    public CursorLocator getCursorLocator() {
        return this.buffer.getCursorLocator();
    }

    public int getCurrentCharacterIndex() {
        return this.buffer.multiCursor();
    }

    public String getLineToCursor() {
        return this.buffer.asString().substring(0, this.buffer.multiCursor());
    }

    public int getCharacterAtCursor() {
        return this.buffer.get(this.buffer.cursor());
    }

    public char getCharacterAtPosition(int position) {
        return (char)this.buffer.get(position);
    }

    private void moveUp(int delta) {
        this.move(delta, 'A');
    }

    private void moveDown(int delta) {
        this.move(delta, 'B');
    }

    private void moveForward(int delta) {
        this.move(delta, 'C');
    }

    private void moveBackward(int delta) {
        this.move(delta, 'D');
    }

    private void move(int delta, char action) {
        if (delta > 0) {
            this.connection.stdoutHandler().accept(Buffer.moveNumberOfColumns(delta, action));
        }
    }

    private void saveCursor() {
        this.connection.stdoutHandler().accept(Parser.toCodePoints(ANSI.CURSOR_SAVE));
    }

    private void restoreCursor() {
        this.connection.stdoutHandler().accept(Parser.toCodePoints(ANSI.CURSOR_RESTORE));
    }

    public class CursorTransactionBuilder {
        private final List<CursorAction> actions = new ArrayList<CursorAction>();

        public CursorTransactionBuilder move(int value) {
            this.actions.add(new MoveAction(value));
            return this;
        }

        public CursorTransactionBuilder colorize(int index, Color text, Color bg, boolean bright) {
            this.actions.add(new ColorizeAction(index, text, bg, bright));
            return this;
        }

        public CursorTransactionBuilder moveBackward(int value) {
            this.actions.add(new MoveBackwardAction(value));
            return this;
        }

        public CursorTransactionBuilder moveForward(int value) {
            this.actions.add(new MoveForwardAction(value));
            return this;
        }

        public CursorTransactionBuilder moveUp(int value) {
            this.actions.add(new MoveUpAction(value));
            return this;
        }

        public CursorTransactionBuilder moveDown(int value) {
            this.actions.add(new MoveDownAction(value));
            return this;
        }

        public CursorTransaction build() {
            if (Line.this.buffer.getCursorLocator().isLocationInvalidated()) {
                return new CursorTransaction(Collections.emptyList());
            }
            return new CursorTransaction(this.actions);
        }
    }

    public class CursorTransaction {
        private final List<CursorAction> actions = new ArrayList<CursorAction>();

        CursorTransaction(List<CursorAction> actions2) {
            this.actions.addAll(actions2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Line.this.saveCursor();
            try {
                for (CursorAction a : this.actions) {
                    try {
                        a.apply();
                    }
                    catch (Exception ex) {
                        LOG.fine("Exception in Cursor transaction: " + ex.getLocalizedMessage());
                        break;
                    }
                }
            }
            finally {
                Line.this.restoreCursor();
            }
        }
    }

    public class MoveDownAction
    extends CursorAction {
        int move;

        MoveDownAction(int move) {
            this.move = move;
        }

        @Override
        public void apply() {
            Line.this.moveDown(this.move);
        }
    }

    public class MoveUpAction
    extends CursorAction {
        int move;

        MoveUpAction(int move) {
            this.move = move;
        }

        @Override
        public void apply() {
            Line.this.moveUp(this.move);
        }
    }

    public class MoveForwardAction
    extends CursorAction {
        int move;

        MoveForwardAction(int move) {
            this.move = move;
        }

        @Override
        public void apply() {
            Line.this.moveForward(this.move);
        }
    }

    public class MoveBackwardAction
    extends CursorAction {
        int move;

        MoveBackwardAction(int move) {
            this.move = move;
        }

        @Override
        public void apply() {
            Line.this.moveBackward(this.move);
        }
    }

    public class ColorizeAction
    extends CursorAction {
        private final Color text;
        private final Color background;
        private final int index;
        private final boolean bright;

        ColorizeAction(int index, Color text, Color background, boolean bright) {
            this.index = index;
            this.text = text;
            this.background = background;
            this.bright = bright;
        }

        @Override
        public void apply() {
            MoveAction move = new MoveAction(this.index);
            move.apply();
            char c = Line.this.buffer.asString().charAt(this.index);
            TerminalCharacter characterData = new TerminalCharacter(c, new TerminalColor(this.text, this.background));
            if (this.bright) {
                Line.this.connection.stdoutHandler().accept(Parser.toCodePoints(ANSI.BOLD));
            } else {
                Line.this.connection.stdoutHandler().accept(Parser.toCodePoints("\u001b[0;22m"));
            }
            Line.this.connection.stdoutHandler().accept(Parser.toCodePoints(characterData.toString()));
            Line.this.moveBackward(1);
        }
    }

    public class MoveAction
    extends CursorAction {
        private final int index;

        MoveAction(int index) {
            this.index = index;
        }

        @Override
        public void apply() {
            CursorLocation loc = Line.this.buffer.getCursorLocator().locate(this.index, Line.this.width);
            if (loc == null) {
                throw new RuntimeException("Null Location for " + this.index);
            }
            CursorLocation cursorLoc = Line.this.buffer.getCursorLocator().locate(Line.this.buffer.multiCursor(), Line.this.width);
            int num = cursorLoc.getRow() - loc.getRow();
            if (num > 0) {
                Line.this.moveUp(num);
            } else {
                Line.this.moveDown(-num);
            }
            Line.this.moveBackward(cursorLoc.getColumn());
            Line.this.moveForward(loc.getColumn());
        }
    }

    public abstract class CursorAction {
        public abstract void apply();
    }
}

