/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.config;

import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Hints {
    public static final String[] NO_HINTS = new String[0];
    public static final String DEFAULT_HINT = "default";
    private static final List<String> NO_HINTS_LIST = Arrays.asList(NO_HINTS);

    private Hints() {
    }

    public static String canonicalHint(String hint) {
        return null == hint || hint.length() == 0 ? DEFAULT_HINT : hint.intern();
    }

    public static boolean isDefaultHint(String hint) {
        return DEFAULT_HINT.equals(hint) || null == hint || hint.length() == 0;
    }

    public static String[] canonicalHints(String ... hints) {
        int length = hints.length;
        if (length == 0 || length == 1 && hints[0].length() == 0) {
            return NO_HINTS;
        }
        for (int i = 0; i < length; ++i) {
            hints[i] = Hints.canonicalHint(hints[i]);
        }
        return hints;
    }

    public static List<String> canonicalHints(List<String> hints) {
        int length = hints.size();
        if (length == 0 || length == 1 && hints.get(0).length() == 0) {
            return NO_HINTS_LIST;
        }
        for (int i = 0; i < length; ++i) {
            hints.set(i, Hints.canonicalHint(hints.get(i)));
        }
        return hints;
    }

    public static String[] canonicalHints(Requirement requirement) {
        String[] hints = requirement.hints();
        if (hints.length > 0) {
            return Hints.canonicalHints(hints);
        }
        String hint = requirement.hint();
        if (hint.length() > 0) {
            return Hints.canonicalHints(hint);
        }
        return NO_HINTS;
    }

    static {
        new Hints();
    }
}

