/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.editor.lsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cpplite.editor.Utils;
import org.netbeans.modules.cpplite.editor.spi.CProjectConfigurationProvider;
import org.netbeans.modules.lsp.client.spi.LanguageServerProvider;
import org.netbeans.modules.lsp.client.spi.ServerRestarter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class LanguageServerImpl
implements LanguageServerProvider {
    private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class.getName());
    private static final Map<Project, Pair<Process, LanguageServerProvider.LanguageServerDescription>> prj2Server = new HashMap<Project, Pair<Process, LanguageServerProvider.LanguageServerDescription>>();
    private static int tempDirIndex = 0;

    public LanguageServerProvider.LanguageServerDescription startServer(Lookup lookup) {
        final Project prj = (Project)lookup.lookup(Project.class);
        if (prj == null) {
            return null;
        }
        final ServerRestarter restarter = (ServerRestarter)lookup.lookup(ServerRestarter.class);
        Utils.settings().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey() == null || "ccls".equals(evt.getKey()) || "clangd".equals(evt.getKey())) {
                    prj2Server.remove(prj);
                    restarter.restart();
                    Utils.settings().removePreferenceChangeListener(this);
                }
            }
        });
        String ccls = Utils.getCCLSPath();
        String clangd = Utils.getCLANGDPath();
        if (ccls != null || clangd != null) {
            return (LanguageServerProvider.LanguageServerDescription)prj2Server.compute(prj, (p, pair) -> {
                if (pair != null && ((Process)pair.first()).isAlive()) {
                    return pair;
                }
                try {
                    ArrayList<String> command = new ArrayList<String>();
                    final CProjectConfigurationProvider config = LanguageServerImpl.getProjectSettings(prj);
                    config.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            prj2Server.remove(prj);
                            restarter.restart();
                            config.removeChangeListener(this);
                        }
                    });
                    File compileCommandDirs = LanguageServerImpl.getCompileCommandsDir(config);
                    if (compileCommandDirs != null) {
                        if (ccls != null) {
                            command.add(ccls);
                            StringBuilder initOpt = new StringBuilder();
                            initOpt.append("--init={\"compilationDatabaseDirectory\":\"");
                            initOpt.append(compileCommandDirs.getAbsolutePath());
                            initOpt.append("\"}");
                            command.add(initOpt.toString());
                        } else {
                            command.add(clangd);
                            command.add("--compile-commands-dir=" + compileCommandDirs.getAbsolutePath());
                            command.add("--clang-tidy");
                            command.add("--completion-style=detailed");
                        }
                        ProcessBuilder builder = new ProcessBuilder(command);
                        if (LOG.isLoggable(Level.FINEST)) {
                            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
                        }
                        Process process = builder.start();
                        InputStream in = process.getInputStream();
                        OutputStream out = process.getOutputStream();
                        if (LOG.isLoggable(Level.FINEST)) {
                            in = new CopyInput(in, System.err);
                            out = new CopyOutput(out, System.err);
                        }
                        return Pair.of((Object)process, (Object)LanguageServerProvider.LanguageServerDescription.create((InputStream)in, (OutputStream)out, (Process)process));
                    }
                    return null;
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                    return null;
                }
            }).second();
        }
        return null;
    }

    public static File getCompileCommandsDir(Project prj) {
        return LanguageServerImpl.getCompileCommandsDir(LanguageServerImpl.getProjectSettings(prj));
    }

    private static CProjectConfigurationProvider getProjectSettings(final Project prj) {
        CProjectConfigurationProvider configProvider = (CProjectConfigurationProvider)prj.getLookup().lookup(CProjectConfigurationProvider.class);
        if (configProvider == null) {
            configProvider = new CProjectConfigurationProvider(){

                @Override
                public CProjectConfigurationProvider.ProjectConfiguration getProjectConfiguration() {
                    return new CProjectConfigurationProvider.ProjectConfiguration(new File(FileUtil.toFile((FileObject)prj.getProjectDirectory()), "compile_commands.json").getAbsolutePath());
                }

                @Override
                public void addChangeListener(ChangeListener listener) {
                }

                @Override
                public void removeChangeListener(ChangeListener listener) {
                }
            };
        }
        return configProvider;
    }

    private static File getCompileCommandsDir(CProjectConfigurationProvider configProvider) {
        CProjectConfigurationProvider.ProjectConfiguration config = configProvider.getProjectConfiguration();
        if (config.commandJsonCommand != null || config.commandJsonPath != null || config.commandJsonContent != null) {
            File tempFile;
            block48: {
                tempFile = Places.getCacheSubfile((String)("cpplite/compile_commands/" + tempDirIndex++ + "/compile_commands.json"));
                if (config.commandJsonCommand != null) {
                    try {
                        new ProcessBuilder(config.commandJsonCommand).redirectOutput(tempFile).redirectError(ProcessBuilder.Redirect.INHERIT).start().waitFor();
                    }
                    catch (IOException | InterruptedException ex) {
                        LOG.log(Level.WARNING, null, ex);
                        return null;
                    }
                }
                if (config.commandJsonPath != null) {
                    File commandsPath = new File(config.commandJsonPath);
                    if (commandsPath.canRead()) {
                        try (FileInputStream in = new FileInputStream(commandsPath);
                             FileOutputStream out = new FileOutputStream(tempFile);){
                            FileUtil.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (IOException ex) {
                            LOG.log(Level.WARNING, null, ex);
                            return null;
                        }
                    }
                } else {
                    if (config.commandJsonContent != null) {
                        try (FileOutputStream out = new FileOutputStream(tempFile);){
                            ((OutputStream)out).write(config.commandJsonContent.getBytes());
                            break block48;
                        }
                        catch (IOException ex) {
                            LOG.log(Level.WARNING, null, ex);
                            return null;
                        }
                    }
                    return null;
                }
            }
            return tempFile.getParentFile();
        }
        return null;
    }

    private static class CopyOutput
    extends OutputStream {
        private final OutputStream delegate;
        private final OutputStream log;

        public CopyOutput(OutputStream delegate, OutputStream log) {
            this.delegate = delegate;
            this.log = log;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            this.log.write(b);
            this.log.flush();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
            this.log.flush();
        }
    }

    private static class CopyInput
    extends InputStream {
        private final InputStream delegate;
        private final OutputStream log;

        public CopyInput(InputStream delegate, OutputStream log) {
            this.delegate = delegate;
            this.log = log;
        }

        @Override
        public int read() throws IOException {
            int read = this.delegate.read();
            this.log.write(read);
            return read;
        }
    }
}

