/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.commonjs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.DefaultESModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.util.List;

public final class NpmCompatibleESModuleLoader
extends DefaultESModuleLoader {
    public static NpmCompatibleESModuleLoader create(JSRealm realm) {
        return new NpmCompatibleESModuleLoader(realm);
    }

    private NpmCompatibleESModuleLoader(JSRealm realm) {
        super(realm);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord resolveImportedModule(ScriptOrModule referencingModule, String specifier) {
        CommonJSRequireBuiltin.log("IMPORT resolve ", specifier);
        if (CommonJSResolution.isCoreModule(specifier)) {
            return this.loadCoreModule(specifier);
        }
        try {
            TruffleFile file = this.resolveURL(referencingModule, specifier);
            return this.loadModuleFromUrl(specifier, file, file.getPath());
        }
        catch (IOException e) {
            CommonJSRequireBuiltin.log("IMPORT resolve ", specifier, " FAILED ", e.getMessage());
            throw Errors.createErrorFromException(e);
        }
    }

    private JSModuleRecord loadCoreModule(String specifier) {
        Source src;
        CommonJSRequireBuiltin.log("IMPORT resolve built-in ", specifier);
        JSModuleRecord existingModule = (JSModuleRecord)this.moduleMap.get(specifier);
        if (existingModule != null) {
            CommonJSRequireBuiltin.log("IMPORT resolve built-in from cache ", specifier);
            return existingModule;
        }
        String moduleReplacementName = this.realm.getContext().getContextOptions().getCommonJSRequireBuiltins().get(specifier);
        if (moduleReplacementName != null && moduleReplacementName.endsWith(".mjs")) {
            try {
                String cwdOption = this.realm.getContext().getContextOptions().getRequireCwd();
                TruffleFile cwd = cwdOption == null ? this.realm.getEnv().getCurrentWorkingDirectory() : this.realm.getEnv().getPublicTruffleFile(cwdOption);
                TruffleFile modulePath = CommonJSResolution.joinPaths(this.realm.getEnv(), cwd, moduleReplacementName);
                src = Source.newBuilder((String)"js", (TruffleFile)modulePath).build();
            }
            catch (IOException | SecurityException e) {
                throw NpmCompatibleESModuleLoader.fail("Failed to load built-in ES module: " + specifier + ". " + e.getMessage());
            }
        } else {
            DynamicObject require = (DynamicObject)this.realm.getCommonJSRequireFunctionObject();
            Object maybeModule = JSFunction.call(JSArguments.create(Undefined.instance, require, specifier));
            if (maybeModule == Undefined.instance || !JSObject.isJSObject(maybeModule)) {
                throw NpmCompatibleESModuleLoader.fail("Failed to load built-in ES module: " + specifier);
            }
            DynamicObject module = (DynamicObject)maybeModule;
            List<String> exportedValues = JSObject.enumerableOwnNames(module);
            StringBuilder moduleBody = new StringBuilder();
            moduleBody.append("const builtinModule = require('" + specifier + "');\n");
            for (String s : exportedValues) {
                moduleBody.append("export const " + s + " = builtinModule." + s + ";\n");
            }
            moduleBody.append("export default builtinModule;");
            src = Source.newBuilder((String)"js", (CharSequence)moduleBody.toString(), (String)(specifier + "-internal.mjs")).build();
        }
        JSModuleRecord record = this.realm.getContext().getEvaluator().parseModule(this.realm.getContext(), src, this);
        this.moduleMap.put(specifier, record);
        return record;
    }

    private TruffleFile resolveURL(ScriptOrModule referencingModule, String specifier) {
        if (specifier.isEmpty()) {
            throw NpmCompatibleESModuleLoader.fail(specifier);
        }
        TruffleLanguage.Env env = this.realm.getEnv();
        TruffleFile resolvedUrl = null;
        URI maybeUri = this.asURI(specifier);
        if (maybeUri != null) {
            try {
                resolvedUrl = env.getPublicTruffleFile(maybeUri);
            }
            catch (FileSystemNotFoundException e) {
                throw NpmCompatibleESModuleLoader.failMessage("Only file:// urls are supported: " + e.getMessage());
            }
        } else if (specifier.charAt(0) == '/') {
            resolvedUrl = env.getPublicTruffleFile(specifier);
        } else if (NpmCompatibleESModuleLoader.isRelativePathFileName(specifier)) {
            TruffleFile fullPath = this.getParentPath(referencingModule);
            if (fullPath == null) {
                throw NpmCompatibleESModuleLoader.fail(specifier);
            }
            resolvedUrl = CommonJSResolution.joinPaths(env, fullPath, specifier);
        } else {
            resolvedUrl = this.packageResolve(specifier, referencingModule);
        }
        assert (resolvedUrl != null);
        if (resolvedUrl.toString().toUpperCase().contains("%2F") || resolvedUrl.toString().toUpperCase().contains("%5C")) {
            throw NpmCompatibleESModuleLoader.fail(specifier);
        }
        if (!resolvedUrl.endsWith("/") && !resolvedUrl.exists(new LinkOption[0])) {
            throw NpmCompatibleESModuleLoader.fail(specifier);
        }
        return resolvedUrl;
    }

    private TruffleFile getParentPath(ScriptOrModule referencingModule) {
        String refPath;
        String string = refPath = referencingModule == null ? null : referencingModule.getSource().getPath();
        if (refPath == null) {
            return this.realm.getEnv().getPublicTruffleFile(this.realm.getContext().getContextOptions().getRequireCwd());
        }
        return this.realm.getEnv().getPublicTruffleFile(refPath).getParent();
    }

    private TruffleFile getFullPath(ScriptOrModule referencingModule) {
        String refPath;
        String string = refPath = referencingModule == null ? null : referencingModule.getSource().getPath();
        if (refPath == null) {
            refPath = this.realm.getContext().getContextOptions().getRequireCwd();
        }
        return this.realm.getEnv().getPublicTruffleFile(refPath);
    }

    private TruffleFile packageResolve(String packageSpecifier, ScriptOrModule referencingModule) {
        TruffleLanguage.Env env = this.realm.getEnv();
        String packageName = null;
        if (packageSpecifier.isEmpty()) {
            throw NpmCompatibleESModuleLoader.fail(packageSpecifier);
        }
        if (packageSpecifier.indexOf(47) != -1) {
            throw NpmCompatibleESModuleLoader.fail(packageSpecifier);
        }
        packageName = packageSpecifier;
        if (packageName.charAt(0) == '.') {
            throw NpmCompatibleESModuleLoader.fail(packageSpecifier);
        }
        TruffleFile mainPackageFolder = this.getFullPath(referencingModule);
        List<TruffleFile> nodeModulesPaths = CommonJSResolution.getNodeModulesPaths(mainPackageFolder);
        for (TruffleFile modulePath : nodeModulesPaths) {
            DynamicObject jsonObj;
            TruffleFile moduleFolder = CommonJSResolution.joinPaths(env, modulePath, packageSpecifier);
            TruffleFile packageJson = CommonJSResolution.joinPaths(env, moduleFolder, "package.json");
            if (!CommonJSResolution.fileExists(packageJson) || !JSObject.isJSObject(jsonObj = CommonJSResolution.loadJsonObject(packageJson, this.realm.getContext()))) continue;
            Object main = JSObject.get(jsonObj, (Object)"main");
            Object type = JSObject.get(jsonObj, (Object)"type");
            if (type == Undefined.instance || !JSRuntime.isString(type) || !"module".equals(JSRuntime.safeToString(type))) {
                throw NpmCompatibleESModuleLoader.failMessage("do not use import() to load non-ES modules.");
            }
            if (!JSRuntime.isString(main)) {
                return CommonJSResolution.loadIndex(env, moduleFolder);
            }
            TruffleFile mainPackageFile = CommonJSResolution.joinPaths(env, moduleFolder, JSRuntime.safeToString(main));
            TruffleFile asFile = CommonJSResolution.loadAsFile(env, mainPackageFile);
            if (asFile != null) {
                return asFile;
            }
            return CommonJSResolution.loadIndex(env, mainPackageFile);
        }
        TruffleFile maybeFile = env.getPublicTruffleFile(packageSpecifier);
        if (maybeFile.exists(new LinkOption[0])) {
            return maybeFile;
        }
        throw NpmCompatibleESModuleLoader.fail(packageSpecifier);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException failMessage(String message) {
        return JSException.create(JSErrorType.TypeError, message);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException fail(String moduleIdentifier) {
        return NpmCompatibleESModuleLoader.failMessage("Cannot load module: '" + moduleIdentifier + "'");
    }

    private static boolean isRelativePathFileName(String moduleIdentifier) {
        return moduleIdentifier.startsWith("./") || moduleIdentifier.startsWith("../");
    }
}

