/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.math.MinNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=MinNode.class)
public final class MinNodeGen
extends MinNode
implements Introspection.Provider {
    @Node.Child
    private JavaScriptNode arguments0_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile min2ParamInt_minProfile_;
    @Node.Child
    private Min2ParamData min2Param_cache;

    private MinNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[]{this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if (state != 0 && arguments0Value_ instanceof Object[]) {
            Min2ParamData s4_;
            Object[] arguments0Value__ = (Object[])arguments0Value_;
            if ((state & 1) != 0 && arguments0Value__.length == 0) {
                return MinNode.min0Param(arguments0Value__);
            }
            if ((state & 2) != 0 && arguments0Value__.length == 1) {
                return this.min1Param(arguments0Value__);
            }
            if ((state & 4) != 0 && arguments0Value__.length == 2 && MinNode.caseIntInt(arguments0Value__)) {
                return MinNode.min2ParamInt(arguments0Value__, this.min2ParamInt_minProfile_);
            }
            if ((state & 8) != 0 && (s4_ = this.min2Param_cache) != null && arguments0Value__.length == 2 && !MinNode.caseIntInt(arguments0Value__)) {
                return this.min2Param(arguments0Value__, s4_.isIntBranch_, s4_.minProfile_, s4_.toNumber1Node_, s4_.toNumber2Node_);
            }
            if ((state & 0x10) != 0 && arguments0Value__.length >= 3) {
                return this.min(arguments0Value__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 8) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 0x13) != 0 && arguments0Value_ instanceof Object[]) {
            Object[] arguments0Value__ = (Object[])arguments0Value_;
            if ((state & 1) != 0 && arguments0Value__.length == 0) {
                return MinNode.min0Param(arguments0Value__);
            }
            if ((state & 2) != 0 && arguments0Value__.length == 1) {
                return this.min1Param(arguments0Value__);
            }
            if ((state & 0x10) != 0 && arguments0Value__.length >= 3) {
                return this.min(arguments0Value__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        Object[] arguments0Value__;
        int state = this.state_;
        if ((state & 8) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 4) != 0 && arguments0Value_ instanceof Object[] && (arguments0Value__ = (Object[])arguments0Value_).length == 2 && MinNode.caseIntInt(arguments0Value__)) {
            return MinNode.min2ParamInt(arguments0Value__, this.min2ParamInt_minProfile_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x1B) == 0 && state != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0xC) == 0 && state != 0) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arguments0Value instanceof Object[]) {
                Object[] arguments0Value_ = (Object[])arguments0Value;
                if (arguments0Value_.length == 0) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Double d = MinNode.min0Param(arguments0Value_);
                    return d;
                }
                if (arguments0Value_.length == 1) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.min1Param(arguments0Value_);
                    return d;
                }
                if (arguments0Value_.length == 2 && MinNode.caseIntInt(arguments0Value_)) {
                    this.min2ParamInt_minProfile_ = ConditionProfile.createBinaryProfile();
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Integer n = MinNode.min2ParamInt(arguments0Value_, this.min2ParamInt_minProfile_);
                    return n;
                }
                if (arguments0Value_.length == 2 && !MinNode.caseIntInt(arguments0Value_)) {
                    Min2ParamData s4_ = (Min2ParamData)super.insert((Node)new Min2ParamData());
                    s4_.isIntBranch_ = ConditionProfile.createBinaryProfile();
                    s4_.minProfile_ = ConditionProfile.createBinaryProfile();
                    s4_.toNumber1Node_ = s4_.insertAccessor(JSToNumberNode.create());
                    s4_.toNumber2Node_ = s4_.insertAccessor(JSToNumberNode.create());
                    this.min2Param_cache = s4_;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.min2Param(arguments0Value_, s4_.isIntBranch_, s4_.minProfile_, s4_.toNumber1Node_, s4_.toNumber2Node_);
                    return object;
                }
                if (arguments0Value_.length >= 3) {
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.min(arguments0Value_);
                    return d;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "min0Param";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "min1Param";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "min2ParamInt";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.min2ParamInt_minProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "min2Param";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            Min2ParamData s4_ = this.min2Param_cache;
            if (s4_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s4_.isIntBranch_, s4_.minProfile_, s4_.toNumber1Node_, s4_.toNumber2Node_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "min";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static MinNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new MinNodeGen(context, builtin, arguments);
    }

    @GeneratedBy(value=MinNode.class)
    private static final class Min2ParamData
    extends Node {
        @CompilerDirectives.CompilationFinal
        ConditionProfile isIntBranch_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile minProfile_;
        @Node.Child
        JSToNumberNode toNumber1Node_;
        @Node.Child
        JSToNumberNode toNumber2Node_;

        Min2ParamData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

