/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.customizer;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.EditorKit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.actions.CustomActionRegistrationSupport;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.customizer.Bundle;
import org.netbeans.modules.gradle.customizer.CustomActionMapping;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public class BuildActionsCustomizer
extends JPanel {
    private static final String CUSTOM_ACTION = Bundle.TXT_CUSTOM();
    private static final String CARD_NOSELECT = "empty";
    private static final String CARD_DETAILS = "details";
    final Project project;
    final DefaultListModel<CustomActionMapping> customActionsModel = new DefaultListModel();
    final DefaultComboBoxModel<String> availableActionsModel = new DefaultComboBoxModel();
    final CustomActionRegistrationSupport actionRegistry;
    final DocumentListener applyListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            BuildActionsCustomizer.this.apply();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BuildActionsCustomizer.this.apply();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BuildActionsCustomizer.this.apply();
        }
    };
    private volatile boolean autoApply;
    private boolean comboReady;
    private JButton btRemove;
    private JComboBox<String> cbAdd;
    private JComboBox<String> cbReloadRule;
    private JCheckBox cbRepeatable;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lbActions;
    private JLabel lbArgs;
    private JLabel lbLabel;
    private JLabel lbName;
    private JLabel lbNoAction;
    private JLabel lbReloadHints;
    private JLabel lbReloadRule;
    private JLabel lbTitle;
    private JList<CustomActionMapping> lsActions;
    private JPanel pnDetails;
    private JPanel pnDetailsPanel;
    private JEditorPane taArgs;
    private JTextField tfLabel;
    private JTextField tfName;

    public BuildActionsCustomizer(Project project) {
        this.project = project;
        this.initComponents();
        this.actionRegistry = new CustomActionRegistrationSupport(project);
        this.lsActions.setCellRenderer(new MyListCellRenderer());
        this.tfLabel.getDocument().addDocumentListener(this.applyListener);
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)"text/x-gradle-cli");
        this.taArgs.setEditorKit(kit);
        this.taArgs.getDocument().putProperty("stream", project);
        this.taArgs.getDocument().addDocumentListener(this.applyListener);
        this.initDefaultModels();
        this.comboReady = true;
    }

    private void initDefaultModels() {
        ActionProvider actionProvider = (ActionProvider)this.project.getLookup().lookup(ActionProvider.class);
        TreeSet<String> allAvailableActions = new TreeSet<String>(Arrays.asList(actionProvider.getSupportedActions()));
        this.actionRegistry.getCustomActions().forEach(mapping -> this.customActionsModel.addElement((CustomActionMapping)mapping));
        this.availableActionsModel.addElement(CUSTOM_ACTION);
        for (String action : allAvailableActions) {
            if (this.actionRegistry.getCustomAction(action) != null) continue;
            this.availableActionsModel.addElement(action);
        }
    }

    private void initComponents() {
        this.lbActions = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lsActions = new JList();
        this.pnDetailsPanel = new JPanel();
        this.lbNoAction = new JLabel();
        this.pnDetails = new JPanel();
        this.lbName = new JLabel();
        this.lbLabel = new JLabel();
        this.tfName = new JTextField();
        this.tfLabel = new JTextField();
        this.lbArgs = new JLabel();
        this.btRemove = new JButton();
        this.lbReloadRule = new JLabel();
        this.cbReloadRule = new JComboBox();
        this.cbRepeatable = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.taArgs = new JEditorPane();
        this.lbReloadHints = new JLabel();
        this.cbAdd = new JComboBox();
        this.lbTitle = new JLabel();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lbActions, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbActions.text"));
        this.lsActions.setModel(this.customActionsModel);
        this.lsActions.setSelectionMode(0);
        this.lsActions.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BuildActionsCustomizer.this.lsActionsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lsActions);
        this.pnDetailsPanel.setLayout(new CardLayout());
        this.lbNoAction.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lbNoAction, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbNoAction.text"));
        this.pnDetailsPanel.add((Component)this.lbNoAction, CARD_NOSELECT);
        this.pnDetails.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((JLabel)this.lbName, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbLabel, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbLabel.text"));
        this.tfName.setEditable(false);
        this.tfName.setEnabled(false);
        this.tfLabel.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.lbArgs, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbArgs.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btRemove, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.btRemove.text"));
        this.btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsCustomizer.this.btRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbReloadRule, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbReloadRule.text"));
        this.cbReloadRule.setModel(new DefaultComboBoxModel<String>(new String[]{"NEVER", "DEFAULT", "ALWAYS", "ALWAYS_ONLINE"}));
        this.cbReloadRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BuildActionsCustomizer.this.cbReloadRuleItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbRepeatable, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.cbRepeatable.text"));
        this.cbRepeatable.setToolTipText(NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.cbRepeatable.toolTipText"));
        this.cbRepeatable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BuildActionsCustomizer.this.cbRepeatableStateChanged(evt);
            }
        });
        this.taArgs.setContentType("text/x-gradle-cli");
        this.jScrollPane3.setViewportView(this.taArgs);
        this.lbReloadHints.setFont(new Font("Dialog", 0, 12));
        this.lbReloadHints.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lbReloadHints, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbReloadHints.text"));
        this.lbReloadHints.setVerticalAlignment(1);
        this.lbReloadHints.setEnabled(false);
        GroupLayout pnDetailsLayout = new GroupLayout(this.pnDetails);
        this.pnDetails.setLayout(pnDetailsLayout);
        pnDetailsLayout.setHorizontalGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnDetailsLayout.createSequentialGroup().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnDetailsLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btRemove)).addGroup(pnDetailsLayout.createSequentialGroup().addContainerGap().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnDetailsLayout.createSequentialGroup().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbName).addComponent(this.lbLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfLabel).addComponent(this.tfName))).addGroup(pnDetailsLayout.createSequentialGroup().addComponent(this.lbReloadRule).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbReloadRule, -2, 138, -2).addGap(18, 18, 18).addComponent(this.cbRepeatable, -1, 146, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnDetailsLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane3)).addGroup(pnDetailsLayout.createSequentialGroup().addComponent(this.lbArgs).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.lbReloadHints, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        pnDetailsLayout.setVerticalGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnDetailsLayout.createSequentialGroup().addContainerGap().addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbName).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbLabel).addComponent(this.tfLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lbArgs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbReloadRule).addComponent(this.cbReloadRule, -2, -1, -2).addComponent(this.cbRepeatable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbReloadHints).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btRemove).addContainerGap()));
        this.pnDetailsPanel.add((Component)this.pnDetails, CARD_DETAILS);
        this.cbAdd.setModel(this.availableActionsModel);
        this.cbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsCustomizer.this.cbAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbTitle, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.lbTitle.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BuildActionsCustomizer.class, (String)"BuildActionsCustomizer.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lbTitle, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbActions).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane2, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnDetailsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAdd, 0, -1, Short.MAX_VALUE))))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lbTitle).addGap(10, 10, 10).addComponent(this.lbActions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAdd, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnDetailsPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane2)).addContainerGap()));
    }

    private void lsActionsValueChanged(ListSelectionEvent evt) {
        CardLayout cardLayout = (CardLayout)this.pnDetailsPanel.getLayout();
        CustomActionMapping mapping = this.getSelectedMapping();
        this.autoApply = false;
        if (mapping != null) {
            cardLayout.show(this.pnDetailsPanel, CARD_DETAILS);
            this.tfName.setText(mapping.getName());
            this.tfLabel.setText(mapping.getDisplayName());
            this.tfLabel.setEnabled(mapping.getName().startsWith("custom-"));
            this.taArgs.setText(mapping.getArgs());
            this.cbReloadRule.setSelectedItem(mapping.getReloadRule().name());
            this.cbRepeatable.setSelected(mapping.isRepeatable());
            this.autoApply = true;
        } else {
            cardLayout.show(this.pnDetailsPanel, CARD_NOSELECT);
        }
    }

    private void btRemoveActionPerformed(ActionEvent evt) {
        CustomActionMapping mapping = this.getSelectedMapping();
        this.customActionsModel.removeElement(mapping);
        this.actionRegistry.unregisterCustomAction(mapping.getName());
        String action = mapping.getName();
        if (!action.startsWith("custom-")) {
            this.availableActionsModel.addElement(action);
        }
    }

    private void apply() {
        if (this.autoApply) {
            CustomActionMapping mapping = this.getSelectedMapping();
            if (mapping.getName().startsWith("custom-")) {
                mapping.setDisplayName(this.tfLabel.getText());
            }
            mapping.setArgs(this.taArgs.getText());
            mapping.setReloadRule(ActionMapping.ReloadRule.valueOf(this.cbReloadRule.getSelectedItem().toString()));
            mapping.setRepeatable(this.cbRepeatable.isSelected());
            this.actionRegistry.registerCustomAction(mapping);
            this.lsActions.repaint();
        }
    }

    private void cbRepeatableStateChanged(ChangeEvent evt) {
        this.apply();
    }

    private void cbReloadRuleItemStateChanged(ItemEvent evt) {
        this.apply();
    }

    private void cbAddActionPerformed(ActionEvent evt) {
        if (!this.comboReady) {
            return;
        }
        String action = this.availableActionsModel.getElementAt(this.cbAdd.getSelectedIndex());
        if (action != CUSTOM_ACTION) {
            this.availableActionsModel.removeElement(action);
        } else {
            action = this.actionRegistry.findNewCustonActionId();
        }
        ProjectActionMappingProvider mappingProvider = (ProjectActionMappingProvider)this.project.getLookup().lookup(ProjectActionMappingProvider.class);
        ActionMapping defaultMapping = mappingProvider.findMapping(action);
        CustomActionMapping mapping = defaultMapping != null ? new CustomActionMapping(defaultMapping) : new CustomActionMapping(action);
        this.customActionsModel.addElement(mapping);
        this.actionRegistry.registerCustomAction(mapping);
        this.lsActions.setSelectedIndex(this.customActionsModel.indexOf(mapping));
        this.cbAdd.setSelectedIndex(0);
    }

    private CustomActionMapping getSelectedMapping() {
        int index = this.lsActions.getSelectedIndex();
        return index >= 0 ? this.customActionsModel.elementAt(index) : null;
    }

    void save() {
        this.actionRegistry.save();
    }

    static class MyListCellRenderer
    extends DefaultListCellRenderer {
        MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof CustomActionMapping) {
                CustomActionMapping mapping = (CustomActionMapping)value;
                String displayName = mapping.getDisplayName();
                if (mapping.getArgs().contains("${input:")) {
                    displayName = displayName + "...";
                }
                label.setText(mapping.isChanged() ? "<html><b>" + displayName + "</b>" : displayName);
            }
            return label;
        }
    }
}

