/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.source;

import com.sun.jdi.StringReference;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.truffle.source.SourceBinaryTranslator;
import org.netbeans.modules.debugger.jpda.truffle.source.SourceFilesCache;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class Source {
    public static final String URL_PROTOCOL = "truffle-scripts";
    static final String ATTR_URI = "com.oracle.truffle InternalURI";
    private static final Map<JPDADebugger, Map<Long, Source>> KNOWN_SOURCES = new WeakHashMap<JPDADebugger, Map<Long, Source>>();
    private final StringReference codeRef;
    private final String name;
    private final String hostMethodName;
    private final String path;
    private final URI uri;
    private final URL url;
    private final String mimeType;
    private final long hash;
    private String content;

    private Source(JPDADebugger jpda, String name, String hostMethodName, String path, URI uri, String mimeType, long hash, StringReference codeRef) {
        this.name = name;
        this.hostMethodName = hostMethodName;
        this.path = path;
        this.codeRef = codeRef;
        URL url = null;
        if (hostMethodName == null) {
            if (uri == null || !"file".equalsIgnoreCase(uri.getScheme())) {
                try {
                    url = SourceFilesCache.get(jpda).getSourceFile(name, hash, uri, this.getContent());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                uri = SourceBinaryTranslator.binary2Source(uri);
            }
            if (url == null) {
                try {
                    url = uri.toURL();
                }
                catch (MalformedURLException muex) {
                    Exceptions.printStackTrace((Throwable)muex);
                }
            }
        }
        this.url = url;
        this.uri = uri;
        this.mimeType = mimeType;
        this.hash = hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Source getExistingSource(JPDADebugger debugger, long id) {
        Map<JPDADebugger, Map<Long, Source>> map = KNOWN_SOURCES;
        synchronized (map) {
            Source src;
            Map<Long, Source> dbgSources = KNOWN_SOURCES.get(debugger);
            if (dbgSources != null && (src = dbgSources.get(id)) != null) {
                return src;
            }
        }
        return null;
    }

    public static URI getTruffleInternalURI(FileObject fo) {
        return (URI)fo.getAttribute(ATTR_URI);
    }

    public static Source getSource(JPDADebugger debugger, long id, String name, String path, URI uri, StringReference codeRef) {
        return Source.getSource(debugger, id, name, path, uri, null, codeRef);
    }

    public static Source getSource(JPDADebugger debugger, long id, String name, String path, URI uri, String mimeType, StringReference codeRef) {
        return Source.getSource(debugger, id, name, null, path, uri, null, codeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Source getSource(JPDADebugger debugger, long id, String name, String hostMethodName, String path, URI uri, String mimeType, StringReference codeRef) {
        Map<JPDADebugger, Map<Long, Source>> map = KNOWN_SOURCES;
        synchronized (map) {
            Source src;
            Map<Long, Source> dbgSources = KNOWN_SOURCES.get(debugger);
            if (dbgSources != null && (src = dbgSources.get(id)) != null) {
                return src;
            }
        }
        return Source.getTheSource(debugger, id, name, hostMethodName, path, uri, mimeType, codeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Source getTheSource(JPDADebugger debugger, long id, String name, String hostMethodName, String path, URI uri, String mimeType, StringReference codeRef) {
        Source src = new Source(debugger, name, hostMethodName, path, uri, mimeType, id, codeRef);
        if (id >= 0L) {
            Map<JPDADebugger, Map<Long, Source>> map = KNOWN_SOURCES;
            synchronized (map) {
                Map<Long, Source> dbgSources = KNOWN_SOURCES.get(debugger);
                if (dbgSources == null) {
                    dbgSources = new HashMap<Long, Source>();
                    KNOWN_SOURCES.put(debugger, dbgSources);
                }
                dbgSources.put(id, src);
            }
        }
        return src;
    }

    public String getName() {
        return this.name;
    }

    public String getHostMethodName() {
        return this.hostMethodName;
    }

    public String getPath() {
        return this.path;
    }

    public URL getUrl() {
        return this.url;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getHash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() {
        Source source = this;
        synchronized (source) {
            if (this.content == null) {
                try {
                    this.content = StringReferenceWrapper.value((StringReference)this.codeRef);
                }
                catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                    this.content = ex.getLocalizedMessage();
                }
            }
            return this.content;
        }
    }
}

