/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.spi;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.glassfish.pfl.basic.func.UnaryFunction;
import org.glassfish.pfl.objectweb.asm.ClassAdapter;
import org.glassfish.pfl.objectweb.asm.ClassReader;
import org.glassfish.pfl.objectweb.asm.ClassVisitor;
import org.glassfish.pfl.objectweb.asm.ClassWriter;
import org.glassfish.pfl.objectweb.asm.MethodVisitor;
import org.glassfish.pfl.objectweb.asm.Type;
import org.glassfish.pfl.objectweb.asm.tree.LocalVariableNode;
import org.glassfish.pfl.objectweb.asm.tree.MethodInsnNode;
import org.glassfish.pfl.objectweb.asm.tree.MethodNode;
import org.glassfish.pfl.objectweb.asm.util.AbstractVisitor;
import org.glassfish.pfl.objectweb.asm.util.CheckClassAdapter;
import org.glassfish.pfl.tf.spi.MethodMonitor;
import org.glassfish.pfl.tf.spi.TraceEnhancementException;

public class Util {
    private final boolean debug;
    private final int verbose;

    public Util(boolean debug, int verbose) {
        this.debug = debug;
        this.verbose = debug && verbose < 1 ? 1 : verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void info(int level, String str) {
        if (this.verbose >= level) {
            String format = level > 1 ? "%" + (4 * (level - 1) + 1) + "s" : "%s";
            String pad = String.format(format, ">");
            this.msg(pad + str);
        }
    }

    public void msg(String str) {
        System.out.println(str);
    }

    public void error(String str) {
        throw new RuntimeException(str);
    }

    public void initLocal(MethodVisitor mv, LocalVariableNode var) {
        this.info(2, "Initializing variable " + var);
        Type type = Type.getType((String)var.desc);
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(3);
                mv.visitVarInsn(54, var.index);
                break;
            }
            case 7: {
                mv.visitInsn(9);
                mv.visitVarInsn(55, var.index);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                mv.visitVarInsn(56, var.index);
                break;
            }
            case 8: {
                mv.visitInsn(14);
                mv.visitVarInsn(57, var.index);
                break;
            }
            default: {
                mv.visitInsn(1);
                mv.visitVarInsn(58, var.index);
            }
        }
    }

    public String getFullMethodDescriptor(String name, String desc) {
        return name + desc;
    }

    public String getFullMethodDescriptor(MethodNode mn) {
        return mn.name + mn.desc;
    }

    public String getFullMethodDescriptor(MethodInsnNode mn) {
        return mn.name + mn.desc;
    }

    public String getFullMethodDescriptor(Method method) {
        String desc = Type.getMethodDescriptor((Method)method);
        return method.getName() + desc;
    }

    public void newWithSimpleConstructor(MethodVisitor mv, Class<?> cls) {
        this.info(2, "generating new for class " + cls);
        Type type = Type.getType(cls);
        mv.visitTypeInsn(187, type.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, type.getInternalName(), "<init>", "()V");
    }

    public String augmentInfoMethodDescriptor(String desc) {
        this.info(2, "Augmenting infoMethod descriptor " + desc);
        Type[] oldArgTypes = Type.getArgumentTypes((String)desc);
        Type retType = Type.getReturnType((String)desc);
        int oldlen = oldArgTypes.length;
        Type[] argTypes = new Type[oldlen + 2];
        System.arraycopy(oldArgTypes, 0, argTypes, 0, oldlen);
        argTypes[oldlen] = Type.getType(MethodMonitor.class);
        argTypes[oldlen + 1] = Type.INT_TYPE;
        String newDesc = Type.getMethodDescriptor((Type)retType, (Type[])argTypes);
        this.info(3, "result is " + newDesc);
        return newDesc;
    }

    public void emitIntConstant(MethodVisitor mv, int val) {
        this.info(2, "Emitting constant " + val);
        if (val <= 5) {
            switch (val) {
                case 0: {
                    mv.visitInsn(3);
                    break;
                }
                case 1: {
                    mv.visitInsn(4);
                    break;
                }
                case 2: {
                    mv.visitInsn(5);
                    break;
                }
                case 3: {
                    mv.visitInsn(6);
                    break;
                }
                case 4: {
                    mv.visitInsn(7);
                    break;
                }
                case 5: {
                    mv.visitInsn(8);
                }
            }
        } else {
            mv.visitLdcInsn((Object)val);
        }
    }

    public int wrapArg(MethodVisitor mv, int argIndex, Type atype) {
        this.info(2, "Emitting code to wrap argument at " + argIndex + " of type " + atype);
        switch (atype.getSort()) {
            case 1: {
                mv.visitVarInsn(21, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Boolean.class), "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 3: {
                mv.visitVarInsn(21, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Byte.class), "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 2: {
                mv.visitVarInsn(21, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Character.class), "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 4: {
                mv.visitVarInsn(21, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Short.class), "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 5: {
                mv.visitVarInsn(21, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 7: {
                mv.visitVarInsn(22, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Long.class), "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 8: {
                mv.visitVarInsn(24, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            case 6: {
                mv.visitVarInsn(23, argIndex);
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            default: {
                mv.visitVarInsn(25, argIndex);
            }
        }
        return argIndex + atype.getSize();
    }

    public void wrapArgs(MethodVisitor mv, int access, String desc) {
        this.info(2, "Wrapping args for descriptor " + desc);
        Type[] atypes = Type.getArgumentTypes((String)desc);
        this.emitIntConstant(mv, atypes.length);
        mv.visitTypeInsn(189, "java/lang/Object");
        int argIndex = (access & 8) == 8 ? 0 : 1;
        for (int ctr = 0; ctr < atypes.length; ++ctr) {
            mv.visitInsn(89);
            this.emitIntConstant(mv, ctr);
            argIndex = this.wrapArg(mv, argIndex, atypes[ctr]);
            mv.visitInsn(83);
        }
    }

    public void storeFromXReturn(MethodVisitor mv, int returnOpcode, LocalVariableNode holder) {
        switch (returnOpcode) {
            case 177: {
                break;
            }
            case 176: {
                mv.visitVarInsn(58, holder.index);
                break;
            }
            case 172: {
                mv.visitVarInsn(54, holder.index);
                break;
            }
            case 173: {
                mv.visitVarInsn(55, holder.index);
                break;
            }
            case 174: {
                mv.visitVarInsn(56, holder.index);
                break;
            }
            case 175: {
                mv.visitVarInsn(57, holder.index);
            }
        }
    }

    public void loadFromXReturn(MethodVisitor mv, int returnOpcode, LocalVariableNode holder) {
        switch (returnOpcode) {
            case 177: {
                break;
            }
            case 176: {
                mv.visitVarInsn(25, holder.index);
                break;
            }
            case 172: {
                mv.visitVarInsn(21, holder.index);
                break;
            }
            case 173: {
                mv.visitVarInsn(22, holder.index);
                break;
            }
            case 174: {
                mv.visitVarInsn(23, holder.index);
                break;
            }
            case 175: {
                mv.visitVarInsn(24, holder.index);
            }
        }
    }

    private void verify(byte[] cls) {
        if (this.getDebug()) {
            this.info(2, "Verifying enhanced class");
            ClassReader cr = new ClassReader(cls);
            PrintWriter pw = new PrintWriter(System.out);
            CheckClassAdapter.verify((ClassReader)cr, (boolean)true, (PrintWriter)pw);
        }
    }

    public boolean hasAccess(int access, int flag) {
        return (access & flag) == flag;
    }

    public static String opcodeToString(int opcode) {
        String[] opcodes = AbstractVisitor.OPCODES;
        if (opcode < 0 || opcode > opcodes.length) {
            return "ILLEGAL[" + opcode + "]";
        }
        return opcodes[opcode];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(boolean debug, byte[] cls, UnaryFunction<ClassVisitor, ClassAdapter> factory) {
        ClassReader cr = new ClassReader(cls);
        ClassWriter cw = new ClassWriter(1);
        PrintWriter pw = null;
        ClassWriter cv = cw;
        if (debug) {
            pw = new PrintWriter(System.out);
        }
        ClassAdapter xform = factory.evaluate((ClassVisitor)cv);
        try {
            cr.accept((ClassVisitor)xform, 4);
        }
        catch (TraceEnhancementException exc) {
            throw exc;
        }
        catch (Exception exc) {
            this.info(1, "Exception: " + exc);
            if (debug) {
                exc.printStackTrace();
            }
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
        byte[] enhancedClass = cw.toByteArray();
        this.verify(enhancedClass);
        return enhancedClass;
    }
}

