/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.php.dbgp.Bundle;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConnectionErrMessage
extends JPanel {
    private static final long serialVersionUID = -2227584113811663220L;
    private final String message;
    private static final String NEWLINE = System.getProperty("line.separator");
    private JLabel copySettingsLabel;
    private JButton copySettingsXdebug2Button;
    private JButton copySettingsXdebug3Button;
    private JLabel debuggerPortOptionLabel;
    private JLabel emptyLabel;
    private JLabel informationLabel;
    private JLabel learnMoreLabel;
    private JLabel messageTextLabel;
    private JLabel noteLabel;
    private JLabel optionsLabel;

    public static void showMe(int seconds) {
        ConnectionErrMessage panel = new ConnectionErrMessage(seconds);
        NotifyDescriptor.Message messageDescriptor = new NotifyDescriptor.Message((Object)"");
        DialogDescriptor descr2 = new DialogDescriptor((Object)panel, messageDescriptor.getTitle(), true, new Object[]{DialogDescriptor.OK_OPTION}, null, 0, null, null);
        DialogDisplayer.getDefault().createDialog(descr2).setVisible(true);
    }

    private ConnectionErrMessage(int seconds) {
        this.message = ConnectionErrMessage.createMessage(seconds);
        this.initComponents();
        this.emptyLabel.setText(" ");
    }

    private static String createMessage(int seconds) {
        String debuggerPort = String.valueOf(PhpOptions.getInstance().getDebuggerPort());
        String xdebugIdekey = String.format("xdebug.idekey=\"%s\"", PhpOptions.getInstance().getDebuggerSessionId());
        StringBuilder sb = new StringBuilder();
        sb.append("<h4>Xdebug 2</h4>");
        sb.append("<ul>");
        sb.append("<li>").append("xdebug.remote_enable=on").append("</li>");
        sb.append("<li>").append("xdebug.remote_handler=dbgp").append("</li>");
        sb.append("<li>").append(Bundle.ConnectionErrMessage_xdebug_remote_host()).append("</li>");
        sb.append("<li>").append(Bundle.ConnectionErrMessage_xdebug_remote_port(debuggerPort)).append("</li>");
        sb.append("<li>").append(xdebugIdekey).append("</li>");
        sb.append("</ul>");
        sb.append("<h4>Xdebug 3</h4>");
        sb.append("<ul>");
        sb.append("<li>").append("xdebug.mode=debug").append("</li>");
        sb.append("<li>").append(Bundle.ConnectionErrMessage_xdebug_client_host()).append("</li>");
        sb.append("<li>").append(Bundle.ConnectionErrMessage_xdebug_client_port(debuggerPort)).append("</li>");
        sb.append("<li>").append(xdebugIdekey).append("</li>");
        sb.append("</ul>");
        return "<html>" + NbBundle.getMessage(ConnectionErrMessage.class, (String)"MSG_ErrDebugSession", (Object)seconds, (Object)sb.toString()) + "</html>";
    }

    private void initComponents() {
        this.messageTextLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.debuggerPortOptionLabel = new JLabel();
        this.optionsLabel = new JLabel();
        this.informationLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.emptyLabel = new JLabel();
        this.copySettingsLabel = new JLabel();
        this.copySettingsXdebug2Button = new JButton();
        this.copySettingsXdebug3Button = new JButton();
        this.messageTextLabel.setText(this.message);
        this.noteLabel.setText("<html><i>Note:</i></html>");
        this.debuggerPortOptionLabel.setText("<html>If you use Xdebug 2 with default port, please set 9000 to the Debugger Port option.</html>");
        this.optionsLabel.setText("<html><a href=\"#\">Options...</a></html>");
        this.optionsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ConnectionErrMessage.this.optionsLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ConnectionErrMessage.this.optionsLabelMouseEntered(evt);
            }
        });
        this.informationLabel.setText("<html><a href=\"#\">More information about Xdebug2 installation/configuration</a>");
        this.informationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ConnectionErrMessage.this.informationLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ConnectionErrMessage.this.informationLabelMouseEntered(evt);
            }
        });
        this.learnMoreLabel.setText("<html><a href=\"#\">Learn more about Xdebug</a>");
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ConnectionErrMessage.this.learnMoreLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ConnectionErrMessage.this.learnMoreLabelMouseEntered(evt);
            }
        });
        this.emptyLabel.setText("EMPTY");
        this.copySettingsLabel.setText("Copy example settings to clipboard:");
        this.copySettingsXdebug2Button.setText("Xdebug 2");
        this.copySettingsXdebug2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionErrMessage.this.copySettingsXdebug2ButtonActionPerformed(evt);
            }
        });
        this.copySettingsXdebug3Button.setText("Xdebug 3");
        this.copySettingsXdebug3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionErrMessage.this.copySettingsXdebug3ButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.optionsLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.informationLabel, -2, -1, -2).addComponent(this.learnMoreLabel, -2, -1, -2).addComponent(this.emptyLabel).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.debuggerPortOptionLabel, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageTextLabel, -2, 550, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.copySettingsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copySettingsXdebug2Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copySettingsXdebug3Button))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageTextLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copySettingsLabel).addComponent(this.copySettingsXdebug2Button).addComponent(this.copySettingsXdebug3Button)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.noteLabel, -2, -1, -2).addGap(7, 7, 7).addComponent(this.debuggerPortOptionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.informationLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.emptyLabel).addContainerGap()));
        this.messageTextLabel.getAccessibleContext().setAccessibleDescription("Error Message");
        this.getAccessibleContext().setAccessibleName("Error Message Form");
        this.getAccessibleContext().setAccessibleDescription("Error Message Form");
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        this.setHandCursor(evt);
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        this.showUrl("https://xdebug.org/docs");
    }

    private void informationLabelMouseEntered(MouseEvent evt) {
        this.setHandCursor(evt);
    }

    private void informationLabelMousePressed(MouseEvent evt) {
        this.showUrl("http://wiki.netbeans.org/HowToConfigureXDebug");
    }

    private void optionsLabelMouseEntered(MouseEvent evt) {
        this.setHandCursor(evt);
    }

    private void optionsLabelMousePressed(MouseEvent evt) {
        Utils.openPhpOptionsDialog();
    }

    private void copySettingsXdebug2ButtonActionPerformed(ActionEvent evt) {
        this.copySettings(this.createXdebug2Settings());
    }

    private void copySettingsXdebug3ButtonActionPerformed(ActionEvent evt) {
        this.copySettings(this.createXdebug3Settings());
    }

    private void showUrl(String url) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(url));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void setHandCursor(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void copySettings(String settings) {
        this.copyToClipboard(settings);
        this.showDialog(Bundle.ConnectionErrMessage_copied(settings));
    }

    private void copyToClipboard(String contents) {
        StringSelection selection = new StringSelection(contents);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    private void showDialog(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
    }

    private String createXdebug2Settings() {
        StringBuilder sb = new StringBuilder();
        sb.append("xdebug.remote_enable=on").append(NEWLINE);
        sb.append("xdebug.remote_handler=dbgp").append(NEWLINE);
        sb.append("xdebug.client_port=localhost").append(NEWLINE);
        sb.append("xdebug.remote_port=").append(String.valueOf(PhpOptions.getInstance().getDebuggerPort())).append(NEWLINE);
        sb.append(String.format("xdebug.idekey=\"%s\"", PhpOptions.getInstance().getDebuggerSessionId()));
        return sb.toString();
    }

    private String createXdebug3Settings() {
        StringBuilder sb = new StringBuilder();
        sb.append("xdebug.mode=debug").append(NEWLINE);
        sb.append("xdebug.client_host=localhost").append(NEWLINE);
        sb.append("xdebug.client_port=").append(String.valueOf(PhpOptions.getInstance().getDebuggerPort())).append(NEWLINE);
        sb.append(String.format("xdebug.idekey=\"%s\"", PhpOptions.getInstance().getDebuggerSessionId()));
        return sb.toString();
    }
}

