/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

public class MicronautConfigUtilities {
    public static ConfigurationMetadataProperty resolveProperty(Document doc, final int offset, final int[] span, final List<ConfigurationMetadataSource> sources) {
        Project project;
        FileObject fo;
        final LineDocument lineDocument = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
        if (lineDocument != null && (fo = EditorDocumentUtils.getFileObject((Document)doc)) != null && "application.yml".equalsIgnoreCase(fo.getNameExt()) && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project)) {
            try {
                int idx;
                int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)offset);
                String text = lineDocument.getText(lineStart, offset - lineStart);
                if (!text.contains("#") && (idx = text.indexOf(58)) < 0) {
                    final ConfigurationMetadataProperty[] property = new ConfigurationMetadataProperty[]{null};
                    ParserManager.parse(Collections.singleton(Source.create((Document)lineDocument)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            List structures;
                            List context;
                            StructureScanner scanner;
                            Language language;
                            Parser.Result r = resultIterator.getParserResult();
                            if (r instanceof ParserResult && (language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null && !(context = MicronautConfigUtilities.getContext(structures = scanner.scan((ParserResult)r), offset)).isEmpty()) {
                                StructureItem item = (StructureItem)context.get(context.size() - 1);
                                int start = (int)item.getPosition();
                                int end = (int)item.getPosition() + item.getName().length();
                                if (span != null && span.length == 2) {
                                    span[0] = start;
                                    span[1] = end;
                                }
                                if (start <= offset && offset <= end && item.getName().equals(lineDocument.getText(start, end - start))) {
                                    String propertyName = MicronautConfigUtilities.getPropertyName(context);
                                    for (Map.Entry<String, ConfigurationMetadataGroup> groupEntry : MicronautConfigProperties.getGroups(project).entrySet()) {
                                        String groupKey = groupEntry.getKey();
                                        if (!Pattern.matches(groupKey.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\w*") + ".*", propertyName)) continue;
                                        ConfigurationMetadataGroup group = groupEntry.getValue();
                                        for (Map.Entry<String, ConfigurationMetadataProperty> propertyEntry : group.getProperties().entrySet()) {
                                            String propertyKey = propertyEntry.getKey();
                                            if (!Pattern.matches(propertyKey.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\\\w*"), propertyName)) continue;
                                            property[0] = propertyEntry.getValue();
                                            if (sources == null) continue;
                                            sources.addAll(group.getSources().values());
                                        }
                                    }
                                }
                            }
                        }
                    });
                    return property[0];
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static void collectUsages(final FileObject fo, final String propertyName, final Consumer<Usage> consumer) {
        try {
            ParserManager.parse(Collections.singleton(Source.create((FileObject)fo)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    StructureScanner scanner;
                    Language language;
                    Parser.Result r = resultIterator.getParserResult();
                    if (r instanceof ParserResult && (language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType())) != null && (scanner = language.getStructure()) != null) {
                        MicronautConfigUtilities.find(fo, propertyName, scanner.scan((ParserResult)r), r.getSnapshot().getText(), consumer);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void find(FileObject fo, String propertyName, List<? extends StructureItem> structures, CharSequence content, Consumer<Usage> consumer) {
        int idx = propertyName.indexOf(46);
        String name = idx < 0 ? propertyName : propertyName.substring(0, idx);
        for (StructureItem structureItem : structures) {
            if (!"*".equals(name) && !name.equals(structureItem.getName())) continue;
            if (idx < 0) {
                int start = (int)structureItem.getPosition();
                int end = (int)structureItem.getEndPosition();
                String text = content.subSequence(start, end).toString();
                consumer.accept(new Usage(fo, start, end, text));
                continue;
            }
            MicronautConfigUtilities.find(fo, propertyName.substring(idx + 1), structureItem.getNestedItems(), content, consumer);
        }
    }

    private static List<StructureItem> getContext(List<? extends StructureItem> structure, int offset) {
        ArrayList<StructureItem> context = new ArrayList<StructureItem>();
        block0: while (structure != null && !structure.isEmpty()) {
            for (StructureItem item : structure) {
                if (item.getPosition() > (long)offset || (long)offset > item.getEndPosition()) continue;
                context.add(item);
                structure = item.getNestedItems();
                continue block0;
            }
            structure = null;
        }
        return context;
    }

    private static String getPropertyName(List<? extends StructureItem> context) {
        StringBuilder sb = new StringBuilder();
        for (StructureItem structureItem : context) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(structureItem.getName());
        }
        return sb.toString();
    }

    public static final class Usage {
        private final FileObject fileObject;
        private final int startOffset;
        private final int endOffset;
        private final String text;

        public Usage(FileObject fileObject, int startOffset, int endOffset, String text) {
            this.fileObject = fileObject;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.text = text;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getText() {
            return this.text;
        }
    }
}

