/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.javascript2.requirejs.Bundle;
import org.netbeans.modules.javascript2.requirejs.ConfigOption;
import org.openide.modules.Places;
import org.openide.util.RequestProcessor;

public class RequireJsDataProvider {
    private static final Logger LOG = Logger.getLogger(RequireJsDataProvider.class.getSimpleName());
    private static RequestProcessor RP = new RequestProcessor(RequireJsDataProvider.class);
    private static RequireJsDataProvider INSTANCE;
    private boolean loadingStarted = false;
    private ProgressHandle progress;
    private static final String CACHE_FOLDER_NAME = "requirejs-doc";
    private static final String API_FILE = "api.html";
    public static final String API_URL = "http://requirejs.org/docs/api.html";
    private static final int URL_CONNECTION_TIMEOUT = 1000;
    private static final int URL_READ_TIMEOUT = 3000;
    private static final String SEARCH_TEXT = "<p id=\"config-";
    private static final HashMap<String, String> TRANSLATE_NAME;

    private RequireJsDataProvider() {
    }

    public static synchronized RequireJsDataProvider getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new RequireJsDataProvider();
        }
        return INSTANCE;
    }

    public Collection<String> getConfigurationOptions() {
        Collection<String> options = this.getConfigurationOptionsFromDoc();
        if (options.isEmpty()) {
            options = this.getConfigurationOptionsStatic();
        }
        return options;
    }

    public String getDocForHtmlTagAttribute(String attributeName) {
        int end;
        String tmpText;
        String searchText;
        int start;
        String api = this.getContentApiFile();
        if (api != null && (start = api.indexOf(searchText = "href=\"#" + attributeName + "\" name=\"" + attributeName + "\"")) > 0 && (start = (tmpText = api.substring(0, start)).lastIndexOf("<h3>")) < (end = api.indexOf("<h3>", start + 10))) {
            return api.substring(start, end);
        }
        return "";
    }

    public String getDocFocOption(String name) {
        String api = this.getContentApiFile();
        if (api != null) {
            int index = api.indexOf(SEARCH_TEXT + name);
            if (index == -1 && TRANSLATE_NAME.containsValue(name)) {
                for (Map.Entry<String, String> entry : TRANSLATE_NAME.entrySet()) {
                    if (!entry.getValue().equals(name)) continue;
                    index = api.indexOf(SEARCH_TEXT + entry.getKey());
                    break;
                }
            }
            if (index > 0) {
                int start = index;
                if ((index = api.indexOf(SEARCH_TEXT, start + SEARCH_TEXT.length())) == -1) {
                    index = api.indexOf("</div>", start + SEARCH_TEXT.length());
                }
                if (index > 0) {
                    return api.substring(start, index);
                }
            }
        }
        return Bundle.doc_notFound();
    }

    private void startLoading() {
        LOG.fine("start loading doc");
        this.progress = ProgressHandle.createHandle((String)Bundle.doc_building());
        this.progress.start(1);
    }

    private Collection<String> getConfigurationOptionsFromDoc() {
        ArrayList<String> result = new ArrayList<String>();
        String api = this.getContentApiFile();
        if (api != null) {
            int index = api.indexOf(SEARCH_TEXT);
            while (index > 0) {
                int start = index + SEARCH_TEXT.length();
                String option = api.substring(start, index = api.indexOf(34, start));
                if (TRANSLATE_NAME.containsKey(option)) {
                    option = TRANSLATE_NAME.get(option);
                }
                if (option != null && !option.isEmpty()) {
                    result.add(option);
                }
                index = api.indexOf(SEARCH_TEXT, index);
            }
        }
        return result;
    }

    public static File getCachedAPIFile() {
        String pathFile = CACHE_FOLDER_NAME + '/' + API_FILE;
        File cacheFile = Places.getCacheSubfile((String)pathFile);
        return cacheFile;
    }

    private String getContentApiFile() {
        String result = null;
        try {
            File cacheFile = RequireJsDataProvider.getCachedAPIFile();
            if (!cacheFile.exists()) {
                if (!this.loadingStarted) {
                    this.loadingStarted = true;
                    this.startLoading();
                }
                this.loadDoc(cacheFile);
                if (this.progress != null) {
                    this.progress.progress(1);
                    this.progress.finish();
                    this.progress = null;
                }
                LOG.log(Level.FINE, "Loading doc finished.");
            }
            result = this.getFileContent(cacheFile);
        }
        catch (IOException | URISyntaxException ex) {
            this.loadingStarted = false;
            if (this.progress != null) {
                this.progress.finish();
                this.progress = null;
            }
            LOG.log(Level.INFO, "Cannot load RequireJS documentation from \"{0}\".", new Object[]{API_URL});
            LOG.log(Level.INFO, "", ex);
        }
        return result;
    }

    private Collection<String> getConfigurationOptionsStatic() {
        ArrayList<String> known = new ArrayList<String>();
        for (ConfigOption option : ConfigOption.values()) {
            known.add(option.getName());
        }
        return known;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadDoc(File cacheFile) throws URISyntaxException, MalformedURLException, IOException {
        LOG.fine("start loading doc");
        URL url = new URI(API_URL).toURL();
        File file = cacheFile;
        synchronized (file) {
            String tmpFileName = cacheFile.getAbsolutePath() + ".tmp";
            File tmpFile = new File(tmpFileName);
            try {
                boolean success;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8");){
                    this.loadURL(url, writer, Charset.forName("UTF-8"));
                    ((Writer)writer).close();
                    boolean success2 = tmpFile.renameTo(cacheFile);
                    if (!success2) {
                        LOG.log(Level.WARNING, "Renaming {0} to {1] was not successful.", new Object[]{tmpFile.getAbsolutePath(), cacheFile.getAbsolutePath()});
                    }
                }
                if (!tmpFile.exists() || (success = tmpFile.delete())) return;
            }
            catch (Throwable throwable) {
                boolean success;
                if (!tmpFile.exists() || (success = tmpFile.delete())) throw throwable;
                LOG.log(Level.WARNING, "Deleting {0} faild.", new Object[]{tmpFile.getAbsolutePath()});
                throw throwable;
            }
            LOG.log(Level.WARNING, "Deleting {0} faild.", new Object[]{tmpFile.getAbsolutePath()});
            {
            }
            return;
        }
    }

    private void loadURL(URL url, Writer writer, Charset charset) throws IOException {
        int read;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        URLConnection con = url.openConnection();
        con.setConnectTimeout(1000);
        con.setReadTimeout(3000);
        con.connect();
        InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(con.getInputStream()), charset);
        char[] buf = new char[2048];
        while ((read = r.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        ((Reader)r).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            int read;
            char[] buf = new char[2048];
            while ((read = r.read(buf)) != -1) {
                sb.append(buf, 0, read);
            }
        }
        return sb.toString();
    }

    static {
        TRANSLATE_NAME = new HashMap();
        TRANSLATE_NAME.put("moduleconfig", "config");
        TRANSLATE_NAME.put("map-notes", "");
    }
}

