/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jdk.jshell.Snippet;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.support.ShellHistory;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;

public class HistoryCompletionProvider
implements CompletionProvider {
    private static final int PRIORITY_SAVED = 2000;
    private static final int PRIORITY_CURRENT = 1000;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static int isFirstJavaLine(JTextComponent component) {
        ShellSession s = ShellSession.get(component.getDocument());
        if (s == null) {
            return -1;
        }
        ConsoleSection sec = s.getModel().getInputSection();
        if (sec == null) {
            return -1;
        }
        LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)component.getDocument(), LineDocument.class);
        if (ld == null) {
            return -1;
        }
        int off = sec.getStart();
        int caret = component.getCaretPosition();
        int s1 = LineDocumentUtils.getLineStart((LineDocument)ld, (int)caret);
        int s2 = LineDocumentUtils.getLineStart((LineDocument)ld, (int)off);
        try {
            return s1 == s2 ? component.getDocument().getText(sec.getPartBegin(), sec.getPartLen()).trim().length() : -1;
        }
        catch (BadLocationException ex) {
            return 0;
        }
    }

    static ShellSession checkInputSection(JTextComponent component) {
        Document doc = component.getDocument();
        ShellSession session = ShellSession.get(doc);
        if (session == null) {
            return null;
        }
        ConsoleModel model = session.getModel();
        if (model == null) {
            return null;
        }
        ConsoleSection is = model.getInputSection();
        if (is == null) {
            return null;
        }
        LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
        if (ld == null) {
            return null;
        }
        int caret = component.getCaretPosition();
        int lineStart = is.getPartBegin();
        try {
            int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)ld, (int)caret);
            if (caret < lineStart || caret > lineEnd) {
                return null;
            }
        }
        catch (BadLocationException ex) {
            return null;
        }
        return session;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        int a = HistoryCompletionProvider.isFirstJavaLine(component);
        if (queryType != 9 && (queryType != 1 || a != 0)) {
            return null;
        }
        ShellSession session = HistoryCompletionProvider.checkInputSection(component);
        if (session == null) {
            return null;
        }
        return new AsyncCompletionTask((AsyncCompletionQuery)new T(session, session.getModel(), session.getModel().getInputSection()), component);
    }

    private static class ItemImpl
    implements CompletionItem {
        private final int index;
        private final String text;
        private final boolean saved;
        private final Snippet.Kind kind;
        private final boolean command;
        private static final String ICON_BASE = "org/netbeans/modules/jshell/resources/history_";

        public ItemImpl(boolean saved, int index, Snippet.Kind kind, boolean command, String text) {
            this.index = index;
            this.text = text;
            this.saved = saved;
            this.command = command;
            this.kind = kind;
        }

        private String getLeftText() {
            return this.text;
        }

        private String getRightText() {
            return Bundle.History_ItemIndex_html(this.index);
        }

        public void defaultAction(JTextComponent component) {
            int last;
            if (component == null) {
                return;
            }
            for (last = this.text.length() - 1; last > 0 && Character.isWhitespace(this.text.charAt(last)); --last) {
            }
            if (last < 0) {
                Completion.get().hideAll();
                return;
            }
            Document d = component.getDocument();
            ShellSession s = ShellSession.get(d);
            if (s == null) {
                Completion.get().hideAll();
                return;
            }
            ConsoleModel mdl = s.getModel();
            ConsoleSection is = mdl.getInputSection();
            int from = is.getPartBegin();
            int l = last + 1;
            AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)d, AtomicLockDocument.class);
            ald.runAtomicAsUser(() -> {
                try {
                    d.remove(from, d.getLength() - from);
                    d.insertString(from, this.text.substring(0, l), null);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            });
            Completion.get().hideAll();
        }

        public void processKeyEvent(KeyEvent evt) {
        }

        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont);
        }

        private ImageIcon getIcon() {
            String baseName;
            if (this.command) {
                baseName = "command";
            } else {
                switch (this.kind) {
                    case VAR: 
                    case EXPRESSION: 
                    case IMPORT: 
                    case METHOD: 
                    case TYPE_DECL: 
                    case STATEMENT: {
                        baseName = this.kind.name().toLowerCase();
                        break;
                    }
                    default: {
                        baseName = "item";
                    }
                }
            }
            return ImageUtilities.loadImageIcon((String)(ICON_BASE + baseName + ".png"), (boolean)true);
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            ImageIcon icon = this.getIcon();
            CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public int getSortPriority() {
            return this.saved ? 2000 : 1000;
        }

        public CharSequence getSortText() {
            return Integer.toString(1000 - this.index);
        }

        public CharSequence getInsertPrefix() {
            return "";
        }
    }

    private static class T
    extends AsyncCompletionQuery {
        private ConsoleContents contents;
        private final ShellSession session;
        private final ConsoleModel model;
        private final ConsoleSection input;
        private int counter = 1;

        public T(ShellSession session, ConsoleModel model, ConsoleSection input) {
            this.session = session;
            this.model = model;
            this.input = input;
        }

        private CompletionItem createHistoryItem(ShellHistory.Item item) {
            return this.createCompletionItem(item, true);
        }

        private CompletionItem createCurrentItem(ShellHistory.Item item) {
            return this.createCompletionItem(item, false);
        }

        private CompletionItem createCompletionItem(ShellHistory.Item item, boolean saved) {
            return new ItemImpl(saved, this.counter++, item.getKind(), item.isShellCommand(), item.getContents());
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (this.model.getDocument() != doc) {
                resultSet.finish();
                return;
            }
            int b = this.input.getPartBegin();
            if (caretOffset < b) {
                resultSet.finish();
                return;
            }
            String prefix = "";
            try {
                prefix = doc.getText(b, caretOffset - b);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            String fPrefix = prefix;
            ShellHistory h = (ShellHistory)this.session.getEnv().getLookup().lookup(ShellHistory.class);
            resultSet.addAllItems((Collection)this.session.historyItems().stream().filter(i -> i.getContents().startsWith(fPrefix)).map(this::createCurrentItem).collect(Collectors.toList()));
            if (h != null) {
                HashSet commands = new HashSet();
                resultSet.addAllItems((Collection)h.getHistory().stream().filter(i -> i.getContents().startsWith(fPrefix) && commands.add(i.getContents())).map(this::createHistoryItem).collect(Collectors.toList()));
            }
            resultSet.finish();
        }
    }
}

