/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.ParserContextBlockNode;
import com.oracle.js.parser.ParserContextBreakableNode;
import com.oracle.js.parser.ParserContextFunctionNode;
import com.oracle.js.parser.ParserContextLabelNode;
import com.oracle.js.parser.ParserContextLoopNode;
import com.oracle.js.parser.ParserContextModuleNode;
import com.oracle.js.parser.ParserContextNode;
import com.oracle.js.parser.ir.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ParserContext {
    private ParserContextNode[] stack = new ParserContextNode[16];
    private int sp = 0;
    private static final int INITIAL_DEPTH = 16;

    ParserContext() {
    }

    public <T extends ParserContextNode> T push(T t) {
        assert (!this.contains(t));
        if (this.sp == this.stack.length) {
            ParserContextNode[] parserContextNodeArray = new ParserContextNode[this.sp * 2];
            System.arraycopy(this.stack, 0, parserContextNodeArray, 0, this.sp);
            this.stack = parserContextNodeArray;
        }
        this.stack[this.sp] = t;
        ++this.sp;
        return t;
    }

    public ParserContextNode peek() {
        return this.stack[this.sp - 1];
    }

    public <T extends ParserContextNode> T pop(T t) {
        --this.sp;
        ParserContextNode parserContextNode = this.stack[this.sp];
        this.stack[this.sp] = null;
        assert (t == parserContextNode);
        return (T)parserContextNode;
    }

    public boolean contains(ParserContextNode parserContextNode) {
        for (int i = 0; i < this.sp; ++i) {
            if (this.stack[i] != parserContextNode) continue;
            return true;
        }
        return false;
    }

    private ParserContextBreakableNode getBreakable() {
        NodeIterator<ParserContextBreakableNode> nodeIterator = new NodeIterator<ParserContextBreakableNode>(ParserContextBreakableNode.class, this.getCurrentFunction());
        while (nodeIterator.hasNext()) {
            ParserContextBreakableNode parserContextBreakableNode = (ParserContextBreakableNode)nodeIterator.next();
            if (!parserContextBreakableNode.isBreakableWithoutLabel()) continue;
            return parserContextBreakableNode;
        }
        return null;
    }

    public ParserContextBreakableNode getBreakable(String string) {
        if (string != null) {
            ParserContextLabelNode parserContextLabelNode = this.findLabel(string);
            if (parserContextLabelNode != null) {
                ParserContextBreakableNode parserContextBreakableNode = null;
                NodeIterator<ParserContextBreakableNode> nodeIterator = new NodeIterator<ParserContextBreakableNode>(ParserContextBreakableNode.class, parserContextLabelNode);
                while (nodeIterator.hasNext()) {
                    parserContextBreakableNode = (ParserContextBreakableNode)nodeIterator.next();
                }
                return parserContextBreakableNode;
            }
            return null;
        }
        return this.getBreakable();
    }

    public ParserContextLoopNode getCurrentLoop() {
        NodeIterator<ParserContextLoopNode> nodeIterator = new NodeIterator<ParserContextLoopNode>(ParserContextLoopNode.class, this.getCurrentFunction());
        return nodeIterator.hasNext() ? (ParserContextLoopNode)nodeIterator.next() : null;
    }

    private ParserContextLoopNode getContinueTo() {
        return this.getCurrentLoop();
    }

    public ParserContextLoopNode getContinueTo(String string) {
        if (string != null) {
            ParserContextLabelNode parserContextLabelNode = this.findLabel(string);
            if (parserContextLabelNode != null) {
                ParserContextLoopNode parserContextLoopNode = null;
                NodeIterator<ParserContextLoopNode> nodeIterator = new NodeIterator<ParserContextLoopNode>(ParserContextLoopNode.class, parserContextLabelNode);
                while (nodeIterator.hasNext()) {
                    parserContextLoopNode = (ParserContextLoopNode)nodeIterator.next();
                }
                return parserContextLoopNode;
            }
            return null;
        }
        return this.getContinueTo();
    }

    public ParserContextBlockNode getFunctionBody(ParserContextFunctionNode parserContextFunctionNode) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.stack[i] != parserContextFunctionNode) continue;
            return (ParserContextBlockNode)this.stack[i + 1];
        }
        throw new AssertionError((Object)(parserContextFunctionNode.getName() + " not on context stack"));
    }

    public ParserContextLabelNode findLabel(String string) {
        NodeIterator<ParserContextLabelNode> nodeIterator = new NodeIterator<ParserContextLabelNode>(ParserContextLabelNode.class, this.getCurrentFunction());
        while (nodeIterator.hasNext()) {
            ParserContextLabelNode parserContextLabelNode = (ParserContextLabelNode)nodeIterator.next();
            if (!parserContextLabelNode.getLabelName().equals(string)) continue;
            return parserContextLabelNode;
        }
        return null;
    }

    public void prependStatementToCurrentNode(Statement statement) {
        assert (statement != null);
        this.stack[this.sp - 1].prependStatement(statement);
    }

    public void appendStatementToCurrentNode(Statement statement) {
        assert (statement != null);
        this.stack[this.sp - 1].appendStatement(statement);
    }

    public ParserContextFunctionNode getCurrentFunction() {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (!(this.stack[i] instanceof ParserContextFunctionNode)) continue;
            return (ParserContextFunctionNode)this.stack[i];
        }
        return null;
    }

    public Iterator<ParserContextBlockNode> getBlocks() {
        return new NodeIterator<ParserContextBlockNode>(ParserContextBlockNode.class);
    }

    public ParserContextBlockNode getCurrentBlock() {
        return this.getBlocks().next();
    }

    public Statement getLastStatement() {
        if (this.sp == 0) {
            return null;
        }
        ParserContextNode parserContextNode = this.stack[this.sp - 1];
        int n = parserContextNode.getStatements().size();
        return n == 0 ? null : parserContextNode.getStatements().get(n - 1);
    }

    public Iterator<ParserContextFunctionNode> getFunctions() {
        return new NodeIterator<ParserContextFunctionNode>(ParserContextFunctionNode.class);
    }

    public ParserContextModuleNode getCurrentModule() {
        NodeIterator<ParserContextModuleNode> nodeIterator = new NodeIterator<ParserContextModuleNode>(ParserContextModuleNode.class, this.getCurrentFunction());
        return nodeIterator.hasNext() ? (ParserContextModuleNode)nodeIterator.next() : null;
    }

    private class NodeIterator<T extends ParserContextNode>
    implements Iterator<T> {
        private int index;
        private T next;
        private final Class<T> clazz;
        private ParserContextNode until;

        NodeIterator(Class<T> clazz) {
            this(clazz, null);
        }

        NodeIterator(Class<T> clazz, ParserContextNode parserContextNode) {
            this.index = ParserContext.this.sp - 1;
            this.clazz = clazz;
            this.until = parserContextNode;
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T t = this.next;
            this.next = this.findNext();
            return t;
        }

        private T findNext() {
            for (int i = this.index; i >= 0; --i) {
                ParserContextNode parserContextNode = ParserContext.this.stack[i];
                if (parserContextNode == this.until) {
                    return null;
                }
                if (!this.clazz.isAssignableFrom(parserContextNode.getClass())) continue;
                this.index = i - 1;
                return (T)parserContextNode;
            }
            return null;
        }
    }
}

