/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTUtil;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.util.BaseUtilities;

public class NBJRTFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Info {
    private static final Logger LOG = Logger.getLogger(NBJRTFileSystem.class.getName());
    private static final String PROTOCOL = "jrt";
    private static final String PROP_JAVA_HOME = "java.home";
    private final File jdkHome;
    private final FileSystem fileSystem;

    @CheckForNull
    public static NBJRTFileSystem create(File jdkHome) {
        File jrtFsJar = NBJRTUtil.getNIOProvider(jdkHome);
        if (jrtFsJar == null) {
            return null;
        }
        try {
            URLClassLoader jrtFsLoader = new URLClassLoader(new URL[]{BaseUtilities.toURI((File)jrtFsJar).toURL()}, ClassLoader.getSystemClassLoader());
            FileSystem fs = FileSystems.newFileSystem(URI.create(String.format("%s:/", PROTOCOL)), Collections.singletonMap(PROP_JAVA_HOME, jdkHome.getAbsolutePath()), (ClassLoader)jrtFsLoader);
            if (fs == null) {
                throw new IllegalStateException(String.format("No %s provider.", PROTOCOL));
            }
            return new NBJRTFileSystem(jdkHome, fs);
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Cannot create %s NIO FS for: %s", PROTOCOL, jdkHome.getAbsolutePath()), ex);
        }
    }

    private NBJRTFileSystem(File jdkHome, FileSystem fileSystem) {
        this.jdkHome = jdkHome;
        this.fileSystem = fileSystem;
        this.list = this;
        this.info = this;
        this.change = this;
        this.attr = new PathAttributes(this, this.info, this.change, this.list);
    }

    public String getDisplayName() {
        return String.format("%s for: %s", PROTOCOL, this.jdkHome.getAbsolutePath());
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean readOnly(String name) {
        return true;
    }

    public boolean folder(String name) {
        return Files.isDirectory(this.getPath(name), new LinkOption[0]);
    }

    public Date lastModified(String name) {
        try {
            return new Date(Files.getLastModifiedTime(this.getPath(name), new LinkOption[0]).toMillis());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public long size(String name) {
        try {
            return Files.size(this.getPath(name));
        }
        catch (NoSuchFileException ex) {
            return 0L;
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, String.format("Cannot read: %s in %s", name, this.getDisplayName()), ex);
            return 0L;
        }
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        try {
            return Files.newInputStream(this.getPath(name), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(name).initCause(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] children(String f) {
        Path p = this.getPath(f);
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(p);){
            ArrayList<String> result = new ArrayList<String>();
            for (Path child : dir) {
                String name = child.getName(child.getNameCount() - 1).toString();
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                result.add(name);
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    public String mimeType(String name) {
        return null;
    }

    @Deprecated
    public void markUnimportant(String name) {
    }

    public void createFolder(String name) throws IOException {
        this.writeOp(IOException.class);
    }

    public void createData(String name) throws IOException {
        this.writeOp(IOException.class);
    }

    public void rename(String oldName, String newName) throws IOException {
        this.writeOp(IOException.class);
    }

    public void delete(String name) throws IOException {
        this.writeOp(IOException.class);
    }

    public OutputStream outputStream(String name) throws IOException {
        return (OutputStream)this.writeOp(IOException.class);
    }

    public void lock(String name) throws IOException {
        this.writeOp(IOException.class);
    }

    public void unlock(String name) {
        this.writeOp(IllegalStateException.class);
    }

    URI getRootURL() throws URISyntaxException {
        return NBJRTUtil.createURI(this.jdkHome, "");
    }

    @NonNull
    Path getPath(@NonNull String name) {
        return this.fileSystem.getPath("/" + name, new String[0]);
    }

    private <R, E extends Exception> R writeOp(Class<E> clz) throws E {
        Exception e;
        String message = String.format("Unsupported write operation on readonly %s", this.getDisplayName());
        try {
            try {
                e = (Exception)clz.getDeclaredConstructor(String.class).newInstance(message);
            }
            catch (NoSuchMethodException nsm) {
                e = (Exception)clz.newInstance();
            }
        }
        catch (ReflectiveOperationException roe) {
            throw new IllegalStateException(message);
        }
        throw e;
    }

    private static final class PathAttributes
    extends DefaultAttributes {
        private static final long serialVersionUID = 1L;
        private final NBJRTFileSystem fs;

        public PathAttributes(NBJRTFileSystem fs, AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
            super(info, change, list);
            this.fs = fs;
        }

        public Object readAttribute(String name, String attrName) {
            if (attrName.equals("java.nio.file.Path")) {
                return this.fs.getPath(name);
            }
            return super.readAttribute(name, attrName);
        }
    }
}

