/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request.json;

import org.apache.solr.client.solrj.request.json.JsonFacetMap;

public class HeatmapFacetMap
extends JsonFacetMap<HeatmapFacetMap> {
    public HeatmapFacetMap(String fieldName) {
        super("heatmap");
        if (fieldName == null) {
            throw new IllegalArgumentException("Parameter 'fieldName' must be non-null");
        }
        this.put("field", fieldName);
    }

    @Override
    public HeatmapFacetMap getThis() {
        return this;
    }

    @Override
    public HeatmapFacetMap withSubFacet(String facetName, JsonFacetMap map) {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't currently support subfacets");
    }

    public HeatmapFacetMap setRegionQuery(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("Parameter 'queryString' must be non-null");
        }
        this.put("geom", queryString);
        return this;
    }

    public HeatmapFacetMap setGridLevel(int individualCellSize) {
        if (individualCellSize <= 0) {
            throw new IllegalArgumentException("Parameter 'individualCellSize' must be a positive integer");
        }
        this.put("gridLevel", individualCellSize);
        return this;
    }

    public HeatmapFacetMap setDistErrPct(double distErrPct) {
        if (distErrPct < 0.0 || distErrPct > 1.0) {
            throw new IllegalArgumentException("Parameter 'distErrPct' must be between 0.0 and 1.0");
        }
        this.put("distErrPct", distErrPct);
        return this;
    }

    public HeatmapFacetMap setDistErr(double distErr) {
        if (distErr < 0.0) {
            throw new IllegalArgumentException("Parameter 'distErr' must be non-negative");
        }
        this.put("distErr", distErr);
        return this;
    }

    public HeatmapFacetMap setHeatmapFormat(HeatmapFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Parameter 'format' must be non-null");
        }
        this.put("format", format.toString());
        return this;
    }

    public static enum HeatmapFormat {
        INTS2D("ints2D"),
        PNG("png");

        private final String value;

        private HeatmapFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

