/* gst-editing-services-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "GES", gir_namespace = "GES", gir_version = "1.0", lower_case_cprefix = "ges_")]
namespace GES {
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_asset_get_type ()")]
	public class Asset : GLib.Object, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Asset ();
		public virtual unowned GES.Extractable extract () throws GLib.Error;
		[Version (since = "1.8")]
		public unowned GLib.Error? get_error ();
		public GLib.Type get_extractable_type ();
		public unowned string get_id ();
		public unowned GES.Asset? get_proxy ();
		public unowned GES.Asset? get_proxy_target ();
		[NoWrapper]
		public virtual void inform_proxy (string proxy_id);
		[CCode (cname = "ges_list_assets")]
		public static GLib.List<weak GES.Asset> list_assets (GLib.Type filter);
		public unowned GLib.List<GES.Asset> list_proxies ();
		public static bool needs_reload (GLib.Type extractable_type, string? id);
		[NoWrapper]
		public virtual void proxied (GES.Asset proxy);
		[CCode (cname = "ges_asset_request", has_construct_function = false)]
		public Asset.request (GLib.Type extractable_type, string? id) throws GLib.Error;
		[CCode (cname = "ges_asset_request_async", has_construct_function = false, type = "void")]
		public async Asset.request_async (GLib.Type extractable_type, string? id, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual bool request_id_update (string proposed_new_id, GLib.Error error);
		public bool set_proxy (GES.Asset? proxy);
		[NoWrapper]
		public virtual GES.AssetLoadingReturn start_loading () throws GLib.Error;
		public bool unproxy (GES.Asset proxy);
		public GLib.Type extractable_type { get; construct; }
		public string id { get; construct; }
		public GES.Asset proxy { get; set; }
		public GES.Asset proxy_target { get; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_audio_source_get_type ()")]
	public abstract class AudioSource : GES.Source, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected AudioSource ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_audio_test_source_get_type ()")]
	public class AudioTestSource : GES.AudioSource, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected AudioTestSource ();
		public double get_freq ();
		public double get_volume ();
		public void set_freq (double freq);
		public void set_volume (double volume);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_audio_track_get_type ()")]
	public class AudioTrack : GES.Track, GES.MetaContainer, Gst.ChildProxy {
		[CCode (has_construct_function = false)]
		public AudioTrack ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_audio_transition_get_type ()")]
	public class AudioTransition : GES.Transition, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		[Version (deprecated = true, deprecated_since = "1.18")]
		public AudioTransition ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_audio_uri_source_get_type ()")]
	public class AudioUriSource : GES.AudioSource, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected AudioUriSource ();
		[NoAccessorMethod]
		public string uri { owned get; construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_base_effect_get_type ()")]
	public abstract class BaseEffect : GES.Operation, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected BaseEffect ();
		[Version (since = "1.18")]
		public bool is_time_effect ();
		[Version (since = "1.18")]
		public bool register_time_property (string child_property_name);
		[Version (since = "1.18")]
		public bool set_time_translation_funcs (GES.BaseEffectTimeTranslationFunc? source_to_sink_func, owned GES.BaseEffectTimeTranslationFunc? sink_to_source_func);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_base_effect_clip_get_type ()")]
	public abstract class BaseEffectClip : GES.OperationClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected BaseEffectClip ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_base_transition_clip_get_type ()")]
	public abstract class BaseTransitionClip : GES.OperationClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected BaseTransitionClip ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_base_xml_formatter_get_type ()")]
	public abstract class BaseXmlFormatter : GES.Formatter, GES.Extractable {
		[CCode (has_construct_function = false)]
		protected BaseXmlFormatter ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_clip_get_type ()")]
	public abstract class Clip : GES.Container, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected Clip ();
		public unowned GES.TrackElement? add_asset (GES.Asset asset);
		[Version (since = "1.18")]
		public unowned GES.TrackElement add_child_to_track (GES.TrackElement child, GES.Track track) throws GLib.Error;
		[Version (since = "1.18")]
		public bool add_top_effect (GES.BaseEffect effect, int index) throws GLib.Error;
		[NoWrapper]
		public virtual unowned GES.TrackElement? create_track_element (GES.TrackType type);
		[NoWrapper]
		public virtual GLib.List<weak GES.TrackElement> create_track_elements (GES.TrackType type);
		public GES.TrackElement? find_track_element (GES.Track? track, GLib.Type type);
		public GLib.List<GES.TrackElement> find_track_elements (GES.Track? track, GES.TrackType track_type, GLib.Type type);
		[Version (since = "1.18")]
		public Gst.ClockTime get_duration_limit ();
		[Version (since = "1.18")]
		public Gst.ClockTime get_internal_time_from_timeline_time (GES.TrackElement child, Gst.ClockTime timeline_time) throws GLib.Error;
		public GES.Layer? get_layer ();
		public GES.TrackType get_supported_formats ();
		[Version (since = "1.18")]
		public Gst.ClockTime get_timeline_time_from_internal_time (GES.TrackElement child, Gst.ClockTime internal_time) throws GLib.Error;
		[Version (since = "1.18")]
		public Gst.ClockTime get_timeline_time_from_source_frame (GES.FrameNumber frame_number) throws GLib.Error;
		public int get_top_effect_index (GES.BaseEffect effect);
		public int get_top_effect_position (GES.BaseEffect effect);
		public GLib.List<GES.TrackElement> get_top_effects ();
		public bool move_to_layer (GES.Layer layer);
		[Version (since = "1.18")]
		public bool move_to_layer_full (GES.Layer layer) throws GLib.Error;
		[Version (since = "1.18")]
		public bool remove_top_effect (GES.BaseEffect effect) throws GLib.Error;
		public void set_supported_formats (GES.TrackType supportedformats);
		public bool set_top_effect_index (GES.BaseEffect effect, uint newindex);
		[Version (since = "1.18")]
		public bool set_top_effect_index_full (GES.BaseEffect effect, uint newindex) throws GLib.Error;
		public bool set_top_effect_priority (GES.BaseEffect effect, uint newpriority);
		public unowned GES.Clip? split (uint64 position);
		[Version (since = "1.18")]
		public unowned GES.Clip? split_full (uint64 position) throws GLib.Error;
		[Version (since = "1.18")]
		public uint64 duration_limit { get; }
		public GES.Layer layer { owned get; }
		public GES.TrackType supported_formats { get; set construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_clip_asset_get_type ()")]
	public class ClipAsset : GES.Asset, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected ClipAsset ();
		[Version (since = "1.18")]
		public Gst.ClockTime get_frame_time (GES.FrameNumber frame_number);
		[Version (since = "1.18")]
		public virtual bool get_natural_framerate (int framerate_n, int framerate_d);
		public GES.TrackType get_supported_formats ();
		public void set_supported_formats (GES.TrackType supportedformats);
		public GES.TrackType supported_formats { get; set construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_command_line_formatter_get_type ()")]
	public class CommandLineFormatter : GES.Formatter, GES.Extractable {
		[CCode (has_construct_function = false)]
		protected CommandLineFormatter ();
		public static string get_help (int nargs, string commands);
		[Version (since = "1.20")]
		public static string get_timeline_uri (GES.Timeline timeline);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_container_get_type ()")]
	public abstract class Container : GES.TimelineElement, GES.Extractable, GES.MetaContainer {
		public weak GLib.List<GES.TimelineElement> children;
		public GES.ChildrenControlMode children_control_mode;
		public weak GES.TimelineElement initiated_move;
		[CCode (has_construct_function = false)]
		protected Container ();
		public bool add (GES.TimelineElement child);
		[NoWrapper]
		public virtual bool add_child (GES.TimelineElement element);
		[Version (deprecated = true, deprecated_since = "1.18")]
		public virtual bool edit (GLib.List<GES.Layer>? layers, int new_layer_priority, GES.EditMode mode, GES.Edge edge, uint64 position);
		public GLib.List<GES.TimelineElement> get_children (bool recursive);
		public static unowned GES.Container group (GLib.List<GES.Container>? containers);
		public bool remove (GES.TimelineElement child);
		[NoWrapper]
		public virtual bool remove_child (GES.TimelineElement element);
		[DestroysInstance]
		public virtual GLib.List<GES.Container> ungroup (bool recursive);
		[NoAccessorMethod]
		public uint height { get; }
		public virtual signal void child_added (GES.TimelineElement element);
		public virtual signal void child_removed (GES.TimelineElement element);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_effect_get_type ()")]
	public class Effect : GES.BaseEffect, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public Effect (string bin_description);
		[CCode (cname = "ges_effect_class_register_rate_property")]
		public class bool register_rate_property (string element_name, string property_name);
		[NoAccessorMethod]
		public string bin_description { owned get; construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_effect_asset_get_type ()")]
	public class EffectAsset : GES.TrackElementAsset, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected EffectAsset ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_effect_clip_get_type ()")]
	public class EffectClip : GES.BaseEffectClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public EffectClip (string video_bin_description, string audio_bin_description);
		[NoAccessorMethod]
		public string audio_bin_description { owned get; construct; }
		[NoAccessorMethod]
		public string video_bin_description { owned get; construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_formatter_get_type ()")]
	public abstract class Formatter : GLib.InitiallyUnowned, GES.Extractable {
		[CCode (has_construct_function = false)]
		protected Formatter ();
		[NoWrapper]
		public virtual bool can_load_uri (string uri) throws GLib.Error;
		public static bool can_save_uri (string uri) throws GLib.Error;
		public static unowned GES.Asset get_default ();
		[Version (deprecated = true, deprecated_since = "1.18")]
		public virtual bool load_from_uri (GES.Timeline timeline, string uri) throws GLib.Error;
		[CCode (cname = "ges_formatter_class_register_metas")]
		public class void register_metas (string name, string description, string extensions, string caps, double version, Gst.Rank rank);
		[Version (deprecated = true, deprecated_since = "1.18")]
		public virtual bool save_to_uri (GES.Timeline timeline, string uri, bool overwrite) throws GLib.Error;
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_group_get_type ()")]
	public class Group : GES.Container, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public Group ();
		[NoAccessorMethod]
		public uint64 duration { get; set; }
		[NoAccessorMethod]
		public uint64 in_point { get; set; }
		[NoAccessorMethod]
		public uint64 max_duration { get; set construct; }
		[NoAccessorMethod]
		public uint priority { get; set; }
		[NoAccessorMethod]
		public uint64 start { get; set; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_image_source_get_type ()")]
	[Version (deprecated = true, deprecated_since = "1.18")]
	public class ImageSource : GES.VideoSource, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected ImageSource ();
		[NoAccessorMethod]
		public string uri { owned get; construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_layer_get_type ()")]
	public class Layer : GLib.InitiallyUnowned, GES.Extractable, GES.MetaContainer {
		public uint32 max_nle_priority;
		public uint32 min_nle_priority;
		public weak GES.Timeline timeline;
		[CCode (has_construct_function = false)]
		public Layer ();
		public unowned GES.Clip add_asset (GES.Asset asset, Gst.ClockTime start, Gst.ClockTime inpoint, Gst.ClockTime duration, GES.TrackType track_types);
		[Version (since = "1.18")]
		public unowned GES.Clip add_asset_full (GES.Asset asset, Gst.ClockTime start, Gst.ClockTime inpoint, Gst.ClockTime duration, GES.TrackType track_types) throws GLib.Error;
		public bool add_clip (GES.Clip clip);
		[Version (since = "1.18")]
		public bool add_clip_full (GES.Clip clip) throws GLib.Error;
		[Version (since = "1.18")]
		public bool get_active_for_track (GES.Track track);
		public bool get_auto_transition ();
		public GLib.List<GES.Clip> get_clips ();
		public GLib.List<GES.Clip> get_clips_in_interval (Gst.ClockTime start, Gst.ClockTime end);
		public Gst.ClockTime get_duration ();
		public uint get_priority ();
		public unowned GES.Timeline? get_timeline ();
		public bool is_empty ();
		[NoWrapper]
		public virtual void object_added (GES.Clip object);
		[NoWrapper]
		public virtual void object_removed (GES.Clip object);
		public bool remove_clip (GES.Clip clip);
		[Version (since = "1.18")]
		public bool set_active_for_tracks (bool active, GLib.List<GES.Track>? tracks);
		public void set_auto_transition (bool auto_transition);
		[Version (deprecated = true, deprecated_since = "1.16.0")]
		public void set_priority (uint priority);
		public void set_timeline (GES.Timeline timeline);
		public bool auto_transition { get; set; }
		[Version (deprecated = true, deprecated_since = "1.16.0")]
		public uint priority { get; set; }
		[Version (since = "1.18")]
		public signal void active_changed (bool active, GLib.GenericArray<GES.Track> tracks);
		public signal void clip_added (GES.Clip clip);
		public signal void clip_removed (GES.Clip clip);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_marker_get_type ()")]
	[Version (since = "1.18")]
	public class Marker : GLib.Object, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected Marker ();
		[NoAccessorMethod]
		public uint64 position { get; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_marker_list_get_type ()")]
	[Version (since = "1.18")]
	public class MarkerList : GLib.Object {
		[CCode (has_construct_function = false)]
		public MarkerList ();
		public unowned GES.Marker add (Gst.ClockTime position);
		public GLib.List<GES.Marker> get_markers ();
		public bool move (GES.Marker marker, Gst.ClockTime position);
		public bool remove (GES.Marker marker);
		public uint size ();
		[NoAccessorMethod]
		[Version (since = "1.20")]
		public GES.MarkerFlags flags { get; set construct; }
		public signal void marker_added (uint64 position, GES.Marker marker);
		public signal void marker_moved (uint64 previous_position, uint64 new_position, GES.Marker marker);
		public signal void marker_removed (GES.Marker marker);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_multi_file_source_get_type ()")]
	[Version (deprecated = true, deprecated_since = "1.18")]
	public class MultiFileSource : GES.VideoSource, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public MultiFileSource (string uri);
		[NoAccessorMethod]
		public string uri { owned get; construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_operation_get_type ()")]
	public abstract class Operation : GES.TrackElement, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected Operation ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_operation_clip_get_type ()")]
	public abstract class OperationClip : GES.Clip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected OperationClip ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_overlay_clip_get_type ()")]
	public abstract class OverlayClip : GES.OperationClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected OverlayClip ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_pipeline_get_type ()")]
	public class Pipeline : Gst.Pipeline, Gst.ChildProxy, Gst.Video.Overlay {
		[CCode (has_construct_function = false)]
		public Pipeline ();
		public GES.PipelineFlags get_mode ();
		public Gst.Sample get_thumbnail (Gst.Caps caps);
		public Gst.Sample get_thumbnail_rgb24 (int width, int height);
		public Gst.Element preview_get_audio_sink ();
		public Gst.Element preview_get_video_sink ();
		public void preview_set_audio_sink (Gst.Element sink);
		public void preview_set_video_sink (Gst.Element sink);
		public bool save_thumbnail (int width, int height, string format, string location) throws GLib.Error;
		public bool set_mode (GES.PipelineFlags mode);
		public bool set_render_settings (string output_uri, Gst.PbUtils.EncodingProfile profile);
		public bool set_timeline (owned GES.Timeline timeline);
		[NoAccessorMethod]
		[Version (since = "1.6.0")]
		public Gst.Element audio_filter { owned get; set; }
		[NoAccessorMethod]
		public Gst.Element audio_sink { owned get; set; }
		public GES.PipelineFlags mode { get; set; }
		[NoAccessorMethod]
		public GES.Timeline timeline { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.6.0")]
		public Gst.Element video_filter { owned get; set; }
		[NoAccessorMethod]
		public Gst.Element video_sink { owned get; set; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_pitivi_formatter_get_type ()")]
	[Version (deprecated = true, deprecated_since = "1.0")]
	public class PitiviFormatter : GES.Formatter, GES.Extractable {
		[CCode (has_construct_function = false)]
		public PitiviFormatter ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_project_get_type ()")]
	public class Project : GES.Asset, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		public Project (string? uri);
		public bool add_asset (GES.Asset asset);
		public bool add_encoding_profile (Gst.PbUtils.EncodingProfile profile);
		[Version (since = "1.18")]
		public void add_formatter (GES.Formatter formatter);
		public bool create_asset (string? id, GLib.Type extractable_type);
		public GES.Asset? create_asset_sync (string? id, GLib.Type extractable_type) throws GLib.Error;
		public GES.Asset? get_asset (string id, GLib.Type extractable_type);
		public GLib.List<GES.Asset> get_loading_assets ();
		public string? get_uri ();
		public GLib.List<GES.Asset> list_assets (GLib.Type filter);
		public unowned GLib.List<Gst.PbUtils.EncodingProfile>? list_encoding_profiles ();
		public bool load (GES.Timeline timeline) throws GLib.Error;
		[NoWrapper]
		public virtual bool loading_error (GLib.Error error, string id, GLib.Type extractable_type);
		public bool remove_asset (GES.Asset asset);
		public bool save (GES.Timeline timeline, string uri, owned GES.Asset? formatter_asset, bool overwrite) throws GLib.Error;
		public string uri { owned get; construct; }
		public virtual signal void asset_added (GES.Asset asset);
		[Version (since = "1.8")]
		public virtual signal void asset_loading (GES.Asset asset);
		public virtual signal void asset_removed (GES.Asset asset);
		[Version (since = "1.18")]
		public signal void error_loading (GES.Timeline timeline, GLib.Error error);
		public signal void error_loading_asset (GLib.Error error, string id, GLib.Type extractable_type);
		public virtual signal void loaded (GES.Timeline timeline);
		[Version (since = "1.18")]
		public virtual signal void loading (GES.Timeline timeline);
		public virtual signal string? missing_uri (GLib.Error error, GES.Asset wrong_asset);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_source_get_type ()")]
	public class Source : GES.TrackElement, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected Source ();
		[NoWrapper]
		[Version (since = "1.20")]
		public virtual unowned Gst.Element create_source ();
		[NoWrapper]
		[Version (since = "1.20")]
		public virtual bool select_pad (Gst.Pad pad);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_source_clip_get_type ()")]
	public class SourceClip : GES.Clip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected SourceClip ();
		[CCode (has_construct_function = false)]
		[Version (since = "1.18")]
		public SourceClip.time_overlay ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_source_clip_asset_get_type ()")]
	[Version (since = "1.18")]
	public class SourceClipAsset : GES.ClipAsset, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected SourceClipAsset ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_test_clip_get_type ()")]
	public class TestClip : GES.SourceClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public TestClip ();
		[CCode (has_construct_function = false)]
		public TestClip.for_nick (string nick);
		public double get_frequency ();
		public double get_volume ();
		public GES.VideoTestPattern get_vpattern ();
		public bool is_muted ();
		public void set_frequency (double freq);
		public void set_mute (bool mute);
		public void set_volume (double volume);
		public void set_vpattern (GES.VideoTestPattern vpattern);
		[NoAccessorMethod]
		public double freq { get; set construct; }
		[NoAccessorMethod]
		public bool mute { get; set construct; }
		public double volume { get; set construct; }
		public GES.VideoTestPattern vpattern { get; set construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_text_overlay_get_type ()")]
	public class TextOverlay : GES.Operation, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		[Version (deprecated = true, deprecated_since = "1.18")]
		public TextOverlay ();
		public uint32 get_color ();
		public unowned string get_font_desc ();
		public GES.TextHAlign get_halignment ();
		public unowned string get_text ();
		public GES.TextVAlign get_valignment ();
		public double get_xpos ();
		public double get_ypos ();
		public void set_color (uint32 color);
		public void set_font_desc (string font_desc);
		public void set_halignment (GES.TextHAlign halign);
		public void set_text (string text);
		public void set_valignment (GES.TextVAlign valign);
		public void set_xpos (double position);
		public void set_ypos (double position);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_text_overlay_clip_get_type ()")]
	public class TextOverlayClip : GES.OverlayClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public TextOverlayClip ();
		public uint32 get_color ();
		public unowned string get_font_desc ();
		public GES.TextHAlign get_halignment ();
		public unowned string get_text ();
		public GES.TextVAlign get_valignment ();
		public double get_xpos ();
		public double get_ypos ();
		public void set_color (uint32 color);
		public void set_font_desc (string font_desc);
		public void set_halign (GES.TextHAlign halign);
		public void set_text (string text);
		public void set_valign (GES.TextVAlign valign);
		public void set_xpos (double position);
		public void set_ypos (double position);
		public uint color { get; set construct; }
		public string font_desc { get; set construct; }
		[NoAccessorMethod]
		public GES.TextHAlign halignment { get; set construct; }
		public string text { get; set construct; }
		[NoAccessorMethod]
		public GES.TextVAlign valignment { get; set construct; }
		public double xpos { get; set construct; }
		public double ypos { get; set construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_timeline_get_type ()")]
	public class Timeline : Gst.Bin, GES.Extractable, GES.MetaContainer, Gst.ChildProxy {
		public weak GLib.List<GES.Layer> layers;
		public weak GLib.List<GES.Track> tracks;
		[CCode (has_construct_function = false)]
		public Timeline ();
		[Version (deprecated = true, deprecated_since = "1.18")]
		public bool add_layer (GES.Layer layer);
		public bool add_track (owned GES.Track track);
		public unowned GES.Layer append_layer ();
		[CCode (has_construct_function = false)]
		public Timeline.audio_video ();
		public bool commit ();
		public bool commit_sync ();
		[Version (since = "1.20")]
		public void freeze_commit ();
		[CCode (has_construct_function = false)]
		public Timeline.from_uri (string uri) throws GLib.Error;
		public bool get_auto_transition ();
		public Gst.ClockTime get_duration ();
		public GES.TimelineElement? get_element (string name);
		[Version (since = "1.18")]
		public GES.FrameNumber get_frame_at (Gst.ClockTime timestamp);
		[Version (since = "1.18")]
		public Gst.ClockTime get_frame_time (GES.FrameNumber frame_number);
		public unowned GLib.List<GES.Group> get_groups ();
		public GES.Layer? get_layer (uint priority);
		public GLib.List<GES.Layer> get_layers ();
		public unowned Gst.Pad? get_pad_for_track (GES.Track track);
		public Gst.ClockTime get_snapping_distance ();
		public unowned GES.Track? get_track_for_pad (Gst.Pad pad);
		public GLib.List<GES.Track> get_tracks ();
		public bool is_empty ();
		public bool load_from_uri (string uri) throws GLib.Error;
		[Version (since = "1.16")]
		public bool move_layer (GES.Layer layer, uint new_layer_priority);
		public GES.TimelineElement? paste_element (GES.TimelineElement element, Gst.ClockTime position, int layer_priority);
		public bool remove_layer (GES.Layer layer);
		public bool remove_track (GES.Track track);
		public bool save_to_uri (string uri, GES.Asset? formatter_asset, bool overwrite) throws GLib.Error;
		public void set_auto_transition (bool auto_transition);
		public void set_snapping_distance (Gst.ClockTime snapping_distance);
		[Version (since = "1.20")]
		public void thaw_commit ();
		public bool auto_transition { get; set; }
		public uint64 duration { get; }
		public uint64 snapping_distance { get; set; }
		public signal void commited ();
		public virtual signal void group_added (GES.Group group);
		public signal void group_removed (GES.Group group, GLib.GenericArray<GES.Container> children);
		public virtual signal void layer_added (GES.Layer layer);
		public virtual signal void layer_removed (GES.Layer layer);
		[Version (since = "1.18")]
		public signal GES.Track select_element_track (GES.Clip clip, GES.TrackElement track_element);
		public signal GLib.GenericArray<GES.Track> select_tracks_for_object (GES.Clip clip, GES.TrackElement track_element);
		public signal void snapping_ended (GES.TrackElement obj1, GES.TrackElement obj2, uint64 position);
		public signal void snapping_started (GES.TrackElement obj1, GES.TrackElement obj2, uint64 position);
		public virtual signal void track_added (GES.Track track);
		public virtual signal void track_removed (GES.Track track);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_timeline_element_get_type ()")]
	public abstract class TimelineElement : GLib.InitiallyUnowned, GES.Extractable, GES.MetaContainer {
		public weak GES.Asset asset;
		public Gst.ClockTime inpoint;
		public Gst.ClockTime maxduration;
		[CCode (has_construct_function = false)]
		protected TimelineElement ();
		public bool add_child_property (GLib.ParamSpec pspec, GLib.Object child);
		public unowned GES.TimelineElement copy (bool deep);
		[NoWrapper]
		public virtual void deep_copy (GES.TimelineElement copy);
		[Version (since = "1.18")]
		public bool edit (GLib.List<GES.Layer>? layers, int64 new_layer_priority, GES.EditMode mode, GES.Edge edge, uint64 position);
		[Version (since = "1.18")]
		public bool edit_full (int64 new_layer_priority, GES.EditMode mode, GES.Edge edge, uint64 position) throws GLib.Error;
		public bool get_child_property (string property_name, out GLib.Value value);
		public GLib.Value get_child_property_by_pspec (GLib.ParamSpec pspec);
		public Gst.ClockTime get_duration ();
		public Gst.ClockTime get_inpoint ();
		[Version (since = "1.16")]
		public virtual uint32 get_layer_priority ();
		public Gst.ClockTime get_max_duration ();
		public string get_name ();
		[Version (since = "1.18")]
		public virtual bool get_natural_framerate (out int framerate_n, out int framerate_d);
		public GES.TimelineElement? get_parent ();
		public uint32 get_priority ();
		public Gst.ClockTime get_start ();
		public GES.Timeline? get_timeline ();
		public GES.TimelineElement get_toplevel_parent ();
		[Version (since = "1.6.0")]
		public virtual GES.TrackType get_track_types ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public GLib.ParamSpec[] list_children_properties ();
		public virtual bool lookup_child (string prop_name, out GLib.Object child, out GLib.ParamSpec pspec);
		[Version (since = "1.6.0")]
		public GES.TimelineElement? paste (Gst.ClockTime paste_position);
		public bool remove_child_property (GLib.ParamSpec pspec);
		public virtual bool ripple (uint64 start);
		public virtual bool ripple_end (uint64 end);
		public virtual bool roll_end (uint64 end);
		public virtual bool roll_start (uint64 start);
		[NoWrapper]
		[Version (since = "1.16")]
		public virtual void set_child_property (GLib.Object child, GLib.ParamSpec pspec, GLib.Value value);
		public void set_child_property_by_pspec (GLib.ParamSpec pspec, GLib.Value value);
		[NoWrapper]
		[Version (since = "1.18")]
		public virtual bool set_child_property_full (GLib.Object child, GLib.ParamSpec pspec, GLib.Value value) throws GLib.Error;
		public virtual bool set_duration (Gst.ClockTime duration);
		public virtual bool set_inpoint (Gst.ClockTime inpoint);
		public virtual bool set_max_duration (Gst.ClockTime maxduration);
		public bool set_name (string? name);
		public virtual bool set_parent (GES.TimelineElement parent);
		[Version (deprecated = true, deprecated_since = "1.10")]
		public virtual bool set_priority (uint32 priority);
		public virtual bool set_start (Gst.ClockTime start);
		public bool set_timeline (GES.Timeline timeline);
		public virtual bool trim (uint64 start);
		public uint64 duration { get; set; }
		[NoAccessorMethod]
		public uint64 in_point { get; set; }
		public uint64 max_duration { get; set construct; }
		public string name { owned get; set construct; }
		public GES.TimelineElement parent { owned get; set; }
		[Version (deprecated = true, deprecated_since = "1.10")]
		public uint priority { get; set; }
		[NoAccessorMethod]
		public bool serialize { get; set; }
		public uint64 start { get; set; }
		public GES.Timeline timeline { owned get; set; }
		[Version (since = "1.18")]
		public signal void child_property_added (GLib.Object prop_object, GLib.ParamSpec prop);
		[Version (since = "1.18")]
		public signal void child_property_removed (GLib.Object prop_object, GLib.ParamSpec prop);
		public signal void deep_notify (GLib.Object prop_object, GLib.ParamSpec prop);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_title_clip_get_type ()")]
	public class TitleClip : GES.SourceClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public TitleClip ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public uint32 get_background_color ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public unowned string get_font_desc ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public GES.TextHAlign get_halignment ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public unowned string get_text ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public uint32 get_text_color ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public GES.TextVAlign get_valignment ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public double get_xpos ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public double get_ypos ();
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_background (uint32 background);
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_color (uint32 color);
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_font_desc (string font_desc);
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_halignment (GES.TextHAlign halign);
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_text (string text);
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_valignment (GES.TextVAlign valign);
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_xpos (double position);
		[Version (deprecated = true, deprecated_since = "1.6")]
		public void set_ypos (double position);
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.6")]
		public uint background { get; set construct; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.6")]
		public uint color { get; set construct; }
		[Version (deprecated = true, deprecated_since = "1.6")]
		public string font_desc { get; set construct; }
		[Version (deprecated = true, deprecated_since = "1.6")]
		public GES.TextHAlign halignment { get; set construct; }
		[Version (deprecated = true, deprecated_since = "1.6")]
		public string text { get; set construct; }
		[Version (deprecated = true, deprecated_since = "1.6")]
		public GES.TextVAlign valignment { get; set construct; }
		[Version (deprecated = true, deprecated_since = "1.6")]
		public double xpos { get; set construct; }
		[Version (deprecated = true, deprecated_since = "1.6")]
		public double ypos { get; set construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_title_source_get_type ()")]
	public class TitleSource : GES.VideoSource, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected TitleSource ();
		public uint32 get_background_color ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public string get_font_desc ();
		public GES.TextHAlign get_halignment ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public string get_text ();
		public uint32 get_text_color ();
		public GES.TextVAlign get_valignment ();
		public double get_xpos ();
		public double get_ypos ();
		public void set_background_color (uint32 color);
		public void set_font_desc (string font_desc);
		public void set_halignment (GES.TextHAlign halign);
		[Version (deprecated = true)]
		public void set_text (string text);
		public void set_text_color (uint32 color);
		public void set_valignment (GES.TextVAlign valign);
		public void set_xpos (double position);
		public void set_ypos (double position);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_track_get_type ()")]
	public class Track : Gst.Bin, GES.MetaContainer, Gst.ChildProxy {
		public GES.TrackType type;
		[CCode (has_construct_function = false)]
		public Track (GES.TrackType type, owned Gst.Caps caps);
		public bool add_element (GES.TrackElement object);
		[Version (since = "1.18")]
		public bool add_element_full (GES.TrackElement object) throws GLib.Error;
		public bool commit ();
		public unowned Gst.Caps get_caps ();
		public GLib.List<GES.TrackElement> get_elements ();
		public bool get_mixing ();
		[Version (since = "1.18")]
		public Gst.Caps get_restriction_caps ();
		public unowned GES.Timeline? get_timeline ();
		public bool remove_element (GES.TrackElement object);
		[Version (since = "1.18")]
		public bool remove_element_full (GES.TrackElement object) throws GLib.Error;
		public void set_mixing (bool mixing);
		public void set_restriction_caps (Gst.Caps caps);
		public void set_timeline (GES.Timeline timeline);
		public void update_restriction_caps (Gst.Caps caps);
		public Gst.Caps caps { get; construct; }
		[NoAccessorMethod]
		public uint64 duration { get; }
		[NoAccessorMethod]
		[Version (since = "1.18")]
		public string id { owned get; set; }
		public bool mixing { get; set construct; }
		public Gst.Caps restriction_caps { owned get; set; }
		[NoAccessorMethod]
		public GES.TrackType track_type { get; construct; }
		public signal void commited ();
		public signal void track_element_added (GES.TrackElement effect);
		public signal void track_element_removed (GES.TrackElement effect);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_track_element_get_type ()")]
	public abstract class TrackElement : GES.TimelineElement, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected TrackElement ();
		[NoWrapper]
		public virtual void active_changed (bool active);
		public void add_children_props (Gst.Element element, [CCode (array_length = false, array_null_terminated = true)] string[]? wanted_categories, [CCode (array_length = false, array_null_terminated = true)] string[]? blacklist, [CCode (array_length = false, array_null_terminated = true)] string[]? whitelist);
		[NoWrapper]
		public virtual void changed ();
		[Version (since = "1.18")]
		public void clamp_control_source (string property_name);
		[NoWrapper]
		public virtual unowned Gst.Element create_element ();
		[NoWrapper]
		public virtual unowned Gst.Element create_gnl_object ();
		[Version (deprecated = true, deprecated_since = "1.18")]
		public bool edit (GLib.List<GES.Layer>? layers, GES.EditMode mode, GES.Edge edge, uint64 position);
		public unowned GLib.HashTable<string,Gst.ControlBinding> get_all_control_bindings ();
		[Version (since = "1.18")]
		public bool get_auto_clamp_control_sources ();
		public unowned Gst.ControlBinding? get_control_binding (string property_name);
		public unowned Gst.Element get_element ();
		[Version (deprecated = true)]
		public unowned Gst.Element get_gnlobject ();
		[Version (since = "1.6")]
		public unowned Gst.Element get_nleobject ();
		public unowned GES.Track? get_track ();
		public GES.TrackType get_track_type ();
		public bool is_active ();
		[Version (since = "1.18")]
		public bool is_core ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		[Version (deprecated = true)]
		public GLib.ParamSpec[] list_children_properties ();
		[Version (deprecated = true, deprecated_since = "1.14")]
		public virtual bool lookup_child (string prop_name, out Gst.Element element, out GLib.ParamSpec pspec);
		public bool remove_control_binding (string property_name);
		public bool set_active (bool active);
		[Version (since = "1.18")]
		public void set_auto_clamp_control_sources (bool auto_clamp);
		public bool set_control_source (Gst.ControlSource source, string property_name, string binding_type);
		[Version (since = "1.18")]
		public bool set_has_internal_source (bool has_internal_source);
		public void set_track_type (GES.TrackType type);
		[NoAccessorMethod]
		public bool active { get; set; }
		[Version (since = "1.18")]
		public bool auto_clamp_control_sources { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.18")]
		public bool has_internal_source { get; set; }
		public GES.Track track { get; }
		public GES.TrackType track_type { get; set construct; }
		public signal void control_binding_added (Gst.ControlBinding control_binding);
		public signal void control_binding_removed (Gst.ControlBinding control_binding);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_track_element_asset_get_type ()")]
	public class TrackElementAsset : GES.Asset, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected TrackElementAsset ();
		[Version (since = "1.18")]
		public virtual bool get_natural_framerate (int framerate_n, int framerate_d);
		public GES.TrackType get_track_type ();
		public void set_track_type (GES.TrackType type);
		public GES.TrackType track_type { get; set construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_transition_get_type ()")]
	public abstract class Transition : GES.Operation, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected Transition ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_transition_clip_get_type ()")]
	public class TransitionClip : GES.BaseTransitionClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public TransitionClip (GES.VideoStandardTransitionType vtype);
		[CCode (has_construct_function = false)]
		public TransitionClip.for_nick (string nick);
		[NoAccessorMethod]
		public GES.VideoStandardTransitionType vtype { get; set construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_uri_clip_get_type ()")]
	public class UriClip : GES.SourceClip, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public UriClip (string uri);
		public unowned string get_uri ();
		public bool is_muted ();
		public void set_is_image (bool is_image);
		public void set_mute (bool mute);
		[NoAccessorMethod]
		public bool is_image { get; set construct; }
		[NoAccessorMethod]
		public bool mute { get; set construct; }
		[NoAccessorMethod]
		public GES.TrackType supported_formats { get; set construct; }
		public string uri { get; construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_uri_clip_asset_get_type ()")]
	public class UriClipAsset : GES.SourceClipAsset, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (finish_name = "ges_asset_request_finish", has_construct_function = false, type = "void")]
		public async UriClipAsset (string uri, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.16")]
		public static GES.UriClipAsset finish (GLib.AsyncResult res) throws GLib.Error;
		public Gst.ClockTime get_duration ();
		public unowned Gst.PbUtils.DiscovererInfo get_info ();
		[Version (since = "1.18")]
		public Gst.ClockTime get_max_duration ();
		public unowned GLib.List<GES.UriSourceAsset> get_stream_assets ();
		[Version (since = "1.18")]
		public bool is_image ();
		[CCode (cname = "ges_uri_clip_asset_request_sync", has_construct_function = false)]
		public UriClipAsset.request_sync (string uri) throws GLib.Error;
		[CCode (cname = "ges_uri_clip_asset_class_set_timeout")]
		public class void set_timeout (Gst.ClockTime timeout);
		[NoAccessorMethod]
		public uint64 duration { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.18")]
		public bool is_nested_timeline { get; }
	}
	[CCode (cheader_filename = "ges/ges.h", has_type_id = false)]
	[Compact]
	public class UriSource {
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_uri_source_asset_get_type ()")]
	public class UriSourceAsset : GES.TrackElementAsset, GES.MetaContainer, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected UriSourceAsset ();
		public unowned GES.UriClipAsset get_filesource_asset ();
		public unowned Gst.PbUtils.DiscovererStreamInfo get_stream_info ();
		public unowned string get_stream_uri ();
		[Version (since = "1.18")]
		public bool is_image ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_video_source_get_type ()")]
	public abstract class VideoSource : GES.Source, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected VideoSource ();
		[Version (since = "1.18")]
		public bool get_natural_size (out int width, out int height);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_video_test_source_get_type ()")]
	public class VideoTestSource : GES.VideoSource, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected VideoTestSource ();
		public GES.VideoTestPattern get_pattern ();
		public void set_pattern (GES.VideoTestPattern pattern);
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_video_track_get_type ()")]
	public class VideoTrack : GES.Track, GES.MetaContainer, Gst.ChildProxy {
		[CCode (has_construct_function = false)]
		public VideoTrack ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_video_transition_get_type ()")]
	public class VideoTransition : GES.Transition, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		public VideoTransition ();
		[Version (deprecated = true, deprecated_since = "1.20")]
		public int get_border ();
		public GES.VideoStandardTransitionType get_transition_type ();
		[Version (deprecated = true, deprecated_since = "1.20")]
		public bool is_inverted ();
		[Version (deprecated = true, deprecated_since = "1.20")]
		public void set_border (uint value);
		[Version (deprecated = true, deprecated_since = "1.20")]
		public void set_inverted (bool inverted);
		public bool set_transition_type (GES.VideoStandardTransitionType type);
		public uint border { get; set; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.20")]
		public bool invert { get; set; }
		public GES.VideoStandardTransitionType transition_type { get; set; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_video_uri_source_get_type ()")]
	public class VideoUriSource : GES.VideoSource, GES.Extractable, GES.MetaContainer {
		[CCode (has_construct_function = false)]
		protected VideoUriSource ();
		[NoAccessorMethod]
		public string uri { owned get; construct; }
	}
	[CCode (cheader_filename = "ges/ges.h", type_id = "ges_xml_formatter_get_type ()")]
	public class XmlFormatter : GES.BaseXmlFormatter, GES.Extractable {
		[CCode (has_construct_function = false)]
		protected XmlFormatter ();
	}
	[CCode (cheader_filename = "ges/ges.h", type_cname = "GESExtractableInterface", type_id = "ges_extractable_get_type ()")]
	public interface Extractable : GLib.InitiallyUnowned {
		public unowned GES.Asset? get_asset ();
		public abstract string get_id ();
		[NoWrapper]
		public abstract void set_asset (GES.Asset asset);
		[NoWrapper]
		public abstract bool set_asset_full (GES.Asset asset);
	}
	[CCode (cheader_filename = "ges/ges.h", type_cname = "GESMetaContainerInterface", type_id = "ges_meta_container_get_type ()")]
	public interface MetaContainer : GLib.Object {
		public bool add_metas_from_string (string str);
		public bool check_meta_registered (string meta_item, out GES.MetaFlag? flags, out GLib.Type? type);
		public void @foreach (GES.MetaForeachFunc func);
		public bool get_boolean (string meta_item, out bool dest);
		public bool get_date (string meta_item, out GLib.Date dest);
		public bool get_date_time (string meta_item, out Gst.DateTime dest);
		public bool get_double (string meta_item, out double dest);
		public bool get_float (string meta_item, out float dest);
		public bool get_int (string meta_item, out int dest);
		public bool get_int64 (string meta_item, out int64 dest);
		[Version (since = "1.18")]
		public GES.MarkerList get_marker_list (string key);
		public unowned GLib.Value? get_meta (string key);
		public unowned string get_string (string meta_item);
		public bool get_uint (string meta_item, out uint dest);
		public bool get_uint64 (string meta_item, out uint64 dest);
		public string metas_to_string ();
		public bool register_meta (GES.MetaFlag flags, string meta_item, GLib.Value value);
		public bool register_meta_boolean (GES.MetaFlag flags, string meta_item, bool value);
		public bool register_meta_date (GES.MetaFlag flags, string meta_item, GLib.Date value);
		public bool register_meta_date_time (GES.MetaFlag flags, string meta_item, Gst.DateTime value);
		public bool register_meta_double (GES.MetaFlag flags, string meta_item, double value);
		public bool register_meta_float (GES.MetaFlag flags, string meta_item, float value);
		public bool register_meta_int (GES.MetaFlag flags, string meta_item, int value);
		public bool register_meta_int64 (GES.MetaFlag flags, string meta_item, int64 value);
		public bool register_meta_string (GES.MetaFlag flags, string meta_item, string value);
		public bool register_meta_uint (GES.MetaFlag flags, string meta_item, uint value);
		public bool register_meta_uint64 (GES.MetaFlag flags, string meta_item, uint64 value);
		[Version (since = "1.18")]
		public bool register_static_meta (GES.MetaFlag flags, string meta_item, GLib.Type type);
		public bool set_boolean (string meta_item, bool value);
		public bool set_date (string meta_item, GLib.Date value);
		public bool set_date_time (string meta_item, Gst.DateTime value);
		public bool set_double (string meta_item, double value);
		public bool set_float (string meta_item, float value);
		public bool set_int (string meta_item, int value);
		public bool set_int64 (string meta_item, int64 value);
		[Version (since = "1.18")]
		public bool set_marker_list (string meta_item, GES.MarkerList list);
		public bool set_meta (string meta_item, GLib.Value? value);
		public bool set_string (string meta_item, string value);
		public bool set_uint (string meta_item, uint value);
		public bool set_uint64 (string meta_item, uint64 value);
		public signal void notify_meta (string key, GLib.Value? value);
	}
	[CCode (cheader_filename = "ges/ges.h")]
	[SimpleType]
	public struct FrameNumber : int64 {
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_ASSET_LOADING_", has_type_id = false)]
	public enum AssetLoadingReturn {
		ERROR,
		ASYNC,
		OK
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_CHILDREN_", has_type_id = false)]
	public enum ChildrenControlMode {
		UPDATE,
		IGNORE_NOTIFIES,
		UPDATE_OFFSETS,
		UPDATE_ALL_VALUES,
		LAST
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_EDGE_", type_id = "ges_edge_get_type ()")]
	public enum Edge {
		[CCode (cname = "GES_EDGE_START")]
		EDGE_START,
		START,
		[CCode (cname = "GES_EDGE_END")]
		EDGE_END,
		END,
		[CCode (cname = "GES_EDGE_NONE")]
		EDGE_NONE,
		NONE;
		[Version (since = "1.16")]
		public unowned string name ();
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_EDIT_MODE_", type_id = "ges_edit_mode_get_type ()")]
	public enum EditMode {
		[CCode (cname = "GES_EDIT_MODE_NORMAL")]
		EDIT_NORMAL,
		NORMAL,
		[CCode (cname = "GES_EDIT_MODE_RIPPLE")]
		EDIT_RIPPLE,
		RIPPLE,
		[CCode (cname = "GES_EDIT_MODE_ROLL")]
		EDIT_ROLL,
		ROLL,
		[CCode (cname = "GES_EDIT_MODE_TRIM")]
		EDIT_TRIM,
		TRIM,
		[CCode (cname = "GES_EDIT_MODE_SLIDE")]
		EDIT_SLIDE,
		SLIDE;
		[Version (since = "1.18")]
		public unowned string name ();
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_ERROR_", has_type_id = false)]
	public enum Error {
		ASSET_WRONG_ID,
		ASSET_LOADING,
		FORMATTER_MALFORMED_INPUT_FILE,
		INVALID_FRAME_NUMBER,
		NEGATIVE_LAYER,
		NEGATIVE_TIME,
		NOT_ENOUGH_INTERNAL_CONTENT,
		INVALID_OVERLAP_IN_TRACK,
		INVALID_EFFECT_BIN_DESCRIPTION
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_MARKER_FLAG_", type_id = "ges_marker_flags_get_type ()")]
	[Flags]
	[Version (since = "1.20")]
	public enum MarkerFlags {
		NONE,
		SNAPPABLE
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_META_", type_id = "ges_meta_flag_get_type ()")]
	[Flags]
	public enum MetaFlag {
		READABLE,
		WRITABLE,
		[CCode (cname = "GES_META_READ_WRITE")]
		READWRITE
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_PIPELINE_MODE_", type_id = "ges_pipeline_flags_get_type ()")]
	[Flags]
	public enum PipelineFlags {
		[CCode (cname = "GES_PIPELINE_MODE_PREVIEW_AUDIO")]
		AUDIO_PREVIEW,
		[CCode (cname = "GES_PIPELINE_MODE_PREVIEW_VIDEO")]
		VIDEO_PREVIEW,
		[CCode (cname = "GES_PIPELINE_MODE_PREVIEW")]
		FULL_PREVIEW,
		RENDER,
		SMART_RENDER
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_TEXT_HALIGN_", type_id = "ges_text_halign_get_type ()")]
	public enum TextHAlign {
		LEFT,
		CENTER,
		RIGHT,
		POSITION,
		ABSOLUTE
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_TEXT_VALIGN_", type_id = "ges_text_valign_get_type ()")]
	public enum TextVAlign {
		BASELINE,
		BOTTOM,
		TOP,
		POSITION,
		CENTER,
		ABSOLUTE
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_TRACK_TYPE_", type_id = "ges_track_type_get_type ()")]
	[Flags]
	public enum TrackType {
		UNKNOWN,
		AUDIO,
		VIDEO,
		TEXT,
		CUSTOM;
		public unowned string name ();
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_VIDEO_STANDARD_TRANSITION_TYPE_", type_id = "ges_video_standard_transition_type_get_type ()")]
	public enum VideoStandardTransitionType {
		NONE,
		BAR_WIPE_LR,
		BAR_WIPE_TB,
		BOX_WIPE_TL,
		BOX_WIPE_TR,
		BOX_WIPE_BR,
		BOX_WIPE_BL,
		FOUR_BOX_WIPE_CI,
		FOUR_BOX_WIPE_CO,
		BARNDOOR_V,
		BARNDOOR_H,
		BOX_WIPE_TC,
		BOX_WIPE_RC,
		BOX_WIPE_BC,
		BOX_WIPE_LC,
		DIAGONAL_TL,
		DIAGONAL_TR,
		BOWTIE_V,
		BOWTIE_H,
		BARNDOOR_DBL,
		BARNDOOR_DTL,
		MISC_DIAGONAL_DBD,
		MISC_DIAGONAL_DD,
		VEE_D,
		VEE_L,
		VEE_U,
		VEE_R,
		BARNVEE_D,
		BARNVEE_L,
		BARNVEE_U,
		BARNVEE_R,
		IRIS_RECT,
		CLOCK_CW12,
		CLOCK_CW3,
		CLOCK_CW6,
		CLOCK_CW9,
		PINWHEEL_TBV,
		PINWHEEL_TBH,
		PINWHEEL_FB,
		FAN_CT,
		FAN_CR,
		DOUBLEFAN_FOV,
		DOUBLEFAN_FOH,
		SINGLESWEEP_CWT,
		SINGLESWEEP_CWR,
		SINGLESWEEP_CWB,
		SINGLESWEEP_CWL,
		DOUBLESWEEP_PV,
		DOUBLESWEEP_PD,
		DOUBLESWEEP_OV,
		DOUBLESWEEP_OH,
		FAN_T,
		FAN_R,
		FAN_B,
		FAN_L,
		DOUBLEFAN_FIV,
		DOUBLEFAN_FIH,
		SINGLESWEEP_CWTL,
		SINGLESWEEP_CWBL,
		SINGLESWEEP_CWBR,
		SINGLESWEEP_CWTR,
		DOUBLESWEEP_PDTL,
		DOUBLESWEEP_PDBL,
		SALOONDOOR_T,
		SALOONDOOR_L,
		SALOONDOOR_B,
		SALOONDOOR_R,
		WINDSHIELD_R,
		WINDSHIELD_U,
		WINDSHIELD_V,
		WINDSHIELD_H,
		CROSSFADE
	}
	[CCode (cheader_filename = "ges/ges.h", cprefix = "GES_VIDEO_TEST_", type_id = "ges_video_test_pattern_get_type ()")]
	public enum VideoTestPattern {
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_SMPTE")]
		SMPTE,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_SNOW")]
		SNOW,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_BLACK")]
		BLACK,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_WHITE")]
		WHITE,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_RED")]
		RED,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_GREEN")]
		GREEN,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_BLUE")]
		BLUE,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_CHECKERS1")]
		CHECKERS_1,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_CHECKERS2")]
		CHECKERS_2,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_CHECKERS4")]
		CHECKERS_4,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_CHECKERS8")]
		CHECKERS_8,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_CIRCULAR")]
		CIRCULAR,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_BLINK")]
		BLINK,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_SMPTE75")]
		SMPTE75,
		ZONE_PLATE,
		GAMUT,
		CHROMA_ZONE_PLATE,
		[CCode (cname = "GES_VIDEO_TEST_PATTERN_SOLID")]
		SOLID_COLOR
	}
	[CCode (cheader_filename = "ges/ges.h", instance_pos = 3.9)]
	[Version (since = "1.18")]
	public delegate Gst.ClockTime BaseEffectTimeTranslationFunc (GES.BaseEffect effect, Gst.ClockTime time, GLib.HashTable<string,GLib.Value?> time_property_values);
	[CCode (cheader_filename = "ges/ges.h", has_target = false)]
	public delegate unowned GES.TrackElement? CreateTrackElementFunc (GES.Clip clip, GES.TrackType type);
	[CCode (cheader_filename = "ges/ges.h", has_target = false)]
	public delegate GLib.List<weak GES.TrackElement> CreateTrackElementsFunc (GES.Clip clip, GES.TrackType type);
	[CCode (cheader_filename = "ges/ges.h", has_target = false)]
	public delegate string ExtractableCheckId (GLib.Type type, string id) throws GLib.Error;
	[CCode (cheader_filename = "ges/ges.h", has_target = false)]
	[Version (deprecated = true, deprecated_since = "1.18")]
	public delegate bool FillTrackElementFunc (GES.Clip clip, GES.TrackElement track_element, Gst.Element nleobj);
	[CCode (cheader_filename = "ges/ges.h", has_target = false)]
	public delegate bool FormatterCanLoadURIMethod (GES.Formatter dummy_instance, string uri) throws GLib.Error;
	[CCode (cheader_filename = "ges/ges.h", has_target = false)]
	public delegate bool FormatterLoadFromURIMethod (GES.Formatter formatter, GES.Timeline timeline, string uri) throws GLib.Error;
	[CCode (cheader_filename = "ges/ges.h", has_target = false)]
	public delegate bool FormatterSaveToURIMethod (GES.Formatter formatter, GES.Timeline timeline, string uri, bool overwrite) throws GLib.Error;
	[CCode (cheader_filename = "ges/ges.h", instance_pos = 3.9)]
	public delegate void MetaForeachFunc (GES.MetaContainer container, string key, GLib.Value value);
	[CCode (cheader_filename = "ges/ges.h", has_target = false, has_typedef = false)]
	public delegate bool abiGetNaturalSizeFunc (GES.VideoSource self, int width, int height);
	[CCode (cheader_filename = "ges/ges.h", has_target = false, has_typedef = false)]
	public delegate bool abiNeedsConvertersFunc (GES.VideoSource self);
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_FRAME_NUMBER_NONE")]
	public const int64 FRAME_NUMBER_NONE;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_DESCRIPTION")]
	public const string META_DESCRIPTION;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_FORMATTER_EXTENSION")]
	public const string META_FORMATTER_EXTENSION;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_FORMATTER_MIMETYPE")]
	public const string META_FORMATTER_MIMETYPE;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_FORMATTER_NAME")]
	public const string META_FORMATTER_NAME;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_FORMATTER_RANK")]
	public const string META_FORMATTER_RANK;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_FORMATTER_VERSION")]
	public const string META_FORMATTER_VERSION;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_FORMAT_VERSION")]
	public const string META_FORMAT_VERSION;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_MARKER_COLOR")]
	public const string META_MARKER_COLOR;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_VOLUME")]
	public const string META_VOLUME;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_META_VOLUME_DEFAULT")]
	public const double META_VOLUME_DEFAULT;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_MULTI_FILE_URI_PREFIX")]
	public const string MULTI_FILE_URI_PREFIX;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_PADDING")]
	public const int PADDING;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_PADDING_LARGE")]
	public const int PADDING_LARGE;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_TIMELINE_ELEMENT_NO_LAYER_PRIORITY")]
	public const uint32 TIMELINE_ELEMENT_NO_LAYER_PRIORITY;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_VERSION_MAJOR")]
	public const int VERSION_MAJOR;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_VERSION_MICRO")]
	public const int VERSION_MICRO;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_VERSION_MINOR")]
	public const int VERSION_MINOR;
	[CCode (cheader_filename = "ges/ges.h", cname = "GES_VERSION_NANO")]
	public const int VERSION_NANO;
	[CCode (cheader_filename = "ges/ges.h")]
	public static bool add_missing_uri_relocation_uri (string uri, bool recurse);
	[CCode (cheader_filename = "ges/ges.h")]
	public static void deinit ();
	[CCode (cheader_filename = "ges/ges.h")]
	[Version (since = "1.18")]
	public static unowned GES.Asset find_formatter_for_uri (string uri);
	[CCode (cheader_filename = "ges/ges.h")]
	public static bool init ();
	[CCode (cheader_filename = "ges/ges.h")]
	public static bool init_check ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref string[]? argv) throws GLib.Error;
	[CCode (cheader_filename = "ges/ges.h")]
	[Version (since = "1.16")]
	public static bool is_initialized ();
	[CCode (cheader_filename = "ges/ges.h")]
	[Version (deprecated = true, deprecated_since = "1.18")]
	public static Gst.Sample play_sink_convert_frame (Gst.Element playsink, Gst.Caps caps);
	[CCode (cheader_filename = "ges/ges.h")]
	public static bool pspec_equal ([CCode (type = "gconstpointer")] GLib.ParamSpec key_spec_1, [CCode (type = "gconstpointer")] GLib.ParamSpec key_spec_2);
	[CCode (cheader_filename = "ges/ges.h")]
	public static uint pspec_hash (void* key_spec);
	[CCode (cheader_filename = "ges/ges.h")]
	public static bool validate_register_action_types ();
	[CCode (cheader_filename = "ges/ges.h")]
	public static void version (out uint major, out uint minor, out uint micro, out uint nano);
}
