/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.BookingType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.mspdi.XsdDuration;

public final class DatatypeConverter {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal();
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal();
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT = new ThreadLocal();
    private static final BigDecimal BIGDECIMAL_ONE = BigDecimal.valueOf(1L);
    private static final ThreadLocal<ProjectFile> PARENT_FILE = new ThreadLocal();

    public static final String printExtendedAttributeCurrency(Number number) {
        return number == null ? null : DatatypeConverter.getNumberFormat().format(number.doubleValue() * 100.0);
    }

    public static final Number parseExtendedAttributeCurrency(String string) {
        Double d = string == null ? null : NumberHelper.getDouble(Double.parseDouble(DatatypeConverter.correctNumberFormat(string)) / 100.0);
        return d;
    }

    public static final String printExtendedAttributeNumber(Number number) {
        return DatatypeConverter.getNumberFormat().format(number.doubleValue());
    }

    public static final Number parseExtendedAttributeNumber(String string) {
        return Double.valueOf(DatatypeConverter.correctNumberFormat(string));
    }

    public static final String printExtendedAttributeBoolean(Boolean bl) {
        return bl != false ? "1" : "0";
    }

    public static final Boolean parseExtendedAttributeBoolean(String string) {
        return string.equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    public static final String printExtendedAttributeDate(Date date) {
        return date == null ? null : DatatypeConverter.getDateFormat().format(date);
    }

    public static final Date parseExtendedAttributeDate(String string) {
        Date date = null;
        if (string != null) {
            try {
                date = DatatypeConverter.getDateFormat().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static final String printExtendedAttribute(MSPDIWriter mSPDIWriter, Object object, DataType dataType) {
        String string = dataType == DataType.DATE ? DatatypeConverter.printExtendedAttributeDate((Date)object) : (object instanceof Boolean ? DatatypeConverter.printExtendedAttributeBoolean((Boolean)object) : (object instanceof Duration ? DatatypeConverter.printDuration(mSPDIWriter, (Duration)object) : (dataType == DataType.CURRENCY ? DatatypeConverter.printExtendedAttributeCurrency((Number)object) : (object instanceof Number ? DatatypeConverter.printExtendedAttributeNumber((Number)object) : object.toString()))));
        return string;
    }

    public static final void parseExtendedAttribute(ProjectFile projectFile, FieldContainer fieldContainer, String string, FieldType fieldType, TimeUnit timeUnit) {
        if (fieldType != null) {
            switch (fieldType.getDataType()) {
                case STRING: {
                    fieldContainer.set(fieldType, string);
                    break;
                }
                case DATE: {
                    fieldContainer.set(fieldType, DatatypeConverter.parseExtendedAttributeDate(string));
                    break;
                }
                case CURRENCY: {
                    fieldContainer.set(fieldType, DatatypeConverter.parseExtendedAttributeCurrency(string));
                    break;
                }
                case BOOLEAN: {
                    fieldContainer.set(fieldType, DatatypeConverter.parseExtendedAttributeBoolean(string));
                    break;
                }
                case NUMERIC: {
                    fieldContainer.set(fieldType, DatatypeConverter.parseExtendedAttributeNumber(string));
                    break;
                }
                case DURATION: {
                    fieldContainer.set(fieldType, DatatypeConverter.parseDuration(projectFile, timeUnit, string));
                    break;
                }
            }
        }
    }

    public static final String printCurrencySymbolPosition(CurrencySymbolPosition currencySymbolPosition) {
        String string;
        switch (currencySymbolPosition) {
            default: {
                string = "0";
                break;
            }
            case AFTER: {
                string = "1";
                break;
            }
            case BEFORE_WITH_SPACE: {
                string = "2";
                break;
            }
            case AFTER_WITH_SPACE: {
                string = "3";
            }
        }
        return string;
    }

    public static final CurrencySymbolPosition parseCurrencySymbolPosition(String string) {
        CurrencySymbolPosition currencySymbolPosition = CurrencySymbolPosition.BEFORE;
        switch (NumberHelper.getInt(string)) {
            case 0: {
                currencySymbolPosition = CurrencySymbolPosition.BEFORE;
                break;
            }
            case 1: {
                currencySymbolPosition = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                currencySymbolPosition = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                currencySymbolPosition = CurrencySymbolPosition.AFTER_WITH_SPACE;
            }
        }
        return currencySymbolPosition;
    }

    public static final String printAccrueType(AccrueType accrueType) {
        return Integer.toString(accrueType == null ? AccrueType.PRORATED.getValue() : accrueType.getValue());
    }

    public static final AccrueType parseAccrueType(String string) {
        return AccrueType.getInstance(NumberHelper.getInt(string));
    }

    public static final String printResourceType(ResourceType resourceType) {
        return Integer.toString(resourceType == null ? ResourceType.WORK.getValue() : resourceType.getValue());
    }

    public static final ResourceType parseResourceType(String string) {
        return ResourceType.getInstance(NumberHelper.getInt(string));
    }

    public static final String printWorkGroup(WorkGroup workGroup) {
        return Integer.toString(workGroup == null ? WorkGroup.DEFAULT.getValue() : workGroup.getValue());
    }

    public static final WorkGroup parseWorkGroup(String string) {
        return WorkGroup.getInstance(NumberHelper.getInt(string));
    }

    public static final String printWorkContour(WorkContour workContour) {
        return Integer.toString(workContour == null ? WorkContour.FLAT.getValue() : workContour.getValue());
    }

    public static final WorkContour parseWorkContour(String string) {
        return WorkContour.getInstance(NumberHelper.getInt(string));
    }

    public static final String printBookingType(BookingType bookingType) {
        return Integer.toString(bookingType == null ? BookingType.COMMITTED.getValue() : bookingType.getValue());
    }

    public static final BookingType parseBookingType(String string) {
        return BookingType.getInstance(NumberHelper.getInt(string));
    }

    public static final String printTaskType(TaskType taskType) {
        return Integer.toString(taskType == null ? TaskType.FIXED_UNITS.getValue() : taskType.getValue());
    }

    public static final TaskType parseTaskType(String string) {
        return TaskType.getInstance(NumberHelper.getInt(string));
    }

    public static final BigInteger printEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        return earnedValueMethod == null ? BigInteger.valueOf(EarnedValueMethod.PERCENT_COMPLETE.getValue()) : BigInteger.valueOf(earnedValueMethod.getValue());
    }

    public static final EarnedValueMethod parseEarnedValueMethod(Number number) {
        return EarnedValueMethod.getInstance(NumberHelper.getInt(number));
    }

    public static final BigDecimal printUnits(Number number) {
        return number == null ? BIGDECIMAL_ONE : new BigDecimal(number.doubleValue() / 100.0);
    }

    public static final Number parseUnits(Number number) {
        return number == null ? null : NumberHelper.getDouble(number.doubleValue() * 100.0);
    }

    public static final BigInteger printTimeUnit(TimeUnit timeUnit) {
        return BigInteger.valueOf(timeUnit == null ? (long)(TimeUnit.DAYS.getValue() + 1) : (long)(timeUnit.getValue() + 1));
    }

    public static final TimeUnit parseTimeUnit(Number number) {
        return TimeUnit.getInstance(NumberHelper.getInt(number) - 1);
    }

    public static final Calendar printDate(Date date) {
        Calendar calendar = null;
        if (date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(14, 0);
            calendar.set(13, 0);
        }
        return calendar;
    }

    public static final Date parseDate(Calendar calendar) {
        Date date = null;
        if (calendar != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.set(1, calendar.get(1));
            calendar2.set(2, calendar.get(2));
            calendar2.set(5, calendar.get(5));
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
            calendar2.set(13, calendar.get(13));
            calendar2.set(14, calendar.get(14));
            date = calendar2.getTime();
        }
        return date;
    }

    public static final Calendar printTime(Date date) {
        Calendar calendar = null;
        if (date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(14, 0);
            calendar.set(13, 0);
        }
        return calendar;
    }

    public static final Date parseTime(Calendar calendar) {
        Date date = null;
        if (calendar != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
            calendar2.set(13, calendar.get(13));
            calendar2.set(14, calendar.get(14));
            date = calendar2.getTime();
        }
        return date;
    }

    public static final TimeUnit parseWorkUnits(BigInteger bigInteger) {
        TimeUnit timeUnit = TimeUnit.HOURS;
        if (bigInteger != null) {
            switch (bigInteger.intValue()) {
                case 1: {
                    timeUnit = TimeUnit.MINUTES;
                    break;
                }
                case 3: {
                    timeUnit = TimeUnit.DAYS;
                    break;
                }
                case 4: {
                    timeUnit = TimeUnit.WEEKS;
                    break;
                }
                case 5: {
                    timeUnit = TimeUnit.MONTHS;
                    break;
                }
                case 7: {
                    timeUnit = TimeUnit.YEARS;
                    break;
                }
                default: {
                    timeUnit = TimeUnit.HOURS;
                }
            }
        }
        return timeUnit;
    }

    public static final BigInteger printWorkUnits(TimeUnit timeUnit) {
        int n;
        if (timeUnit == null) {
            timeUnit = TimeUnit.HOURS;
        }
        switch (timeUnit) {
            case MINUTES: {
                n = 1;
                break;
            }
            case DAYS: {
                n = 3;
                break;
            }
            case WEEKS: {
                n = 4;
                break;
            }
            case MONTHS: {
                n = 5;
                break;
            }
            case YEARS: {
                n = 7;
                break;
            }
            default: {
                n = 2;
            }
        }
        return BigInteger.valueOf(n);
    }

    public static final Duration parseDuration(ProjectFile projectFile, TimeUnit timeUnit, String string) {
        Duration duration = null;
        XsdDuration xsdDuration = null;
        if (string != null && string.length() != 0) {
            try {
                xsdDuration = new XsdDuration(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (xsdDuration != null) {
            TimeUnit timeUnit2 = TimeUnit.DAYS;
            if (xsdDuration.getSeconds() != 0.0 || xsdDuration.getMinutes() != 0) {
                timeUnit2 = TimeUnit.MINUTES;
            }
            if (xsdDuration.getHours() != 0) {
                timeUnit2 = TimeUnit.HOURS;
            }
            if (xsdDuration.getDays() != 0) {
                timeUnit2 = TimeUnit.DAYS;
            }
            if (xsdDuration.getMonths() != 0) {
                timeUnit2 = TimeUnit.MONTHS;
            }
            if (xsdDuration.getYears() != 0) {
                timeUnit2 = TimeUnit.YEARS;
            }
            double d = 0.0;
            switch (timeUnit2) {
                case YEARS: {
                    d += (double)xsdDuration.getYears();
                    d += (double)xsdDuration.getMonths() / 12.0;
                    d += (double)xsdDuration.getDays() / 365.0;
                    d += (double)xsdDuration.getHours() / 8760.0;
                    d += (double)xsdDuration.getMinutes() / 525600.0;
                    d += xsdDuration.getSeconds() / 3.1536E7;
                    break;
                }
                case ELAPSED_YEARS: {
                    d += (double)xsdDuration.getYears();
                    d += (double)xsdDuration.getMonths() / 12.0;
                    d += (double)xsdDuration.getDays() / 365.0;
                    d += (double)xsdDuration.getHours() / 8760.0;
                    d += (double)xsdDuration.getMinutes() / 525600.0;
                    d += xsdDuration.getSeconds() / 3.1536E7;
                    break;
                }
                case MONTHS: {
                    d += (double)(xsdDuration.getYears() * 12);
                    d += (double)xsdDuration.getMonths();
                    d += (double)xsdDuration.getDays() / 30.0;
                    d += (double)xsdDuration.getHours() / 720.0;
                    d += (double)xsdDuration.getMinutes() / 43200.0;
                    d += xsdDuration.getSeconds() / 2592000.0;
                    break;
                }
                case ELAPSED_MONTHS: {
                    d += (double)(xsdDuration.getYears() * 12);
                    d += (double)xsdDuration.getMonths();
                    d += (double)xsdDuration.getDays() / 30.0;
                    d += (double)xsdDuration.getHours() / 720.0;
                    d += (double)xsdDuration.getMinutes() / 43200.0;
                    d += xsdDuration.getSeconds() / 2592000.0;
                    break;
                }
                case WEEKS: {
                    d += (double)(xsdDuration.getYears() * 52);
                    d += (double)(xsdDuration.getMonths() * 4);
                    d += (double)xsdDuration.getDays() / 7.0;
                    d += (double)xsdDuration.getHours() / 168.0;
                    d += (double)xsdDuration.getMinutes() / 10080.0;
                    d += xsdDuration.getSeconds() / 604800.0;
                    break;
                }
                case ELAPSED_WEEKS: {
                    d += (double)(xsdDuration.getYears() * 52);
                    d += (double)(xsdDuration.getMonths() * 4);
                    d += (double)xsdDuration.getDays() / 7.0;
                    d += (double)xsdDuration.getHours() / 168.0;
                    d += (double)xsdDuration.getMinutes() / 10080.0;
                    d += xsdDuration.getSeconds() / 604800.0;
                    break;
                }
                case DAYS: {
                    d += (double)(xsdDuration.getYears() * 365);
                    d += (double)(xsdDuration.getMonths() * 30);
                    d += (double)xsdDuration.getDays();
                    d += (double)xsdDuration.getHours() / 24.0;
                    d += (double)xsdDuration.getMinutes() / 1440.0;
                    d += xsdDuration.getSeconds() / 86400.0;
                    break;
                }
                case ELAPSED_DAYS: {
                    d += (double)(xsdDuration.getYears() * 365);
                    d += (double)(xsdDuration.getMonths() * 30);
                    d += (double)xsdDuration.getDays();
                    d += (double)xsdDuration.getHours() / 24.0;
                    d += (double)xsdDuration.getMinutes() / 1440.0;
                    d += xsdDuration.getSeconds() / 86400.0;
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    d += (double)(xsdDuration.getYears() * 8760);
                    d += (double)(xsdDuration.getMonths() * 720);
                    d += (double)(xsdDuration.getDays() * 24);
                    d += (double)xsdDuration.getHours();
                    d += (double)xsdDuration.getMinutes() / 60.0;
                    d += xsdDuration.getSeconds() / 3600.0;
                    break;
                }
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    d += (double)(xsdDuration.getYears() * 525600);
                    d += (double)(xsdDuration.getMonths() * 43200);
                    d += (double)(xsdDuration.getDays() * 1440);
                    d += (double)(xsdDuration.getHours() * 60);
                    d += (double)xsdDuration.getMinutes();
                    d += xsdDuration.getSeconds() / 60.0;
                    break;
                }
            }
            ProjectProperties projectProperties = projectFile.getProjectProperties();
            if (timeUnit == null) {
                timeUnit = projectProperties.getDefaultDurationUnits();
            }
            duration = Duration.convertUnits(d, timeUnit2, timeUnit, projectProperties);
        }
        return duration;
    }

    public static final String printDuration(MSPDIWriter mSPDIWriter, Duration duration) {
        String string = null;
        if (duration != null && duration.getDuration() != 0.0) {
            string = DatatypeConverter.printDurationMandatory(mSPDIWriter, duration);
        }
        return string;
    }

    public static final String printDurationMandatory(MSPDIWriter mSPDIWriter, Duration duration) {
        String string = null;
        if (duration != null) {
            TimeUnit timeUnit = duration.getUnits();
            if (timeUnit == TimeUnit.HOURS || timeUnit == TimeUnit.ELAPSED_HOURS) {
                string = new XsdDuration(duration).toString();
            } else {
                duration = duration.convertUnits(TimeUnit.HOURS, mSPDIWriter.getProjectFile().getProjectProperties());
                string = new XsdDuration(duration).toString();
            }
        }
        return string;
    }

    public static final BigInteger printDurationTimeUnits(Duration duration, boolean bl) {
        BigInteger bigInteger = null;
        if (duration != null) {
            bigInteger = DatatypeConverter.printDurationTimeUnits(duration.getUnits(), bl);
        }
        return bigInteger;
    }

    public static final Double parseCurrency(Number number) {
        return number == null ? null : NumberHelper.getDouble(number.doubleValue() / 100.0);
    }

    public static final BigDecimal printCurrency(Number number) {
        return number == null || number.doubleValue() == 0.0 ? null : new BigDecimal(number.doubleValue() * 100.0);
    }

    public static final TimeUnit parseDurationTimeUnits(BigInteger bigInteger) {
        return DatatypeConverter.parseDurationTimeUnits(bigInteger, TimeUnit.HOURS);
    }

    public static final TimeUnit parseDurationTimeUnits(BigInteger bigInteger, TimeUnit timeUnit) {
        TimeUnit timeUnit2 = timeUnit;
        if (bigInteger != null) {
            switch (bigInteger.intValue()) {
                case 3: 
                case 35: {
                    timeUnit2 = TimeUnit.MINUTES;
                    break;
                }
                case 4: 
                case 36: {
                    timeUnit2 = TimeUnit.ELAPSED_MINUTES;
                    break;
                }
                case 5: 
                case 37: {
                    timeUnit2 = TimeUnit.HOURS;
                    break;
                }
                case 6: 
                case 38: {
                    timeUnit2 = TimeUnit.ELAPSED_HOURS;
                    break;
                }
                case 7: 
                case 39: 
                case 53: {
                    timeUnit2 = TimeUnit.DAYS;
                    break;
                }
                case 8: 
                case 40: {
                    timeUnit2 = TimeUnit.ELAPSED_DAYS;
                    break;
                }
                case 9: 
                case 41: {
                    timeUnit2 = TimeUnit.WEEKS;
                    break;
                }
                case 10: 
                case 42: {
                    timeUnit2 = TimeUnit.ELAPSED_WEEKS;
                    break;
                }
                case 11: 
                case 43: {
                    timeUnit2 = TimeUnit.MONTHS;
                    break;
                }
                case 12: 
                case 44: {
                    timeUnit2 = TimeUnit.ELAPSED_MONTHS;
                    break;
                }
                case 19: 
                case 51: {
                    timeUnit2 = TimeUnit.PERCENT;
                    break;
                }
                case 20: 
                case 52: {
                    timeUnit2 = TimeUnit.ELAPSED_PERCENT;
                    break;
                }
                default: {
                    timeUnit2 = PARENT_FILE.get().getProjectProperties().getDefaultDurationUnits();
                }
            }
        }
        return timeUnit2;
    }

    public static final BigInteger printDurationTimeUnits(TimeUnit timeUnit, boolean bl) {
        int n;
        if (timeUnit == null) {
            timeUnit = TimeUnit.HOURS;
        }
        switch (timeUnit) {
            case MINUTES: {
                n = bl ? 35 : 3;
                break;
            }
            case ELAPSED_MINUTES: {
                n = bl ? 36 : 4;
                break;
            }
            case ELAPSED_HOURS: {
                n = bl ? 38 : 6;
                break;
            }
            case DAYS: {
                n = bl ? 39 : 7;
                break;
            }
            case ELAPSED_DAYS: {
                n = bl ? 40 : 8;
                break;
            }
            case WEEKS: {
                n = bl ? 41 : 9;
                break;
            }
            case ELAPSED_WEEKS: {
                n = bl ? 42 : 10;
                break;
            }
            case MONTHS: {
                n = bl ? 43 : 11;
                break;
            }
            case ELAPSED_MONTHS: {
                n = bl ? 44 : 12;
                break;
            }
            case PERCENT: {
                n = bl ? 51 : 19;
                break;
            }
            case ELAPSED_PERCENT: {
                n = bl ? 52 : 20;
                break;
            }
            default: {
                n = bl ? 37 : 5;
            }
        }
        return BigInteger.valueOf(n);
    }

    public static final Priority parsePriority(BigInteger bigInteger) {
        return bigInteger == null ? null : Priority.getInstance(bigInteger.intValue());
    }

    public static final BigInteger printPriority(Priority priority) {
        int n = 500;
        if (priority != null) {
            n = priority.getValue();
        }
        return BigInteger.valueOf(n);
    }

    public static final Duration parseDurationInThousanthsOfMinutes(Number number) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(null, number, TimeUnit.MINUTES, 1000);
    }

    public static final Duration parseDurationInTenthsOfMinutes(Number number) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(null, number, TimeUnit.MINUTES, 10);
    }

    public static final Duration parseDurationInThousanthsOfMinutes(ProjectProperties projectProperties, Number number, TimeUnit timeUnit) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(projectProperties, number, timeUnit, 1000);
    }

    public static final Duration parseDurationInTenthsOfMinutes(ProjectProperties projectProperties, Number number, TimeUnit timeUnit) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(projectProperties, number, timeUnit, 10);
    }

    public static final BigInteger printDurationInIntegerThousandthsOfMinutes(Duration duration) {
        BigInteger bigInteger = null;
        if (duration != null && duration.getDuration() != 0.0) {
            bigInteger = BigInteger.valueOf((long)DatatypeConverter.printDurationFractionsOfMinutes(duration, 1000));
        }
        return bigInteger;
    }

    public static final BigDecimal printDurationInDecimalThousandthsOfMinutes(Duration duration) {
        BigDecimal bigDecimal = null;
        if (duration != null && duration.getDuration() != 0.0) {
            bigDecimal = BigDecimal.valueOf(DatatypeConverter.printDurationFractionsOfMinutes(duration, 1000));
        }
        return bigDecimal;
    }

    public static final BigInteger printDurationInIntegerTenthsOfMinutes(Duration duration) {
        BigInteger bigInteger = null;
        if (duration != null && duration.getDuration() != 0.0) {
            bigInteger = BigInteger.valueOf((long)DatatypeConverter.printDurationFractionsOfMinutes(duration, 10));
        }
        return bigInteger;
    }

    private static final Duration parseDurationInFractionsOfMinutes(ProjectProperties projectProperties, Number number, TimeUnit timeUnit, int n) {
        Duration duration = null;
        if (number != null && timeUnit != (duration = Duration.getInstance(number.intValue() / n, TimeUnit.MINUTES)).getUnits()) {
            duration = duration.convertUnits(timeUnit, projectProperties);
        }
        return duration;
    }

    private static final double printDurationFractionsOfMinutes(Duration duration, int n) {
        double d = 0.0;
        if (duration != null) {
            d = duration.getDuration();
            switch (duration.getUnits()) {
                case HOURS: 
                case ELAPSED_HOURS: {
                    d *= 60.0;
                    break;
                }
                case DAYS: {
                    d *= 480.0;
                    break;
                }
                case ELAPSED_DAYS: {
                    d *= 1440.0;
                    break;
                }
                case WEEKS: {
                    d *= 2400.0;
                    break;
                }
                case ELAPSED_WEEKS: {
                    d *= 10080.0;
                    break;
                }
                case MONTHS: {
                    d *= 9600.0;
                    break;
                }
                case ELAPSED_MONTHS: {
                    d *= 43200.0;
                    break;
                }
                case YEARS: {
                    d *= 124800.0;
                    break;
                }
                case ELAPSED_YEARS: {
                    d *= 525600.0;
                    break;
                }
            }
        }
        return d *= (double)n;
    }

    public static final BigDecimal printRate(Rate rate) {
        BigDecimal bigDecimal = null;
        if (rate != null && rate.getAmount() != 0.0) {
            bigDecimal = new BigDecimal(rate.getAmount());
        }
        return bigDecimal;
    }

    public static final Rate parseRate(BigDecimal bigDecimal) {
        Rate rate = null;
        if (bigDecimal != null) {
            rate = new Rate(bigDecimal, TimeUnit.HOURS);
        }
        return rate;
    }

    public static final BigInteger printDay(Day day) {
        return day == null ? null : BigInteger.valueOf(day.getValue() - 1);
    }

    public static final Day parseDay(Number number) {
        return Day.getInstance(NumberHelper.getInt(number) + 1);
    }

    public static final ConstraintType parseConstraintType(Number number) {
        return ConstraintType.getInstance(number);
    }

    public static final BigInteger printConstraintType(ConstraintType constraintType) {
        return constraintType == null ? null : BigInteger.valueOf(constraintType.getValue());
    }

    public static final String printTaskUID(Integer n) {
        ProjectFile projectFile = PARENT_FILE.get();
        if (projectFile != null) {
            projectFile.getEventManager().fireTaskWrittenEvent(projectFile.getTaskByUniqueID(n));
        }
        return n.toString();
    }

    public static final Integer parseTaskUID(String string) {
        return Integer.valueOf(string);
    }

    public static final String printResourceUID(Integer n) {
        ProjectFile projectFile = PARENT_FILE.get();
        if (projectFile != null) {
            projectFile.getEventManager().fireResourceWrittenEvent(projectFile.getResourceByUniqueID(n));
        }
        return n.toString();
    }

    public static final Integer parseResourceUID(String string) {
        return Integer.valueOf(string);
    }

    public static final String printBoolean(Boolean bl) {
        return bl == null || bl == false ? "0" : "1";
    }

    public static final Boolean parseBoolean(String string) {
        return string == null || string.charAt(0) != '1' ? Boolean.FALSE : Boolean.TRUE;
    }

    public static final String printTime(Calendar calendar) {
        return calendar == null ? null : DatatypeConverter.getTimeFormat().format(calendar.getTime());
    }

    public static final Calendar parseTime(String string) {
        Calendar calendar = null;
        if (string != null && string.length() != 0) {
            calendar = Calendar.getInstance();
            try {
                calendar.setTime(DatatypeConverter.getTimeFormat().parse(string));
            }
            catch (ParseException parseException) {
                calendar = null;
            }
        }
        return calendar;
    }

    public static final String printDateTime(Calendar calendar) {
        return calendar == null ? null : DatatypeConverter.getDateFormat().format(calendar.getTime());
    }

    public static final Calendar parseDateTime(String string) {
        Calendar calendar = null;
        if (string != null && string.length() != 0) {
            try {
                calendar = Calendar.getInstance();
                calendar.setTime(DatatypeConverter.getDateFormat().parse(string));
            }
            catch (ParseException parseException) {
                calendar = null;
            }
        }
        return calendar;
    }

    public static final String printString(String string) {
        return string;
    }

    public static final String parseString(String string) {
        return string;
    }

    public static final void setParentFile(ProjectFile projectFile) {
        PARENT_FILE.set(projectFile);
    }

    private static final NumberFormat getNumberFormat() {
        NumberFormat numberFormat = NUMBER_FORMAT.get();
        if (numberFormat == null) {
            numberFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
            numberFormat.setGroupingUsed(false);
            NUMBER_FORMAT.set(numberFormat);
        }
        return numberFormat;
    }

    private static final DateFormat getDateFormat() {
        DateFormat dateFormat = DATE_FORMAT.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            dateFormat.setLenient(false);
        }
        return dateFormat;
    }

    private static final DateFormat getTimeFormat() {
        DateFormat dateFormat = TIME_FORMAT.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("HH:mm:ss");
            dateFormat.setLenient(false);
        }
        return dateFormat;
    }

    private static final String correctNumberFormat(String string) {
        String string2;
        int n = string.indexOf(44);
        if (n == -1) {
            string2 = string;
        } else {
            char[] cArray = string.toCharArray();
            cArray[n] = 46;
            string2 = new String(cArray);
        }
        return string2;
    }
}

