/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.ArrayList;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.GenericVersionConstraint;
import org.eclipse.aether.util.version.GenericVersionRange;
import org.eclipse.aether.util.version.UnionVersionRange;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

public final class GenericVersionScheme
implements VersionScheme {
    @Override
    public Version parseVersion(String version) throws InvalidVersionSpecificationException {
        return new GenericVersion(version);
    }

    @Override
    public VersionRange parseVersionRange(String range2) throws InvalidVersionSpecificationException {
        return new GenericVersionRange(range2);
    }

    @Override
    public VersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>();
        String process2 = constraint;
        while (process2.startsWith("[") || process2.startsWith("(")) {
            int index2;
            int index1 = process2.indexOf(41);
            int index3 = index2 = process2.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index3 = index1;
            }
            if (index3 < 0) {
                throw new InvalidVersionSpecificationException(constraint, "Unbounded version range " + constraint);
            }
            VersionRange range2 = this.parseVersionRange(process2.substring(0, index3 + 1));
            ranges.add(range2);
            if ((process2 = process2.substring(index3 + 1).trim()).length() <= 0 || !process2.startsWith(",")) continue;
            process2 = process2.substring(1).trim();
        }
        if (process2.length() > 0 && !ranges.isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "Invalid version range " + constraint + ", expected [ or ( but got " + process2);
        }
        GenericVersionConstraint result = ranges.isEmpty() ? new GenericVersionConstraint(this.parseVersion(constraint)) : new GenericVersionConstraint(UnionVersionRange.from(ranges));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

