# FSGS - Common functionality for FS Game System.
# Copyright (C) 2013-2019  Frode Solheim <frode@solheim.dev>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
from fsgs.knownfiles import KnownFile
from fsgs.platforms import PLATFORM_ZXS

ZXS_48_ROM = KnownFile(
    "5ea7c2b824672e914525d1d5c419d71b84a426a2", PLATFORM_ZXS, "48.rom"
)
ZXS_128_0_ROM = KnownFile(
    "4f4b11ec22326280bdb96e3baf9db4b4cb1d02c5", PLATFORM_ZXS, "128-0.rom"
)
ZXS_128_1_ROM = KnownFile(
    "80080644289ed93d71a1103992a154cc9802b2fa", PLATFORM_ZXS, "128-1.rom"
)
ZXS_PLUS3_0_ROM = KnownFile(
    "e319ed08b4d53a5e421a75ea00ea02039ba6555b", PLATFORM_ZXS, "plus3-0.rom"
)
ZXS_PLUS3_1_ROM = KnownFile(
    "c9969fc36095a59787554026a9adc3b87678c794", PLATFORM_ZXS, "plus3-1.rom"
)
ZXS_PLUS3_2_ROM = KnownFile(
    "22e50c6ba4157a3f6a821bd9937cd26e292775c6", PLATFORM_ZXS, "plus3-2.rom"
)
ZXS_PLUS3_3_ROM = KnownFile(
    "65f031caa8148a5493afe42c41f4929deab26b4e", PLATFORM_ZXS, "plus3-3.rom"
)
