/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.joni.Region;

public abstract class GrokCaptureExtracter {
    abstract void extract(byte[] var1, int var2, Region var3);

    static class MapExtracter
    extends GrokCaptureExtracter {
        private final Map<String, Object> result;
        private final List<GrokCaptureExtracter> fieldExtracters;

        MapExtracter(List<GrokCaptureConfig> captureConfig) {
            this.result = captureConfig.isEmpty() ? Collections.emptyMap() : new HashMap();
            this.fieldExtracters = new ArrayList<GrokCaptureExtracter>(captureConfig.size());
            for (GrokCaptureConfig config : captureConfig) {
                this.fieldExtracters.add(config.objectExtracter(v -> this.result.put(config.name(), v)));
            }
        }

        @Override
        void extract(byte[] utf8Bytes, int offset, Region region) {
            for (GrokCaptureExtracter extracter : this.fieldExtracters) {
                extracter.extract(utf8Bytes, offset, region);
            }
        }

        Map<String, Object> result() {
            return this.result;
        }
    }
}

