/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import com.android.dx.io.instructions.DecodedInstruction;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.CallMthInterface;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;
import org.jetbrains.annotations.Nullable;

public class InvokeNode
extends InsnNode
implements CallMthInterface {
    private final InvokeType type;
    private final MethodInfo mth;

    public InvokeNode(MethodInfo mth, DecodedInstruction insn, InvokeType type, boolean isRange, int resReg) {
        super(InsnType.INVOKE, mth.getArgsCount() + (type == InvokeType.STATIC ? 0 : 1));
        int k;
        this.mth = mth;
        this.type = type;
        if (resReg >= 0) {
            this.setResult(InsnArg.reg(resReg, mth.getReturnType()));
        }
        int n = k = isRange ? insn.getA() : 0;
        if (type != InvokeType.STATIC) {
            int r = isRange ? k : InsnUtils.getArg(insn, k);
            this.addReg(r, mth.getDeclClass().getType());
            ++k;
        }
        for (ArgType arg : mth.getArgumentsTypes()) {
            this.addReg(isRange ? k : InsnUtils.getArg(insn, k), arg);
            k += arg.getRegCount();
        }
    }

    public InvokeNode(MethodInfo mth, InvokeType invokeType, int argsCount) {
        super(InsnType.INVOKE, argsCount);
        this.mth = mth;
        this.type = invokeType;
    }

    public InvokeType getInvokeType() {
        return this.type;
    }

    @Override
    public MethodInfo getCallMth() {
        return this.mth;
    }

    @Override
    @Nullable
    public RegisterArg getInstanceArg() {
        InsnArg firstArg;
        if (this.type != InvokeType.STATIC && this.getArgsCount() > 0 && (firstArg = this.getArg(0)).isRegister()) {
            return (RegisterArg)firstArg;
        }
        return null;
    }

    @Override
    public int getFirstArgOffset() {
        return this.type == InvokeType.STATIC ? 0 : 1;
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new InvokeNode(this.mth, this.type, this.getArgsCount()));
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvokeNode) || !super.isSame(obj)) {
            return false;
        }
        InvokeNode other = (InvokeNode)obj;
        return this.type == other.type && this.mth.equals(other.mth);
    }

    @Override
    public String toString() {
        return super.toString() + ' ' + this.mth + " type: " + (Object)((Object)this.type);
    }
}

