/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.TypeHandler;

public class CommandLine {
    private List args = new LinkedList();
    private Map options = new HashMap();
    private Map hashcodeMap = new HashMap();
    private Option[] optionsArray;

    CommandLine() {
    }

    public boolean hasOption(String opt) {
        return this.options.containsKey(opt);
    }

    public boolean hasOption(char opt) {
        return this.hasOption(String.valueOf(opt));
    }

    public Object getOptionObject(String opt) {
        String res = this.getOptionValue(opt);
        Object type = ((Option)((List)this.options.get(opt)).iterator().next()).getType();
        return res == null ? null : TypeHandler.createValue(res, type);
    }

    public Object getOptionObject(char opt) {
        return this.getOptionObject(String.valueOf(opt));
    }

    public String getOptionValue(String opt) {
        String[] values = this.getOptionValues(opt);
        return values == null ? null : values[0];
    }

    public String getOptionValue(char opt) {
        return this.getOptionValue(String.valueOf(opt));
    }

    public String[] getOptionValues(String opt) {
        ArrayList values = new ArrayList();
        if (this.options.containsKey(opt)) {
            List opts = (List)this.options.get(opt);
            Iterator iter = opts.iterator();
            while (iter.hasNext()) {
                Option optt = (Option)iter.next();
                values.addAll(optt.getValuesList());
            }
        }
        return values.size() == 0 ? null : values.toArray(new String[0]);
    }

    public String[] getOptionValues(char opt) {
        return this.getOptionValues(String.valueOf(opt));
    }

    public String getOptionValue(String opt, String defaultValue) {
        String answer = this.getOptionValue(opt);
        return answer != null ? answer : defaultValue;
    }

    public String getOptionValue(char opt, String defaultValue) {
        return this.getOptionValue(String.valueOf(opt), defaultValue);
    }

    public String[] getArgs() {
        String[] answer = new String[this.args.size()];
        this.args.toArray(answer);
        return answer;
    }

    public List getArgList() {
        return this.args;
    }

    void addArg(String arg) {
        this.args.add(arg);
    }

    void addOption(Option opt) {
        this.hashcodeMap.put(new Integer(opt.hashCode()), opt);
        String key = opt.getOpt();
        if (" ".equals(key)) {
            key = opt.getLongOpt();
        }
        if (this.options.get(key) != null) {
            ((List)this.options.get(key)).add(opt);
        } else {
            this.options.put(key, new ArrayList());
            ((List)this.options.get(key)).add(opt);
        }
    }

    public Iterator iterator() {
        return this.hashcodeMap.values().iterator();
    }

    public Option[] getOptions() {
        Collection processed = this.hashcodeMap.values();
        this.optionsArray = new Option[processed.size()];
        return processed.toArray(this.optionsArray);
    }
}

