/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.memory;

import java.beans.PropertyEditorSupport;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.memory.UserAttribute;
import org.springframework.security.userdetails.memory.UserAttributeEditor;
import org.springframework.security.userdetails.memory.UserMap;

public class UserMapEditor
extends PropertyEditorSupport {
    public static UserMap addUsersFromProperties(UserMap userMap, Properties props) {
        UserAttributeEditor configAttribEd = new UserAttributeEditor();
        Iterator iter = ((Hashtable)props).keySet().iterator();
        while (iter.hasNext()) {
            String username = (String)iter.next();
            String value = props.getProperty(username);
            configAttribEd.setAsText(value);
            UserAttribute attr = (UserAttribute)configAttribEd.getValue();
            if (attr == null) continue;
            User user = new User(username, attr.getPassword(), attr.isEnabled(), true, true, true, attr.getAuthorities());
            userMap.addUser(user);
        }
        return userMap;
    }

    public void setAsText(String s) throws IllegalArgumentException {
        UserMap userMap = new UserMap();
        if (s != null && !"".equals(s)) {
            PropertiesEditor propertiesEditor = new PropertiesEditor();
            propertiesEditor.setAsText(s);
            Properties props = (Properties)propertiesEditor.getValue();
            UserMapEditor.addUsersFromProperties(userMap, props);
        }
        this.setValue(userMap);
    }
}

