/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.JDefaultButton;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.db.DataSourceTypeDialogFactory;
import ca.sqlpower.swingui.db.DataSourceTypeEditor;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DefaultDataSourceTypeDialogFactory
implements DataSourceTypeDialogFactory {
    private JDialog d;
    private DataSourceTypeEditor editor;
    private final DataSourceCollection dsCollection;

    public DefaultDataSourceTypeDialogFactory(DataSourceCollection ds) {
        this.dsCollection = ds;
    }

    @Override
    public Window showDialog(Window owner) {
        if (this.d == null) {
            this.d = SPSUtils.makeOwnedDialog(owner, "JDBC Drivers");
            this.editor = new DataSourceTypeEditor(this.dsCollection, owner);
            JPanel cp = new JPanel(new BorderLayout(12, 12));
            cp.add((Component)this.editor.getPanel(), "Center");
            cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            JDefaultButton okButton = new JDefaultButton(DataEntryPanelBuilder.OK_BUTTON_LABEL);
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DefaultDataSourceTypeDialogFactory.this.editor.applyChanges();
                    DefaultDataSourceTypeDialogFactory.this.d.dispose();
                }
            });
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DefaultDataSourceTypeDialogFactory.this.editor.discardChanges();
                    DefaultDataSourceTypeDialogFactory.this.d.dispose();
                }
            };
            cancelAction.putValue("Name", DataEntryPanelBuilder.CANCEL_BUTTON_LABEL);
            JButton cancelButton = new JButton(cancelAction);
            JPanel buttonPanel = ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton);
            SPSUtils.makeJDialogCancellable(this.d, cancelAction);
            this.d.getRootPane().setDefaultButton(okButton);
            cp.add((Component)buttonPanel, "South");
            this.d.setContentPane(cp);
            this.d.pack();
            this.d.setLocationRelativeTo(owner);
        }
        this.d.pack();
        this.d.setVisible(true);
        return this.d;
    }
}

