/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.messages;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.DefaultSeverities;
import com.adobe.epubcheck.messages.LocalizedMessages;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.util.PathUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OverriddenMessages {
    private final DefaultSeverities defaultSeverities = new DefaultSeverities();
    private final Map<MessageId, Message> overridenMessages = new EnumMap<MessageId, Message>(MessageId.class);
    private final LocalizedMessages defaultMessages = LocalizedMessages.getInstance();
    private final Pattern parameterPattern = Pattern.compile("%(\\d+)\\$s");
    private final File overrideFile;
    private final Report report;

    public OverriddenMessages(File overrideFile, Report report) {
        this.overrideFile = overrideFile;
        this.report = report;
        this.loadOverriddenMessageSeverities();
    }

    public Message getMessage(MessageId id) {
        Message m = this.overridenMessages.get(id);
        if (m == null && (m = this.defaultMessages.getMessage(id)) == null) {
            throw new IllegalArgumentException("MessageId " + id.name() + " is invalid.");
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOverriddenMessageSeverities() {
        if (this.overrideFile != null) {
            int lineNumber = -1;
            int columnNumber = -1;
            FileInputStream fis = null;
            BufferedReader br = null;
            try {
                String line;
                fis = new FileInputStream(this.overrideFile);
                br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
                lineNumber = 1;
                while (null != (line = br.readLine())) {
                    if (1 == lineNumber && line.toLowerCase(Locale.ROOT).startsWith("id")) continue;
                    columnNumber = 0;
                    String[] fields = line.split("\t");
                    if (fields.length >= 2) {
                        Severity oldSeverity;
                        Severity newSeverity;
                        MessageId id;
                        try {
                            id = MessageId.fromString(fields[0]);
                        }
                        catch (NoSuchElementException unused) {
                            this.report.message(MessageId.CHK_002, EPUBLocation.create("", lineNumber, 0), fields[0], PathUtil.removeWorkingDirectory(this.overrideFile.getAbsolutePath()));
                            continue;
                        }
                        try {
                            columnNumber += 1 + fields[0].length();
                            newSeverity = Severity.fromString(fields[1]);
                        }
                        catch (NoSuchElementException ignored) {
                            this.report.message(MessageId.CHK_003, EPUBLocation.create("", lineNumber, columnNumber), fields[1], PathUtil.removeWorkingDirectory(this.overrideFile.getAbsolutePath()));
                            continue;
                        }
                        Message message = this.defaultMessages.getMessage(id);
                        String messageText = message.getMessage();
                        if (fields.length >= 3 && fields[2] != null && fields[2].length() > 0 && (messageText = this.checkMessageForParameterCount(lineNumber, columnNumber += 1 + fields[1].length(), message.getMessage(), fields[2])) == null) {
                            this.report.message(MessageId.CHK_004, EPUBLocation.create("", lineNumber, 0, fields[2]), PathUtil.removeWorkingDirectory(this.overrideFile.getAbsolutePath()));
                            continue;
                        }
                        if (messageText != null && newSeverity != (oldSeverity = this.defaultSeverities.get(message.getID()))) {
                            messageText = String.format(" (severity overridden from %1$s) %2$s", new Object[]{oldSeverity, messageText});
                        }
                        String suggestionText = message.getSuggestion();
                        if (fields.length >= 4 && fields[3] != null && fields[3].length() > 0 && (suggestionText = this.checkMessageForParameterCount(lineNumber, columnNumber += 1 + fields[1].length(), message.getSuggestion(), fields[3])) == null) {
                            this.report.message(MessageId.CHK_005, EPUBLocation.create("", lineNumber, 0, fields[3]), PathUtil.removeWorkingDirectory(this.overrideFile.getAbsolutePath()));
                            continue;
                        }
                        if (message != null && (newSeverity != message.getSeverity() || messageText.compareTo(message.getMessage()) != 0 || suggestionText.compareTo(message.getSuggestion()) != 0)) {
                            this.overridenMessages.put(id, new Message(message.getID(), newSeverity, message.getSeverity(), messageText, suggestionText));
                        }
                    }
                    ++lineNumber;
                }
            }
            catch (FileNotFoundException fnf) {
                this.report.message(MessageId.CHK_001, EPUBLocation.create(this.overrideFile.getAbsolutePath()), new Object[0]);
            }
            catch (IOException ex) {
                this.report.message(MessageId.CHK_007, EPUBLocation.create("", lineNumber, columnNumber), PathUtil.removeWorkingDirectory(this.overrideFile.getAbsolutePath()), ex.getMessage());
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException fnf) {}
            }
        }
    }

    private String checkMessageForParameterCount(int lineNumber, int columnNumber, String originalText, String newText) {
        if (newText != null) {
            int maxOriginal = this.getParameterCount(lineNumber, columnNumber, originalText);
            int maxNew = this.getParameterCount(lineNumber, columnNumber, newText);
            if (maxNew <= maxOriginal) {
                return newText;
            }
            return null;
        }
        return originalText;
    }

    private int getParameterCount(int lineNumber, int columnNumber, String text) {
        int max = 0;
        Matcher m = this.parameterPattern.matcher(text);
        while (m.find()) {
            int absoluteColumnNumber = columnNumber + m.start();
            String s = m.group(1);
            try {
                Integer number = Integer.parseInt(s);
                if (number <= max) continue;
                max = number;
            }
            catch (NumberFormatException ex) {
                String pathAdjustedFileName = PathUtil.removeWorkingDirectory(this.overrideFile.getAbsolutePath());
                this.report.message(MessageId.CHK_006, EPUBLocation.create("", lineNumber, absoluteColumnNumber, text), pathAdjustedFileName);
            }
        }
        return max;
    }
}

