/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.File;
import java.io.Writer;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStoreBackedResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultSerializer;
import org.gradle.api.tasks.testing.TestOutputEvent;

public class BinaryResultBackedTestResultsProvider
extends TestOutputStoreBackedResultsProvider {
    private final TestResultSerializer resultSerializer;

    public BinaryResultBackedTestResultsProvider(File resultsDir) {
        super(new TestOutputStore(resultsDir));
        this.resultSerializer = new TestResultSerializer(resultsDir);
    }

    @Override
    public boolean hasOutput(final long id, final TestOutputEvent.Destination destination) {
        final boolean[] hasOutput = new boolean[1];
        this.withReader(new Action<TestOutputStore.Reader>(){

            public void execute(TestOutputStore.Reader reader) {
                hasOutput[0] = reader.hasOutput(id, destination);
            }
        });
        return hasOutput[0];
    }

    @Override
    public void writeAllOutput(final long id, final TestOutputEvent.Destination destination, final Writer writer) {
        this.withReader(new Action<TestOutputStore.Reader>(){

            public void execute(TestOutputStore.Reader reader) {
                reader.writeAllOutput(id, destination, writer);
            }
        });
    }

    @Override
    public boolean isHasResults() {
        return this.resultSerializer.isHasResults();
    }

    @Override
    public void writeNonTestOutput(final long id, final TestOutputEvent.Destination destination, final Writer writer) {
        this.withReader(new Action<TestOutputStore.Reader>(){

            public void execute(TestOutputStore.Reader reader) {
                reader.writeNonTestOutput(id, destination, writer);
            }
        });
    }

    @Override
    public void writeTestOutput(final long classId, final long testId, final TestOutputEvent.Destination destination, final Writer writer) {
        this.withReader(new Action<TestOutputStore.Reader>(){

            public void execute(TestOutputStore.Reader reader) {
                reader.writeTestOutput(classId, testId, destination, writer);
            }
        });
    }

    @Override
    public void visitClasses(Action<? super TestClassResult> visitor) {
        this.resultSerializer.read(visitor);
    }
}

