/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;

public class KeyCertificate
extends Certificate {
    public static final int HEADER_LENGTH = 4;
    static final byte[] Ed25519_PAYLOAD;
    static final byte[] ECDSA256_PAYLOAD;
    public static final KeyCertificate ELG_ECDSA256_CERT;
    public static final KeyCertificate ELG_Ed25519_CERT;

    public KeyCertificate(byte[] payload) throws DataFormatException {
        super(5, payload);
        if (payload != null && payload.length < 4) {
            throw new DataFormatException("data");
        }
    }

    public KeyCertificate(SigningPublicKey spk) {
        super(5, null);
        if (spk == null || spk.getData() == null) {
            throw new IllegalArgumentException();
        }
        SigType type = spk.getType();
        int len = type.getPubkeyLen();
        int extra = Math.max(0, len - 128);
        this._payload = new byte[4 + extra];
        int code = type.getCode();
        this._payload[0] = (byte)(code >> 8);
        this._payload[1] = (byte)(code & 0xFF);
        if (extra > 0) {
            System.arraycopy(spk.getData(), 128, this._payload, 4, extra);
        }
    }

    public KeyCertificate(SigningPublicKey spk, PublicKey pk) {
        super(5, null);
        if (spk == null || spk.getData() == null || pk == null || pk.getData() == null) {
            throw new IllegalArgumentException();
        }
        SigType type = spk.getType();
        int len = type.getPubkeyLen();
        int extra = Math.max(0, len - 128);
        this._payload = new byte[4 + extra];
        int code = type.getCode();
        this._payload[0] = (byte)(code >> 8);
        this._payload[1] = (byte)(code & 0xFF);
        code = pk.getType().getCode();
        this._payload[2] = (byte)(code >> 8);
        this._payload[3] = (byte)(code & 0xFF);
        if (extra > 0) {
            System.arraycopy(spk.getData(), 128, this._payload, 4, extra);
        }
    }

    public KeyCertificate(SigType type) {
        this(type, EncType.ELGAMAL_2048);
    }

    public KeyCertificate(SigType type, EncType etype) {
        super(5, null);
        int len = type.getPubkeyLen();
        int extra = Math.max(0, len - 128);
        this._payload = new byte[4 + extra];
        int code = type.getCode();
        this._payload[0] = (byte)(code >> 8);
        this._payload[1] = (byte)(code & 0xFF);
        code = etype.getCode();
        this._payload[2] = (byte)(code >> 8);
        this._payload[3] = (byte)(code & 0xFF);
    }

    public KeyCertificate(Certificate cert) throws DataFormatException {
        this(cert.getPayload());
        if (cert.getCertificateType() != 5) {
            throw new DataFormatException("type");
        }
    }

    public int getSigTypeCode() {
        if (this._payload == null) {
            return -1;
        }
        return (this._payload[0] & 0xFF) << 8 | this._payload[1] & 0xFF;
    }

    public int getCryptoTypeCode() {
        if (this._payload == null) {
            return -1;
        }
        return (this._payload[2] & 0xFF) << 8 | this._payload[3] & 0xFF;
    }

    public SigType getSigType() {
        return SigType.getByCode(this.getSigTypeCode());
    }

    public EncType getEncType() {
        return EncType.getByCode(this.getCryptoTypeCode());
    }

    public byte[] getExtraKeyData() {
        if (this._payload == null || this._payload.length <= 4) {
            return null;
        }
        byte[] rv = new byte[this._payload.length - 4];
        System.arraycopy(this._payload, 4, rv, 0, rv.length);
        return rv;
    }

    public byte[] getExtraSigningKeyData() {
        if (this._payload == null || this._payload.length <= 4) {
            return null;
        }
        SigType type = this.getSigType();
        if (type == null) {
            throw new UnsupportedOperationException("unknown sig type");
        }
        int extra = Math.max(0, type.getPubkeyLen() - 128);
        if (this._payload.length == 4 + extra) {
            return this.getExtraKeyData();
        }
        byte[] rv = new byte[extra];
        System.arraycopy(this._payload, 4, rv, 0, extra);
        return rv;
    }

    @Override
    public KeyCertificate toKeyCertificate() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[Certificate: type: Key certificate");
        if (this._payload == null) {
            buf.append(" null payload");
        } else {
            buf.append("\n\tCrypto type: ").append(this.getCryptoTypeCode()).append(" (").append((Object)this.getEncType()).append(')');
            buf.append("\n\tSig type: ").append(this.getSigTypeCode()).append(" (").append((Object)this.getSigType()).append(')');
            if (this._payload.length > 4) {
                buf.append("\n\tKey data: ").append(this._payload.length - 4).append(" bytes");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    static {
        KeyCertificate kc;
        Ed25519_PAYLOAD = new byte[]{0, (byte)SigType.EdDSA_SHA512_Ed25519.getCode(), 0, 0};
        ECDSA256_PAYLOAD = new byte[]{0, (byte)SigType.ECDSA_SHA256_P256.getCode(), 0, 0};
        try {
            kc = new ECDSA256Cert();
        }
        catch (DataFormatException dfe) {
            throw new RuntimeException(dfe);
        }
        ELG_ECDSA256_CERT = kc;
        try {
            kc = new Ed25519Cert();
        }
        catch (DataFormatException dfe) {
            throw new RuntimeException(dfe);
        }
        ELG_Ed25519_CERT = kc;
    }

    private static final class Ed25519Cert
    extends KeyCertificate {
        private static final byte[] ED_DATA = new byte[]{5, 0, 4, 0, (byte)SigType.EdDSA_SHA512_Ed25519.getCode(), 0, 0};
        private static final int ED_LENGTH = ED_DATA.length;
        private final int _hashcode = super.hashCode();

        public Ed25519Cert() throws DataFormatException {
            super(Ed25519_PAYLOAD);
        }

        @Override
        public void setCertificateType(int type) {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void setPayload(byte[] payload) {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void readBytes(InputStream in) throws DataFormatException, IOException {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void writeBytes(OutputStream out) throws IOException {
            out.write(ED_DATA);
        }

        @Override
        public int writeBytes(byte[] target, int offset) {
            System.arraycopy(ED_DATA, 0, target, offset, ED_LENGTH);
            return ED_LENGTH;
        }

        @Override
        public int readBytes(byte[] source, int offset) throws DataFormatException {
            throw new RuntimeException("Data already set");
        }

        @Override
        public int size() {
            return ED_LENGTH;
        }

        @Override
        public int hashCode() {
            return this._hashcode;
        }
    }

    private static final class ECDSA256Cert
    extends KeyCertificate {
        private static final byte[] ECDSA256_DATA = new byte[]{5, 0, 4, 0, (byte)SigType.ECDSA_SHA256_P256.getCode(), 0, 0};
        private static final int ECDSA256_LENGTH = ECDSA256_DATA.length;
        private final int _hashcode = super.hashCode();

        public ECDSA256Cert() throws DataFormatException {
            super(ECDSA256_PAYLOAD);
        }

        @Override
        public void setCertificateType(int type) {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void setPayload(byte[] payload) {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void readBytes(InputStream in) throws DataFormatException, IOException {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void writeBytes(OutputStream out) throws IOException {
            out.write(ECDSA256_DATA);
        }

        @Override
        public int writeBytes(byte[] target, int offset) {
            System.arraycopy(ECDSA256_DATA, 0, target, offset, ECDSA256_LENGTH);
            return ECDSA256_LENGTH;
        }

        @Override
        public int readBytes(byte[] source, int offset) throws DataFormatException {
            throw new RuntimeException("Data already set");
        }

        @Override
        public int size() {
            return ECDSA256_LENGTH;
        }

        @Override
        public int hashCode() {
            return this._hashcode;
        }
    }
}

