/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import net.i2p.data.Destination;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.SessionId;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class MessageReceivedJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final Destination _toDest;
    private final Payload _payload;
    private final boolean _sendDirect;

    public MessageReceivedJob(RouterContext ctx, ClientConnectionRunner runner, Destination toDest, Destination fromDest, Payload payload, boolean sendDirect) {
        super(ctx);
        this._log = ctx.logManager().getLog(MessageReceivedJob.class);
        this._runner = runner;
        this._toDest = toDest;
        this._payload = payload;
        this._sendDirect = sendDirect;
    }

    @Override
    public String getName() {
        return "Deliver New Message";
    }

    @Override
    public void runJob() {
        this.receiveMessage();
    }

    public boolean receiveMessage() {
        if (this._runner.isDead()) {
            return false;
        }
        MessageId id = null;
        try {
            long nextID = this._runner.getNextMessageId();
            if (this._sendDirect) {
                this.sendMessage(nextID);
            } else {
                id = new MessageId(nextID);
                this._runner.setPayload(id, this._payload);
                this.messageAvailable(id, this._payload.getSize());
            }
            return true;
        }
        catch (I2CPMessageException ime) {
            String msg = "Error sending data to client " + this._runner.getDestHash().toBase32();
            if (this._log.shouldWarn()) {
                this._log.warn(msg, ime);
            } else {
                this._log.logAlways(30, msg);
            }
            if (id != null && !this._sendDirect) {
                this._runner.removePayload(id);
            }
            return false;
        }
    }

    private void messageAvailable(MessageId id, long size) throws I2CPMessageException {
        MessageStatusMessage msg = new MessageStatusMessage();
        msg.setMessageId(id.getMessageId());
        SessionId sid = this._runner.getSessionId(this._toDest.calculateHash());
        if (sid == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No session for " + this._toDest.toBase32());
            }
            return;
        }
        msg.setSessionId(sid.getSessionId());
        msg.setSize(size);
        msg.setNonce(1L);
        msg.setStatus(0);
        this._runner.doSend(msg);
    }

    private void sendMessage(long id) throws I2CPMessageException {
        MessagePayloadMessage msg = new MessagePayloadMessage();
        msg.setMessageId(id);
        SessionId sid = this._runner.getSessionId(this._toDest.calculateHash());
        if (sid == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No session for " + this._toDest.toBase32());
            }
            return;
        }
        msg.setSessionId(sid.getSessionId());
        msg.setPayload(this._payload);
        this._runner.doSend(msg);
    }
}

