/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfTable;

public class DxfLAYER
extends DxfTable {
    public static final String DEFAUT_LAYER = "0";
    public static final short LAYER_FROZEN = 1;
    public static final short LAYER_AUTO_FROZEN = 2;
    public static final short LAYER_LOCKED = 4;
    public static final short LAYER_XREF = 8;
    public static final short LAYER_XREF_FOUND = 16;
    public static final short LAYER_USED = 32;
    public static final short LAYER_INVISIBLE = 16384;
    protected short color = (short)-1;
    protected String linetype;
    protected boolean visible = true;
    protected boolean is0 = false;

    DxfLAYER() {
    }

    DxfLAYER(String name) {
        this.name = name.toUpperCase();
        this.color = (short)7;
    }

    public boolean setGroup(short grpNr, short col) {
        if (grpNr == 62) {
            if (col < 0) {
                this.color = -col;
                this.flags = (short)(this.flags | 0x4000);
            } else {
                this.color = col;
                this.flags = (short)(this.flags & 0xFFFFBFFF);
            }
            return true;
        }
        return super.setGroup(grpNr, this.color);
    }

    public boolean setGroup(short grpNr, String str) {
        if (grpNr == 6) {
            this.linetype = str;
            return true;
        }
        return super.setGroup(grpNr, str);
    }

    public boolean finishRead(DxfFile file) {
        this.visible = (this.flags & 0x4001) == 0;
        this.is0 = DEFAUT_LAYER.equals(this.name);
        return true;
    }

    public boolean getVisibility() {
        return this.visible;
    }

    public void setVisibility(boolean onoff) {
        this.visible = onoff;
    }

    public boolean isLayer0() {
        return this.is0;
    }

    public short getColor() {
        this.setReferenced();
        return this.color;
    }

    public String getLineTypeName() {
        return this.linetype == null ? "CONTINUOUS" : this.linetype;
    }
}

